<?php

/* ===========+========+===== changelog ==============================================
 -- YYYY.MM.DD | author | change
 -- -----------+--------+-------------------------------------------------------------
 -- 2022.09.01	 rre	  add new lookup views 
 -- **********************************************************************************
 */
 
define('T_CATALOGOBJECT', 		'catalogObject');
define('T_CATALOGOBJECTINST', 	'catalogObjectInstance');
define('T_USER', 				'user');
define('T_USERSETTING',			'userSetting');
define('T_USERSETTINGCATALOG',	'userSettingCatalog');
define('T_USERGROUP',			'userGroup');
define('T_CATOBJACCESS',		'catalogObjectAccess');
define('T_ADMINDOMAIN',			'adminDomain');
define('T_USERGROUPMEMB',		'userGroupMemeber');
define('T_TRANSACTION',			'transaction');
define('T_CALLABLEOBJ',			'callableObject');
define('T_CALLABLEOBJSEQ',		'callableObjectSeq');
define('T_CATALOGOBJCALLABLE',	'catalogObjectCallable');
define('T_TRANSACTPARAMSET',	'transactionParameterSet');
define('T_TRANSACTMENU',		'transactionMenu');
define('T_TRANSACTACCESS', 		'transactionAccess');
define('T_CALLABLEACC',			'callableAccess');
define('T_CATALOGOBJCOLPROP',	'catalogObjectColumnProp');
define('T_CONSTRAINT',			'constraint');
define('T_LOOKUP',				'lookup');
define('T_MASTERDETAIL',		'masterDetail');
define('T_MASTERDETAILLINK',	'masterDetailLink');
define('T_LOGGING',				'logging');
define('T_CONNECTION',			'connection');
define('T_LOOKUPSYSTEM', 		'lookupValueSystem');
define('T_USERPARAMETER',		'userParameter');
define('V_CATALOGINSTANCEID',	'cataloginstanceid');
define('T_CATALOGOBJECTCONFIG', 'catalogObjectConfig');
//V3.3.0 deployment-tables
define('T_DEPLOYDATAIMP', 	  'deploydataimp');
define('T_DEPLOYDATAEXP', 	  'deploydataexp');
define('T_DEPLOYLOG', 	      'deploylog');
define('T_DEPLOYLOGSTEP', 	  'deploylogstep');
define('T_DEPLOYARCHIVE', 	  'deployarchive');
//V3.3.0 extended meta-information tables
define('T_METADBOBJECT', 	  'metadbobject');
define('T_METADBLINK', 	      'metadblink');
define('T_METADBLINKDETAIL',  'metadblinkdetail');
define('T_COLUMNFORMAT',      'columnformat');
//V3.3.0 new helper/config tables
define('T_MESSAGETEXT',		 'messagetext');
define('T_SEQUENCE', 	  	 'sequence');
define('T_SYSTEMCONFIG',  	 'systemconfig');
define('T_USERCONFIG', 	  	 'userconfig');
define('T_USERCOMMAREA',  	 'usercommarea');
define('V_USERGROUP_LU',  	 'usergroup_lookup');
//v5.0.1 new message table
define('T_MESSAGEDETAIL',	 	'messagedetail');
define('V_CATALOG_INSTANCE_LU',	'lookup_instance');
define('V_NEXTCATALOGID_LU',  	'nextcatalog_id_lookup');
//v5.0.x formatting tables
define('T_FORMATDOMAINLOGC',	'logicaldomain');
define('T_FORMATDOMAINPHYS',	'physicaldomain');
define('T_FORMATDOMAINSEMA',	'semanticdomain');
define('T_FORMATCOLUMNCOLL',	'columncollection');
define('T_FORMATOBJECTEXT',		'objectformat');
define('T_FORMATCOLUMNEXT',		'columnformat');

define('V_FORMATDOMAINLOGC_LU',	'logicaldomain_lookup');
define('V_FORMATDOMAINPHYS_LU',	'physicaldomain_lookup');
define('V_FORMATDOMAINSEMA_LU',	'semanticdomain_lookup');

define('V_METADBREPOSITORY',	'metadb_object_repository');


//EXAMPLE
//define('V_CALLABLE_ACCESS',		'v_callableAccess');

// mapping of table names, corresponding view names
const SYSTEM_TABLES = [
//catalog tables
		T_CATALOGOBJECT 			=> ["et_catalog_object", "v_et_catalog_object", ["catalog_id"]],
		T_CATALOGOBJECTINST 		=> ["et_catalog_object_instance", "v_et_catalog_object_instance", ["catalog_id", "instance_name"]],
		//user, group tables
		T_USER 						=> ["et_user", "v_et_user", ["username"]],
		//TODO: remove unnecessary constant:
		T_USERSETTING 				=> ["et_user_setting", "v_et_user_setting", []],
		//TODO: remove unnecessary constant:
		T_USERSETTINGCATALOG		=> ["et_user_setting_catalog", "v_et_user_setting_catalog", []],
		T_USERGROUP 				=> ["et_user_group", "v_et_user_group", ["usergroupname"]],
		T_CATOBJACCESS 				=> ["et_catalog_object_access", "v_et_catalog_object_access", ["usergroupname", "catalog_id"]],
		T_ADMINDOMAIN				=> ["et_admin_domain", "v_et_admin_domain"],
		T_USERGROUPMEMB				=> ["et_user_group_member", "v_et_user_group_member", ["usergroupname", "username"]],
		//transaction tables
		T_TRANSACTION				=> ["et_transaction", "v_et_transaction", ["transaction_code"]],
		T_TRANSACTPARAMSET			=> ["et_transaction_parameter_set", "v_et_transaction_param_set", ["transaction_code", "param_set"]],
		T_TRANSACTMENU				=> ["et_transaction_menu", "v_et_transaction_menu", ["menu_id"]],
		T_TRANSACTACCESS			=> ["et_transaction_access", "v_et_transaction_access", ["transaction_code", "usergroupname"]],
		T_CALLABLEOBJ				=> ["et_callable_object", "v_et_callable_object", ["callable_object"]],
		T_CALLABLEOBJSEQ			=> ["et_callable_seq", "v_et_callable_seq", ["callable_object", "callable_object_seq_member"]],
		T_CATALOGOBJCALLABLE		=> ["et_catalog_object_callable", "v_et_catalog_object_callable", ["catalog_id", "callable_object"]],
		T_CALLABLEACC				=> ["et_callable_access","v_et_callable_access", ["callable_object", "usergroupname"]],
		//catalog object column settings
		T_CATALOGOBJCOLPROP			=> ["et_catalog_object_column_prop","v_et_catalog_object_col_prop", ["catalog_object", "column_name"]],
		T_CONSTRAINT				=> ["et_constraint","v_et_constraint", ["constraint_name"]],
		T_LOOKUP					=> ["et_lookup","v_et_lookup", ["lookup_name"]],
		//master detail
		T_MASTERDETAIL				=> ["et_table_link","v_et_table_link", ["catalog_id_master", "instance_name_master", "logical_link"]],
		T_MASTERDETAILLINK			=> ["et_table_link_detail","v_et_table_link_detail", ["catalog_id_master", "instance_name_master", "logical_link"]],
		//logging
		T_LOGGING					=> ["et_logging", "v_et_logging", ["conn_name"]],
		T_CONNECTION				=> ["et_connection", "v_et_connection", ["conn_name"]],
		T_LOOKUPSYSTEM				=> ["et_lookup_value_system", "v_et_lookup_value_system", ["lookup_name", "lookup_number"]],
		T_USERPARAMETER				=> ["et_user_parameter", "v_et_user_parameter", ["param_id"]],
		V_CATALOGINSTANCEID			=> ["", "v_et_catalog_instance_id", ["cataloginstanceid"]],
		//etx config tables
		T_CATALOGOBJECTCONFIG		=> ["etx_catalog_object_config", "v_etx_catalog_object_config", ["appcode_cfg", "catalog_id", "cfg_id"]],
		
		//V3.3.0 deployment-tables
		T_DEPLOYDATAIMP 			=> ["et_deploydata_imp", "v_et_deploydata_imp_pending", []],
		T_DEPLOYDATAEXP 			=> ["et_deploydata_exp", "v_et_deploydata_exp_pending", []],
		T_DEPLOYLOG 				=> ["et_deploylog", "v_et_deploylog", ["niota_id", "deploy_id"]],
		T_DEPLOYLOGSTEP 			=> ["et_deploylog_step", "v_et_deploylog_step",  ["niota_id", "deploy_id", "stepnbr_deploy"]],
		T_DEPLOYARCHIVE 			=> ["et_deployarchive", "v_et_deployarchive", ["id_archive"]],
		
		//V3.3.0 extended meta-information tables
		T_METADBOBJECT 				=> ["et_metadb_object", "v_metadb_object", ["object"]],
		T_COLUMNFORMAT 				=> ["et_catalog_object_column_format", "v_et_catalog_object_column_format", ["catalog_id", "column_format"]],
		T_METADBLINK 				=> ["et_metadb_link", "v_et_metadb_link", ["catalog_id", "logical_link"]],
		T_METADBLINKDETAIL 			=> ["et_metadb_link_detail", "v_et_metadb_link_detail", ["catalog_id", "logical_link", "column_name"]],
		T_USERCOMMAREA 				=> ["et_user_comm_area", "et_user_comm_area", ["username"]],
		
		//V3.3.0 new helper/config tables
		T_MESSAGETEXT 				=> ["etx_message_text", "etx_message_text", ["appcode_msg", "msg_id", "lang_msg"]],
		T_SEQUENCE 					=> ["etx_sequence", "v_etx_sequence", ["appcode_seq", "seq_id"]],
		T_SYSTEMCONFIG 				=> ["etx_system_config", "v_etx_system_config", ["appcode_cfg", "cfg_id"]],
		T_USERCONFIG 				=> ["etx_user_config", "v_etx_user_config", ["appcode_cfg", "username", "cfg_id"]],
		V_USERGROUP_LU 				=> ["", "v_et_user_group_lu", ["usergroupname"]],
		
		//v5.0.1 new helper/config tables
		T_MESSAGEDETAIL				=> ["etx_message_detail", "etx_message_detail", ["id_log"]],
		V_CATALOG_INSTANCE_LU		=> ["", "v_et_catalog_object_instance_lookup", ["catalog_id", "instance_name"]],
		V_NEXTCATALOGID_LU 			=> ["", "v_et_catalog_id_next", ["catalog_id_next"]],
		
		T_FORMATDOMAINLOGC			=> ["et_format_domain_logical", "v_et_format_domain_logical", ["domain_id_logical"]],
		T_FORMATDOMAINPHYS			=> ["et_format_domain_physical", "v_et_format_domain_physical", ["domain_id_physical"]],
		T_FORMATDOMAINSEMA			=> ["et_format_domain_semantic", "v_et_format_domain_semantic", ["domain_id_semantic"]],		
		T_FORMATCOLUMNCOLL			=> ["et_format_collection_column", "v_et_format_collection_column", ["collection_id","column_name"]],
		T_FORMATOBJECTEXT			=> ["et_format_object", "v_et_format_object", ["catalog_id","instance_name"]],
		T_FORMATCOLUMNEXT			=> ["et_format_object_column", "v_et_format_object_column", ["catalog_id","instance_name","column_name"]],
		
		V_FORMATDOMAINLOGC_LU		=> ["", "v_et_format_domain_logical_lu", ["domain_id_logical"]],		
		V_FORMATDOMAINPHYS_LU		=> ["", "v_et_format_domain_physical_lu", ["domain_id_physical"]],		
		V_FORMATDOMAINSEMA_LU		=> ["", "v_et_format_domain_semantic_lu", ["domain_id_semantic"]],
		V_METADBREPOSITORY			=> ["", "v_et_metadb_object_repository", ["objabbrev","config_id"]]
	
		
];

const SYSTEM_VIEWS = [
//EXAMPLE:
//V_CALLABLE_ACCESS 				=> ["v_et_callable_access", ["callable_object", "usergroupname"]]
];
