<?php 
include 'classes/includeETclasses.php';

if (!isset($_SESSION))
	session_start();

	
if(isset ($_SESSION['username'])) {
	
	//we have to store $from, $to, etc values in $_SESSION. each POST is a "reload" of this page!!! 
	$rowCount 			= 0;
	$maxError			= -1;
	$maxMsg				= -1;
	$from				= 0;
	$to  				= 0;
	$chunkSize 			= 0;
	$ret				= ['finished' => false, 'from' => $from, 'to'=>$to, 'error' => false];
	$catalogInstanceId 	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];
	$connName 			= ET_BrowsingStore::getBrowsingStore()->get_connName($catalogInstanceId);
	
	if (isset($_POST['validationRequest'])) {
		
		$msgGuid 				= ET_CallableObjectHelper::getGUID();
		$br						= ET_BrowsingStore::getBrowsingStore();
		$lookups 				= $br->get_lookupSettings($catalogInstanceId);
		$lookupValues			= array();
		
		$_SESSION[$msgGuid] 	= array();
		$_SESSION[$msgGuid][SESS_VALIDATION_LOG_MESSAGES] 		= array();
		$_SESSION[$msgGuid][SESS_VALIDATION_CHECKED_ROWS_COUNT] = intval(0);
		$_SESSION[$msgGuid][SESS_VALIDATION_CHUNK_COLLECTOR] 	= array();
		$_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_LKP]	= intval(0);
		$_SESSION[$msgGuid][SESS_VALIDATION_ERROR_COUNT_CONST]	= intval(0);
		$_SESSION[$msgGuid][SESS_VALIDATION_ERROR_LOG_COUNT]	= intval(0);
		
		try {
			$lookupValues			= ET_ValidationHandler::getLookupValues($lookups);
		} catch (Exception $ex) {
			$ret['error'] 		= true;
			$ret['errorMsg'] 	= $ex->getMessage();
			$ret['msgGuid']		= $msgGuid;
		}
		
		ET_ValidationDataSessionManager::setLookupValuesForValidation($msgGuid, $lookupValues);
		
		
		try {
			$validationSettings = ET_ValidationDataConnector::getValidationSettings($catalogInstanceId, $connName);
			$rowCount	= $validationSettings['maxRow'];
			$maxMsg 	= $validationSettings['maxMsg'];
			$maxError 	= $validationSettings['maxErr'];
		} catch (Exception $e) {
			$ret['error'] 		= true;
			$ret['errorMsg'] 	= $e->getMessage();
			$ret['msgGuid']		= $msgGuid;
		}
		
		$chunkSize	= ET_ValidationDataConnector::getChunkSizeValue();
		$to 		= ET_ValidationDataConnector::calculateToValue(0, $chunkSize, $rowCount);
		
		ET_ValidationDataSessionManager::setAnyValidationSessionVariable($msgGuid, [
				"rowCount" 	=> $rowCount,
				"from" 		=> $from,
				"to" 		=> $to,
				"chunkSize" => $chunkSize,
				"maxErr"	=> $maxError,
				"maxMsg"	=> $maxMsg
		]);
				
		$ret['from'] 		= $from;
		$ret['to']			= $to;
		$ret['rowCount']	= $rowCount;
		$ret['msgGuid']		= $msgGuid;
		
		$logger				= new ET_DirectLogger($connName);
		try {
			$msStartLoaclized = ET_DisplayHelper::localize("VALIDATION_START", array(), PAGE_TYPE_GRID);
			$logger->log($msStartLoaclized, $msgGuid, CO_MESSAGE_TYPE_INFO, ET_DirectLogger::LOG_MSG_TYPE_SIMPLE);
		} catch (Exception $e) {
			$ret['error'] = true;
			$ret['errorMsg'] = $e->getMessage();
		}
		
		$ret['msg_process_status'] = ET_DisplayHelper::localize("VALIDATION_MSG_PROCESS_STATUS", array($rowCount, $from, $to, $msgGuid), PAGE_TYPE_GRID);
		
		echo json_encode($ret);
	}
	if (isset($_POST['chunkProcessRequest'])) {
		
		$errorLimitReached = false;
		$msgGuid	= isset($_POST['msgGuid']) ? $_POST['msgGuid'] : "";
		$from		= ET_ValidationDataSessionManager::getFrom($msgGuid);
		$to			= ET_ValidationDataSessionManager::getTo($msgGuid);
		$chunkSize	= ET_ValidationDataSessionManager::getChunkSize($msgGuid);
		$rowCount	= ET_ValidationDataSessionManager::getRowcount($msgGuid);
		$finished 	= false; 
		$summaryMsg	= "";
		$validationResult = ET_ValidationHandler::handleValidation($from, $to, $chunkSize, $rowCount, $catalogInstanceId, $msgGuid);
		
		$fromNext 	= intval($to) + 1;
		
		
		if (isset($validationResult['error_logging']) && $validationResult['error_logging'] === true) {
			
			$ret['error_logging'] = true;
			$ret['error_logging_msg'] = $validationResult['error_logging_msg'];
			
		} else if ($validationResult['errorLimitReached']) {			
			$finished 			= true;			
			$summaryMsg 		= ET_ValidationHandler::writeSummaryLogMsg($msgGuid, true, $connName);						
		} else if($fromNext >= $rowCount) {			
			$finished 			= true;			
			$errorLimitReached 	= $validationResult['errorLimitReached'];
			$summaryMsg 		= ET_ValidationHandler::writeSummaryLogMsg($msgGuid, $errorLimitReached, $connName);						
		}  else {
			$toNext = ET_ValidationDataConnector::calculateToValue($fromNext, $chunkSize, $rowCount);
			ET_ValidationDataSessionManager::setFrom($msgGuid, $fromNext);
			ET_ValidationDataSessionManager::setTo($msgGuid, $toNext);
			$ret['to']	= $toNext;
		}
			
		$ret['from'] 		= $fromNext;
		$ret['rowCount']	= $rowCount;
		
		if ($finished) {
			$ret['finished'] = true;
			$ret['init_msg'] 	= ET_DisplayHelper::localize("VALIDATION_END_INIT_MSG", array($msgGuid), PAGE_TYPE_GRID);
			$ret['summary'] 	= $summaryMsg;
			ET_ValidationDataSessionManager::resetCurrentValidationData($msgGuid);
		} else {			
			$ret['msg_process_status'] = ET_DisplayHelper::localize("VALIDATION_MSG_PROCESS_STATUS", array($rowCount, $from, $to, $msgGuid), PAGE_TYPE_GRID);
		}
		
		echo json_encode($ret);
	}
	
} else {
	header("Location: ../login.php");
}



?>