<?php
use phpGrid\C_DataBase as C_DataBase;
use phpGrid\C_DataGrid as C_DataGrid;
use phpGrid\C_DataArray as C_DataArray;
use phpGrid\C_Utility as C_Utility;
use phpGrid\C_SessionMaker as C_SessionMaker;

require_once(__DIR__ . '/conf/conf.php');

if(!isset($_SESSION)) {
	session_start();
}

$session 			= C_SessionMaker::getSession(FRAMEWORK);
$gridName 			= isset($_GET['gn']) ? $_GET['gn'] : die('PHPGRID_ERROR: URL parameter "gn" is not defined');
$catalogInstance	= $_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER];

/* etixpert old 
$connNameTemp = $_SESSION['selected_conn'];
$connType 	= getConnTypeByName($connNameTemp);
*/
$browsingStore 	= ET_BrowsingStore::getBrowsingStore();
$user 			= ET_NiotaUser::getNiotaUserFromSession();

$connNameTemp 	= $browsingStore->get_connName($catalogInstance);
$connType 		= ET_ConnHelper::getConnectionTypeByName($connNameTemp);

if($connType == 'oci805')
	$gridName = str_replace(".", "_", $gridName);
else {	
	//$gridName = $connNameTemp . "_" . str_replace(".", "_", $gridName);
	$gridName =  str_replace(".", "_", $gridName);
}


$grid_sql	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql');
$sql_key	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_key');
$sql_fkey	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_fkey');
$sql_table	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_table');  
$sql_filter	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_filter');       
$db_connection = unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_db_connection'));
$export_type= isset($_GET['export_type']) ? $_GET['export_type'] : $session->get(GRID_SESSION_KEY.'_'.$gridName.'_export_type');
$col_titles	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_col_titles'));
$col_hiddens= array_keys(unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_col_hiddens')));	// extract the keys only from multiple dimension       
$col_edittypes	= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_col_edittypes'));
$pdf_logo   = unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_pdf_logo'));

$db_charset = '';
$db_type = '';

if(!is_array($grid_sql)){
// establish db connection
    $cn = $db_connection;
    if(empty($cn)){
		//etixpert change start
		/*$db_name = PHPGRID_DB_NAME;
		$db_type = PHPGRID_DB_TYPE;
		$db_hostname = PHPGRID_DB_HOSTNAME;
		$db_username = PHPGRID_DB_USERNAME;
		$db_password = PHPGRID_DB_PASSWORD;
		
		$db_charset = PHPGRID_DB_CHARSET;
		*/
    	//etixpert change end
    	
    	$db_name = '';
    	$db_type = '';
    	$db_hostname = '';
    	$db_username = '';
    	$db_password = '';
    	
    	$db_charset = '';
    	$db_auth_mechanism = "";
    	$db_password_encrypted = false;
    	
		if (isset($_SESSION["selected_db"]) && isset($_SESSION["selected_conn"])) {
			$conn_array = ET_CONNECTIONS[$_SESSION["selected_conn"]];
			$db_hostname 	= $conn_array['PHPGRID_DB_HOSTNAME'];
			$db_username 	= $conn_array['PHPGRID_DB_USERNAME'];
			$db_password 	= $conn_array['PHPGRID_DB_PASSWORD'];
			$db_type 		= $conn_array['PHPGRID_DB_TYPE'];
			$db_charset 	= $conn_array['PHPGRID_DB_CHARSET'];
			$db_name 		= $_SESSION["selected_db"];
			
			if (isset($conn_array['PHPGRID_AUTH_MECHANISM']))
				$db_auth_mechanism = $conn_array['PHPGRID_AUTH_MECHANISM'];
			
			$db_password_encrypted	= $conn_array[PHPGRID_DB_PW_ENCRYPTED]; 
		}
		$db = new C_DataBase($db_hostname, $db_username, $db_password, $db_name, $db_type, $db_charset, array(), $db_auth_mechanism, $db_password_encrypted);
		//$db = new C_DataBase(PHPGRID_DB_HOSTNAME, PHPGRID_DB_USERNAME, PHPGRID_DB_PASSWORD, $db_name, PHPGRID_DB_TYPE, PHPGRID_DB_CHARSET);
    }
    else {
    	$db = new C_DataBase($cn["hostname"],$cn["username"],$cn["password"],$cn["dbname"],$cn["dbtype"],$cn["dbcharset"], array(), $cn['dbauthmechanism'], $cn['passwordEncrypted']);
       
        //Etixpert change
           	$db_type 	= $cn["dbtype"];
        	$db_charset = $cn["dbcharset"];
        //Etixpert change ends
    }
}else{
    $db = new C_DataArray($grid_sql);
}


// die if export wasn't enabled
if($export_type==null){
    die('Cannot export the grid. Please use enable_export() method to enable this feature.');
}



// --------------------- 4/20/2015 Richard ----------------
// if it is a masterdetail/subgrid, obtain the value of the foreign key to used later for filtering
$src = isset($_GET['src'])?$_GET['src']:'';
if($src=='md' || $src=='sg'){
    $fkey = $sql_fkey;//$_GET['fkey'];
    $fkey_value = $_GET['fkey_value'];

    if(C_Utility::is_debug()){
        echo 'fkey: ' ."\n";
        print_r($fkey);
        echo  "\n";
        echo 'fkey_value: ' ."\n";
        print_r($fkey_value);
    }
}
// create filter if exporting from a detail grid. Must check if the key is actual a database field
$sql_filter_md = '';
if($src=='md' || $src=='sg'){
    $sql_filter_md = $db->quote_field($grid_sql, $fkey, C_Utility::add_slashes($fkey_value));     // 1. master foreign key filter
}
// ------------ end of master detail filter ----------------



//$sord = (isset($_GET['sord']))?$_GET['sord']:'asc'; 
//$sidx = (isset($_GET['sidx']))?$_GET['sidx']:1; 
//Etixpert change
$sord = (isset($_GET['sord']) && $_GET['sord'] !== "null") ? $_GET['sord'] : 'asc';
$sidx = (isset($_GET['sidx']) && $_GET['sidx'] !== "null") ? $_GET['sidx'] : 1;
//Etixpert change
$do	= isset($_GET['do']) && $_GET['do'] !== "null" ? $_GET['do'] : 1;

//Etixpert change ends
if(!$sidx) $sidx =1; 

$rs     = $db->select_limit($grid_sql, 1, 1);


$sqlWhere = "";
$searchOn = (isset($_REQUEST['_search']) && $_REQUEST['_search'] =='true')?true:false;
if($searchOn) {
    $col_dbnames = array();
    $col_dbnames = $db->get_col_dbnames($rs);
    foreach($_REQUEST as $key=>$value) {
        if(in_array($key, $col_dbnames)){
            $fm_type = $db->field_metatype($rs, $db->field_index($rs, $key));
            switch ($fm_type) {
                case 'I':
                case 'N':
                case 'R':
                case 'L':
                    $sqlWhere .= " AND ".$key." = ".$value;
                    break;
                default:
                    $sqlWhere .= " AND ".$key." LIKE '".$value."%'";
                    break;
            }    
        }
        
    }
	//advanced search    
	if(isset($_REQUEST['filters']) && $_REQUEST['filters'] !=''){
		$op = array("eq"=>" ='%s' ","ne"=>" !='%s' ","lt"=>" < %s ",
			"le"=>" <= %s ","gt"=>" > %s ","ge"=>" >= %s ",
			"bw"=>" like '%s%%' ","bn"=>" not like '%s%%' " ,
			"in"=> " in (%s) ","ni"=> " not in (%s) ",
			"ew"=> " like '%%%s' ","en"=> " not like '%%%s' ",
			"cn"=> " like '%%%s%%' ","nc"=> " not like '%%%s%%' ");
		
		$filters = json_decode(stripcslashes($_REQUEST['filters']));
		$groupOp = $filters->groupOp;
		$rules = $filters->rules;
		
		for($i=0;$i<count($rules);$i++){                   
			$sqlWhere .=  $groupOp . " ". $rules[$i]->field .
				sprintf($op[$rules[$i]->op],$rules[$i]->data);              
		}
	}
}


// Sheldon (earthlink) contribution
// remove leading logical operator
$posAND = strpos($sqlWhere,'AND ');
$posOR = strpos($sqlWhere,'OR ');
if ($posAND !== false) {
    $sqlWhere = substr_replace($sqlWhere,'',$posAND,strlen('AND '));
}
elseif ($posOR !== false) {
    $sqlWhere = substr_replace($sqlWhere,'',$posOR,strlen('OR '));
}
else { //do nothing
}

//etixpert change
$sqlOrderBy = "";
// set ORDER BY. Don't use if user hasn't select a sort
if ($do == 0) {
	$pos = strpos(strtolower($grid_sql), "order by");
	if ($pos) {
		$grid_sql = substr($grid_sql, 0, $pos);
	}
	$sqlOrderBy = (!$sidx) ? "" : " ORDER BY $sidx $sord";
}
//etixpert ends

//original
//$sqlOrderBy = (!$sidx) ? "" : " ORDER BY $sidx $sord";

      
// ********* prepare the final query ***********************
$SQL = '';
if(!is_array($grid_sql)){
    if($sql_filter != '' && $searchOn){
        $SQL = $grid_sql .' WHERE '
                            .(($sql_filter_md!='') ? $sql_filter_md.' AND ' : '')
                            .$sql_filter .' AND ' .$sqlWhere 
                            .$sqlOrderBy;
    }elseif($sql_filter != '' && !$searchOn){
        $SQL = $grid_sql .' WHERE '
                            .(($sql_filter_md!='') ? $sql_filter_md.' AND ' : '') 
                            .$sql_filter 
                            .$sqlOrderBy;
    }elseif($sql_filter == '' && $searchOn){
        $SQL = $grid_sql .' WHERE '
                            .(($sql_filter_md!='') ? $sql_filter_md.' AND ' : '')
                            .$sqlWhere 
                            .$sqlOrderBy;
    }else{  // if($sql_filter == '' && !$searchOn){
        $SQL = $grid_sql .  (($sql_filter_md!='') ? ' WHERE '.$sql_filter_md : '')
                            .$sqlOrderBy;
    }
}
//echo 'sql_filter: '. $sql_filter;
//echo 'searchOn: '. $searchOn;
//echo $SQL; 

try {
	$connName = ET_BrowsingStore::getBrowsingStore()->get_ConnName($_SESSION[SESS_CATALOG_INSTANCE_ID_MASTER]);
	ET_LoggingHelper::log($connName, $SQL, LOGGING_SOURCE_EXCEL_EXPORT);
} catch (Throwable $e) {
	die('PHPGRID_ERROR: Logging error occured');
}

		
$result     = $db->db_query($SQL);
$row_count  = $db->num_rows($result);
$col_count  = $db->num_fields($result);

// $col_titles = array();
// $col_titles = $col_titles();
$j = 0;

switch(strtoupper($export_type)){
    case 'HTML': 
        header("Content-type: text/html");
        header("Content-disposition:  attachment; filename=Grid_". $gridName ."_".date("Y-m-d").".htm");
        header ('Expires: 0');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public');

        echo '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head><body>'. "\n";
        
        echo '<table border="1" cellspacing="0" cellpadding="2">' ."\n";  
        echo '<thead>' ."\n";      
            echo '<tr style="background-color:black;color:white">';
            for($j = 0; $j < $db->num_fields($rs); $j++) {
                $col_name = $db->field_name($rs, $j);                             
                if(!in_array($col_name, $col_hiddens)){
                    if(isset($col_titles[$col_name])){
                        echo '<th>'. $col_titles[$col_name] .'</th>';                
                    }else{
                        echo '<th>'. $col_name .'</th>';                                
                    }
                    
                }        
            }
            echo '</tr>' ."\n";            
        echo '</thead>' ."\n";
            
        echo '<tbody>' ."\n";
        if(!is_array($grid_sql)){
            while($row = $db->fetch_array_assoc($result)) {
                echo '<tr>';
                for($j = 0; $j < $db->num_fields($result); $j++) {
                    $col_name = $db->field_name($result, $j);
                    if(!in_array($col_name, $col_hiddens)){                // if not hidden
                        echo '<td>'. text_by_edittype($col_edittypes, $col_name, $row[$col_name]) .'&nbsp;</td>';
                    }
                }
                echo '</tr>' ."\n";
            }
        }else{
            foreach($result as $row){
                echo '<tr>';
                for($j = 0; $j < $db->num_fields($result); $j++) {
                    $col_name = $db->field_name($row, $j);
                    // echo 'col_name: '. $col_name ."\n";
                    if(!in_array($col_name, $col_hiddens)){
                        echo '<td>'. text_by_edittype($col_edittypes, $col_name, $row[$col_name]) .'&nbsp;</td>';
                        // echo '<td>'. $row[$col_name] .'&nbsp;</td>';
                    }
                }
                echo '</tr>' ."\n";
            }
        }
        echo '</tbody>' ."\n";
        echo '</table>' ."\n";      
        
        echo '</body></html>';      
		
    break;

    case 'EXCEL':
    	
    	$browsingStore = ET_BrowsingStore::getBrowsingStore();
    	$fullTableName = $browsingStore->get_fullTableName($catalogInstance);
    	
    	$selected_table = ET_CatalogInstance::getTableNameFromFullyQualifiedForm($fullTableName);
    	
    	//$con_md = getConnection(ET_METADATA_CONNECTION);
    	
    	
    	$admin = $user->get_isAdmin();
    	
    	if ($admin) {
    		
    		$user_rights 	= $user->get_userRights();    		
    		$allow_export 	= $user_rights[$catalogInstance]['allow_export'];

    		if (!$allow_export) {
    			print("No user rights for this operation.");
    			exit();
    		}
    	}
    	
    	$conn = $db->db;
    	
    	if (!$conn) {
    		die("Connection failed.");
    	}
    		
    	$sheet 		= [];
    	$colTypes 	= [];
    		
    	//$result = $conn->Execute($query . " order by ID");
    	   	
    	$oracle = ($db_type == 'oci805');
    	    	
    	if ($result) {
    		//$rs     = select_limit($query, 1, 1, $con);
    		$sheetHeader = array();
    	
    		for($j = 0; $j < $rs->FieldCount(); $j++) {
    			$col_name = ET_ExcelHelper::field_name($rs, $j);
    			//orig:
    			//$col_type = ET_ExcelHelper::field_metatype($rs, $j);
    			//new:
    			$col_type = ET_ExcelHelper::field_metatype($rs, $j, $db_type);
    			array_push($sheetHeader, $col_name);
    			array_push($colTypes, $col_type);
    		}
    		array_push($sheet, $sheetHeader);
    		    		
    		while($row = ET_ExcelHelper::fetch_array_assoc($result)) {
    			$sheetRow = array();
    			for($j = 0; $j < $result->FieldCount(); $j++) {
    				$col_name = ET_ExcelHelper::field_name($result, $j);
    				$colType = $colTypes[$j];
    				$val = $row[$col_name];
    				if ($colType == 'T') {
    					
    					if ($val != '') {
    						//print($val . "<br>");
							if ($oracle) {
								//$datetime = DateTime::createFromFormat('d-M-y h.i.s.u A', $val);
								$datetime = DateTime::createFromFormat('d-M-Y h.i.s.u A', $val);
								$val = $datetime->format("Y-m-d H:i:s");
							}
    					}
    				} else if ($colType == 'C') {
    					if ($db_type == 'odbc_mssql'  || $db_type == DB_TYPE_MSSQL) {
    						$val = iconv($db_charset, "utf-8", $val);
    					} else if ($db_type == 'odbc_teradata') {	
    						$val = iconv("iso-8859-2", "utf-8", $val);
    					}
    				}
    				array_push($sheetRow, $val);
    			}
    			array_push($sheet, $sheetRow);
    		}
    		
    		$filename = "Grid_" . $selected_table . "_" . date("Y-m-d") .".xlsx";    		
    		
    		$objPHPExcel = new PHPExcel();
    	
    		$objPHPExcel->getActiveSheet()->fromArray($sheet, NULL, 'A1');
    		$objPHPExcel->getActiveSheet()->setTitle($selected_table); // Change sheet's title
    	
    		$sheet_exc = $objPHPExcel->getActiveSheet();
    		$highestRow = $sheet_exc->getHighestRow();
    		$highestColumn = $sheet_exc->getHighestColumn();
    		
    		//$colIterator = $sheet_exc->getColumnIterator(1, $highestColumn);
    		
    		for ($k = 0; $k < count($colTypes); $k++) {
    			$colType = $colTypes[$k];
    			if ($colType == 'D' || $colType == 'T') {
    				$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow($k, 2, $k, $highestRow + 1000)
    				->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT );
    			}
    		}

//     		$objPHPExcel->getActiveSheet()->getStyle('E2')
//     		->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_TEXT );
    		
    		header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
    		//header("Content-Type:   application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8");
    		//Etixpert cange
    		//header("Content-Type: application/openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8");
    		//Etixpert cange ends
    		header("Content-Disposition: attachment; filename=". $filename);
    		header("Expires: 0");
    		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    		header("Cache-Control: private",false);
    	
    		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    		ob_end_clean();
    		$writer->save('php://output');
    		
    		exit;
    	} 
    	else {
    		print('<br>Database connection problem.<br>');
    	}
 
    break;

	case 'CSV':		
		header("Content-type: text/csv");
		header("Content-Disposition: attachment; filename=Grid_". $gridName ."_".date("Y-m-d").".csv");
		header("Pragma: no-cache");
		header("Expires: 0");

		$rows_all = array();
		$row_header = array();
        for($j = 0; $j < $db->num_fields($rs); $j++) {
            $col_name = $db->field_name($rs, $j);
            if(!in_array($col_name, $col_hiddens)){
                if(isset($col_titles[$col_name])){
                    $row_header[] = $col_titles[$col_name];
                }else{
                    $row_header[] = $col_name;
                }

            }
        }
		$rows_all[] = $row_header;
        if(!is_array($grid_sql)){
            while($row = $db->fetch_array_assoc($result)) {
                $row_body = array();
                for($j = 0; $j < $db->num_fields($result); $j++) {
                    $col_name = $db->field_name($result, $j);
                    if(!in_array($col_name, $col_hiddens)){
                        $row_body[] = text_by_edittype($col_edittypes, $col_name, $row[$col_name]);
                        // $row_body[] = $row[$col_name];
                    }
                }
                $rows_all[] = $row_body;
            }
        }else{
            foreach($result as $row) {
                $row_body = array();
                for($j = 0; $j < $db->num_fields($result); $j++) {
                    $col_name = $db->field_name($row, $j);
                    if(!in_array($col_name, $col_hiddens)){
                        $row_body[] = text_by_edittype($col_edittypes, $col_name, $row[$col_name]);
                        // $row_body[] = $row[$col_name];
                    }
                }
                $rows_all[] = $row_body;
            }
        }

		outputCSV($rows_all);
	break;

	case 'PDF':
		$htmloutput = '';
        $column_count = $db->num_fields($rs);

        // PDF logo (jpg only)
        if(!empty($pdf_logo)){
            $img_path   = $pdf_logo[0];  //realpath('logos/phpgrid-logo.jpg');
            $imgsize    = getimagesize($img_path);

            $width      = (isset($pdf_logo[1]))?$pdf_logo[1]:$imgsize[0]/4;
            $height     = (isset($pdf_logo[2]))?$pdf_logo[2]:$imgsize[1]/4;
            $static_txt = (isset($pdf_logo[3]))?$pdf_logo[3]:'';

            $htmloutput .='<table border=0><tr><td align=r><img src='. $img_path .' width=' .intval($width) .' height='. intval($height) .' /><br><br></td></tr><tr><td>'. $static_txt .'</td></tr><tr><td></td></tr></table>';
        }
        
        $htmloutput .= '<table border=1>' ;
        $htmloutput .= '<tr bgcolor=#9CC8FF repeat>';	// repeat this row on every page (header)
        for($j = 0; $j < $column_count; $j++) {
            $col_name = $db->field_name($rs, $j);
            if(!in_array($col_name, $col_hiddens)){
                if(isset($col_titles[$col_name])){
                    $htmloutput .= '<td>'. $col_titles[$col_name] .'</td>';
                }else{
                    $htmloutput .= '<td>'. $col_name .'</td>';
                }

            }
        }
        $htmloutput .= '</tr>' ;

        if(!is_array($grid_sql)){
            while($row = $db->fetch_array_assoc($result)) {
                $htmloutput .= '<tr>';
                for($j = 0; $j < $column_count; $j++) {
                    $col_name = $db->field_name($result, $j);
                    if(!in_array($col_name, $col_hiddens))
                        $htmloutput .= '<td>'. text_by_edittype($col_edittypes, $col_name, $row[$col_name]) .'&nbsp;</td>';
                        // $htmloutput .= '<td>'. $row[$col_name] .'&nbsp;</td>';
                }
                $htmloutput .= '</tr>' ;
            }
        }else{
            foreach($result as $row) {
                $htmloutput .= '<tr>';
                for($j = 0; $j < $column_count; $j++) {
                    $col_name = $db->field_name($row, $j);
                    if(!in_array($col_name, $col_hiddens))
                        $htmloutput .= '<td>'. text_by_edittype($col_edittypes, $col_name, $row[$col_name]) .'&nbsp;</td>';
                        // $htmloutput .= '<td>'. $row[$col_name] .'&nbsp;</td>';
                }
                $htmloutput .= '</tr>' ;
            }
        }

		$htmloutput .= '</table>' ;
		
		$pdf = new PDFTable();
		$pdf->AddPage();
		$pdf->AddFont('DejaVu','','DejaVuSansCondensed.ttf',true);
		$pdf->SetFont('DejaVu','',7);
		$pdf->htmltable($htmloutput);
		$pdf->output("Grid_". $gridName ."_".date("Y-m-d").".pdf", "I");
    break;

    case 'EXCELXML':
        header("Content-type: text/xml");
        header("Content-disposition:  attachment; filename=Grid_". $gridName ."_".date("Y-m-d").".xml");
        header ('Expires: 0');
        header ('Cache-Control: cache, must-revalidate');
        header ('Pragma: public');
        // Excel XML
        // ExpandedColumnCount and ExpandedRowCount must be greater than the actual # of cols and rows.
        echo '<?xml version="1.0"?>
            <?mso-application progid="Excel.Sheet"?>
            <Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
             xmlns:o="urn:schemas-microsoft-com:office:office"
             xmlns:x="urn:schemas-microsoft-com:office:excel"
             xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
             xmlns:html="http://www.w3.org/TR/REC-html40">
             <DocumentProperties xmlns="urn:schemas-microsoft-com:office:office">
              <Author>phpGrid.com</Author>
              <Created></Created>
              <LastSaved></LastSaved>
              <Version></Version>
             </DocumentProperties>
             <ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">
                <WindowHeight>768</WindowHeight>
                <WindowWidth>1024</WindowWidth>
                <WindowTopX>0</WindowTopX>
                <WindowTopY>0</WindowTopY>
                <ProtectStructure>False</ProtectStructure>
                <ProtectWindows>False</ProtectWindows>
            </ExcelWorkbook>
            <Styles>
                <Style ss:ID="Default" ss:Name="Normal">
                    <Alignment ss:Vertical="Bottom" />
                    <Borders/>
                    <Font ss:FontName="Arial" ss:Size="8" />
                    <Interior/>
                    <NumberFormat />
                    <Protection />
                </Style>
                <Style ss:ID="sHyperlink" ss:Name="Hyperlink">
                    <Font ss:Color="#0000FF" ss:Underline="Single" />
                </Style>
                <Style ss:ID="sDate">
                    <NumberFormat ss:Format="Short Date"/>
                </Style>
                <Style ss:ID="sNumber">
                    <NumberFormat/>
                </Style>                
                <Style ss:ID="sHeader">
                    <Font ss:Family="Arial" ss:Bold="1" />
                </Style>
                <Style ss:ID="sDecimal">
                    <NumberFormat ss:Format="Fixed"/>
                </Style>
            </Styles>';
        echo '<Worksheet ss:Name="Sheet1">
            <Table ss:ExpandedColumnCount="'. $col_count .'" 
              ss:ExpandedRowCount="'. ($row_count+1) .'" x:FullColumns="1"
              x:FullRows="1">';

        // grid header
        echo '<Row>';
        for($j = 0; $j < $col_count; $j++) {
            $col_name = $db->field_name($rs, $j);
            if(!in_array($col_name, $col_hiddens)){
                if(isset($col_titles[$col_name])){
                    echo '<Cell ss:StyleID="sHeader"><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $col_titles[$col_name])) .'</Data></Cell>';
                }else{
                    echo '<Cell ss:StyleID="sHeader"><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $col_name)) .'</Data></Cell>';
                }

            }
        }
        echo '</Row>' ."\n";

        // grid body
        $fm_type = 'C'; // field meta type
        if(!is_array($grid_sql)){
            while($row = $db->fetch_array_assoc($result)) {
                echo '<Row>';
                for($j = 0; $j < $col_count; $j++) {
                    $col_name = $db->field_name($result, $j);
                    if(!in_array($col_name, $col_hiddens)){
                        // $fm_type   = $db->field_metatype($result, $db->field_index($result, $col_name));
                        $display_text = text_by_edittype($col_edittypes, $col_name, $row[$col_name]);
                        echo '<Cell ss:StyleID="sDate"><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $display_text)) .'</Data></Cell>';
                        /*
                        switch($fm_type){
                            case 'D':
                                echo '<Cell ss:StyleID="sDate"><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $display_text)) .'</Data></Cell>';
                                break;
                            case 'I':
                            case 'R':
                                echo '<Cell ss:StyleID="sNumber"><Data ss:Type="Number">'. $row[$col_name] .'</Data></Cell>';
                                break;
                            case 'N':
                                echo '<Cell ss:StyleID="sDecimal"><Data ss:Type="Number">'. $row[$col_name] .'</Data></Cell>';
                                break;
                            default:
                                echo '<Cell><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $display_text)) .'</Data></Cell>';
                        }
                        */
                    }
                }
                echo '</Row>' ."\n";
            }
        }else{
            foreach($result as $row) {
                echo '<Row>';
                for($j = 0; $j < $col_count; $j++) {
                    $col_name = $db->field_name($row, $j);
                    if(!in_array($col_name, $col_hiddens)){
                        // $fm_type   = $db->field_metatype($result, $db->field_index($result, $col_name));
                        $display_text = text_by_edittype($col_edittypes, $col_name, $row[$col_name]);
                        echo '<Cell ss:StyleID="sDate"><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $display_text)) .'</Data></Cell>';
                        /*
                        switch($fm_type){
                            case 'D':
                                echo '<Cell ss:StyleID="sDate"><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $row[$col_name])) .'</Data></Cell>';
                                break;
                            case 'I':
                            case 'R':
                                echo '<Cell ss:StyleID="sNumber"><Data ss:Type="Number">'. $row[$col_name] .'</Data></Cell>';
                                break;
                            case 'N':
                                echo '<Cell ss:StyleID="sDecimal"><Data ss:Type="Number">'. $row[$col_name] .'</Data></Cell>';
                                break;
                            default:
                                echo '<Cell><Data ss:Type="String">'. str_replace('>', '&gt;', str_replace('<', '&lt;', $row[$col_name])) .'</Data></Cell>';
                        }
                        */
                    }
                }
                echo '</Row>' ."\n";
            }
        }


        echo '</Table>';
        echo '<WorksheetOptions 
              xmlns="urn:schemas-microsoft-com:office:excel">
                <Print>
                    <ValidPrinterInfo />
                    <HorizontalResolution>800</HorizontalResolution>
                    <VerticalResolution>0</VerticalResolution>
                </Print>
                <Selected />
                <Panes>
                    <Pane>
                        <Number>3</Number>
                        <ActiveRow>1</ActiveRow>
                    </Pane>
                </Panes>
                <ProtectObjects>False</ProtectObjects>
                <ProtectScenarios>False</ProtectScenarios>
            </WorksheetOptions>
        </Worksheet>
        </Workbook>';    
    break;
}

function outputCSV($data) {
	$outstream = fopen("php://output", "w");
	function __outputCSV(&$vals, $key, $filehandler) {
		fputcsv($filehandler, $vals); // add parameters if you want
	}
	array_walk($data, "__outputCSV", $outstream);
	fclose($outstream);
}

// e.g. str_kvpair: 1:San Francisco;2:Boston;3:NYC;test:Paris;5:Tokyo;6:Sydney;7:London
// convert to array e.g. $arr_kvpair[1] = 'San ...'
function array_kvpair($str_kvpair){
    $tmp = explode(';', $str_kvpair);
    $arr_kvpair = array();
    foreach($tmp as $key => $value){
        $k = substr($value, 0, strpos($value, ':'));
        $v = substr($value, strpos($value, ':')+1);
        $arr_kvpair[$k] = $v;
    }

    return $arr_kvpair;
}

// For now, the only edit type we need to deal with here is "select" 
function text_by_edittype(&$col_edtypes, $col, $select_key){
    $display_text = '';

    if(isset($col_edtypes[$col])){
        if($col_edtypes[$col]['type']=='select'){    // if edit type is select
            $arr_kvpair = array_kvpair($col_edtypes[$col]['value']);
            // print_r($arr_kvpair);
            if(isset($arr_kvpair[$select_key])){
                $display_text = $arr_kvpair[$select_key];
            }else{
                $display_text = '';
            }
        }else{
            $display_text = $select_key;
        }
    }else{
        $display_text = $select_key;    // default
    }

    return $display_text;
}
          
// free resource       
$db = null;
?>