<?php 
if (!isset($_SESSION)){
	session_start();
}
	ob_start();
	
	function exceptions_error_handler($severity, $message, $filename, $lineno) {
		
		if (error_reporting() == 0) {
			return;
		}
		if (error_reporting() & $severity) {	
			
			if (strpos($message, 'connections.php') !== 0 || strpos($message, 'include_once') !== 0) {				
				echo "<b class='error'>NIOTA INITIALIZATION ERROR! One ore more configuration file(s) cannot be found! 
					Check folder 'conf'!</b><br>
					$message<br>";
			}
			$errorMessage = $message;	
			return;
		}
	}
	set_error_handler('exceptions_error_handler');
	
	require_once(__DIR__ . '/etixpert/classes/ET_CookieHandler.php');
	require_once(__DIR__ . '/etixpert/generalFunctions.php');
	
	setClientIntoSession();	
	$clientName = $_SESSION['client'];
	
	require_once(__DIR__ . '/conf/conf.php');		
	ET_CookieHandler::setCookieClientName();
	ET_DisplayHelper::generateNiotaStyleSheet(); 		
	
 	// handling form submit
 	handleLoginPost();
 	
	$phpFileName 			= basename(__FILE__, '.php'); 	
 	$htmlTag 				= new HTMLhtml();
 	$headTag 				= new HTMLHead();
 	$bodyTag 				= new HTMLBody();
 	$title					= new HTMLTitle();
 	$divContent 			= new HTMLDiv(); 
 	$divFormContainer		= new HTMLDiv();
 	$divFooterHalf1			= new HTMLDiv();
 	$divFooterHalf2			= new HTMLDiv();
 	$divFeedbackMsg			= new HTMLDiv();
 	$divImgContainer		= new HTMLDiv();
 	
 	$divLoginContainer		= new HTMLDiv();	
 	$divHelpContainer		= new HTMLDiv();
 	
 	//$divOneThirdLeft		= new HTMLDiv();
 	$divOneThirdMid			= new HTMLDiv();
 	$divOneThirdRight		= new HTMLDiv();
 	
 	$imgLogin				= new HTMLImage();
 	$spanNiota				= new HTMLSpan();
 	$spanFooterBrand		= new HTMLSpan();
 	$spanFooterVersion		= new HTMLSpan(); 	
 	$spanFeedbackContent    = new HTMLSpan();
 	$formLogin				= new HTMLForm(); 	
 	$inputUsername			= new HTMLInput();
 	$inputPassword			= new HTMLInput();
 	$inputHiddenClient 		= new HTMLInput();
 	
 	$title->set_display_text(TITLE . " stardate: " . VERSION);
 	$bodyTag->set_id("login_body")->set_class("entry_body");
 	
 	//$divContent->set_class("width-100perc height-94vh bgcolor-deep-rgba flex-container");
 	$divContent->set_class("login_main_content");
 	$divFormContainer->set_class("horizontal-middle element-inline height-3vh");
 	$divFooterHalf1->set_class("bottom width-100perc height-3vh bgcolor-deep");
 	$divFooterHalf2->set_class("bottom width-100perc height-3vh bgcolor-mid");
 	$divFeedbackMsg->set_class("feedback_message font-l");
 	$divImgContainer->set_class("div_submit");
 	$divLoginContainer->set_class("horizontal-middle float-left login-container");
 	$divHelpContainer->set_class("help_container");
 	
 	//$divOneThirdLeft->set_class("third");
 	$divOneThirdMid->set_class("login_content_element");
 	$divOneThirdRight->set_class("login_content_element");
 	
 	//it was the only "niota" title on screen before that is why it is the naming:
 	$spanNiota->set_display_text("log in")->set_class("font-xxl element-block margin-bottom-20px")->set_style("width: 120px");
 	$spanFooterBrand->set_display_text(LOGIN_FOOTER)->set_class("float-left margin-left-20px font-m margin-top-1vh");
 	$spanFooterVersion->set_display_text("stardate: " . VERSION)->set_class("float-right margin-right-20px font-m margin-top-1vh");
 	$spanFeedbackContent->set_id("feedback_content");
 	
 	$imgLogin->set_onclick("javascript: document.forms[\"form_login\"].submit();")->set_src("etixpert/images/login.png")->set_title(ET_DisplayHelper::localize("LOGIN", null, PAGE_TYPE_GRID, true))->set_class("pointer");
 	
 	$formLogin->set_name("form_login")->set_action("login.php")->set_style("width: 400px;")->set_method("post")->set_class("element-inline");
 	$inputUsername->set_id("username")->set_type("text")->set_name("username")->set_placeholder(ET_DisplayHelper::localize("USERNAME", null, PAGE_TYPE_GRID, true))->set_autofocus()->set_class("input-login");
 	$inputPassword->set_id("password")->set_type("password")->set_name("password")->set_placeholder(ET_DisplayHelper::localize("PASSWORD", null, PAGE_TYPE_GRID, true))->set_keydown("javascript:submitwithenter(event, \"form_login\");")->set_class("input-login margin-top-10px");
 	$inputHiddenClient->set_id("hidden")->set_type("hidden")->set_name("client")->set_value($clientName);
 	echo "<!DOCTYPE html>";
 	$htmlTag->printOpeningTag();
 		$headTag->printOpeningTag();
 			ET_DisplayHelper::generateAndPrintTabIconTag("login");
 			$title->printOpeningTag();
 				$title->printDisplayText();
 			$title->printClosingTag();
 			
 			$colorThemeSettingFeedback = ET_DisplayHelper::getNiotaColorTheme(false);
 			if ($colorThemeSettingFeedback != "")
 				ET_DisplayHelper::addErrorLine($colorThemeSettingFeedback, "login");
 			
 			echo "<meta name='viewport' content='width=device-width, initial-scale=1'>";
 			echo "<script type='text/javascript' src='" . SERVER_ROOT . "/js/jquery-2.1.4.min.js'></script>";
 			echo "<script src='etixpert/js/ajaxFunctions.js' type='text/javascript'></script>";
 			echo "<script src='etixpert/js/eventHandlers.js' type='text/javascript'></script>";
 		$headTag->printClosingTag();
 		$bodyTag->printOpeningTag();
 		
 			$divContent->printOpeningTag();
 			
	 			//$divOneThirdLeft->printOpeningTag();
	 			//$divOneThirdLeft->printClosingTag();
	 			
	 			//$divOneThirdMid->printOpeningTag();
 			
		 			$divLoginContainer->printOpeningTag();
			 			$spanNiota->printOpeningTag();
			 			$spanNiota->printDisplayText();
			 			$spanNiota->printClosingTag();
		 				$divFormContainer->printOpeningTag();
			 				
			 				$formLogin->printOpeningTag();
			 					$inputUsername->printOpeningTag();
			 					$inputUsername->printBr();
			 					$inputPassword->printOpeningTag();
			 					$inputHiddenClient->printOpeningTag();
			 				$formLogin->printClosingTag();
			 				$divImgContainer->printOpeningTag();
			 					$imgLogin->printOpeningTag();
			 				$divImgContainer->printClosingTag();
		 				$divFormContainer->printClosingTag();				
		 			$divLoginContainer->printClosingTag();
		 				
		 				//$divOneThirdMid->printClosingTag();
		 				$divOneThirdRight->printOpeningTag();
			 				$divHelpContainer->printOpeningTag();
			 					ET_DisplayHelper::loadLoginHelpContent();
			 				$divHelpContainer->printClosingTag();
		 				$divOneThirdRight->printClosingTag();		 			
		 			
	 			if(isset($_SESSION[$phpFileName])){
	 				ET_DisplayHelper::printMessageBox($phpFileName, true);
	 				$_SESSION[$phpFileName] = "";
	 			}
	 			
 			$divContent->printClosingTag();
 			$divFooterHalf1->printOpeningTag();
 			$divFooterHalf1->printClosingTag();
 			$divFooterHalf2->printOpeningTag();
	 			$spanFooterBrand->printOpeningTag();
	 			$spanFooterBrand->printDisplayText();
	 			$spanFooterBrand->printClosingTag();
	 			$spanFooterVersion->printOpeningTag();
	 			$spanFooterVersion->printDisplayText();
	 			$spanFooterVersion->printClosingTag();
 			$divFooterHalf2->printClosingTag(); 			
 		$bodyTag->printClosingTag();
 	$htmlTag->printClosingTag();
 		
 	ob_end_flush();
	
	?>	 		
 	
	
				
	