<?php
use phpGrid\C_DataBase as C_DataBase;
use phpGrid\C_DataGrid as C_DataGrid;
use phpGrid\C_Utility as C_Utility;
use phpGrid\C_SessionMaker as C_SessionMaker;

require_once(__DIR__ . '/conf/conf.php');

// the request url should looks sth like this: 
// masterdetail.php?id=2&_search=false&nd=1277597709752&rows=20&page=1&sidx=lineid&sord=asc
$session = C_SessionMaker::getSession(FRAMEWORK);

$catalogInstanceId		= isset($_GET['catalog_instance_id']) ? $_GET['catalog_instance_id'] : null;

if (!is_null($catalogInstanceId)) {
	
	$gridName 				= isset($_GET['gn']) ? $_GET['gn'] : die('PHPGRID_ERROR: URL parameter "gn" is not defined');
	$subgridNumber 			= isset($_GET['sgn']) ? $_GET['sgn'] : die('PHPGRID_ERROR: URL parameter "sgn" is not defined');
	$data_type  			= isset($_GET['dt']) ? $_GET['dt']:'json';
	$virtualColumnPosition 	= isset($_GET['vcp']) ? $_GET['vcp'] : -1;
	//at frist load - when grids are empty - catalog ins. id is NULL. it is filled only when there is a selection on the master table
	
	$adminDatagridMaster	= isset($_GET['adgm']) ? $_GET['adgm'] : false;
	$logicalLink			= isset($_GET['sll']) ? $_GET['sll'] : 'EMPTY_LOGICAL_LINK';
	$catalogInstanceIdMaster
	= isset($_GET['ciim']) ? $_GET['ciim'] : false;
	$fixedValues			= (!is_null($catalogInstanceId) && $adminDatagridMaster) ? ET_BrowsingStore::getBrowsingStore()->get_mergedColumns($catalogInstanceId, $logicalLink) : array();
	$mergedColumnsMaster	= ($catalogInstanceIdMaster) ?  ET_BrowsingStore::getBrowsingStore()->get_mergedColumns($catalogInstanceIdMaster) : array();
	
	//it is needed onyl because of admin menui item:
	//custom menu setting -> the master and the detail grid has got the same catalog instance id
	$selfLookup 			= $catalogInstanceId == $catalogInstanceIdMaster ? true : false;
	
	//check the where in the grid sql and set a flag
	
	$grid_sql			= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql');
	$sql_key			= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_key'));
	$sql_fkey			= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_fkey');
	$sql_mfkey			= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_mfkey');
	$sql_fkey_ops 		= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_fkey_ops');
	$detail_order_by 	= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_detail_order_by');
	$sql_table			= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_table');
	//$sql_filter seems to get used at 'form only mode' only
	$sql_filter			= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_sql_filter');
	// $is_debug		= $session->get(GRID_SESSION_KEY.'_'.$gridName.'_is_debug');
	$db_connection 		= unserialize($session->get(GRID_SESSION_KEY.'_'.$gridName.'_db_connection'));
	
	//establish db connection
	$cn = $db_connection;
	
	$db 		= new C_DataBase($cn["hostname"],$cn["username"],$cn["password"],$cn["dbname"],$cn["dbtype"],$cn["dbcharset"], array(), $cn["dbauthmechanism"], $cn['passwordEncrypted']);
	$db_type 	= $cn["dbtype"];
	$db_charset = $cn["dbcharset"];
	
	//etixpert extension starts
	$br 			= ET_BrowsingStore::getBrowsingStore();
	$gridSqlObj 	= $br->get_gridSqlObject($catalogInstanceId);
	$objectJoinAlias = $gridSqlObj->getObjectJoinAlias();
	//etixpert extension ends
	
	//01.26.2011 by yuuki
	//Desc: commented line below
	//$sdg= $dg->obj_md;
	
	//$pk_val = $_GET['id'];
	$fk_val = (isset($_GET['fkey_value'])) ? $_GET['fkey_value'] : die();   // no selected row (when page is first loaded)
	$fk_val = ET_StringCheck::resolveSubstitutedCharactersInGET($fk_val);
	
	if(stripos($fk_val, '<input') !== false && stripos($fk_val, 'class="editable"') !== false){
		die();  // adding a new row in INLINE edit - do not load child grid
	}
	
	$fk     = $sql_fkey; //$dg->get_sql_fkey();
	$mfk	= $sql_mfkey;
	
	$fk_ops = $sql_fkey_ops;
	// ###### DEBUG ONLY #############
	//	echo 'sql_fkey: '. $sql_fkey;
	//  echo 'fk_val: '.($fk_val);
	//  echo '$fk: ' .($fk);
	// ###############################
	
	$page   = (isset($_GET['page']))?$_GET['page']:1;
	$limit  = (isset($_GET['rows']))?$_GET['rows']:20;
	$sord   = (isset($_GET['sord']))?$_GET['sord']:'asc';
	$sidx   = (isset($_GET['sidx']))?$_GET['sidx']:'';
	$do		= isset($_GET['do']) ? $_GET['do'] : 1;
	
	$rs     = $db->select_limit($grid_sql, 1, 1);
	
	// prepare sql WHERE statement.
	// there are THREE filters in detail grid
	// 1. master foreign key filter ($sql_filter_md)
	// 2. query filter (set_query_filter)
	// 3. search filter (integral or advanced)
	
	$fk = explode(SEPARATOR_HTML_GET, $fk);
	$mfk = explode(SEPARATOR_HTML_GET, $mfk);
	$fk_val = explode(SEPARATOR_HTML_GET, $fk_val);
	$fk_ops = explode(SEPARATOR_HTML_GET, $fk_ops);
	
	$br = ET_BrowsingStore::getBrowsingStore();
	
	$mergedDefaults = array();
	
	// 1. master foreign key filter
	$sql_filter_md = $db->quote_field_array($grid_sql, $fk, /*C_Utility::add_slashes($fk_val)*/ $fk_val, $fk_ops, $mfk, $mergedColumnsMaster);
	
	
	if (empty($sql_filter_md))
		$sql_filter_md = "1=1";
		
		//$sqlWhhere is the WHERE condition of the filter input placed on the grid (magnifier icon)
		//2. query filter. Set by magnifier icon - column filter on the top of each column
		$sqlWhere = '';
		$searchOn = (isset($_REQUEST['_search']) && $_REQUEST['_search'] =='true')?true:false;
		
		$col_dbnames = array();
		$col_dbnames = $db->get_col_dbnames($rs);
		
		if($searchOn) {
			
			//print_r($col_dbnames);
			// check if the key is actual a database field. If true, add it to SQL Where (sqlWhere) statement
			foreach($_REQUEST as $key=>$value) {
				//echo 'key:'. $key ."\n";
				if(in_array($key, $col_dbnames)){
					$fm_type = $db->field_metatype($rs, $db->field_index($rs, str_replace('`', '', $key)));
					switch ($fm_type) {
						case 'I':
						case 'N':
						case 'R':
						case 'SERIAL':
						case 'L':
							$sqlWhere .= " AND ".$key." = ". $value;
							break;
						default:
							$sqlWhere .= " AND ".$key." LIKE '". $value."%'";
							break;
					}
				}
				
			}
			
			//integrated toolbar and advanced search
			if(isset($_REQUEST['filters']) && $_REQUEST['filters'] !=''){
				$op = array("eq"=>" ='%s' ","ne"=>" !='%s' ","lt"=>" < %s ",
						"le"=>" <= %s ","gt"=>" > %s ","ge"=>" >= %s ",
						"bw"=>" like '%s%%' ","bn"=>" not like '%s%%' " ,
						"in"=> " in (%s) ","ni"=> " not in (%s) ",
						"ew"=> " like '%%%s' ","en"=> " not like '%%%s' ",
						"cn"=> " like '%%%s%%' ","nc"=> " not like '%%%s%%' ");
				
				$filters = json_decode(stripcslashes($_REQUEST['filters']));
				$groupOp = $filters->groupOp;	// AND/OR
				$rules = $filters->rules;
				
				for($i=0;$i<count($rules);$i++){
					$sqlWhere .=  $groupOp . " ". $rules[$i]->field .
					sprintf($op[$rules[$i]->op],C_Utility::add_slashes($rules[$i]->data));
				}
			}
		}
		
		// remove leading sql AND/OR
		$pos = strpos($sqlWhere,'AND ');
		if ($pos !== false) {
			$sqlWhere = substr_replace($sqlWhere,'',$pos,strlen('AND '));
		}
		$pos = strpos($sqlWhere,'OR ');
		if ($pos !== false) {
			$sqlWhere = substr_replace($sqlWhere,'',$pos,strlen('OR '));
		}
		
		// set ORDER BY. Don't use if user hasn't select a sort
		//original:
		//$sqlOrderBy = (!$sidx) ? "" : " ORDER BY $sidx $sord";
		//Etixpert change
		$sqlOrderBy = "";
		
		if (!empty($objectOrderBy)) {
			$sqlOrderBy = $objectOrderBy;
		} else {
			if ($do == 0) {
				$sqlOrderBy = (!$sidx) ? "" : " ORDER BY $sidx $sord";
			} else {
				//removed this at 2021-03-31:
				//previously set objectOrder is used
				//if (!empty($detail_order_by)) {
				//	$sqlOrderBy = " ORDER BY " . $detail_order_by;
				//}
			}
		}
		//etixpert ends
		
		if ($searchOn) {
			$gridSqlObj->setWhereColumnSearch($sqlWhere);
		}
		
		$gridSqlObj->setOrderByPhpGrid($sqlOrderBy);
		$gridSqlObj->setWhereSqlFilter($sql_filter);
		$gridSqlObj->setWhereMasterDetail($sql_filter_md);
		
		$SQL = "";
		if (!$selfLookup) {
			$SQL = $gridSqlObj->generateSql();
		} else {
			//this old 'n ugly code is here because of self master-detaill setting:
			//admin custom-menu menu item
			
			// ********* prepare the final query ***********************
			if($sql_filter != '' && $searchOn){
				$SQL = $grid_sql .' WHERE '. $sql_filter_md . ' AND '. $sql_filter .' AND '. $sqlWhere . $sqlOrderBy;
			}elseif($sql_filter != '' && !$searchOn){
				$SQL = $grid_sql .' WHERE '. $sql_filter_md .' AND '. $sql_filter . $sqlOrderBy;
			}elseif($sql_filter == '' && $searchOn){
				$SQL = $grid_sql .' WHERE '. $sql_filter_md .' AND '. $sqlWhere . $sqlOrderBy;
			}else{ // if($sql_filter == '' && !$searchOn){
				$SQL = $grid_sql .' WHERE '. $sql_filter_md . $sqlOrderBy;
			}
			// ********* prepare the final query ETIXPERT way ***********************
			//NOTE: $grid_sql contains the objectFilter of the catalog instance!!!
			
			
			//Etixpert change 2018-02-07
			//ALL uppercase WHERE turns to AND. in the grid sql the objectFilter is lowecase where!!
			if (strpos($SQL, ' where ')) {
				$SQL = str_replace(' WHERE ', ' AND ', $SQL);
			}
			
		}
		
		//TODO: convert the SQL to the db charset to avoid problems of special characters in SQL
		if ($db_type != DB_TYPE_OCI805) {
			$SQL = iconv("utf-8", $db_charset, $SQL);
		}
		
		//Etixpert change ends
		//echo $SQL;
		// **** DEBUG **** //
		if(C_Utility::is_debug()){
			echo $SQL ."<br />";
		}
		
		// ********************** pagination *******************
		$rs    = $db->db_query($SQL);
		$count = $db->num_rows($rs);
		
		// calculate the total pages for the query
		if( $count > 0 && $limit > 0) {
			$total_pages = ceil($count/$limit);
		}else{
			$total_pages = 0;
		}
		
		// if for some reasons the requested page is greater than the total, set the requested page to total page
		if ($page > $total_pages) $page=$total_pages;
		// calculate the starting position of the rows
		$start = $limit*$page - $limit;
		// if for some reasons start position is negative set it to 0. typical case is that the user type 0 for the requested page
		if($start <0) $start = 0;
		
		
		
		// ******************* execute query finally *****************
		$db->db->SetFetchMode(ADODB_FETCH_BOTH);
		$result = $db->select_limit($SQL, $limit, $start);
		
		// **** DEBUG **** //
		if(C_Utility::is_debug()){
			echo $limit ."<br />";
			echo $start ."<br />";
			echo $total_pages ."<br />";
			echo $fk ."<br />";
			
			echo "<br />";
		}
		
		// $col_hiddens = $sdg->get_col_hiddens();
		
		//01.26.2011 by yuuki
		//Desc: get the data type from $dg object
		//$data_type = $sdg->get_jq_datatype();
		// $data_type = $dg->get_jq_datatype();
		switch($data_type)
		{
			// render xml. Must set appropriate header information.
			case "xml":
				$data = "<?xml version='1.0' encoding='utf-8'?>";
				$data .=  "<rows>";
				$data .= "<page>".$page."</page>";
				$data .= "<total>".$total_pages."</total>";
				$data .= "<records>".$count."</records>";
				$i = 0;
				while($row = $db->fetch_array_assoc($result)) {
					//01.26.2011 by yuuki
					//Desc: get the data key from $dg object
					// $data .= "<row id='". $row[$dg->get_sql_key()] ."'>";
					$data .= "<row id='". gen_rowids($row, $sql_key) ."'>";
					for($i = 0; $i < $db->num_fields($result); $i++) {
						$col_name = $db->field_name($result, $i);
						$data .= "<cell>". $row[$col_name] ."</cell>";
					}
					$data .= "</row>";
				}
				$data .= "</rows>";
				
				header("Content-type: text/xml;charset=utf-8");
				echo $data;
				break;
				
			case "json":
				$response = new stdClass();   // define anonymous objects
				$response->page = $page;
				$response->total = $total_pages;
				$response->records = $count;
				$i=0;
				$data = array();
				
				$columnInfo = !empty($catalogInstanceId) ? ET_BrowsingStore::getBrowsingStore()->get_selectedColumnInfo($catalogInstanceId) : array();
				
				$mergedIndexes = array();
				$mergedIndexesSet = FALSE;
				
				//Etixpert change starts
				
				if (count($fixedValues) > 0) {
					
					//if(!$result->EOF) {
					for ($ii = 0; $ii < count($fixedValues); $ii++) {
						$settings = $fixedValues[$ii];
						$col1 		= $settings['column1'];
						$col2 		= $settings['column2'];
						$colTarget 	= $settings['columnTarget'];
						$alias		= $settings['alias'];
						$delimiter 	= $settings['delimiter'];
						$mergedIndex = array();
						
						//for ($j = 0; $j < $db->num_fields($result); $j++) {
						$fldCount = $result->fieldCount();
						
						for ($j = 0; $j < $fldCount; $j++) {
							//$col_name = $db->field_name($result, $j);
							$col_name = $result->Fetchfield($j)->name;
							
							if (strtolower($col_name) == strtolower($col1)) {
								$mergedIndex['col1_index'] = $j;
								$mergedIndex['col1'] = $col1;
							}
							else if (strtolower($col_name) == strtolower($col2)) {
								$mergedIndex['col2_index'] = $j;
								$mergedIndex['col2'] = $col2;
							}
							
							if (strtolower($col_name) == strtolower($colTarget)) {
								$mergedIndex['col_target_index'] = $j;
								$mergedIndex['col_target'] = $colTarget;
							}
							
						}
						$mergedIndex['delimiter'] = $delimiter;
						$mergedIndexesSet = TRUE;
						$mergedIndexes[] = $mergedIndex;
					}
					//}
				}
				
				setDefaultMergeValues($mergedDefaults, $mergedIndexes, $col_dbnames, $fk, $fk_val);
				
				ob_start();
				
				$result->MoveFirst();
				
				while ($row = $db->fetch_array_assoc($result)) {
					unset($data);
					//01.26.2011 by yuuki
					//Desc: get the key from $dg object
					//$response->rows[$i]['id']=$row[$sdg->get_sql_key()];
					$response->rows[$i][JQGRID_ROWID_KEY]=C_Utility::gen_rowids($row, $sql_key); //$row[$sql_key];
					
					$offset = 0;
					
					//Etixpert chnage starts
					if($virtualColumnPosition == 0) {
						$data[] = "";
						$offset = 1;
					}
					//Etixpert change ends
				
					for($j = 0; $j < $db->num_fields($result); $j++) {
						
						$col_name = $db->field_name($result, $j);
						//original line:
						//$data[] = $row[$col_name];
						
						//etixpert change start
						//$fieldMetaType = $columnInfo[strtolower($col_name)]['metaType'];
						
						$fieldMetaType = $columnInfo[strtolower($col_name)]['metaType'];
						if($fieldMetaType == 'C' && $db_type != 'oci805'){
							if($db_type == "odbc_teradata")
								$data[] = rtrim(iconv($db_charset, "UTF-8", $row[$col_name]));
								else
									$data[] = iconv($db_charset, "UTF-8", $row[$col_name]);
						}
						else{
							$data[] = $row[$col_name];
						}
						
						//etixpert ends
					}
					
					if ($mergedIndexesSet) {
						
						for ($k = 0; $k < count($mergedIndexes); $k++) {
							$mergedIndex = $mergedIndexes[$k];
							$col1_index = $mergedIndex['col1_index'] + $offset;
							$col2_index = $mergedIndex['col2_index'] + $offset;
							$col_target_index = $mergedIndex['col_target_index'] + $offset;
							$col_target = $mergedIndex['col_target'];
							$delimiter  = $mergedIndex['delimiter'];
							$mergedVal = $data[$col1_index] . $delimiter . $data[$col2_index];
							$data[$col_target_index] = $mergedVal;
							
						}
					}
					
					$response->rows[$i]['cell'] = $data;
					$i++;
					
				}
				//}
				//else {
				//
					//}
					//$orderedColumnNames = ET_DataGrid::getColumnNamesOrdered($columnInfo, false);
					
				$defaultValues = array();
					if ($virtualColumnPosition == 0)
						array_push($defaultValues, "");
						
						for ($i = 0; $i < count($fk); $i++) {
							if ($fk_ops[$i] === '1' || $fk_ops[$i] === '0') {
								$defaultValues[$fk[$i]] = $fk_val[$i];
								if (isset($mergedDefaults[$fk[$i]])) {
									$defaultValues[$fk[$i]] = $mergedDefaults[$fk[$i]];
									
								}
								else {
									$defaultValues[$fk[$i]] = $fk_val[$i];
								}
							}
						}
						
						$response->defaultValues = $defaultValues;
						
						echo json_encode($response);
						break;
		}
		
		// free resource
		$db = null;
		$gridSqlObj->setWhereMasterDetail("");
		$gridSqlObj->setWhereSqlFilter("");
	
} else {
	return;
}


function setDefaultMergeValues(&$mergedDefaults, $mergedIndexes, $colNames, $fk, $fk_val) {
	
	for ($i = 0; $i < count($mergedIndexes); $i++) {
		$mergedIndex = $mergedIndexes[$i];
		
		$col1_index = $mergedIndex['col1_index'];
		$col2_index = $mergedIndex['col2_index'];
		$col_target_index = $mergedIndex['col_target_index'];
		$col_target = $mergedIndex['col_target'];
		$col1 = $mergedIndex['col1'];
		$col2 = $mergedIndex['col2'];
		$delimiter  = $mergedIndex['delimiter'];
		$col1_val = "";
		$col2_val = "";
		
		$fkArray = array();
		for ($d = 0; $d < count($fk); $d++) {
			$fkArray[strtolower($fk[$d])] = $fk_val[$d];
		}
		
		for ($ii = 0; $ii < count($colNames); $ii++) {
			$colName = $colNames[$ii];
			$keyValue = isset($fkArray[strtolower($colName)]) ? $fkArray[strtolower($colName)] : "";
						
			if (strtolower($colName) == strtolower($col1)) {
				$col1_val = $keyValue;				
			} else if (strtolower($colName) == strtolower($col2)) {
				$col2_val = $keyValue;
			}
			
		}
		
		if ($col1 != '')
			$mergedDefaults[$col_target] = $col1_val . $delimiter . $col2_val; 
	}	
	
}


?>
