<?php

session_start();
ob_start();

function exceptions_error_handler($severity, $message, $filename, $lineno) {
	
	if (error_reporting() == 0) {
		return;
	}
	if (error_reporting() & $severity) {
		
		if (strpos($message, 'connections.php') !== 0 || strpos($message, 'include_once') !== 0) {
			echo "<b class='error'>NIOTA INITIALIZATION ERROR! One ore more configuration file(s) cannot be found or outdated!
			Check folder 'conf'!</b><br>
			$message<br>";
		}
		$errorMessage = $message;
		return;
	}
}
set_error_handler('exceptions_error_handler');

require_once(__DIR__ . '/etixpert/classes/ET_CookieHandler.php');
require_once(__DIR__ . '/etixpert/generalFunctions.php');

setClientIntoSession();
$clientName = $_SESSION['client'];

require_once(__DIR__ . '/conf/conf.php');

ET_CookieHandler::setCookieClientName();
ET_DisplayHelper::generateNiotaStyleSheet();

$phpFileName 			= basename(__FILE__, '.php');
$htmlTag 				= new HTMLhtml();
$headTag 				= new HTMLHead();
$bodyTag 				= new HTMLBody();
$title					= new HTMLTitle();
$divContent 			= new HTMLDiv();
$divFormContainer		= new HTMLDiv();
$divFooterHalf1			= new HTMLDiv();
$divFooterHalf2			= new HTMLDiv();
$divFeedbackMsg			= new HTMLDiv();
$divImgContainer		= new HTMLDiv();
$divImgContainer		= new HTMLDiv();

$divHelpContainer		= new HTMLDiv();
$spanFooterBrand		= new HTMLSpan();
$spanFooterVersion		= new HTMLSpan();
$spanFeedbackContent    = new HTMLSpan();
$formLogin				= new HTMLForm();
$inputUsername			= new HTMLInput();
$inputPassword			= new HTMLInput();
$inputHiddenClient 		= new HTMLInput();

$divModalMain			= new HTMLDiv();
$divContentModal		= new HTMLDiv();
$divHeader				= new HTMLDiv();
$divUserData 			= new HTMLDiv();
$divPassword 			= new HTMLDiv();
$divFeedbackPers		= new HTMLDiv();
$divWrapperLowerPart 	= new HTMLDiv();
$divLowerPartLeftSide 	= new HTMLDiv();
$divLowerPartRigthSide 	= new HTMLDiv();

$spanHeader				= new HTMLSpan();

$formUserData			= new HTMLForm();
$inputFirstname 		= new HTMLInput();
$inputLastName 			= new HTMLInput();
$inputCompany 			= new HTMLInput();
$inputEmail 			= new HTMLInput();
$inputPasswordNew 		= new HTMLInput();
$inputPasswordNewRe 	= new HTMLInput();
$inputTermsOfUse 		= new HTMLInput();

$spanFirstName			= new HTMLSpan();
$spanLastName			= new HTMLSpan();
$spanCompany			= new HTMLSpan();
$spanEmail				= new HTMLSpan();
$spanPasswordNew		= new HTMLSpan();
$spanPasswordNewRe		= new HTMLSpan();
$spanAcceptTerms 		= new HTMLSpan();

$buttonRegister			= new HTMLButton();
$buttonSendLink			= new HTMLButton();

$formBlank				= new HTMLForm();
$inputBlank	 			= new HTMLInput();

$aShowHidePasswd		= new HTMLa();
$imgLock 				= new HTMLImage();
$imgLockTitle			= ET_DisplayHelper::localize("PERSONAL_SHOW_PW", array(), PAGE_TYPE_GRID, true);
$imgInfo				= new HTMLImage();
$aAlreadyRegistered 	= new HTMLa();
$aTermsOfUse 			= new HTMLa();
$aSendVerifyEmail		= new HTMLa();

$divModalMain->set_class("modal_reg")->set_id("modal_reg");
$divContentModal->set_class("modal_reg_content");
$divHeader->set_class("modal_reg_header");
$divUserData->set_class("modal_personal_form_wrapper");
$divPassword->set_class("modal_personal_form_wrapper");
$divFeedbackPers->set_id("feedback_container")->set_class("margin-left-20px margin-top-20px element-inline-block white-space-normal");
$divWrapperLowerPart->set_class("width-100perc");
$divLowerPartLeftSide->set_class("width-50perc float-left");
$divLowerPartRigthSide->set_class("width-50perc float-right");

$spanHeader->set_display_text("registration page")->set_class("font-l bold");

$formUserData->set_name("update_userdata")->set_action("niota.php")->set_method("post");
$inputFirstname->set_type("text")->set_name(POST_PERSONAL_FIRSTNAME)->set_id("firstname")->set_class("modal_reg_input")->set_maxlength("64");
$inputLastName->set_type("text")->set_name(POST_PERSONAL_LASTNAME)->set_id("lastname")->set_class("modal_reg_input")->set_maxlength("64");
$inputEmail->set_type("text")->set_name(POST_PERSONAL_EMAIL)->set_id("email")->set_class("modal_reg_input")->set_maxlength("64");
$inputCompany->set_class("modal_reg_input")->set_id("company")->set_maxlength("128");
$spanFirstName->set_display_text(ET_DisplayHelper::localize("FIRSTNAME_REG", array(), PAGE_TYPE_GRID, true));
$spanLastName->set_display_text(ET_DisplayHelper::localize("LASTNAME_REG", array(), PAGE_TYPE_GRID, true));
$spanCompany->set_display_text(ET_DisplayHelper::localize("COMPANY", array(), PAGE_TYPE_GRID, true));
$spanEmail->set_display_text(ET_DisplayHelper::localize("EMAIL_REG", array(), PAGE_TYPE_GRID, true));
$spanAcceptTerms->set_display_text(ET_DisplayHelper::localize("ACCEPT", array(), PAGE_TYPE_GRID, true), array(), PAGE_TYPE_GRID, true);

$inputPasswordNew->set_type("password")->set_name(POST_PERSONAL_PASSWORD_NEW)->set_id("password_new")->set_class("modal_reg_input")->set_maxlength("32");
$inputPasswordNewRe->set_type("password")->set_name(POST_PERSONAL_PASSWORD_NEW_RE)->set_id("password_new_re")->set_class("modal_reg_input")->set_maxlength("32");

$spanPasswordNew->set_display_text(ET_DisplayHelper::localize("PASSWORD", array(), PAGE_TYPE_GRID, true));
$spanPasswordNewRe->set_display_text(ET_DisplayHelper::localize("PASSWORD_RE", array(), PAGE_TYPE_GRID, true));

$inputTermsOfUse->set_type("checkbox")->set_id("chck_terms")->set_name("chck_terms")->set_class("modal_reg_checkbox");

$aShowHidePasswd->set_onclick("toggle_password(" . json_encode(false) . ", \"$imgLockTitle\"," . json_encode(true). " )")->set_id("showhidepasswd")->set_status("hidden");
$imgLock->set_src(NIOTA_ROOT_DIR . '/etixpert/images/open_lock.png')->set_title($imgLockTitle)->set_class("pointer");
$imgInfo->set_class("float-right pointer")->set_src(NIOTA_ROOT_DIR . '/etixpert/images/info.png')->set_title(ET_DisplayHelper::localize("REGISTRATION_INFO", array(), PAGE_TYPE_GRID, true))->set_onclick("javascript:displayDiv(\"registration_from_info_main_id\")");

$buttonRegister->setButtonText(ET_DisplayHelper::localize("REGISTER", array(), PAGE_TYPE_GRID, true))->set_class("modal_reg_button")->set_onclick("register()");
$buttonSendLink->setButtonText(ET_DisplayHelper::localize("RESEND_VERIFY_EMAIL", array(), PAGE_TYPE_GRID, true))->set_onclick("resendEmail()")->set_class("send_link_button");

$clientToLink = "?client=$clientName";
$aAlreadyRegistered->set_display_text(ET_DisplayHelper::localize("ALREADY_REGISTERED", array(), PAGE_TYPE_GRID, true))->set_href("login.php" . $clientToLink)->set_class("float-left");

$aTermsOfUse->set_display_text(ET_DisplayHelper::localize("TERMS_OF_USE", array(), PAGE_TYPE_GRID, true))->set_href(TERMS_OF_USE_LINK)->set_target("_blank");
$aSendVerifyEmail->set_display_text(ET_DisplayHelper::localize("RESEND_VERIFY_EMAIL", array(), PAGE_TYPE_GRID, true))->set_onclick("send_verify_email()")->set_class("pointer float-right");

$title->set_display_text(TITLE . " stardate: " . VERSION);
$bodyTag->set_id("register_body")->set_class("entry_body");

$divContent->set_class("width-100perc height-94vh bgcolor-deep-rgba overflow-auto;");
$divFormContainer->set_class("horizontal-middle element-inline height-3vh");
$divFooterHalf1->set_class("bottom width-100perc height-3vh bgcolor-deep");
$divFooterHalf2->set_class("bottom width-100perc height-3vh bgcolor-mid");
$divFeedbackMsg->set_class("feedback_message font-l");
$divImgContainer->set_class("div_submit");

$divHelpContainer->set_class("modal_reg_content");

//it was the only "niota" title on screen before that is why it is the naming:
$spanFooterBrand->set_display_text(LOGIN_FOOTER)->set_class("float-left margin-left-20px font-m margin-top-1vh");
$spanFooterVersion->set_display_text("stardate: " . VERSION)->set_class("float-right margin-right-20px font-m margin-top-1vh");
$spanFeedbackContent->set_id("feedback_content");

echo "<!DOCTYPE html>";
$htmlTag->printOpeningTag();
$headTag->printOpeningTag();
ET_DisplayHelper::generateAndPrintTabIconTag("register");
$title->printOpeningTag();
$title->printDisplayText();
$title->printClosingTag();

$colorThemeSettingFeedback = ET_DisplayHelper::getNiotaColorTheme(false);
if ($colorThemeSettingFeedback != "")
	ET_DisplayHelper::addErrorLine($colorThemeSettingFeedback, "login");
	
	echo "<meta name='viewport' content='width=device-width, initial-scale=1'>";
	echo "<script type='text/javascript' src='" . SERVER_ROOT . "/js/jquery-2.1.4.min.js'></script>";
	echo "<script src='etixpert/js/ajaxFunctions.js' type='text/javascript'></script>";
	echo "<script src='etixpert/js/eventHandlers.js' type='text/javascript'></script>";
	echo "<script src='etixpert/js/registration.js' type='text/javascript'></script>";
	$headTag->printClosingTag();
	$bodyTag->printOpeningTag();
	
	$divContent->printOpeningTag();
		ET_DisplayHelper::printSimpleBox('register');
		$divModalMain->printOpeningTag();
		
		$divContentModal->printOpeningTag();
			$aAlreadyRegistered->printOpeningTag();
				$aAlreadyRegistered->printDisplayText();
			$aAlreadyRegistered->printClosingTag();
			$imgInfo->printOpeningTag();
			$aAlreadyRegistered->printBr();$aAlreadyRegistered->printBr();			
			$formUserData->printOpeningTag();
				$spanFirstName->printOpeningTag();$spanFirstName->printDisplayText();$spanFirstName->printClosingTag();$spanFirstName->printBr();
				$inputFirstname->printOpeningTag();
				$inputFirstname->printBr();
				$spanLastName->printOpeningTag();$spanLastName->printDisplayText();$spanLastName->printClosingTag();$spanFirstName->printBr();
				$inputLastName->printOpeningTag();
				$inputLastName->printBr();
				$spanCompany->printOpeningTag();$spanCompany->printDisplayText();$spanCompany->printClosingTag();$spanCompany->printBr();
				$inputCompany->printOpeningTag();
				$inputCompany->printBr();
				$spanEmail->printOpeningTag();$spanEmail->printDisplayText();$spanEmail->printClosingTag();$spanFirstName->printBr();
				$inputEmail->printOpeningTag();
				$inputEmail->printBr();
			
				$aShowHidePasswd->printOpeningTag();$imgLock->printOpeningTag();
				$aShowHidePasswd->printClosingTag();$aShowHidePasswd->printBr();	
				$inputPassword->printBr();
				$spanPasswordNew->printOpeningTag();$spanPasswordNew->printDisplayText();$spanPasswordNew->printClosingTag();$spanPasswordNew->printBr();
				$inputPasswordNew->printOpeningTag();
				$inputPasswordNew->printBr();
				$spanPasswordNewRe->printOpeningTag();$spanPasswordNewRe->printDisplayText();$spanPasswordNewRe->printClosingTag();$spanPasswordNewRe->printBr();
				$inputPasswordNewRe->printOpeningTag();
				$inputPasswordNewRe->printBr();	
				$inputTermsOfUse->printOpeningTag();$inputTermsOfUse->printClosingTag();
				$spanAcceptTerms->printOpeningTag();$spanAcceptTerms->printDisplayText();$spanAcceptTerms->printClosingTag();
				$aTermsOfUse->printOpeningTag();
					echo " "; $aTermsOfUse->printDisplayText();
				$aTermsOfUse->printClosingTag();
				$formUserData->printClosingTag();
				
				$divWrapperLowerPart->printOpeningTag();
					$divLowerPartLeftSide->printOpeningTag();
						$divFeedbackPers->printOpeningTag();
						$divFeedbackPers->printClosingTag();
					$divLowerPartLeftSide->printClosingTag();
					$divLowerPartRigthSide->printOpeningTag();
						$buttonRegister->printOpeningTag();
							$buttonRegister->printButtonText();
						$buttonRegister->printClosingTag();
						
						$buttonSendLink->printOpeningTag();
							$buttonSendLink->printButtonText();
						$buttonRegister->printClosingTag();
					$divLowerPartRigthSide->printClosingTag();
				$divWrapperLowerPart->printClosingTag();
		$divContentModal->printClosingTag();
		$divHelpContainer->printOpeningTag();
			ET_DisplayHelper::loadLoginHelpContent(true);
		$divHelpContainer->printClosingTag();		
		
		
		
		
		$divModalMain->printClosingTag();
		
	$divContent->printClosingTag();
	
	
	if(isset($_SESSION[$phpFileName])){
		ET_DisplayHelper::printMessageBox($phpFileName, true);
		$_SESSION[$phpFileName] = "";
	}
	
	
	$divFooterHalf1->printOpeningTag();
	$divFooterHalf1->printClosingTag();
	$divFooterHalf2->printOpeningTag();
	$spanFooterBrand->printOpeningTag();
	$spanFooterBrand->printDisplayText();
	$spanFooterBrand->printClosingTag();
	$spanFooterVersion->printOpeningTag();
	$spanFooterVersion->printDisplayText();
	$spanFooterVersion->printClosingTag();
	$divFooterHalf2->printClosingTag();
	$bodyTag->printClosingTag();
	$htmlTag->printClosingTag();
	
	ob_end_flush();
	
	?>
 	
	
				
	