
<?php

if (!defined('ADODB_DIR')) die();

if (!defined('_ADODB_ODBC_LAYER')) {
	include(ADODB_DIR."/drivers/adodb-odbc.inc.php");
}

class  ADODB_odbc_teradata extends ADODB_odbc {
	var $databaseType = 'odbc_teradata';
	var $replaceQuote = "''"; // string to use to replace quotes
	var $concat_operator='||';
	var $fmtDate = "'Y-m-d 00:00:00'";
	var $fmtTimeStamp = "'Y-m-d h:i:sA'";
	var $metaTablesSQL = 'select table_name from cat';
	var $metaColumnsSQL = "select ColumnName, ColumnFormat, ColumnType, ColumnLength, Nullable, idColType, DefaultValue from dbc.columns where TableName='%s' order by ColumnId";
	var $metaColumnsSQLWithDB = "select ColumnName, ColumnFormat, ColumnType, ColumnLength, Nullable, idColType, DefaultValue from dbc.columns where TableName='%s' and DatabaseName='%s' order by ColumnId";
	
	//var $metaColumnsSQL = "select ColumnName, ColumnFormat, ColumnType, ColumnLength, Nullable, idColType from dbc.columns where TableName='%s' and ( ColumnFormat is not null) and (ColumnType is not null)   and (ColumnLength is not null) order by ColumnId";
	//var $metaColumnsSQLWithDB = "select ColumnName, ColumnFormat, ColumnType, ColumnLength, Nullable, idColType from dbc.columns where TableName='%s' and DatabaseName='%s' and ( ColumnFormat is not null) and (ColumnType is not null)   and (ColumnLength is not null) order by ColumnId";
	//var $metaIndexSQL = "select ColumnName from dbc.indices where tablename = '%s' and indexType = 'K' and databasename='test'";
	//var $primaryKeySQL = "SELECT ColumnName FROM dbc.IndicesV where TableName='%s'";
	//var $primaryKeySQLWithDB = "SELECT ColumnName FROM dbc.IndicesV where DatabaseName = '%s' and TableName='%s'";

	var $sysDate = "TRUNC(SYSDATE)";
	var $sysTimeStamp = 'SYSDATE';
	//why can't we pass the database name as optional 3rd parameter?
	function MetaPrimaryKeys($table, $owner=false) {
		
		global $ADODB_FETCH_MODE;
		$this->SetFetchMode(ADODB_FETCH_ASSOC);
		
		$metaIndexSQL = '';
		//orig:
		/*
		if (strpos($table, '.')!==false) {
			$dbName = substr($table, 0, strpos($table, '.'));
			$table = substr($table, strpos($table, '.') + 1);
			$metaIndexSQL = "select ColumnName from dbc.indices where TableName = '%s' and (IndexType = 'K' or IndexType = 'P') and DatabaseName='$dbName'";
		} else {
			$metaIndexSQL = "select ColumnName from dbc.indices where TableName = '%s' and (IndexType = 'K' or IndexType = 'P')";
		}
		*/
		//new:
		$dbName = ET_AdodbHelper::getTableQualifierItem($table, 1);
		$table 	= ET_AdodbHelper::getTableQualifierItem($table, 3);
		
		
		if (!empty($dbName)) {
			$metaIndexSQL = "select ColumnName from dbc.indices where TableName = '%s' and (IndexType = 'K' or IndexType = 'P') and DatabaseName='$dbName'";
		}
		else {
			$metaIndexSQL = "select ColumnName from dbc.indices where TableName = '%s' and (IndexType = 'K' or IndexType = 'P')";
		}
		
		
		$rs = $this->Execute(sprintf($metaIndexSQL,$table));
		if ($rs === false) {
			$false = false;
			return $false;
		}
		$retarr = array();
		$i=0;
		if ($rs) {
			while (!$rs->EOF) {
				$fieldName = trim($rs->fields['ColumnName']);
				//a column can be an index and a primary key at the same time?				
				if (!in_array($fieldName, $retarr))
					array_push($retarr, $fieldName);
					
				$rs->MoveNext();
			}
		}
		
		return $retarr;
	}
	
	function DBDate($d,$isfld=false)
	{
		if (empty($d) && $d !== 0) {
			return 'null';
		}
	
		return "cast (cast('$d' as date format 'YYYY-MM-DD') as char(10))";
	}
	
	function DBTimeStamp($ts,$isfld=false)
	{
		if (empty($ts) && $ts !== 0) {
			return 'null';
		}
		
		return "cast('$ts' as timestamp(0))"; 
	}
	
	function MetaType($t, $len=0, $fieldObj = false) {
		
		switch (strtoupper($t)) {
			case 'CF':
			case 'CV':
				return 'C';
			case 'CO':
				return 'X';
			case 'BO':
				return 'B';
		
			case 'DA':
				return 'D';
			case 'AT':
			case 'TS': 
				return 'T';
		
			case 'I1':
			case 'I2':
			case 'I8':
			case 'BF':
			case 'I':
				return 'I';
		
			default:
				return 'N';
		}
	}
	
	function MetaColumns($table, $normalize=true)
	{
		global $ADODB_FETCH_MODE;
		$this->SetFetchMode(ADODB_FETCH_ASSOC);
		
		$rs = null;
		//orig:
		
		if (strpos($table, '.') !== false) {
			$dbName = explode(".", $table)[0];
			$tableName = explode(".", $table)[1];
			$rs = $this->Execute(sprintf($this->metaColumnsSQLWithDB,strtoupper($tableName), strtoupper($dbName)));
		} else {
			$rs = $this->Execute(sprintf($this->metaColumnsSQL,strtoupper($table)));
		}
		
		//new:
		/*
		if (count($dbTableName) > 1) {
			$dbName = $dbTableName[0];						
			$rs = $this->Execute(sprintf($this->metaColumnsSQLWithDB,strtoupper($table), strtoupper($dbName)));
		} else {
			$rs = $this->Execute(sprintf($this->metaColumnsSQL,strtoupper($table)));
		}
		*/
		if ($rs === false) {
			$false = false;
			return $false;
		}
		$retarr = array();
		
		$counter = 0;
		
		while (!$rs->EOF) { //print_r($rs->fields);
			$fld = new ADOFieldObject();
			
			$fld->name = trim($rs->fields['ColumnName']);
			$fld->type = trim($rs->fields['ColumnType']);
			//if ($fld->type == 'CV') $fld->type = 'C';
			
			$fld->max_length = $rs->fields['ColumnLength'];
			$fld->not_null = $rs->fields['Nullable'] === "Y" ? false : true;			
			//$fld->not_null = $rs->fields['Nullable'];
			
			if ($rs->fields['IdColType'] != null)
				$fld->identity = $rs->fields['IdColType'];
			else 
				$fld->identity = '';

			if ($rs->fields['DefaultValue'] != null)
				$fld->default_value = $rs->fields['DefaultValue'];
			else 
				$fld->default_value = '';
					
			
			$fld->orderNumber = $counter;
			$counter++;
						
			if ($ADODB_FETCH_MODE == ADODB_FETCH_NUM) $retarr[] = $fld;
			else $retarr[$fld->name] = $fld;

			$rs->MoveNext();
		}
						
		$rs->Close();
		return $retarr;
		
	}
	
}

class  ADORecordSet_odbc_teradata extends ADORecordSet_odbc {

	var $databaseType = 'odbc_teradata';

	function __construct($id,$mode=false)
	{
		return parent::__construct($id,$mode);
	}
}
