/*
NIOTA METADATA V2.0
FOR NIOTA v4.0.0

-----------------
-	LOAD DATA	-	
-----------------

ORDER OF STEPS WHEN SETTING UP NIOTA META DB:
	1) metadata_db.sql
	2) metadata_tables.sql
	3) METADATA_LOAD.SQL
	4) metadata_constraints.sql
	5) folders: 'functions', 'stored procedures'
*/
-- select * from et_lookup_value_system where lookup_name = 'column_type';
-- add the lookup values
-- delete from et_lookup_value_system where ;
insert into et_lookup_value_system (lookup_name,lookup_number,lookup_description,ind_active,lookup_int,lookup_char) values 
-- column type
 ('column_type',					1,'date', 1,null,'D'),
 ('column_type',					2,'datetime',1,null,'T'),
 ('column_type',					3,'numeric',1,null,'N'),
 ('column_type',					4,'text',1,null,'C'),
-- callable object type
 ('callable_object_type',			0,'stored procedure',1,0,null),
 ('callable_object_type',			1,'sql statement',1,1,null),
 ('callable_object_type',			2,'batch command',1,2,null),
 ('callable_object_type',			3,'web service call', 1, 3, NULL),
-- callable_object_prompt_type
 ('callable_object_prompt_type', 	1, 'no prompt page', 1, 0, null),
 ('callable_object_prompt_type', 	2, 'file upload', 1, 1, NULL),
-- 'conn_type';
 ('conn_type', 						1, 'database', 1,0, NULL),
 ('conn_type', 						2, 'web service', 1, 1, NULL),
-- targe page
 ('target_page',					1,'for table loading', 1, null,'niota.php'),
 ('target_page',					2,'to execute callable objects',0,null,'execute_callable.php'),
-- usergroup type 
 ('usergroup_type',					1,'self group',1,1,null),
 ('usergroup_type',					2,'custom group',1,2,null),
-- user parame level
 ('user_param_level',				1,'user level settings',1,null,'user'),
 ('user_param_level',				2,'catalog level settings',1,null,'catalog'),
-- link type
 ('link_type',						1,'master-detail',1,0,null),
 ('link_type',						2,'advanced filter',1,1,null),
 -- link type_md
 ('link_type_md',					1,'master-detail',1,0,null),
 -- link type_af
 ('link_type_af',					1,'advanced filter',1,1,null),
-- transaction param name
 ('transaction_param_name',			1,'define popup filter',1,null,'popup_filter'),
 ('transaction_param_name',			2,'loads a catalog object instance',1,null,'selected_instance'),
 ('transaction_param_name',			3,'runs a callable object',0,null,'callable_object'),
 ('transaction_param_name',			4,'popup filter catalog-object-instance',1,null,'filter instance'),
-- constraint
 ('constraint',						0,'no operation',1,0,null),
 ('constraint',						1,'equals',1,1,null),
 ('constraint',						2,'not equals',1,2,null),
 ('constraint',						3,'greater than',1,3,null),
 ('constraint',						4,'less than',1,4,null),
 ('constraint',						5,'greater than or equal to',1,5,null),
 ('constraint',						6,'less than or equal to',1,6,null),
 ('constraint',						7,'between',1,7,null),
 ('constraint',						8,'not between',1,8,null),
 ('constraint',						9,'like',1,9,null),
 ('constraint',						10,'not like',1,1,null),
 ('constraint',						11,'starts with',1,11,null),
 ('constraint',						12,'starts not with',1,12,null),
 ('constraint',						13,'ends with',1,13,null),
 ('constraint',						14,'ends not with',1,14,null),
-- user parameter
 ('user_parameter',					1,'table selector state',1,null,'table_selector_state'),
 ('user_parameter',					2,'upload popup window position',1,null,'popup_position_upload'),
 ('user_parameter',					3,'specific column width',1,null,'col_width'),
 ('user_parameter',					4,'grid height and width',1,null,'grid_dimensions'),
 ('user_parameter',					5,'callable objects window position',1,null,'popup_position_callables'),
-- callable binding level
 ('callable_binding_level', 		1, 'table level', 1, 0,null),
 ('callable_binding_level', 		2, 'line level', 1, 1,null),
 -- callable category
 ('callobject_category', 			1, 'custom standard', 1, null,'cust.std'),
 ('callobject_category', 			2, 'custom sequence member', 1, null,'cust.seq'),
 ('callobject_category', 		  100, 'system standard', 1, null,'sys.std'),
 ('callobject_category', 		  101, 'system sequence member', 1, null,'sys.seq'),
 ('callobject_category', 		  102, 'logger module', 1, null,'sys.log'),
-- debug grid
 ('debug_grid', 					1, 'do not write debug content info into file', 1, 0, NULL),
 ('debug_grid', 					2, 'write debug content info into file', 1, 1, NULL),
-- debug sql
 ('debug_sql_loglevel', 			1, 'do not log sql queries', 1, 0, NULL),
 ('debug_sql_loglevel', 			2, 'log most important sql queries into file', 1, 1, NULL),
 ('debug_sql_loglevel', 			3, 'log more detailed sql queries into file', 1, 2, NULL),
 ('debug_sql_loglevel', 			4, 'log all sql into file', 1, 3, NULL),
 -- ui level
 ('ui_language', 					1, 'English', 1, NULL, 'en'),
 ('ui_language', 					2, 'Deutsch', 1, NULL, 'de'),
 -- lookup type
 ('lookup_type', 					1, 'standard lookup', 1, 0, NULL),
 ('lookup_type', 					2, 'cascaded lookup', 1, 1, NULL),
-- ('lookup_type', 3, 'concatenated lookup', 1, 2, NULL),
-- 'catalog_config'
 ('catalog_config', 				1, 'error limit', 1, null,'max_number_validation_err'),
 ('catalog_config', 				2, 'messages to log', 1, null,'max_number_validation_msg'),
 ('catalog_config', 				3, 'rows to check', '1', null,'max_number_validation_row'),
-- 'user_config';
 ('user_config', 					1,'toggle debug grid(0/1)', 1,null,'debug_grid'),
 ('user_config', 					2,'sql log level(0/1/2/3)', 1,null,'debug_sql_loglevel'),
 ('user_config', 					3,'jobname for deploy (string)', 1,null,'deploy_jobname'),
-- grid location
 ('grid_location_detail', 			1, 'top-right', 1, 2, null),
 ('grid_location_detail', 			2, 'bottom-left', 1, 3, null),
 ('grid_location_detail', 			3, 'bottom-right', 1, 4, null),
-- logger callables
 ('logger_niota', 					1, 'standard mysql logger', 1, null, 'niota_mysql_LOG_COMMAND'),
 -- logger callables
 ('custom_lookup', 					1, 'logger', 1, null, 'logger_custom'),
 ('custom_iconfile', 				2, 'icon files', 1, null, 'iconfile_custom'),
  -- ui level
 ('messagetype', 					1, 'Error', 1, NULL, 'ERR'),
 ('messagetype', 					2, 'Info', 1, NULL, 'INF'),
 ('messagetype', 					3, 'Warning', 1, NULL, 'WRN'),
  -- application
 ('application', 					1, 'niota table management', 1, NULL, 'niota'),
  -- edittype
 ('edittype', 						1, 'text column', 1, NULL, 'text'),
 ('edittype', 						2, 'text area / box', 1, NULL, 'textarea'),
 ('edittype', 						3, 'checkbox', 1, NULL, 'checkbox')
 as loadval
 on DUPLICATE KEY UPDATE
  lookup_description = loadval.lookup_description,
  ind_active = loadval.ind_active,
  lookup_int = loadval.lookup_int,
  lookup_char = loadval.lookup_char; 

-- delete from et_lookup_value_system;
insert into et_lookup_value_system (lookup_name,lookup_number,lookup_description,ind_active,lookup_int,lookup_char) values 
-- icon files 
 ('iconfile_custom', 1, 'user on a bagde', 1, null, 'account_badge_s.png'),
 ('iconfile_custom', 2, 'user with pen', 1, null, 'account_edit_s.png'),
 ('iconfile_custom', 3, 'simple plus sign', 1, null, 'add.png'),
 ('iconfile_custom', 4, 'copy from ...', 1, null, 'blueprint.png'),
 ('iconfile_custom', 6, 'wrench/tool', 1, null, 'build.png'),
 ('iconfile_custom', 7, 'calender tab', 1, null, 'calendar_month_s.png'),
 ('iconfile_custom', 8, 'calender with event', 1, null, 'calendar_multiple_s.png'),
 ('iconfile_custom', 9, 'group of user', 1, null, 'crm.png'),
 ('iconfile_custom', 10, 'horizontal double arrow', 1, null, 'double_arrow.png'),
 ('iconfile_custom', 11, 'download', 1, null, 'download.png'),
 ('iconfile_custom', 12, 'burger menu', 1, null, 'dynamic_menu.png'),
 ('iconfile_custom', 13, 'paper page with pen', 1, null, 'edit_document_s.png'),
 ('iconfile_custom', 14, 'grid with pen', 1, null, 'edit_journal.png'),
 ('iconfile_custom', 15, 'calender with checked event', 1, null, 'event_checked.png'),
 ('iconfile_custom', 16, 'spooky eye', 1, null, 'eye-outline_s.png'),
 ('iconfile_custom', 17, 'ancient factory', 1, null, 'factory_s.png'),
 ('iconfile_custom', 18, 'page with arrow', 1, null, 'file-import_s.png'),
 ('iconfile_custom', 19, 'glass or mug - empty', 1, null, 'glass-mug_s.png'),
 ('iconfile_custom', 20, 'chain - link', 1, null, 'link_s.png'),
 ('iconfile_custom', 21, 'burger menu', 1, null, 'menu.png'),
 ('iconfile_custom', 22, 'paper / report', 1, null, 'message_journal.png'),
 ('iconfile_custom', 23, 'paper / report', 1, null, 'offer.png'),
 ('iconfile_custom', 24, 'phone with speech bubble', 1, null, 'phone_message_s.png'),
 ('iconfile_custom', 25, 'user portrait', 1, null, 'portrait_s.png'),
 ('iconfile_custom', 26, 'circled arrow', 1, null, 'redo.png'),
 ('iconfile_custom', 27, 'circled arrow', 1, null, 'replay.png'),
 ('iconfile_custom', 28, 'network box', 1, null, 'server.png'),
 ('iconfile_custom', 29, 'grid with a plus sign', 1, null, 'servicecost.png'),
 ('iconfile_custom', 30, 'small horiz. arrows', 1, null, 'swap_horizontal.png'),
 ('iconfile_custom', 31, '3 bar table with header', 1, null, 'table.png'),
 ('iconfile_custom', 32, 'thumb up - small', 1, null, 'thumb_up_s.png'),
 ('iconfile_custom', 33, 'timer', 1, null, 'timer.png'),
 ('iconfile_custom', 34, 'apps and transactions', 1, null, 'transactions.png'),
 ('iconfile_custom', 35, 'standard table', 1, null, 'user_folder_s.png'),
 ('iconfile_custom', 36, 'watch', 1, null, 'watch.png')
 as loadval
 on DUPLICATE KEY UPDATE
  lookup_description = loadval.lookup_description,
  ind_active = loadval.ind_active,
  lookup_int = loadval.lookup_int,
  lookup_char = loadval.lookup_char; 
  
-- add the default user
-- delete from et_user where username in ('superuser', '*ALL_GROUP');
insert into et_user (username, password, ind_is_admin) values 
('superuser', '$2y$10$f.mqXGFPHEc0VoTldUATKOebX7Z4ItXlI.ZjrNxzW2ZeedA1.Ieqy', 1),
('*ALL_GROUP', 'system user for the handling of all user logical group', 0) as loadval
 on DUPLICATE KEY UPDATE
 password = loadval.password,
 ind_is_admin = loadval.ind_is_admin;
 

-- add the system usergroups
-- delete from et_user_group where usergroup_type = 0;
insert into et_user_group (usergroupname, description, ind_active, usergroup_type) values 
('*ALL_ADMIN_GROUP', 'system default group', 1, 0),
('*ALL_NON_ADMIN_GROUP', 'system default group', 1, 0),
('*ALL_GROUP', 'system default group', 1, 0)
as loadval
 on DUPLICATE KEY UPDATE
description = loadval.description, 
ind_active = loadval.ind_active,
usergroup_type = loadval.usergroup_type;


-- add default connection meta db
INSERT INTO et_connection (conn_name, description, conn_name_msg) VALUES 
('niota_meta', 'Standard Meta DB', 'niota_meta')
as loadval
 on DUPLICATE KEY UPDATE
description = loadval.description, 
conn_name_msg = loadval.conn_name_msg;
;


insert into et_callable_object (callable_object, description, ind_active, callobject_type, conn_name, command, 
callobject_category, sortorder, ind_messaging, ind_reload_grid, ind_seq, promptpage_type, icon_callable)
values ('niota_mysql_LOG_COMMAND', 'log useraction to table', 1, 0, 'niota_meta',
 'call mdLog_UserAction(''LOG'',''[SESSION]($sessionId)'',$catalogId,''$instanceName'',''$userName'',''WEBEDIT'',''$sql'')', 
 'sys.log', 1, 0, 0, 0, 0, null)
as loadval
 on DUPLICATE KEY UPDATE
    description = loadval.description
 ;
 
insert into et_callable_access (callable_object, usergroupname, ind_active)
values('niota_mysql_LOG_COMMAND', '*ALL_GROUP', 1)
as loadval 
 on DUPLICATE KEY UPDATE
    ind_active = loadval.ind_active;


-- add default connection meta db
INSERT INTO et_logging (conn_name, ind_active_logfile, ind_active_logdb, filename_log, callable_object) VALUES 
('niota_meta', 1, 1, 'admin_action.log', 'niota_mysql_LOG_COMMAND')
as loadval
 on DUPLICATE KEY UPDATE
conn_name = loadval.conn_name;

-- call mdLog_UserAction('LOG', '[SESSION](x) ', 100, '*DEFAULT', 'rreis', 'web', 'abc');

-- add message to etx_table ('en' and 'de')
-- delete from etx_message_text where msg_id = 100;
insert into etx_message_text (appcode_msg, msg_id, lang_msg, type_msg, ind_stop_msg, text_msg) values 
('niota', 0100, 'de', 'ERR', null, 'Systemkonfigurationseintrag <b>{0}/{1}</b> nicht gefunden'),
('niota', 0100, 'en', 'ERR', null, 'System config entry <b>{0}/{1}</b> not found'),
('niota', 0101, 'de', 'ERR', null, 'Benutzer-Konfigurationseintrag <b>{0}/{1}/{2}</b> nicht gefunden'),
('niota', 0101, 'en', 'ERR', null, 'User config entry <b>{0}/{1}/{2}</b> not found'),
('niota', 1000, 'de', 'INF', null, 'Konfiguration <b>{0}</b> mit <b>{1}</b> zum Löschen markiert. Beschreibung zurückändern um Eintrag zu behalten'),
('niota', 1000, 'en', 'INF', null, 'Config <b>{0}</b> tagged with <b>{1}</b> for deletion. Change description back to keep entry'),
('niota', 1001, 'de', 'INF', null, '<b>{0}</b> Konfigurationseinträge in <b>{1}</b> werden dauerhaft gelöscht'),
('niota', 1001, 'en', 'INF', null, '<b>{0}</b> Config entries in <b>{1}</b> will be deleted permanently'),
('niota', 1002, 'de', 'INF', null, 'Konfigurationstransaktion mit Parameter <b>{0}</b> gestartet'),
('niota', 1002, 'en', 'INF', null, 'Configurations transaction started with parameter <b>{0}</b>'),
('niota', 1050, 'de', 'INF', null, 'Konfiguration <b>{0}</b> mit <b>{1}</b> zum Löschen markiert. Beschreibung zurückändern um Eintrag zu behalten'),
('niota', 1050, 'en', 'INF', null, 'Config <b>{0}</b> tagged with <b>{1}</b> for deletion. Change description back to keep entry'),
('niota', 1051, 'de', 'INF', null, 'Konfiguration <b>{0}</b> und alle abhängigen Einträge dauerhaft gelöscht'),
('niota', 1051, 'en', 'INF', null, 'Config <b>{0}</b> and all depending entries deleted permanently'),
('niota', 1052, 'de', 'INF', null, 'Konfiguration <b>{0}</b> ist nicht zum Löschen markiert - Löschen vorbereiten ausführen'),
('niota', 1052, 'en', 'INF', null, 'Config <b>{0}</b> is not prepared for delete - execute prepare delete'),
('niota', 1053, 'en', 'INF', NULL, 'Your formatting for <b>{0}</b> are now active for <b>*ANY</b> user'),
('niota', 1053, 'de', 'INF', NULL, 'Ihre Formattierung für <b>{0}</b> ist jetzt für alle (<b>*ANY</b> user) aktiv'),
('niota', 1060, 'de', 'INF', null, 'Einsatzdatenanforderung für <b>{1}</b> mit Job ID <b>{0}</b> gestartet'),
('niota', 1060, 'en', 'INF', null, 'Deployment request started for <b>{1}</b> with job id <b>{0}</b>'),
('niota', 1061, 'de', 'INF', null, 'Job <b>{0}</b> mit Einsatzdaten aus System <b>{1}</b> started'),
('niota', 1061, 'en', 'INF', null, 'Job <b>{0}</b> with deployment data from <b>{1}</b> started'),
('niota', 1062, 'de', 'INF', null, 'Import Job <b>{0}</b> mit Einsatzdaten von <b>{1}</b> gestarted'),
('niota', 1062, 'en', 'INF', null, 'Import job <b>{0}</b> with deployment data from <b>{1}</b> started'),
('niota', 1063, 'de', 'INF', null, 'Simulations-Importjob <b>{0}</b> mit Einsatzdaten von <b>{1}</b> gestarted'),
('niota', 1063, 'en', 'INF', null, 'Simulation import job <b>{0}</b> with deployment data from <b>{1}</b> started'),
('niota', 1064, 'de', 'INF', null, 'Importjob mit Fehlercode <b>{0}</b> beendet - Daten nicht geladen'),
('niota', 1064, 'en', 'INF', null, 'Import job terminated with error code <b>{0}</b>  - data not loaded'),
('niota', 1065, 'de', 'INF', null, 'Importjob im Modus <b>{0}</b> fehlerfrei beendet'),
('niota', 1065, 'en', 'INF', null, 'Import job in mode <b>{0}</b> finished without erorrs'),
('niota', 1066, 'de', 'ERR', null, 'Datenbankverbindung <b>{0}</b> für Import-Simulation nicht gefunden'),
('niota', 1066, 'en', 'ERR', null, 'DB connection  <b>{0}</b> for import simulation not found'),
('niota', 1067, 'de', 'INF', null, 'Vorlagenschema <b>{0}</b> auf Objekt <b>{1}</b> erfolgreich angewendet'),
('niota', 1067, 'en', 'INF', NULL, 'Templateschema <b>{0}</b> applied successfully on object <b>{1}</b> '),
('niota', 1068, 'de', 'INF', NULL, 'Tabellenanzeigeformat für <b>{0}</b> von Benutzer <b>{1}</b> erfolgreich auf Gruppe <b>{2}</b> angewendet'),
('niota', 1068, 'en', 'INF', null, 'Gridlayout of <b>{0}</b> of user <b>{1}</b> successfully applied on group <b>{2}</b>'),
('niota', 1069, 'de', 'INF', null, 'Einsatzdaten Extraktion Nr. <b>{1}</b> Befehl <b>{0}</b> durchgeführt - aus <b>{2}</b> Tabelle(n) gesamt <b>{3}</b> Datensätze exportiert'),
('niota', 1069, 'en', 'INF', null, 'Deploy data extraction nbr. <b>{1}</b> command <b>{0}</b>  executed - from <b>{2}</b> table(s) in total <b>{3}</b> records extracted'),
('niota', 1070, 'de', 'INF', null, 'Einsatzdaten Jobdaten mit Befehl {0} und Option {1} verarbeitet'),
('niota', 1070, 'en', 'INF', null, 'Deploy jobdata with command {0} with option {1} executed'),
('niota', 1071, 'de', 'INF', null, 'Datensatz mit ID {0} als Favorit {1} eingetragen'),
('niota', 1071, 'en', 'INF', null, 'Record {0} set as favorite {1}'),
('niota', 1072, 'de', 'INF', null, 'Datensatzpriosierung für ID {1} {0} geändert'),
('niota', 1072, 'en', 'INF', null, 'Record {0} favorite {1} updated'),
('niota', 1100, 'de', 'ERR', null, 'SP beendet - überprüfe Befehl und Optionen - überprüfe {0} gültig: {1}'),
('niota', 1100, 'en', 'ERR', null, 'SP {0} canceled - check command {1} (valid: {2}) and options {3} (valid: {4}) and allowed combinations'),
('niota', 1101, 'de', 'ERR', null, 'UDF beendet - überprüfe parameter for {0} ({1}, {2}, {3}, {4}, {5})'),
('niota', 1101, 'en', 'ERR', null, 'UDF canceled - check parameter for {0} ({1}, {2}, {3}, {4}, {5})'),
('niota', 1200, 'en', 'INF', null, 'Configuration record {0} {1} not found in {2}'),
('niota', 1201, 'en', 'INF', null, 'Metadatabase object entry {0} not found in {1}'),
('niota', 1210, 'en', 'INF', null, 'Configuration record for {0} {1} {2} now ready to be deleted'),
('niota', 1220, 'en', 'INF', null, 'Configuration record for {0} {1} {2} not ready to be deleted'),
('niota', 1230, 'en', 'INF', null, '{0} {1} deleted from {2}'),
('niota', 1240, 'en', 'INF', null, '{0} {1} {2} revived'),
('niota', 1250, 'en', 'INF', null, '{0} {1} {2} is used at {3} {4}'),
('niota', 1260, 'en', 'INF', null, '{0} {1} {2} is assigned to {3} {4}'),
('niota', 1270, 'en', 'INF', null, '{0} {1} {2} has {3} {4}'),
('niota', 1280, 'en', 'INF', null, '{0} {1} {2} has or is used at {3} {4}'),
('niota', 1290, 'en', 'INF', null, '{0} {1} {2} references to <b>{3}</b> major configuration objects/entries')

as loadval
 on DUPLICATE KEY UPDATE
type_msg = loadval.type_msg, 
ind_stop_msg = loadval.ind_stop_msg , 
text_msg = loadval.text_msg;


-- delete from etx_system_config where appcode_cfg = 'niota';
insert into etx_system_config (appcode_cfg, cfg_id, cfg_value, description) values 
('niota', 'table_schema_deploy_simulate', 'niota_meta_demo', 'simulation deploy'),
('niota', 'deploy_export_path', '../deploydata/export/', 'deployfile path'),
('niota', 'deploy_export_fileext', 'txt', 'deployfile fileextension'),
('niota', 'EMAIL_FALLBACK', 'myuser@company.xx', 'fallback eMail address'),
('niota', 'EMAIL_REGISTRATION_DUMMY', 'myuser@company.xx', 'eMail to override entered eMail for sendMail'),
('niota', 'EMAIL_REGISTRATION_WATCHER', 'myuser@company.xx', 'eMail to send copy of registration'),
('niota', 'EMAIL_REGISTRATION_SPY', 'myuser@company.xx', 'eMail to send blind copy of registration'),

('niota', 'NBR_PRIORIZED_MD_ENTRIES', '10', 'number of md entries to prioritize')
as loadval
 on DUPLICATE KEY UPDATE
 cfg_value = loadval.cfg_value, 
 description = loadval.description;
 
-- **** important **** add in mysql.ini -> secure_file_priv=""

-- delete from etx_user_config where appcode_cfg = 'niota';
insert into etx_user_config (appcode_cfg, username, cfg_id, cfg_value, description) values 
('niota', 'superuser', 'deploy_jobname', 'COLLECTED', 'jobname for deploy collection')
as loadval
 on DUPLICATE KEY UPDATE
 cfg_value = loadval.cfg_value, 
 description = loadval.description;

-- delete from etx_sequence where appcode_seq = 'niota';
INSERT INTO etx_sequence (appcode_seq, seq_id, seq_value_increment, seq_value_min, seq_value_max, seq_value_cur, ind_cycle) VALUES
('niota', 'CATALOG_ID', 10, 10, 100, 10, 1),
('niota', 'DEPLOY_ID', 1, 1, 10000, 1, 1),
('niota', 'UNLOAD_ID', 1, 10001, 19999, 10001, 1),
('niota', 'WORKER_ID', 1, 10000000, 99999999, 10000000, 1)
as loadval
 on DUPLICATE KEY UPDATE
 seq_value_increment = loadval.seq_value_increment, 
 seq_value_min = loadval.seq_value_min, 
 seq_value_max = loadval.seq_value_max, 
 seq_value_cur = loadval.seq_value_cur, 
 ind_cycle = loadval.ind_cycle; 

