

DELIMITER $$
CREATE FUNCTION `mdInfo_CurrentValue` (`appcode_i` varchar(5), `seq_id_i` varchar(16))
RETURNS bigint NOT DETERMINISTIC
-- drop function if exists mdInfo_CurrentValue;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.01
-- 
-- get current value from a sequence table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
--
-- *******************************************************************************
--	
BEGIN
    DECLARE cur_val bigint;

-- retrieve the current next value (already set as cur value in DB 
    SELECT seq_value_cur INTO cur_val
     FROM etx_sequence
    WHERE appcode_seq = appcode_i 
     and seq_id = seq_id_i;
 
    RETURN cur_val;
END$$
DELIMITER ;
