
DELIMITER $$
CREATE FUNCTION `mdInfo_Instance`(
	`infotype_i` VARCHAR(16),
	`catalog_id_i` INT,
	`instance_name_i` VARCHAR(16)

) RETURNS varchar(512) CHARSET UTF8MB4
    DETERMINISTIC
BEGIN

-- drop function if exists mdInfo_Instance; 
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.12
-- 
-- get some information from a catalog instance
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.12   rre     add comment and header
-- 2021.11.03	nmz		mysql 8.0 compatiblity - remove definer. adding ` around reserved word: row_number
-- *******************************************************************************
--	 
declare `row_number` bigint default 0;
declare loop_max bigint default 0;
declare error_tag varchar(03) default 'ERR';
declare warning_tag varchar(03) default 'WRN';
declare defsep varchar(01) default ':';

declare this_udf varchar(32) default 'mdInfo_Instance';

declare l_end_of_cursor integer default 0;

declare instance_info varchar(512);
declare message_function varchar(512);


declare l_infotype varchar(16);

declare l_catalog_id int;
declare l_instance_name varchar(16);
declare l_username_owner varchar(16);
declare l_usergroupname varchar(32);
declare l_usergroupname_deputy varchar(32);
declare l_email varchar(56);
declare l_email_list varchar(512);


declare usergroup_c1 cursor for
select distinct 
  usr.email
  from v_et_user_group ugr
  join v_et_user_group_member ugm
  on ugm.usergroupname = ugr.usergroupname
  join v_et_user usr
  on usr.username = ugm.username 
  where ugr.usergroupname = l_usergroupname_deputy
  and ugr.ind_active = 1
  and ugm.ind_active = 1
  and usr.ind_active = 1
;

 
declare CONTINUE HANDLER 
        for not found set l_end_of_cursor = 1;
        

function_block: BEGIN
set message_function = 'OK';

set l_infotype = infotype_i;

if upper(l_infotype) not in ('EMAIL_OWNER', 'EMAIL_DEPUTY', 'OWNER_EMAIL', 'DEPUTY_EMAIL') then
   set message_function = concat(error_tag, defsep, 'invalid infotype', defsep, l_infotype);
   leave function_block;
end if;

set l_catalog_id = catalog_id_i;

select 
  username_owner
 ,usergroupname_deputy
 into 
  l_username_owner
 ,l_usergroupname_deputy
from v_et_catalog_object
where catalog_id = l_catalog_id;

if row_count() <> 1 then
   set message_function = concat(error_tag, defsep, this_udf, defsep, 'catalog_id not found', defsep, l_catatlog_id);
	leave function_block; 
end if;

email_owner: BEGIN

if upper(l_infotype) not in('EMAIL_OWNER', 'OWNER_EMAIL') then
	leave email_owner;
end if; 

select 
 email
 into
 l_email
from v_et_user
where username = l_username_owner;

if row_count() <> 1 then
   set message_function = concat(error_tag, defsep, this_udf, defsep, 'username owner not found', defsep, l_username_owner);
	leave function_block; 
end if;

set instance_info = l_email;
leave function_block;

END email_owner;

email_deputy: BEGIN

if upper(l_infotype) not in('EMAIL_DEPUTY', 'DEPUTY_EMAIL') then
	leave email_deputy;
end if;

select 
 usergroupname
 into
 l_usergroupname
from v_et_user_group
where usergroupname = l_usergroupname_deputy;

if row_count() <> 1 and l_usergroupname_deputy <> ' ' then
   set message_function = concat(error_tag, defsep, this_udf, defsep, 'usergroup deputy not found', defsep, l_usergroupname_deputy);
	leave function_block; 
end if;
 

set `row_number` = 0;
set loop_max = 50;
set l_email_list = '';
 
open usergroup_c1;

loopc1: while 1 = 1 do
 if `row_number` = loop_max then
    leave loopc1;
 end if;

 fetch usergroup_c1 into
       l_email
 ;
 
 if l_end_of_cursor = 1 then  
    leave loopc1;
 end if;

 if `row_number` > 0 then 
    set l_email_list = concat(l_email_list, ', ');
 end if;   

 set `row_number` = `row_number` + 1;
 set l_email_list = concat(l_email_list, trim(l_email));
		        
end while loopc1;
close usergroup_c1;

if l_email_list <> '' then
  set l_email_list = trim(l_email_list);
end if;

set instance_info = nullif(l_email_list, '');
leave email_deputy;

END email_deputy;

END function_block;

if message_function = 'OK' then
   return(instance_info);
else
   return(message_function);
end if;


END$$
DELIMITER ;
