DELIMITER $$

CREATE FUNCTION `mdInfo_NextValue` (`appcode_i` varchar(5), `seq_id_i` varchar(16))
RETURNS bigint NOT DETERMINISTIC
-- drop function mdInfo_NextValue;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.04.01
-- 
-- get next value from a sequence table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
-- 2021.11.03	nmz		 add DELIMITER ; at the end of function
-- *******************************************************************************
--	
BEGIN
    DECLARE cur_val bigint;

-- retrieve the current next value (already set as cur value in DB 
    SELECT seq_value_cur INTO cur_val
     FROM etx_sequence
    WHERE appcode_seq = appcode_i 
     and seq_id = seq_id_i
     ;
 
-- update or wrap the next current value   
    IF cur_val IS NOT NULL THEN
        UPDATE etx_sequence
        SET seq_value_cur = 
           IF ((seq_value_cur + seq_value_increment) > seq_value_max,
              IF (ind_cycle = TRUE, -- then
                    seq_value_min, -- then
                    NULL       -- else
                ),
                seq_value_cur + seq_value_increment -- else
            )
    WHERE appcode_seq = appcode_i 
     and seq_id = seq_id_i;
    END IF;
 
    RETURN cur_val;
END$$
DELIMITER ;