DELIMITER $$
CREATE FUNCTION `mdInfo_SysConfigDefault` (
`cfg_id_i` VARCHAR(32)
) RETURNS varchar(256) CHARSET UTF8MB4
    DETERMINISTIC
-- drop function if exists mdInfo_SysConfigDefault;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.04.01
-- 
-- return a niota system constant to the caller to avoid cancel/not found in stored proc. 
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.04.01   rre      add comment and header
--
-- *******************************************************************************
--	
BEGIN
     
    DECLARE constant_value  varchar(256); 
    case upper(constant_name_i)
    when 'LOGLEVEL' then set constant_value = '0';
        
    else set constant_value = null;
    end case;
    
    RETURN constant_value;
END$$
DELIMITER ;