DELIMITER $$
CREATE FUNCTION `mdInfo_SysConfigOption`(
  	`appcode_i` VARCHAR(5)
 ,	`cfg_id_i` VARCHAR(32)
) RETURNS varchar(256) CHARSET UTF8MB4
    DETERMINISTIC
BEGIN
-- drop function if exists `mdInfo_SysConfigOption`
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.04.01
-- 
-- get the a list of config options
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.04.01   rre     add comment and header
--
-- *******************************************************************************
--	
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdInfo_SysConfigOption';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare configuration_value varchar(256);

declare l_appcode varchar(5) default ' ';
declare l_cfg_id varchar(32);
declare l_config_value varchar(256);

function_block: BEGIN

set l_appcode = coalesce(appcode_i,mdinfo_SysConstant('APPCODE'));
set l_cfg_id = cfg_id_i;

select 
  cfg_value
 into 
  l_config_value
from etx_system_config
where upper(appcode_cfg) = upper(l_appcode)
and upper(cfg_id) = upper(l_cfg_id);

if row_count() <> 1 then 
   set l_config_value = 'no config option available';
end if;
   
set l_msg_id_final = 0;
set configuration_value = l_config_value;

END function_block;

if l_msg_id_final = 0 then
   return(configuration_value);
else
  set l_message_text = this_udf;
  
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
