

DELIMITER $$
CREATE FUNCTION `mdInfo_SysConstant`(`constant_name_i` varchar(32) ) RETURNS varchar(256)  CHARSET UTF8MB4
    DETERMINISTIC
-- drop function if exists mdInfo_SysConstant;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.01
-- 
-- return a niota system constant to the caller to avaid redundancy in stored proc. 
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
--
-- *******************************************************************************
--	
BEGIN
     
    DECLARE constant_value  varchar(256); 
    case upper(constant_name_i)
    when 'APPCODE' then set constant_value = 'niota';
    when 'LANG' then set constant_value = 'en';
    when 'MSG_ID_SP_ERR' then set constant_value = '1100';
    when 'MSG_ID_UDF_ERR' then set constant_value = '1101';

    when 'SEP_NEWLINE' then set constant_value = '\r\n';
    when 'SEP_SCHEMA' then set constant_value = '.';    
    when 'SEP_MSGPAR' then set constant_value = ',';
    when 'SEP_SYPPAR' then set constant_value = '|';
    when 'SEP_TEXT'   then set constant_value = ' ';
    when 'SEP_FILEEXT' then set constant_value = '.'; 
    
    when 'USERNAME_SU' then set constant_value = 'superuser';
    when 'USERGROUPNAME_ALLGROUP' then set constant_value = '*ALL_GROUP';
        
    else set constant_value = null;
    end case;
    
    RETURN constant_value;
END$$
DELIMITER ;