DELIMITER $$
CREATE FUNCTION `mdInfo_SysMessage`(
`msg_id_i` integer,
`msg_par_i` varchar(4000)  
 )
RETURNS varchar(4000) CHARSET UTF8MB4
DETERMINISTIC

BEGIN
-- DROP function if exists mdInfo_SysMessage
-- grant execute on mdInfo_SysMessage to 'niota'@'%'; 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2023.03.26
-- 
-- return a system message
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.03.26   rre     created
--
-- *******************************************************************************
--	

declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdInfo_SysMessage';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare MSG_ID_C varchar(5);
declare MSGTYP_C varchar(3);
declare CS       varchar(1) default ' ';
declare MSGTXT_C varchar(3000);
declare MSGTXT_OUT varchar(4000);

declare l_msg_id integer default 0;
declare l_msg_par varchar(4000) default ' ';
declare l_appcode varchar(5) default mdinfo_SysConstant('appcode');
declare l_lang varchar(2) default mdinfo_SysConstant('LANG');

declare l_text_msg varchar(2000);

declare PARSEP varchar(1) default mdinfo_SysConstant('SEP_MSGPAR');
declare PARMARKER_LEFT varchar(1) default '{';
declare PARMARKER_RIGHT varchar(1) default '}';
declare PARREPL varchar(3) default '';
declare LOOPCNT integer;

declare MSG_PAR varchar(256);
declare MSG_PAR_WRK varchar(4000);

declare charlen_par int;

declare charpos_name_start int;
declare charlen_name int;

declare charpos_value_start int;
declare charpos_value_end int;
declare charlen_value int;

declare MSG_P1 varchar(256) default '';       -- message parameter 1
declare MSG_P2 varchar(256) default '';       -- message parameter 2
declare MSG_P3 varchar(256) default '';       -- message parameter 3
declare MSG_P4 varchar(256) default '';       -- message parameter 4
declare MSG_P5 varchar(256) default '';       -- message parameter 5
declare MSG_P6 varchar(256) default '';       -- message parameter 6
declare MSG_P7 varchar(256) default '';       -- message parameter 7
declare MSG_P8 varchar(256) default '';       -- message parameter 8
declare MSG_P9 varchar(256) default '';       -- message parameter 9


function_block: BEGIN

-- split the message parameter by delimiter
set l_msg_id = msg_id_i;
set l_msg_par = msg_par_i;

set MSG_ID_C = LPAD(l_msg_id, 5, 0);

if l_msg_id < 1 then
   set MSG_ID_C = cast(l_msg_id as character(5));
else 
   set MSG_ID_C = LPAD(l_msg_id, 5, 0);
end if;

select  text_msg, type_msg
   into l_text_msg, msgtyp_c 
 from etx_message_text
where appcode_msg = l_appcode
  and lang_msg = l_lang
  and msg_id = l_msg_id;
  
if row_count() = 0 then
   set l_text_msg = concat('unknown message ', l_appcode,  ' ', l_lang, ' ', cast(l_msg_id as character(10)), ' ', rtrim(l_msg_par));
   leave function_block;
end if; 

set l_msg_id_final = 0;

do_replace: BEGIN

set charpos_value_start = 1;
set charpos_value_end = 1;

set MSG_PAR_WRK = l_msg_par;

set LOOPCNT = -1;

do_loop: WHILE 1 = 1 DO
  
set LOOPCNT = LOOPCNT + 1;
if LOOPCNT > 8 then
   leave do_loop;
end if;

set MSG_PAR = '';
 
set charpos_value_start = 1;

-- patindex vs. locate
--
set charpos_value_end = locate(PARSEP, MSG_PAR_WRK);
-- 

-- select charpos_value_end;

if charpos_value_end = 0 then
   set charpos_value_end = length(MSG_PAR_WRK) + 1;
end if;

set charlen_value = charpos_value_end - charpos_value_start;
if charlen_value <= 0 then
  leave do_loop; 
end if;

if charpos_value_end > charpos_value_start then
   set MSG_PAR = ltrim(rtrim(SUBSTRING(MSG_PAR_WRK, charpos_value_start, charlen_value)));
end if;

set PARREPL = concat(PARMARKER_LEFT, cast(LOOPCNT as character(1)), PARMARKER_RIGHT);

if MSG_PAR <> '' then set l_text_msg = replace(l_text_msg,PARREPL,MSG_PAR); end if; 
if MSG_PAR <> '' and LOOPCNT = 0 then set MSG_P1 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 1 then set MSG_P2 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 2 then set MSG_P3 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 3 then set MSG_P4 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 4 then set MSG_P5 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 5 then set MSG_P6 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 6 then set MSG_P7 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 7 then set MSG_P8 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 8 then set MSG_P9 = MSG_PAR; end if; 

set charlen_par = length(MSG_PAR_WRK) - charpos_value_end + 1;
set MSG_PAR_WRK = ltrim(SUBSTRING(MSG_PAR_WRK, charpos_value_end + 1,charlen_par) );

END WHILE; -- do_loop

END do_replace;

set MSGTXT_OUT = l_text_msg;

leave function_block;

END function_block;

if l_msg_id_final = 0 then
   return(MSGTXT_OUT);
else
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
