
DELIMITER $$
CREATE FUNCTION `mdInfo_SysMessageStop`(`msg_id_i` integer ) RETURNS smallint
    DETERMINISTIC
-- drop function if exists mdInfo_SysMessageStop;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.03.26
-- 
-- return the type of a system message. 
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
--
-- *******************************************************************************
--	
BEGIN
   
    declare l_appcode varchar(5) default mdinfo_SysConstant('APPCODE');
    declare l_lang varchar(2) default mdinfo_SysConstant('LANG');
    declare l_ind_stop_msg smallint default 0;
    
    select 
       coalesce(l_ind_stop_msg, 0)
    into
       l_ind_stop_msg
    from etx_message_text
    where appcode_msg = l_appcode
      and msg_id = msg_id_i
      and lang_msg = l_lang;
    
    RETURN l_ind_stop_msg;
END$$
DELIMITER ;