
DELIMITER $$
CREATE FUNCTION `mdInfo_SysMessageType`(`msg_id_i` integer ) RETURNS varchar(3)  CHARSET UTF8MB4
    DETERMINISTIC
-- drop function if exists mdInfo_SysMessageType;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.03.26
-- 
-- return the type of a system message. 
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
--
-- *******************************************************************************
--	
BEGIN
   
    declare l_appcode varchar(5) default mdinfo_SysConstant('APPCODE');
    declare l_lang varchar(2) default mdinfo_SysConstant('LANG');
    declare l_type_msg varchar(3) default '???';
    
    select 
       coalesce(type_msg, '???')
    into
       l_type_msg
    from etx_message_text
    where appcode_msg = l_appcode
      and msg_id = msg_id_i
      and lang_msg = l_lang;
    
    RETURN l_type_msg;
END$$
DELIMITER ;