DELIMITER $$
CREATE FUNCTION `mdInfo_UserCommArea`(
	`infotype_i` VARCHAR(16)
  , `username_i` VARCHAR(16)       
) RETURNS varchar(256) CHARSET UTF8MB4
    DETERMINISTIC
BEGIN
-- drop function if exists `mdInfo_UserCommArea`
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.11
-- 
-- retrieve info from user communication area
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.11   rre      add comment and header
-- 2021.11.03	nmz		 mysql 8.0 compatiblity - adding ` around reserved word: row_number
-- *******************************************************************************
--	
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdInfo_UserCommArea';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare uca_info varchar(512);
declare l_infotype varchar(16);

declare l_username varchar(16);
declare l_save_default smallint;
declare l_appcode varchar(5);
declare l_id_session varchar(32);
declare l_guid_msg varchar(32);
declare l_lang varchar(2);
declare l_uca varchar(512);

function_block: BEGIN

set l_infotype = infotype_i;
set l_username = username_i;

if upper(l_infotype) not in ('APPCODE', 'ID_SESSION', 'SESSION_ID', 'GUID_MSG', 'MSG_GUID', 'LANG', 'UCA') then
   set l_message_text = concat('invalid infotype', sep_mp, l_infotype);
   leave function_block;
end if;

select 
  appcode 
 ,id_session
 ,guid_msg
 ,lang
 ,uca
 into 
  l_appcode 
 ,l_id_session
 ,l_guid_msg
 ,l_lang
 ,l_uca
from et_user_comm_area
where username = l_username
;

if row_count() <> 1 then
    set l_message_text = concat('user communication area entry not found', sep_mp, l_username);
    set l_appcode = mdinfo_SysConstant('APPCODE');
    set l_id_session = '?';
    set l_guid_msg = '?';
    set l_lang = mdinfo_SysConstant('LANG');
    set l_uca = l_message_text;
    --	leave function_block;
end if; 

uca: BEGIN
set l_msg_id_final = 0; -- you made it!
 
if upper(l_infotype) in('APPCODE') then
   set uca_info = l_appcode;
	leave uca;
end if; 

if upper(l_infotype) in('ID_SESSION', 'SESSION_ID') then
   set uca_info = l_id_session;
	leave uca;
end if; 

if upper(l_infotype) in('GUID_MSG', 'MSG_GUID') then
   set uca_info = l_guid_msg;
	leave uca;
end if; 

if upper(l_infotype) in('LANG') then
   set uca_info = l_lang;
	leave uca;
end if; 

if upper(l_infotype) in('UCA') then
   set uca_info = l_uca;
	leave uca;
end if; 

END uca;

END function_block;

if l_msg_id_final = 0 then
   return(uca_info);
else
  
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
