DELIMITER $$
CREATE FUNCTION `mdInfo_UserConfigValue`(
  	`appcode_i` VARCHAR(5)
 ,  `username_i` VARCHAR(16)
 ,  `cfg_id_i` VARCHAR(32)
) RETURNS varchar(256) CHARSET UTF8MB4
    DETERMINISTIC
BEGIN
-- drop function if exists `mdInfo_UserConfigValue`
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.20
-- 
-- get the value of a niota user config value
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.12   rre     add comment and header
-- 2021.11.03	nmz		mysql 8.0 compatiblity - adding ` around reserved word: row_number
--
-- *******************************************************************************
--	
declare `row_number` bigint default 0;
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdInfo_UserConfigValue';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare configuration_value varchar(256);

declare l_appcode varchar(5) default "";

declare l_cmdlog_get varchar(16) default "GET";
declare l_opt_cmdlog varchar(128) default "";

declare l_username_superuser varchar(16) default mdinfo_SysConstant('USERNAME_SU');
declare l_username varchar(16);
declare l_cfg_id varchar(32);

declare l_config_value varchar(256);

set l_msg_par_final = concat(this_udf, sep_mp, appcode_i, sep_mp, username_i, sep_mp, cfg_id_i);
function_block: BEGIN

set l_appcode = appcode_i;
set l_username = username_i;
set l_cfg_id = cfg_id_i;

select 
  cfg_value
 into 
  l_config_value
from etx_user_config
where upper(appcode_cfg) = upper(l_appcode)
and upper(username) = upper(l_username)
and upper(cfg_id) = upper(l_cfg_id);

if row_count() <> 1 then

  select 
    cfg_value
   into 
    l_config_value
from etx_user_config
where upper(appcode_cfg) = upper(l_appcode)
  and upper(username) = upper(l_username_superuser) 
  and upper(cfg_id) = upper(l_cfg_id);

  if row_count() <> 1 then
     set l_msg_id_final = 101;
     set l_msg_par_final = concat(l_appcode,sep_mp,l_username,sep_mp,l_cfg_id);
     leave function_block;
  end if; 

end if;
set l_msg_id_final = 0;
set l_msg_par_final = '';
set configuration_value = l_config_value;

END function_block;

if l_msg_id_final = 0 then
   return(configuration_value);
else
  call mdLog_UserMessage(l_cmdlog_get, l_opt_cmdlog, current_user, this_udf, l_msg_id_final, l_msg_par_final, l_message_text);
  
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
