DELIMITER //
CREATE FUNCTION `mdLookup_SortOrder`(
	`infotype_i` VARCHAR(16),
	`id_i` varchar(128)
) RETURNS varchar(128) CHARSET utf8mb4
    DETERMINISTIC
BEGIN
--
-- use niota_meta
-- drop function if exists `mdLookup_SortOrder`
--
-- -- how to test --
-- select mdLookup_SortOrder('catalog_id', x.catalog_id) as sort_id, x.* from et_catalog_object x order by sort_id
--
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.20
-- 
-- get an alternative sort-value for a catalog id and ....
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.12   rre     add comment and header
--
-- *******************************************************************************
declare sep    varchar(01) default mdinfo_SysConstant('SEP_TEXT');

declare l_this_udf varchar(32) default 'mdLookup_SortOrder';
declare l_msg_id_udferr integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_udferr varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');

declare l_username varchar(32) default mdinfo_SysConstant('USERGROUPNAME_ALLGROUP');
declare l_param_name varchar(256) default 'prioritized_md_entry';

declare l_infotype_catalog varchar(16) default 'CATALOG_ID';
declare l_ind_infotype_catalog bit default 0;

declare sortvalue varchar(128) default null;

declare l_infotype varchar(16);
declare l_catalog_id_c varchar(10);
declare l_param_filter_03 varchar(128);
declare l_param_value varchar(256);

function_block: BEGIN
set l_infotype = infotype_i;

if upper(l_infotype) not in (l_infotype_catalog) then
   set l_message_text = concat('invalid infotype', sep, l_infotype, sep, 'valid: ', l_infotype_catalog);
   leave function_block;
end if;

catalog: BEGIN
set l_catalog_id_c = substring(id_i, 1, 10);

select 
 param_value
into 
 l_param_value
from et_user_parameter
where username = l_username 
and param_name = l_param_name
and param_filter_01 = l_infotype
and param_filter_03 = l_catalog_id_c
order by param_value
limit 1;

if row_count() <> 0 then
   set sortvalue = lpad(substr(trim(l_param_value), 1, 2),9,'0');
 else 
   set sortvalue = '999999999';
end if;

set l_msg_id_final = 0;
leave function_block; 
END catalog;


END function_block;

if l_msg_id_final = 0 then
   return(sortvalue);
else
   
 SIGNAL SQLSTATE '45000'
 SET MESSAGE_TEXT = l_message_text;
end if;


END//
DELIMITER ;


