DELIMITER //
CREATE FUNCTION `mdLookup_SysMDObject`(
	`object_i` VARCHAR(128)
) RETURNS integer  DETERMINISTIC
BEGIN
--
-- use niota_meta
-- drop function if exists `mdLookup_SysMDObject`;
--
-- -- how to test --
-- select object, mdLookup_SysMDObject(object) as catalog_id_s, x.* from et_metadb_object x order by catalog_id
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- return catalog id of a system object - or -1 ....
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************

declare rownumber bigint default 0;
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdLookup_SysMDObject';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' '; 
declare l_cmdlog_get varchar(16) default "GET";
declare l_opt_cmdlog varchar(128) default "";

declare l_object varchar(128);
declare l_catalog_id integer;

function_block: BEGIN
set l_object = object_i;

select 
 coalesce(catalog_id, -1)
into 
 l_catalog_id
from et_metadb_object
where object = l_object 
limit 1;

if row_count() <> 1 then
   set l_catalog_id = -1;
end if;

set l_msg_id_final = 0;
leave function_block; 

END function_block;

if l_msg_id_final = 0 then
   return(l_catalog_id);
else
  call mdLog_UserMessage(l_cmdlog_get, l_opt_cmdlog, current_user, this_udf, l_msg_id_final, l_msg_par_final, l_message_text);
  
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;

END//
DELIMITER ;


