DELIMITER //
CREATE FUNCTION `mdLookup_SysMDObjectDescription`(
	`object_i` VARCHAR(128)
) RETURNS varchar(128)  DETERMINISTIC
BEGIN
--
-- use niota_meta
-- drop function if exists `mdLookup_SysMDObjectDescription`;
--
-- -- how to test --
-- select object, mdLookup_SysMDObject(object) as catalog_id_s, x.* from et_metadb_object x order by catalog_id
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.04.06
-- 
-- return description of a system object - or name itself ....
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.04.06   rre     create this cool feature
--
-- *******************************************************************************

declare this_udf varchar(32) default 'mdLookup_SysMDObjectDescription';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_message_text varchar(128) default ' '; 

declare l_object varchar(128);
declare l_description varchar(128);

set l_message_text = concat(this_udf,'started');

function_block: BEGIN
set l_object = object_i;

select 
 coalesce(description, l_object)
into 
 l_description
from et_metadb_object
where object = l_object 
limit 1;

if row_count() <> 1 then
   set l_description = concat('unknown object', l_object);
end if;

set l_msg_id_final = 0;
leave function_block; 

END function_block;

if l_msg_id_final = 0 then
   return(l_description);
else
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;

END//
DELIMITER ;


