
DELIMITER $$
CREATE FUNCTION `nHelper_OptionCheckOnOff`(`optionvalue` varchar(20), `optionlist` varchar(256)) 

RETURNS bit 
    DETERMINISTIC
-- drop function if exists nHelper_OptionCheckOnOff;
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.01
-- 
-- return a niota system constant to the caller to avaid redundancy in stored proc. 
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
--
-- *******************************************************************************
--	
BEGIN
     
    DECLARE on_off bit default 0; 
    DECLARE looper smallint default 0;
    declare thisoption varchar(256);
    declare sep varchar(1) default ',';
    declare brk varchar(1) default '(';

    declare optionlist_reduced varchar(256);
    declare optionends smallint default 0;
    declare optionends2 smallint default 0;
    
    set optionlist_reduced = trim(BOTH sep from optionlist);
    set looper = 0;
    checkstring: while 1 = 1 do
      set looper = looper + 1;
      if looper = 10 then leave checkstring; end if;
      
      set optionends = locate(sep,optionlist_reduced);
      
      
      if optionends > 0 then 
         set thisoption = left(optionlist_reduced,optionends-1);
      else
         set thisoption = optionlist_reduced;
      end if;   
      
	  set optionends2 = locate(brk,thisoption);
      if optionends2 > 0 then 
         set thisoption = left(thisoption,optionends2-1);
      end if;   

      
     -- insert into etx_log (logtext) values(concat(thisoption, ' at ' , cast(optionends as char)));
      
      if upper(optionvalue) = upper(thisoption) then
         set on_off = 1;
         leave checkstring;
      end if;
	  if optionends <= 0 then leave checkstring; end if;
      set optionlist_reduced = substring(optionlist_reduced,optionends+1);
      
      -- insert into etx_log (logtext) values(optionlist_reduced);
    end while;
        
    RETURN on_off;
END$$
DELIMITER ;