
DELIMITER $$
CREATE FUNCTION `mdConfig_CatalogObject`(
	`actiontype_i` VARCHAR(16),
	`catalog_id_i` INT,

) RETURNS varchar(512) CHARSET UTF8MB4
    DETERMINISTIC
BEGIN

-- drop function if exists mdConfig_CatalogObject; 
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.03.26
-- 
-- get some config stuff on catalog object
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.12   rre     add comment and header
-- 2021.11.03	nmz		mysql 8.0 compatiblity - remove definer. adding ` around reserved word: row_number
-- *******************************************************************************
--	 
declare `row_number` bigint default 0;
declare loop_max bigint default 0;
declare error_tag varchar(03) default 'ERR';
declare warning_tag varchar(03) default 'WRN';
declare defsep varchar(01) default ':';

declare this_udf varchar(32) default 'mdConfig_CatalogObject';

declare l_end_of_cursor integer default 0;

declare instance_info varchar(512);
declare message_function varchar(512);


declare l_actiontype varchar(16);

declare l_catalog_id int;
declare l_description varchar(128);
declare l_ind_active integer;
declare l_email varchar(56);
declare l_email_list varchar(512);
      

function_block: BEGIN
set message_function = 'OK';

set l_actiontype = actiontype_i;

if upper(l_actiontype) not in ('CHECK', 'CLEANUP') then
   set message_function = concat(error_tag, defsep, 'invalid actiontype', defsep, l_actiontype);
   leave function_block;
end if;

set l_catalog_id = catalog_id_i;

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
from et_catalog_object
where catalog_id = l_catalog_id;

if row_count() <> 1 then
   set message_function = concat(error_tag, defsep, this_udf, defsep, 'catalog_id not found', defsep, l_catatlog_id);
	leave function_block; 
end if;

check_this: BEGIN

if upper(l_actiontype) not in('CHECK') then
	leave check_this;
end if; 

select 
 email
 into
 l_email
from v_et_user
where username = l_username_owner;

if row_count() <> 1 then
   set message_function = concat(error_tag, defsep, this_udf, defsep, 'username owner not found', defsep, l_username_owner);
	leave function_block; 
end if;

set instance_info = l_email;
leave function_block;

END check_this;

email_deputy: BEGIN

if upper(l_actiontype) not in('EMAIL_DEPUTY', 'DEPUTY_EMAIL') then
	leave email_deputy;
end if;

select 
 usergroupname
 into
 l_usergroupname
from v_et_user_group
where usergroupname = l_usergroupname_deputy;

if row_count() <> 1 and l_usergroupname_deputy <> ' ' then
   set message_function = concat(error_tag, defsep, this_udf, defsep, 'usergroup deputy not found', defsep, l_usergroupname_deputy);
	leave function_block; 
end if;
 

set `row_number` = 0;
set loop_max = 50;
set l_email_list = '';
 
open usergroup_c1;

loopc1: while 1 = 1 do
 if `row_number` = loop_max then
    leave loopc1;
 end if;

 fetch usergroup_c1 into
       l_email
 ;
 
 if l_end_of_cursor = 1 then  
    leave loopc1;
 end if;

 if `row_number` > 0 then 
    set l_email_list = concat(l_email_list, ', ');
 end if;   

 set `row_number` = `row_number` + 1;
 set l_email_list = concat(l_email_list, trim(l_email));
		        
end while loopc1;
close usergroup_c1;

if l_email_list <> '' then
  set l_email_list = trim(l_email_list);
end if;

set instance_info = nullif(l_email_list, '');
leave email_deputy;

END email_deputy;

END function_block;

if message_function = 'OK' then
   return(instance_info);
else
   return(message_function);
end if;


END$$
DELIMITER ;
