-- USE <mydb>
GO

/****** Object:  StoredProcedure [dbo].[cui_ProjektIst]    Script Date: 30.01.2022 10:03:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- exec [dbo].[niotaHelloWorld] 'As', 'Bs';

CREATE or alter procedure [dbo].[niotaHelloWorld]
-- grant execute on [dbo].[niotaHelloWorld] to niota;
-- drop procedure if exists [dbo].[niotaHelloWorld];
-- exec [dbo].[niotaHelloWorld] @CMDSYP_I = 'A', @OPTSYP_I = 'B';
-- 
(
  @CMDSYP_I        nvarchar(16)              -- ui procedure command
 ,@OPTSYP_I        nvarchar(128)             -- ui procedure option
)
as
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2022.01.01
-- 
-- test if connection via user comm area is up and running
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2022.01.04   rreis    created
--
-- *******************************************************************************
--	
Begin
declare @THIS_PROC_NAME sysname = QUOTENAME(OBJECT_SCHEMA_NAME(@@PROCID)) + '.' + QUOTENAME(OBJECT_NAME(@@PROCID));
declare @THIS_SP sysname = OBJECT_NAME(@@PROCID);

declare @RC_SP int;
declare @RC_SH int;
declare @MSG_SP nvarchar(256) = ' end reached ';

declare @MSG_COUNTS nvarchar(256) = ' ';
declare @ROWCOUNT integer = -1;
declare @ROWCOUNT_C nvarchar(10) = '?';

declare @START nvarchar(5)   = 'start';
declare @SUCCESS nvarchar(5) = 'ended';
declare @NOTE nvarchar(5)    = 'note';

declare @RECORDS nvarchar(10) = ' records=';
declare @NOW nvarchar(40);
declare @MSGTYP_I nvarchar(6) = '-- INF';
declare @MSGTYP_E nvarchar(6) = '-- ERR';
declare @MSGTYP_W nvarchar(6) = '-- WRN';
declare @EVENT_TYP nvarchar(10) = ' ..... ';

declare @username_uca varchar(16);

declare @CMDSYP varchar(16);
declare @OPTSYP varchar(128);
declare @OPTSYP_VALID nvarchar(255) = 'kkkk';

declare @username varchar(16);
declare @appcode varchar(5);
declare @id_session varchar(32);
declare @guid_msg varchar(32);
declare @lang varchar(32)
declare @uca varchar(512);
declare @text_msg varchar(2000);

set @CMDSYP = @CMDSYP_I;
set @OPTSYP = @OPTSYP_I;

set @username_uca = @OPTSYP;

select 
     @username = username
	,@appcode = appcode
	,@id_session = id_session
	,@guid_msg = guid_msg
	,@lang = lang
	,@uca = uca
from [dbo].[et_user_comm_area]
where username = @username_uca;
;

set @uca = rtrim(@uca) + ' Hello World!';

merge [et_user_comm_area] AS trgtable 
USING 
( 
select @username_uca as username, @uca as uca 
) AS srctable
ON 
(
  trgtable.[username] = srctable.[username] 
)
--When records are matched, update the records if there is any change 
WHEN MATCHED 
THEN UPDATE SET    
  trgtable.[uca] = srctable.[uca]
WHEN NOT MATCHED BY TARGET THEN INSERT
 (
       [username]
      ,[appcode]
      ,[id_session]
      ,[guid_msg]
	  ,[lang]
	  ,[uca]
) VALUES ( 
       srctable.[username]
      ,'niota'
      ,'mssql'
      ,'this'
	  ,'en'
	  ,@uca
);

set @text_msg = 'Dear ' + @username_uca + ' niota is greeting you from System "' + @@SERVERNAME + '" directly from sp "' + @THIS_SP + '" running as ' + system_user + ' with  "' + trim(@uca) + '"';

INSERT INTO [dbo].[etx_message]
           ([id_session]
           ,[guid_msg]
           ,[type_msg]
           ,[text_msg]
           ,[username]
           ,[poster_be]
           ,[username_be]
           ,[ind_stop_msg]
	)	
     VALUES
           (@id_session
           ,@guid_msg
           ,'INF'
           ,@text_msg
           ,@username_uca
           ,@THIS_SP
           ,substring(SYSTEM_USER,1,16)
           ,0
 );

set @MSG_SP = @uca;
goto endofJob;

UNVALIDCMD:
 set @MSG_SP = 'unvalid CMDSYP ' + @CMDSYP;
 goto error_PROCCALL;

UNVALIDOPT:
 set @MSG_SP = 'unvalid OPTSYP ' + @OPTSYP + ' valid: ' + @OPTSYP_VALID;
 goto error_PROCCALL;
  
endofJob:
 set @EVENT_TYP = @SUCCESS
 set @NOW = cast(SYSDATETIME() as varchar(30))
 RAISERROR (N'%s %s %s %s %s', 10, 1, @MSGTYP_I, @NOW, @THIS_SP, @EVENT_TYP, @MSG_SP) WITH NOWAIT;
 return (0)

error_PROCCALL:
 set @EVENT_TYP = @NOTE
 set @NOW = cast(SYSDATETIME() as varchar(30))
 RAISERROR (N'%s %s %s %s', 10, 1, @MSGTYP_E, @THIS_SP, @NOW, @MSG_SP) WITH NOWAIT;
 return (-16)
end
GO


