DELIMITER $$
CREATE FUNCTION `mdInfo_OptionConfigValue`(
	OPTSYP_I        varchar(128) -- OPTion SYstem Procedure
   ,OPTION_I        varchar(16)
) RETURNS varchar(128) CHARSET UTF8MB4
    DETERMINISTIC
BEGIN
-- drop function if exists `mdInfo_OptionConfigValue`
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.12
-- 
-- get the specific option configuration value from a option list
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.12   rre     add comment and header
-- 2021.11.03	nmz		mysql 8.0 compatiblity - adding ` around reserved word: row_number
-- 
-- *******************************************************************************
--	
declare `row_number` bigint default 0;
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdInfo_OptionConfigValue';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare lb varchar(01) default '(';
declare rb varchar(01) default ')';

declare l_optsyp varchar(128);
declare l_option varchar(16);

declare l_cmdlog_get varchar(16) default "GET";
declare l_opt_cmdlog varchar(128) default "";

declare charpos_value_start integer;
declare charpos_value_end integer;
declare charpos_value_len integer;
declare charlen_value integer;

declare configuration_value varchar(128) default null;

set l_optsyp = OPTSYP_I;
set l_option = OPTION_I;
set l_option = concat(trim(l_option),lb); -- add the bracket;
set charlen_value = length(l_option);

set l_msg_id_final = 0; -- this function does not cancel

function_block: BEGIN

set charpos_value_start = locate(l_option, l_optsyp);

if charpos_value_start is null or charpos_value_start < 1 then leave function_block; end if;
set charpos_value_start = charpos_value_start + charlen_value;

-- locate to next right bracket
set charpos_value_end = locate(rb, l_optsyp, charpos_value_start);
if charpos_value_end is null or charpos_value_end < 1 then leave function_block; end if;

set charlen_value = charpos_value_end - charpos_value_start;

set configuration_value = substring(l_optsyp, charpos_value_start, charlen_value);


END function_block;

if l_msg_id_final = 0 then
   return(configuration_value);
else
  call mdLog_UserMessage(l_cmdlog_get, l_opt_cmdlog, current_user, this_udf, l_msg_id_final, l_msg_par_final, l_message_text);
  
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;  
end$$

DELIMITER ;
