-- USE niota_demo
GO

/****** Object:  StoredProcedure [dbo].[cui_ProjektIst]    Script Date: 30.01.2022 10:03:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- exec [dbo].[niota_mdLog_MessageWithUCA] 'As', 'Bs';

CREATE or alter procedure [dbo].[niota_mdLog]
-- grant execute on [dbo].[niota_mdLog] to niota;
-- exec [dbo].[niota_mdLog] @POSTER_I = 'A',@LOGTEXT_I;
-- 
(
  @POSTER_I      nvarchar(128)               -- poster of the LogMessage
 ,@LOGTEXT_I     nvarchar(4000)              -- message to log
)
as
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2022.08.05
-- 
-- log a simple text to system log table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2022.08.05   rreis    created
--
-- *******************************************************************************
--	
Begin
declare @THIS_PROC_NAME sysname = QUOTENAME(OBJECT_SCHEMA_NAME(@@PROCID)) + '.' + QUOTENAME(OBJECT_NAME(@@PROCID));
declare @THIS_SP sysname = OBJECT_NAME(@@PROCID);
declare @MSG_SP nvarchar(256) = '';
declare @LOGTEXT_SP nvarchar(4000) = '';


declare @poster nvarchar(128);
declare @logtext nvarchar(4000);

set @poster = @POSTER_I;
set @logtext = @LOGTEXT_I;


INSERT INTO [dbo].[etx_log]
           ([poster_log]
           ,[logtext]
	)	
     VALUES
           (@poster
           ,@logtext
 );

goto endofJob;

  
endofJob:
 return (0)

error_PROCCALL:
 set @LOGTEXT_SP = dbo.niota_mdHelper_getErrorMessage(@THIS_SP, @MSG_SP);
 RAISERROR (N'%s', 10, 1, @LOGTEXT_SP) WITH NOWAIT;
 return (-16)
end
GO