-- USE niota_demo
GO

/****** Object:  StoredProcedure [dbo].[cui_ProjektIst]    Script Date: 30.01.2022 10:03:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- exec [dbo].[niota_mdLog_MessageWithUCA] 'As', 'Bs';

CREATE or alter procedure [dbo].[niota_mdLog_UserMessage]
-- grant execute on [dbo].[niota_mdLog_UserMessage] to niota;
-- exec [dbo].[niota_mdLog_UserMessage] @CMDSYP_I = 'A', @OPTSYP_I = 'B';
-- 
(
  @CMDSYP_I        nvarchar(16)              -- ui procedure command
 ,@OPTSYP_I        nvarchar(128)             -- ui procedure option
 ,@USERNAME_I      nvarchar(16)              -- username UI
 ,@TYPE_MSG_I      nvarchar(3)               -- type of message to log
 ,@TEXT_MSG_I      nvarchar(2000)            -- message to log
)
as
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2022.08.05
-- 
-- log a simple message to etx_messages - by using local et_user_comm_area
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2022.08.05   rreis    created
--
-- *******************************************************************************
--	
Begin
declare @THIS_PROC_NAME sysname = QUOTENAME(OBJECT_SCHEMA_NAME(@@PROCID)) + '.' + QUOTENAME(OBJECT_NAME(@@PROCID));
declare @THIS_SP sysname = OBJECT_NAME(@@PROCID);

declare @MSG_SP nvarchar(256) = '';
declare @LOGTEXT_SP nvarchar(4000) = '';

declare @CMDSYP varchar(16);
declare @OPTSYP varchar(128);
declare @OPTSYP_VALID nvarchar(255) = 'kkkk';

declare @username varchar(16);
declare @username_dft varchar(16) = 'superuser';

declare @appcode varchar(5);
declare @id_session varchar(32);
declare @guid_msg varchar(32);
declare @lang varchar(32)
declare @uca varchar(512);

declare @type_msg varchar(3);
declare @type_msg_dft varchar(3) = 'INF';

declare @text_msg varchar(2000);
declare @ind_stop_msg int = 0;

set @CMDSYP = @CMDSYP_I;
set @OPTSYP = @OPTSYP_I;

set @username = coalesce(@USERNAME_I,'?');
set @type_msg = coalesce(@TYPE_MSG_I,@type_msg_dft);
set @text_msg = coalesce(@TEXT_MSG_I,'?');
if @type_msg = 'ERR' begin; set @ind_stop_msg = 1; end;

select 
     @username = username
	,@appcode = appcode
	,@id_session = id_session
	,@guid_msg = guid_msg
	,@lang = lang
	,@uca = uca
from [dbo].[et_user_comm_area]
where username = @username;
if @@ROWCOUNT = 0 begin
   set @LOGTEXT_SP = 'no UCA found for ' + @username + ' use ' + @username_dft + ' instead';
   exec [dbo].[niota_mdLog] @THIS_SP ,@LOGTEXT_SP;
   set @username = @username_dft;
   set @appcode = '?????';
   set @guid_msg = '?';
   set @lang = 'en';
end;


INSERT INTO [dbo].[etx_message]
           ([id_session]
           ,[guid_msg]
           ,[type_msg]
           ,[text_msg]
           ,[username]
           ,[poster_be]
           ,[username_be]
           ,[ind_stop_msg]
	)	
     VALUES
           (@id_session
           ,@guid_msg
           ,@type_msg
           ,@text_msg
           ,@username
           ,@THIS_SP
           ,substring(SYSTEM_USER,1,16)
           ,@ind_stop_msg
 );

set @LOGTEXT_SP = dbo.niota_mdHelper_getInfoMessage(@THIS_SP, @text_msg);
RAISERROR (N'%s', 10, 1, @LOGTEXT_SP) WITH NOWAIT;
goto endofJob;

UNVALIDCMD:
 set @MSG_SP = 'unvalid CMDSYP ' + @CMDSYP;
 goto error_PROCCALL;

UNVALIDOPT:
 set @MSG_SP = 'unvalid OPTSYP ' + @OPTSYP + ' valid: ' + @OPTSYP_VALID;
 goto error_PROCCALL;
  
endofJob:
 set @LOGTEXT_SP = dbo.niota_mdHelper_getSuccessMessage(@THIS_SP, @MSG_SP);
 RAISERROR (N'%s', 10, 1, @LOGTEXT_SP) WITH NOWAIT;
 return (0)

error_PROCCALL:
 set @LOGTEXT_SP = dbo.niota_mdHelper_getErrorMessage(@THIS_SP, @MSG_SP);
 RAISERROR (N'%s', 10, 1, @LOGTEXT_SP) WITH NOWAIT;
 return (-16)
end
GO