DELIMITER $$
drop procedure if exists `mdConfig_ColumnProperty`;$$
--
CREATE PROCEDURE `mdConfig_ColumnProperty`(
  IN CMDSYP_I        varchar(16)  -- CoMmanD SYstem Procedure           
 ,IN OPTSYP_I        varchar(128) -- OPTion SYstem Procedure
 ,IN OBJECT_I        varchar(128) -- OBJECT ID                
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_ColumnProperty`
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.12
-- 
-- set column properties for meta data columns
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
-- 2021.11.03	nmz		mysql 8.0 compatiblity - adding ` around reserved word: row_number
--
-- *******************************************************************************
--	

declare loop_max bigint default 1000;
declare loop_max_c varchar(10);

declare `row_number` bigint default 0;
declare row_number_c varchar(10);
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare l_this_sp varchar(128) default 'mdConfig_ColumnProperty';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare l_cmdsyp varchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_setformat varchar(16) default 'SETFORMAT';
declare l_ind_cmdsyp_setformat bit default 0;

-- all possible system options
declare l_optsyp_metadb varchar(16) default 'METADB';
declare l_ind_optsyp_metadb bit default 0;

declare l_optsyp_withuca varchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_optsyp varchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_username varchar(16) default current_user();

declare l_end_of_cursor INTEGER DEFAULT 0;

declare l_object varchar(128);
declare l_catalog_id integer;
declare l_catalog_id_c varchar(10);

declare l_table_schema varchar(64);
declare l_metatype varchar(1);
declare l_ind_is_autoseq smallint;
declare l_ind_nullable smallint;
declare l_ind_is_required smallint;
declare l_ind_is_volatile smallint;
declare l_description varchar(128);

-- cursor columns
declare l_table_name varchar(128);

declare l_column_name varchar(64);
declare l_ordinal_position bigint;
declare l_ordinal_position_pkey bigint;
declare l_is_nullable varchar(3);
declare l_datatype varchar(64);
declare l_column_len bigint;
declare l_column_len_ui bigint;
declare l_colvalue_default longtext;
declare l_extra varchar(30);

declare schema_c1 cursor for
select mob.catalog_id 
, t.table_name
, c.column_name
, c.is_nullable
, c.data_type
, c.character_maximum_length
, c.column_default
, c.extra 
, k.ordinal_position as ordinal_position_pkey
from et_metadb_object mob
-- join et_connection cnc
-- on cnc.conn_name = mob.conn_name
join INFORMATION_SCHEMA.TABLES t
  on t.table_name = mob.object
 and t.table_schema = l_table_schema
join INFORMATION_SCHEMA.COLUMNS c
  on c.table_catalog = t.table_catalog
 and c.table_schema = t.table_schema
 and c.table_name = t.table_name
left outer join INFORMATION_SCHEMA.KEY_COLUMN_USAGE k
  on k.table_catalog = t.table_catalog
 and k.table_schema = t.table_schema
 and k.table_name = t.table_name
 and k.column_name = c.column_name
 and k.constraint_name = 'PRIMARY'  
where mob.object = l_object
order by c.ordinal_position
;
  
DECLARE CONTINUE HANDLER 
        FOR NOT FOUND SET l_end_of_cursor = 1;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_object = OBJECT_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_setformat, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_setformat = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_setformat; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_setformat); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_optsyp_metadb, l_optsyp, 1) > 0 then set l_ind_optsyp_metadb = 1; end if;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_metadb | l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_metadb, sep_sp, l_optsyp_withuca); -- next

main: begin
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
if l_ind_optsyp_withuca then set l_opt_cmdlog = l_optsyp_withuca; end if;
 
mdb_prop: begin
if not l_ind_optsyp_metadb then leave mdb_prop; end if;

-- get the username from the option-string or current user
set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca),  substring(current_user(),1,16));
set l_table_schema = mdInfo_OptionConfigValue(l_optsyp, l_optsyp_metadb);

open schema_c1;
set `row_number` = 0;

C1: while 1 = 1 do

  if `row_number` = loop_max then 
     leave C1;
  end if; 

 fetch schema_c1 into
  l_catalog_id
,  l_table_name
, l_column_name
, l_is_nullable
, l_datatype
, l_column_len
, l_colvalue_default
, l_extra 
, l_ordinal_position_pkey
;
 if l_end_of_cursor = 1 then  
    leave C1;
 end if;

set `row_number` = `row_number` + 1;

if l_is_nullable = 'YES' then set l_ind_nullable = 1; else set l_ind_nullable = 0; end if;
if l_extra = 'auto_increment' then set l_ind_is_autoseq = 1; else set l_ind_is_autoseq = 0; end if;
if l_datatype = 'varchar' then set l_metatype = 'C' ; else set l_metatype = 'N'; end if;
if l_ordinal_position_pkey is not null and l_ordinal_position_pkey > 0 then set l_ind_is_required = 1; else set l_ind_is_required = 0; end if;
set l_description = concat('enter description for ', l_column_name); 
set l_ind_is_volatile = null;

insert into et_catalog_object_column_prop
(
catalog_id, column_name, description, ind_active, datatype, metatype, ind_nullable, column_len, ind_is_autoseq, ind_is_volatile, ind_is_required, colvalue_default, ordinal_position_pkey
) 
values (
l_catalog_id, l_column_name, l_description, 1, l_datatype, l_metatype, l_ind_nullable, l_column_len, l_ind_is_autoseq, l_ind_is_volatile, l_ind_is_required, l_colvalue_default, l_ordinal_position_pkey

)
on duplicate key update
 datatype = values(datatype),
 metatype = values(metatype),
 ind_nullable = values(ind_nullable),
 column_len = values(column_len),
 ind_is_volatile = values(ind_is_volatile),
 ordinal_position_pkey = values(ordinal_position_pkey)
 ;

end while;
close schema_c1;

set row_number_c = convert(`row_number`, char);
set l_catalog_id_c = convert(l_catalog_id, char);

if `row_number` = 0 then
   set l_msg_id_final = 1060;
   set l_msg_par_final = concat(l_table_schema, sep_mp, l_catalog_id_c);
else
   set l_msg_id_final = 1061;
   set l_msg_par_final = concat(l_table_schema, sep_mp, l_catalog_id_c, sep_mp, row_number_c);
end if;

end mdb_prop;
end main;

/*call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);*/

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
