DELIMITER $$
CREATE PROCEDURE `mdConfig_DeployApply`(
  IN CMDSYP_I            nvarchar(16)             
 ,IN OPTSYP_I            nvarchar(128) 
 ,IN NIOTA_ID_I          nvarchar(32)
 ,IN JOBNAME_I           nvarchar(32)
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_DeployApply`
-- grant execute on mdConfig_DeployApply to 'niota'@'%'; 
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.04.01
-- 
-- import data from deployment task
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
-- 2021.11.03	nmz		mysql 8.0 compatiblity - adding ` around reserved word: row_number
--
-- *******************************************************************************
--	
declare l_ind_rollback bool default 0;
   
declare loop_max bigint default 1000;
declare loop_max_c nvarchar(10);

declare `row_number` bigint default 0;
declare row_number_c nvarchar(10);
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare sep_sn varchar(01) default mdinfo_SysConstant('SEP_SCHEMA');
declare sep_nl varchar(04) default mdinfo_SysConstant('SEP_NEWLINE'); 

declare l_this_sp nvarchar(128) default 'mdConfig_DeployApply';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final nvarchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';
declare l_appcode char(5) default mdinfo_SysConstant('APPCODE');

declare l_cmdsyp nvarchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_import nvarchar(16) default 'IMPORT';
declare l_ind_cmdsyp_import bit default 0;

declare l_optsyp nvarchar(128);
declare l_ind_optsyp bit default 0;

declare l_optsyp_job nvarchar(16) default 'JOB';
declare l_ind_optsyp_job bit default 0;

declare l_optsyp_simulation nvarchar(16) default 'SIMULATION';
declare l_ind_optsyp_simulation bit default 0;

declare l_optsyp_metadb nvarchar(16) default 'METADB';
declare l_ind_optsyp_metadb bit default 0;

declare l_optsyp_withuca nvarchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_alloptsyp nvarchar(512);
declare l_allcmdsyp nvarchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_config_id_sim_schema varchar(32) default 'deploy_schema_simulate';
declare l_sequence_id_import varchar(16) default 'WORKER_ID';

declare l_sqlcmd nvarchar(21845);
declare l_end_of_cursor INTEGER DEFAULT 0;

declare l_workunit_id_import bigint;

declare l_niota_id nvarchar(32);
declare l_username nvarchar(16);
declare l_jobname nvarchar(32);
declare l_table_schema nvarchar(64);

declare l_deploy_id integer;

declare l_stepnbr_deploy integer;
declare l_sortorder_deploy smallint;
declare l_table_name_deploy nvarchar(128);
declare l_command_deploy nvarchar(16);
declare l_columnlist_deploy nvarchar(4096);
declare l_data_deploy nvarchar(4096);
declare l_onduplicate_deploy nvarchar(4096);

declare l_dynsql_insert nvarchar(4096) default '';
declare l_task_wu varchar(16) default '';
declare l_rc_wu integer default 0;

declare deploy_c1 cursor for
-- deploy always the root 
 select
    deploy_id
  , stepnbr_deploy
  , sortorder_deploy
  , table_name_deploy
  , command_deploy
  , columnlist_deploy
  , data_deploy
  , onduplicate_deploy
 from et_deploydata_imp
 where workunit_id_import = l_workunit_id_import
   and ind_locked_wu = 1 
  order by deploy_id, stepnbr_deploy, sortorder_deploy
;
  
DECLARE CONTINUE HANDLER 
        FOR NOT FOUND 
 begin 
       GET DIAGNOSTICS @cno = NUMBER;
       GET DIAGNOSTICS CONDITION @cno @errno_notf = MYSQL_ERRNO, 
       @l_sqlstate = RETURNED_SQLSTATE ;
       SET l_end_of_cursor = 1;
 end;

DECLARE CONTINUE HANDLER FOR 1062
  BEGIN
    set @duplicates = @duplicates + 1;
  END;

DECLARE CONTINUE HANDLER FOR SQLEXCEPTION 
begin
  GET DIAGNOSTICS @cno = NUMBER;
  GET DIAGNOSTICS CONDITION @cno l_rc_wu = MYSQL_ERRNO,
      @l_sqlstate = RETURNED_SQLSTATE, 
      @l_message_text = MESSAGE_TEXT;
   set l_ind_rollback = 1;
end;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_niota_id = NIOTA_ID_I;
set l_jobname = JOBNAME_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_import, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_import = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_import; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_import); -- next

-- test the set options and switch on option indicators 
if locate(l_optsyp_job, l_optsyp, 1) > 0 then   set l_ind_optsyp_job = 1; end if;
if locate(l_optsyp_simulation, l_optsyp, 1) > 0 then   set l_ind_optsyp_simulation = 1; end if;
if locate(l_optsyp_metadb, l_optsyp, 1) > 0 then set l_ind_optsyp_metadb = 1; end if;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_job | l_ind_optsyp_simulation | l_ind_optsyp_metadb | l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_ind_optsyp_job, sep_sp, l_ind_optsyp_simulation, sep_sp, l_optsyp_metadb, sep_sp, l_optsyp_withuca); -- next

main: begin
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
if l_ind_optsyp_withuca then set l_opt_cmdlog = l_optsyp_withuca; end if;

-- get username/table_schema or use default values
set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca), substring(current_user(),1,16));
set l_table_schema = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_metadb),l_optsyp_metadb);
  
set l_sqlcmd = '';

set `row_number` = 0;
set l_rc_wu = 0;

set l_task_wu = l_cmdsyp;

if l_ind_optsyp_simulation then
   set l_table_schema = mdInfo_SysConfigValue(l_appcode, l_config_id_sim_schema);
   set l_task_wu = l_optsyp_simulation;

-- get the target schema
end if;
  
set l_workunit_id_import = mdInfo_NextValue(l_appcode, l_sequence_id_import);

set autocommit = off;
set l_ind_rollback = 0;

-- mark the working set
start transaction;

if l_ind_optsyp_simulation then

update et_deploydata_imp
 set  username_import = l_username
     ,workunit_id_import = l_workunit_id_import
     ,ts_start_wu = current_timestamp(6)
     ,task_wu = l_task_wu
     ,ind_locked_wu = 1
     ,status_wu = -1
     ,rc_wu = -1
 where niota_id = l_niota_id
  and (jobname_deploy like l_jobname or jobname_deploy = l_jobname);

else 
 
 update et_deploydata_imp
 set  username_import = l_username
     ,workunit_id_import = l_workunit_id_import
     ,ts_start_wu = current_timestamp(6)
     ,task_wu = l_task_wu
     ,ind_locked_wu = 1
     ,status_wu = -1
     ,rc_wu = -1
 where niota_id = l_niota_id
  and (jobname_deploy like l_jobname or jobname_deploy = l_jobname)
  and ind_locked_wu = 0 and status_wu in (0, 2);
end if;
  
if l_ind_rollback then
   ROLLBACK;
   set l_ind_rollback = 0;
ELSE
   COMMIT;
END IF;

set l_ind_rollback = 0;
START TRANSACTION;

open deploy_c1;
-- select concat(convert(@l_sqlstate,char), ":", convert(@cno, char), ":",l_task_wu);
-- insert into mylog values(l_number_of_columns);

C1: while 1 = 1 do

 if `row_number` = loop_max then leave C1; end if;
 if l_ind_rollback then leave C1; end if;

 fetch deploy_c1 into
  l_deploy_id
, l_stepnbr_deploy
, l_sortorder_deploy  
, l_table_name_deploy
, l_command_deploy
, l_columnlist_deploy
, l_data_deploy
, l_onduplicate_deploy
;

-- when at end use a dummy value for ...this
if l_end_of_cursor = 1 then leave C1; end if;

set `row_number` = `row_number` + 1;

set l_dynsql_insert = ''; 

prepare_insert: begin
if l_command_deploy <> 'INSERT' then leave prepare_insert; end if;

-- finalize the on dynamic rootlink - string
set l_dynsql_insert = concat(
    "INSERT INTO "
   , l_table_schema, sep_sn, l_table_name_deploy, sep_nl
   , "(", l_columnlist_deploy, ")" , sep_nl 
   , "VALUES (", l_data_deploy, ")" , sep_nl
   );
   
if l_onduplicate_deploy <> '' then
   set l_dynsql_insert = concat(l_dynsql_insert, l_onduplicate_deploy); 
end if;

set @deploy_import = l_dynsql_insert;
end prepare_insert;

PREPARE dynsql FROM @deploy_import; 
EXECUTE dynsql; 


deallocate prepare dynsql; 

end while;
close deploy_c1;

-- commit or rollback this transaction
if l_ind_rollback then
   ROLLBACK;
   set l_ind_rollback = 0;
ELSE
   COMMIT;
END IF;

-- start the final update status transaction
START transaction;

if l_rc_wu = 0 then

   update et_deploydata_imp
      set ts_end_wu = current_timestamp(6)
         ,ind_locked_wu = 0
         ,status_wu = case when l_ind_optsyp_simulation then 0 else 1 end
         ,rc_wu = l_rc_wu
   where workunit_id_import = l_workunit_id_import;

   set l_msg_id_final = 1065;
   set l_msg_par_final = l_task_wu;


else 

   update et_deploydata_imp
      set ind_locked_wu = case when l_ind_optsyp_simulation then 0 else ind_locked_wu end 
		 ,status_wu = 2
         ,rc_wu = case 
             when deploy_id = l_deploy_id and stepnbr_deploy = l_stepnbr_deploy and sortorder_deploy = l_sortorder_deploy then l_rc_wu 
             else rc_wu end
   where workunit_id_import = l_workunit_id_import;

   set l_msg_id_final = 1064;
   set l_msg_par_final = convert(l_rc_wu, char);

end if;
 
COMMIT;

end main;

set autocommit = on;


call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
