DELIMITER $$
CREATE 
PROCEDURE `mdConfig_DeployCreate`(
  IN CMDSYP_I            nvarchar(16)             
 ,IN OPTSYP_I            nvarchar(128)
 ,IN NIOTA_ID_I          nvarchar(32)
 ,IN JOBNAME_I           nvarchar(32)
 ,IN TABLE_NAME_I        nvarchar(128)
 ,IN WHERE_ROOT_I        nvarchar(1024)
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_DeployCreate`
-- grant execute on mdConfig_DeployCreate to 'niota'@'%';
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.04.01
-- 
-- export data into table for deployment task
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
-- 2021.11.03	nmz		 mysql 8.0 compatiblity - adding ` around reserved word: row_number
--						 remove DEFINER... part	
-- *******************************************************************************
--	

declare loop_max bigint default 1000;
declare loop_max_c nvarchar(10);

declare `row_number` bigint default 0;
declare row_number_c nvarchar(10);
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare l_this_sp nvarchar(128) default 'mdConfig_DeployCreate';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final nvarchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';
declare l_appcode char(5) default mdinfo_SysConstant('APPCODE');

declare row_number_group bigint default 0;
declare ind_total_break smallint default 0;
declare ind_total_start smallint default 1;

declare l_cmdsyp nvarchar(16);
declare l_ind_cmdsyp bit default 0;

-- all possible system commands
declare l_cmdsyp_export nvarchar(16) default 'EXPORT';
declare l_ind_cmdsyp_export bit default 0;

-- all possible system options
declare l_optsyp_tree nvarchar(16) default 'TREE';
declare l_ind_optsyp_tree bit default 0;

declare l_optsyp_this nvarchar(16) default 'THIS';
declare l_ind_optsyp_this bit default 0;

declare l_optsyp_table nvarchar(16) default 'TABLE';
declare l_ind_optsyp_table bit default 0;

declare l_optsyp_log nvarchar(16) default 'LOG';
declare l_ind_optsyp_log bit default 0;

declare l_optsyp_nolog nvarchar(16) default 'NOLOG';
declare l_ind_optsyp_nolog bit default 0;

declare l_optsyp_withuca nvarchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_optsyp nvarchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp nvarchar(512);
declare l_allcmdsyp nvarchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_sequence_id_deploy varchar(16) default 'DEPLOY_ID';
declare l_command_insert nvarchar(16) default 'INSERT';

declare l_sqlcmd nvarchar(8192);
declare l_end_of_cursor INTEGER DEFAULT 0;
declare l_nl char(4) default '\r\n';

declare l_niota_id nvarchar(32);
declare l_username nvarchar(20);
declare l_jobname nvarchar(32);
declare l_table_name nvarchar(64);

declare l_data_type nvarchar(64);
declare l_metatype nvarchar(1);
declare l_ordinal_position bigint;
declare l_number_of_columns bigint;
declare l_ind_nullable smallint;
declare l_ind_linked smallint;

declare l_deploy_id integer;
declare l_workunit_id_deploy bigint;
declare l_task_wu nvarchar(16) default ' ';
declare l_ind_locked_wu smallint default 0;
declare l_status_wu smallint default 0;
declare l_rc_wu integer default 0;

declare l_table_name_root nvarchar(64);
declare l_table_name_deploy nvarchar(64);
declare l_table_name_deploy_prev nvarchar(64);

declare l_ind_subtree smallint;
declare l_ind_subtree_prev smallint;
declare l_sortorder_table smallint;
declare l_sortorder_table_prev smallint;
declare l_catalog_id int;
declare l_catalog_id_linked int;

declare l_where_root nvarchar(1024);
declare l_sortorder integer;
declare l_stepnbr_deploy integer;

declare l_cnt_table integer default 0;
declare l_cnt_row integer default 0;

declare l_columnlist_deploy nvarchar(4096);

declare l_where_deploy nvarchar(1024);

declare l_table_name_subtree nvarchar(64);
declare l_description nvarchar(128);
declare l_sortorder_link smallint;
declare l_sortorder_type smallint;
declare l_sortorder_command smallint;

declare l_catalog_id_root int;
declare l_catalog_id_subtree int;
declare l_logical_link nvarchar(32);

declare l_dynsql_deploy_values nvarchar(4096);
declare l_dynsql_link nvarchar(4096);

declare l_column_name_root nvarchar(64);
declare l_column_name_subtree nvarchar(64);
declare l_column_name_deploy nvarchar(64);

declare l_breakcontrol_1_this integer;
declare l_breakcontrol_1_prev integer;

declare l_this_cqfunction_charcol nvarchar(64) default 'concat("""", concat($this_cn_deploy), """") ';
declare l_this_cqfunction_numcol nvarchar(64) default 'concat("""", convert($this_cn_deploy, char), """") ';
declare l_this_cqfunction nvarchar(64);

declare l_dynsql_value nvarchar(4096) default '';
declare l_prefix_value nvarchar(64) default 'concat( ';
declare l_wrap_value_nullable nvarchar(128) default 'case when $this_cn_deploy is null then concat("NULL") else $this_cqfunction_deploy end';
declare l_wrap_value_notnull nvarchar(128) default '$this_cqfunction_deploy';

declare l_wrap_value nvarchar(128) default '';
declare l_sep_value nvarchar(20) default ', concat(", "), ';
declare l_suffix_value nvarchar(64) default ') ';

declare l_this_value nvarchar(256) default '';

declare l_dynsql_onduplicate nvarchar(4096) default '';
declare l_prefix_onduplicate nvarchar(64) default 'ON DUPLICATE KEY UPDATE ';
declare l_wrap_onduplicate nvarchar(64) default '$this_cn_deploy = values($this_cn_deploy)';
declare l_sep_onduplicate nvarchar(2) default ', ';
declare l_suffix_onduplicate nvarchar(20) default '';

declare l_this_onduplicate nvarchar(128) default '';

declare l_dynsql_wherelinked nvarchar(4096) default '';
declare l_prefix_wherelinked nvarchar(64) default 'concat(concat("WHERE "), ';
declare l_wrap_wherelinked nvarchar(64) default ' "$this_cn_deploy = ", $this_cn_root';
declare l_sep_wherelinked nvarchar(20) default 'concat("AND "), ';
declare l_suffix_wherelinked nvarchar(64) default ') as ROOTBASEDLINK ';

declare l_this_wherelinked nvarchar(128) default '';
 
 
declare l_dynsql_deployment nvarchar(4096) default '';
declare l_prefix_deployment nvarchar(128) default 'insert into et_deploydata_exp ';
declare l_collist_deployment nvarchar(1024) default '(niota_id, deploy_id, stepnbr_deploy, jobname_deploy
, username_export, workunit_id_export, username_import, workunit_id_import, ts_start_wu, ts_end_wu, task_wu, ind_locked_wu, status_wu, rc_wu
, table_name_deploy, sortorder_deploy, command_deploy, columnlist_deploy, data_deploy, onduplicate_deploy) ';
declare l_sellist_deployment nvarchar(4096) default ' ';
declare l_from_deployment nvarchar(256) default ' ';   

declare l_this_deployment nvarchar(8192) default '';

declare deploy_c1 cursor for
-- deploy always the root 
 select * from
 (
 select
  0 as ind_subtree
, 0 as sortorder_table
, cfmt.ordinal_position  
, mobr.catalog_id
, mobr.catalog_id as catalog_id_linked
, mobr.object as table_name_deploy
, cfmt.column_name as column_name_deploy
, cfmt.metatype
, 0 as ind_linked
, null as column_name_root
, cfmt.ind_nullable
from et_metadb_object mobr
join et_catalog_object_column_format cfmt
on cfmt.catalog_id = mobr.catalog_id
where mobr.object = l_table_name
and mobr.ind_deploy = 1
and mobr.er_level = 0

union

select
  1 as ind_subtree 
, mlnk.sortorder as sortorder_table
, cfmt.ordinal_position  
, mobr.catalog_id
, mlnk.catalog_id_linked
, mobl.object as table_name_deploy
, cfmt.column_name as column_name_deploy
, cfmt.metatype
 ,case when lnkd.column_name_linked is null then 0 else 1 end AS ind_linked
 ,lnkd.column_name AS column_name_root
, cfmt.ind_nullable
from et_metadb_object mobr
join et_metadb_link mlnk
  on mlnk.catalog_id = mobr.catalog_id
join et_catalog_object_column_format cfmt
  on cfmt.catalog_id = mlnk.catalog_id_linked
join et_metadb_object mobl
  on mobl.catalog_id = mlnk.catalog_id_linked
left outer join et_metadb_link_detail lnkd 
  on lnkd.catalog_id = mlnk.catalog_id
 and lnkd.logical_link = mlnk.logical_link
 and lnkd.column_name_linked = cfmt.column_name
where mobr.object = l_table_name
  and mobr.ind_deploy = 1
  and mobr.er_level = 0
  and mlnk.catlink_type = 1  
) allobject
where ind_subtree in (0,l_ind_subtree)
order by 
  sortorder_table
, ordinal_position  
;
  
DECLARE CONTINUE HANDLER 
        FOR NOT FOUND SET l_end_of_cursor = 1;

-- init the columns for break control
set l_breakcontrol_1_this = null;
set l_breakcontrol_1_prev = null;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_niota_id = NIOTA_ID_I;
set l_jobname = JOBNAME_I;
set l_table_name = TABLE_NAME_I;
set l_where_root = WHERE_ROOT_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_export, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_export = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_export; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_export); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_optsyp_tree, l_optsyp, 1) > 0 then set l_ind_optsyp_tree = 1; end if;
if locate(l_optsyp_this, l_optsyp, 1) > 0 then set l_ind_optsyp_this = 1; end if;
if locate(l_optsyp_table, l_optsyp, 1) > 0 then set l_ind_optsyp_table = 1; end if;
if locate(l_optsyp_log, l_optsyp, 1) > 0 then set l_ind_optsyp_log = 1; end if;
if locate(l_optsyp_nolog, l_optsyp, 1) > 0 then set l_ind_optsyp_nolog = 1; end if;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp =  l_ind_optsyp_tree |  l_ind_optsyp_this | l_ind_optsyp_table | l_ind_optsyp_log | l_ind_optsyp_nolog | l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_tree, sep_sp, l_optsyp_this, sep_sp, l_optsyp_table, sep_sp, l_optsyp_log, sep_sp, l_optsyp_nolog, sep_sp, l_optsyp_withuca); -- next

main: BEGIN
 
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
if l_ind_optsyp_withuca then set l_opt_cmdlog = l_optsyp_withuca; end if;

-- get username or use default values
set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca), substring(current_user(),1,16));

if l_ind_optsyp_tree then set l_ind_subtree = 1; else set l_ind_subtree = 0; end if;
-- toggle the logging option 
if l_ind_optsyp_nolog then set l_ind_optsyp_log = 0; end if;

set l_task_wu = l_cmdsyp;
    
set l_sqlcmd = '';

open deploy_c1;

set `row_number` = 0;
set row_number_group = 0;

-- insert into mylog values(l_number_of_columns);

C1: while 1 = 1 do

 if `row_number` = loop_max then leave C1; end if;

 fetch deploy_c1 into
  l_ind_subtree
, l_sortorder_table
, l_ordinal_position  
, l_catalog_id
, l_catalog_id_linked
, l_table_name_deploy
, l_column_name_deploy
, l_metatype
, l_ind_linked
, l_column_name_root
, l_ind_nullable
;

/*
 if l_end_of_cursor = 1 then  
    leave C1;
 end if;
*/

set l_breakcontrol_1_this = l_sortorder_table;

-- when at end use a dummy value for ...this
if l_end_of_cursor = 1 then 
   set ind_total_break = 1; 
   set l_breakcontrol_1_this = null;
end if;

-- handle break logic -- tasks at end of break
-- ####
allbreak_end: Begin

if `row_number` = 0 
  or row_number_group = 0 
  or l_breakcontrol_1_prev = l_breakcontrol_1_this then leave allbreak_end; end if;

if row_number_group > 0 then 
  set l_sqlcmd ='';
 
  -- set l_sqlcmd = replace(l_sqlcmd, '$where_root', l_where_root);
end if;

-- if there is a link between the deploy-table and the root table translate the link into a root-based where clause otherwhise use root-where
set l_where_deploy = l_where_root;

xlate_where: begin
if l_ind_subtree_prev = 0 then leave xlate_where; end if;

-- finalize the on dynamic rootlink - string
if l_dynsql_wherelinked <> '' then 
   set l_dynsql_wherelinked = concat(l_prefix_wherelinked, l_dynsql_wherelinked, l_suffix_wherelinked);
end if;   

set @xlate_where = concat( 
  "select "
, l_dynsql_wherelinked
, " into @where_subtree " 
, " from "
, l_table_name
, " " 
, l_where_root
);

PREPARE dynsql FROM @xlate_where; 
EXECUTE dynsql; # thus far working ok


deallocate prepare dynsql; 
set l_where_deploy = @where_subtree;

end xlate_where;

set l_stepnbr_deploy = (l_sortorder_table_prev * 100) + row_number_group;

-- finalize the on duplicate clause
if l_dynsql_onduplicate <> '' then 
   set l_dynsql_onduplicate = concat(l_prefix_onduplicate, l_nl, l_dynsql_onduplicate);
end if;   

-- finalize the on duplicate clause
if l_dynsql_value <> '' then 
   set l_dynsql_value = concat(l_prefix_value, l_dynsql_value, l_suffix_value);
end if;   

set l_this_deployment = '';

set l_sellist_deployment = concat(l_nl, "select ", l_nl
, """", l_niota_id, """", " as niota_id, ", l_nl 
, convert(l_deploy_id, char), " as deploy_id, ", l_nl
, convert(l_stepnbr_deploy, char), " as stepnbr_id, ", l_nl
, """", l_jobname, """", " as jobname_deploy, ", l_nl  

, """", l_username, """", " as username_export, ", l_nl  
, convert(l_deploy_id, char), " as workunit_id_export, ", l_nl
-- , """", l_username, """", " as username_import, ", l_nl 
, "NULL", " as username_import, ", l_nl 
-- , convert(l_deploy_id, char), " as workunit_id_import, ", l_nl
, "NULL", " as workunit_id_import, ", l_nl

, """", convert(current_timestamp(6), char), """", " as ts_start_wu, ", l_nl
, """", convert(current_timestamp(6), char), """", " as ts_end_wu, ", l_nl
, """", l_task_wu, """", " as task_wu, ", l_nl
, convert(l_ind_locked_wu, char), " as ind_locked_wu, ", l_nl
, convert(l_status_wu, char), " as status_wu, ", l_nl
, convert(l_rc_wu, char), " as rc_wu, ", l_nl

, """", l_table_name_deploy_prev, """", " as table_name_deploy, ", l_nl
, "@dplcnt := coalesce(@dplcnt,0) + 1 as sortorder_deploy, ", l_nl 
, """", l_command_insert, """", " as command_deploy, ", l_nl
, """", l_columnlist_deploy, """", " as columnslist, ", l_nl
, l_dynsql_value, " as data_deploy, ", l_nl
, """", l_dynsql_onduplicate, """", " as onduplicate_deploy ", l_nl
);

set l_from_deployment = concat(" from ", l_table_name_deploy_prev, " ", l_nl);
 
set l_this_deployment = concat(
  l_prefix_deployment
 ,l_collist_deployment
 ,l_sellist_deployment
 ,l_from_deployment
 ,l_where_deploy
 );
 
if l_ind_optsyp_log then 

   insert into et_deploylog_step (niota_id, deploy_id, stepnbr_deploy, table_name_deploy, dynsql_data)
   values (l_niota_id, l_deploy_id, l_stepnbr_deploy, l_table_name_deploy_prev, l_this_deployment);

end if;
 
 
set @dplcnt = 0;
set @dynsql_deployment = l_this_deployment;

PREPARE dynsql_2 FROM @dynsql_deployment; 
EXECUTE dynsql_2; # thus far working ok
deallocate prepare dynsql_2; 

set l_cnt_row = l_cnt_row + @dplcnt;
set l_cnt_table = l_cnt_table + 1;


set row_number_group = 0;

end allbreak_end;

if ind_total_break = 1 then 
   set l_msg_id_final = 1069;
   set l_msg_par_final = concat(l_cmdsyp, sep_mp, convert(l_deploy_id, char), sep_mp, convert(l_cnt_table, char), sep_mp, convert(l_cnt_row, char));
   leave C1; 
end if;

set `row_number` = `row_number` + 1;
set row_number_group = row_number_group + 1;
  
-- ####

-- detail record logic
alldetail: begin
-- if ind_total_break = 1 then leave alldetail; end if;

-- handle break logic -- tasks at start of break
allbreak_start: Begin
-- execute only once;
if row_number_group > 1 
 or l_breakcontrol_1_prev = l_breakcontrol_1_this then leave allbreak_start; end if;

total_start: Begin
if ind_total_start = 0 then leave total_start; end if;

-- retrieve the next deploy-id and clean up tables;
set l_deploy_id = mdInfo_NextValue(l_appcode, l_sequence_id_deploy);

if l_ind_optsyp_log then 
   delete from et_deploylog where niota_id = l_niota_id and deploy_id = l_deploy_id;  
   delete from et_deploylog_step where niota_id = l_niota_id and deploy_id = l_deploy_id;  

   insert into et_deploylog (niota_id, deploy_id, cmdsyp_deploy, optsyp_deploy, username_deploy, jobname_deploy, table_name_root, where_root)
   values(l_niota_id, l_deploy_id, l_cmdsyp, l_optsyp, l_username, l_jobname, l_table_name, l_where_root);
end if;

set ind_total_start = 0;
end total_start;


set l_columnlist_deploy = '';
set l_sqlcmd = '';
set l_dynsql_onduplicate = '';
set l_dynsql_wherelinked = '';
set l_dynsql_value = '';

set l_number_of_columns = 1;

if row_number_group = 1 then 
  set @nop = null;    
end if;
    
end allbreak_start;

-- save the values for the break-control
set l_table_name_deploy_prev = l_table_name_deploy;
set l_ind_subtree_prev = l_ind_subtree;
set l_sortorder_table_prev = l_sortorder_table;


-- collect the column list of all columns to deploy
if l_columnlist_deploy <> '' then 
   set l_columnlist_deploy = concat(l_columnlist_deploy, ', ');
end if;   
set l_columnlist_deploy = concat(l_columnlist_deploy, trim(l_column_name_deploy));

-- collect the function for the values()-sql
if l_dynsql_value <> '' then 
   set l_dynsql_value = concat(l_dynsql_value, l_sep_value, l_nl);
end if;   

set l_this_value = '';
if l_metatype = "C" then 
    set l_this_cqfunction = l_this_cqfunction_charcol;
 else 
   set l_this_cqfunction = l_this_cqfunction_numcol;
end if;

if l_ind_nullable = 1 then 
   set l_wrap_value = l_wrap_value_nullable;
else
   set l_wrap_value = l_wrap_value_notnull;
end if;

set l_this_value = replace(l_wrap_value,'$this_cqfunction_deploy', l_this_cqfunction); 
set l_this_value = replace(l_this_value,'$this_cn_deploy', l_column_name_deploy);

set l_dynsql_value = concat(l_dynsql_value, trim(l_this_value));


-- collect the columns for the on duplicate key
set l_this_onduplicate = '';
 
if l_dynsql_onduplicate <> '' then 
   set l_dynsql_onduplicate = concat(l_dynsql_onduplicate, l_sep_onduplicate, l_nl);
end if;   

set l_this_onduplicate = replace(l_wrap_onduplicate,'$this_cn_deploy', l_column_name_deploy);
set l_dynsql_onduplicate = concat(l_dynsql_onduplicate, trim(l_this_onduplicate));

-- translate the rootbased link into a subtree-where-condition

-- collect the columns for the where clause
if l_ind_linked = 1 then
   set l_this_wherelinked = '';
 
   if l_dynsql_wherelinked <> '' then 
      set l_dynsql_wherelinked = concat(l_dynsql_wherelinked, l_sep_wherelinked);
   end if;   

   set l_this_wherelinked = replace(l_wrap_wherelinked,'$this_cn_deploy', l_column_name_deploy);
   set l_this_wherelinked = replace(l_this_wherelinked,'$this_cn_root', l_column_name_root);

   set l_dynsql_wherelinked = concat(l_dynsql_wherelinked, trim(l_this_wherelinked));
end if;

-- set the break control columns
set l_breakcontrol_1_prev = l_breakcontrol_1_this;

end alldetail;

end while;
close deploy_c1;

end main;

call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
