DELIMITER $$
CREATE PROCEDURE `mdConfig_DeployMove`(
  IN CMDSYP_I           nvarchar(16) 
 ,IN OPTSYP_I           nvarchar(128) 
 ,IN NIOTA_ID_I         nvarchar(32)
 ,IN JOBNAME_I          nvarchar(32)
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_DeployMove`
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.04.01
-- 
-- transfer deploy data between tables (export/import/archive)
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
-- 2021.11.03	nmz		 mysql 8.0 compatiblity - adding ` around reserved word: row_number
--
-- *******************************************************************************
--	
declare loop_max bigint default 1000;
declare loop_max_c nvarchar(10);

declare `row_number` bigint default 0;
declare row_number_c nvarchar(10);
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');
declare sep_fe varchar(01) default mdinfo_SysConstant('SEP_FILEEXT');

declare l_this_sp nvarchar(128) default 'mdConfig_DeployMove';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final nvarchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';
declare l_appcode char(5) default mdinfo_SysConstant('APPCODE');

declare l_cmdsyp nvarchar(16);
declare l_ind_cmdsyp bit default 0;

-- all possible system commands
declare l_cmdsyp_swapexport nvarchar(16) default 'SWAPEXPORT';
declare l_ind_cmdsyp_swapexport bit default 0;

declare l_cmdsyp_unload nvarchar(16) default 'UNLOAD';
declare l_ind_cmdsyp_unload bit default 0;

declare l_cmdsyp_collect nvarchar(16) default 'COLLECT';
declare l_ind_cmdsyp_collect bit default 0;

declare l_cmdsyp_deleteimport nvarchar(16) default 'DELETEIMPORT';
declare l_ind_cmdsyp_deleteimport bit default 0;

declare l_cmdsyp_deleteexport nvarchar(16) default 'DELETEEXPORT';
declare l_ind_cmdsyp_deleteexport bit default 0;

-- all possible system options
declare l_optsyp_job nvarchar(16) default 'JOB';
declare l_ind_optsyp_job bit default 0;

declare l_optsyp_withuca nvarchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_seq_id_worker_id varchar(16) default 'WORKER_ID';
declare l_seq_id_deploy_id varchar(16) default 'DEPLOY_ID';
declare l_seq_id_unload_id varchar(16) default 'UNLOAD_ID';

declare l_optsyp nvarchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp nvarchar(512);
declare l_allcmdsyp nvarchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_end_of_cursor INTEGER DEFAULT 0;

declare l_niota_id nvarchar(32);
declare l_username nvarchar(16) default current_user();
declare l_jobname nvarchar(32);
declare l_jobname_deploy nvarchar(32);
declare l_jobname_deploy_collect nvarchar(32);

declare l_cfg_id_jobname_deploy nvarchar(32) default 'deploy_jobname';
declare l_cfg_id_deploy_outpath nvarchar(32) default 'deploy_export_path';
declare l_cfg_id_deploy_outext  nvarchar(32) default 'deploy_export_fileext';

declare l_unload_id integer;
declare l_stepnbr_deploy integer;
declare l_sortorder_deploy integer;

declare l_workunit_id_deploy bigint;
declare l_task_wu nvarchar(16);

declare l_outfile nvarchar(256);
declare l_outfile_path nvarchar(128) default '';
declare l_outfile_ext nvarchar(05) default '';


declare l_dynsql_tooutfile nvarchar(4096) default '';
declare l_prefix_tooutfile  nvarchar(128) default "SELECT * INTO OUTFILE ";
declare l_cmd_tooutfile     nvarchar(256) default "FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '""' LINES TERMINATED BY '\\n' ";
declare l_from_tooutfile    nvarchar(128) default " FROM et_deploydata_exp ";
declare l_where_tooutfile   nvarchar(128) default " WHERE ";

declare l_this_tooutfile nvarchar(128) default '';


declare deploy_c_exp cursor for
-- deploy always the root 
 select distinct 
   niota_id
 , jobname_deploy
  from et_deploydata_exp
 where (niota_id like l_niota_id or niota_id = l_niota_id)
   and (jobname_deploy like l_jobname or jobname_deploy = l_jobname)
 order by niota_id, jobname_deploy
 for update;
 
 declare deploy_c_imp cursor for
-- deploy always the root 
 select distinct 
   niota_id
 , jobname_deploy
  from et_deploydata_imp
 where (niota_id like l_niota_id or niota_id = l_niota_id)
   and (jobname_deploy like l_jobname or jobname_deploy = l_jobname)
 order by niota_id, jobname_deploy
 for update;
 
DECLARE CONTINUE HANDLER 
 FOR NOT FOUND SET l_end_of_cursor = 1;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_niota_id = NIOTA_ID_I;
set l_jobname = JOBNAME_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_swapexport, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_swapexport = 1; end if;
if locate(l_cmdsyp_unload, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_unload = 1; end if;
if locate(l_cmdsyp_deleteimport, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_deleteimport = 1; end if;
if locate(l_cmdsyp_deleteexport, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_deleteexport = 1; end if;
if locate(l_cmdsyp_collect, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_collect = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_swapexport | l_ind_cmdsyp_unload | l_ind_cmdsyp_deleteimport | l_ind_cmdsyp_deleteexport | l_ind_cmdsyp_collect; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_swapexport, sep_sp, l_cmdsyp_unload, sep_sp, l_cmdsyp_deleteimport, sep_sp, l_cmdsyp_deleteexport, sep_sp, l_cmdsyp_collect); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_optsyp_job, l_optsyp, 1) > 0 then set l_ind_optsyp_job = 1; end if;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp =  l_ind_optsyp_job | l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_job, sep_sp, l_optsyp_withuca); -- next

main: BEGIN
 
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
if l_ind_optsyp_withuca then set l_opt_cmdlog = l_optsyp_withuca; end if;

-- get username/table_schema or use default values
set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca), substring(current_user(),1,16));

-- if jobs are to be collected to a larger package
if l_ind_cmdsyp_collect then
   set l_jobname_deploy_collect = mdInfo_UserConfigValue(l_appcode, l_username,l_cfg_id_jobname_deploy);
   set l_unload_id = mdInfo_CurrentValue(l_appcode, l_seq_id_unload_id);
   set l_jobname_deploy_collect = concat(trim(l_jobname_deploy_collect),"_",convert(l_unload_id,char));
end if;

-- get the target infomation for unload to file
if l_ind_cmdsyp_unload then
    
   set l_outfile_path = mdInfo_SysConfigValue(l_appcode, l_cfg_id_deploy_outpath);
   set l_outfile_ext = mdInfo_SysConfigValue(l_appcode, l_cfg_id_deploy_outext);

end if;
  

if l_ind_cmdsyp_swapexport or l_ind_cmdsyp_unload or l_ind_cmdsyp_deleteexport or l_ind_cmdsyp_collect then  
   open deploy_c_exp;
end if;

if l_ind_cmdsyp_deleteimport then  
   open deploy_c_imp;
end if;

set l_task_wu = l_cmdsyp;

set `row_number` = 0;

C1: while 1 = 1 do

 if `row_number` = loop_max then leave C1; end if;
 
 if l_ind_cmdsyp_swapexport or l_ind_cmdsyp_unload or l_ind_cmdsyp_deleteexport or l_ind_cmdsyp_collect then  
 fetch deploy_c_exp into
   l_niota_id
 , l_jobname_deploy
;
 end if;

 if l_ind_cmdsyp_deleteimport then  
 fetch deploy_c_imp into
   l_niota_id
 , l_jobname_deploy
;
 end if;
 
-- when at end use a dummy value for ...this
if l_end_of_cursor = 1 then 
   set l_msg_id_final = 1070;
   set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_optsyp);
   leave C1; 
end if; 

set `row_number` = `row_number` + 1;

if l_ind_cmdsyp_unload or l_ind_cmdsyp_swapexport then  
   set l_workunit_id_deploy = mdInfo_NextValue(l_appcode, l_seq_id_worker_id);
end if;

if l_ind_cmdsyp_swapexport or l_ind_cmdsyp_unload or l_ind_cmdsyp_deleteimport then

delete from et_deploydata_imp
 where niota_id = l_niota_id
   and jobname_deploy = l_jobname_deploy;
   
end if;

if l_ind_cmdsyp_swapexport then

insert into et_deploydata_imp 
(niota_id, deploy_id, stepnbr_deploy, sortorder_deploy, jobname_deploy, username_export, workunit_id_export, username_import, workunit_id_import, ts_start_wu, ts_end_wu, task_wu,
 ind_locked_wu, status_wu, rc_wu, table_name_deploy, command_deploy, columnlist_deploy, data_deploy, onduplicate_deploy)
select niota_id,
 deploy_id,
 stepnbr_deploy,
 sortorder_deploy,
 jobname_deploy,
 l_username,
 l_workunit_id_deploy,
 username_import,
 workunit_id_import,
 current_timestamp(6),
 current_timestamp(6),
 l_task_wu as task_wu,
 0 as ind_locked_wu,
 0 as status_wu,
 0 as rc_wu,
 table_name_deploy,
 command_deploy,
 columnlist_deploy,
 data_deploy,
 onduplicate_deploy
 from et_deploydata_exp
where niota_id = l_niota_id
   and jobname_deploy = l_jobname_deploy;
end if;

if l_ind_cmdsyp_unload then
 
 set l_dynsql_tooutfile = '';
 set l_outfile = concat(l_outfile_path, l_jobname_deploy, sep_fe, l_outfile_ext);
 
 set l_dynsql_tooutfile = concat(l_prefix_tooutfile 
 , " '", l_outfile, "' "
 , l_cmd_tooutfile
 , l_from_tooutfile
 , l_where_tooutfile
 , "niota_id = ", """", l_niota_id, """"
 , " and jobname_deploy = ", """", l_jobname_deploy, """"
 );
 
 set @tooutfile = l_dynsql_tooutfile;

 PREPARE dynsql FROM @tooutfile; 
 EXECUTE dynsql; # thus far working ok

 -- burn the active deploy_id
 set l_unload_id = mdInfo_NextValue(l_appcode, l_seq_id_unload_id);
    
 deallocate prepare dynsql; 
 
insert into et_deployarchive
(workunit_id_archive, niota_id, deploy_id, stepnbr_deploy, sortorder_deploy, jobname_deploy, username_export, workunit_id_export, username_import, workunit_id_import, ts_start_wu, ts_end_wu, task_wu,
 ind_locked_wu, status_wu, rc_wu, table_name_deploy, command_deploy, columnlist_deploy, data_deploy, onduplicate_deploy)
select l_workunit_id_deploy,
 niota_id,
 deploy_id,
 stepnbr_deploy,
 sortorder_deploy,
 jobname_deploy,
 username_export,
 workunit_id_export,
 username_import,
 workunit_id_import,
 ts_start_wu,
 ts_end_wu,
 task_wu,
 ind_locked_wu,
 status_wu,
 rc_wu,
 table_name_deploy,
 command_deploy,
 columnlist_deploy,
 data_deploy,
 onduplicate_deploy
 from et_deploydata_exp
where niota_id = l_niota_id
   and jobname_deploy = l_jobname_deploy
;
end if;


if l_ind_cmdsyp_swapexport or l_ind_cmdsyp_unload or l_ind_cmdsyp_deleteexport then

delete from et_deploydata_exp
 where niota_id = l_niota_id
   and jobname_deploy = l_jobname_deploy;

end if;

if l_ind_cmdsyp_collect then

update et_deploydata_exp
 set jobname_deploy = l_jobname_deploy_collect
 where niota_id = l_niota_id
   and jobname_deploy = l_jobname_deploy;

end if;

end while;

if l_ind_cmdsyp_swapexport or l_ind_cmdsyp_unload or l_ind_cmdsyp_deleteexport or l_ind_cmdsyp_collect then
   close deploy_c_exp;
end if;

if l_ind_cmdsyp_deleteimport then
   close deploy_c_imp;
end if;

end main;

call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
