DELIMITER $$
CREATE PROCEDURE `mdConfig_ManagedEntry`(
  IN CMDSYP_I              varchar(16)   -- CoMmanD SYstem Procedure           
 ,IN OPTSYP_I              varchar(128)  -- OPTion SYstem Procedure
 ,IN CATALOG_ID_MDBO_I     integer       -- catalog ID meta db    
 ,IN CONFIG_ID_I           varchar(128)  -- ID to handle 
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_ManagedEntry`
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.03.12
-- 
-- manage some et_catalog_object properties
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.12.12   fmrre    created
--
-- *******************************************************************************
--	
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');
declare sep varchar(01) default ' ';


declare l_this_sp varchar(128) default 'mdConfig_ManagedEntry';
declare l_msg_id_sperr integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_sperr varchar(4000) default ' ';
declare l_msg varchar(4000) default ' ';
declare l_logtext varchar(8192) default ' ';
declare l_optionsp varchar(256) default mdinfo_SysConfigOption(null,l_this_sp);
declare l_loglevel varchar(01) default mdInfo_OptionConfigValue(l_optionsp,'LOGLEVEL');

declare l_message_text varchar(128) DEFAULT ' ';
declare l_msg_id_not_found integer default 1200;
declare l_msg_id_mdbo_not_found integer default 1201;
declare l_msg_id_abandoned integer default 1210;
declare l_msg_id_not_abandoned integer default 1220;
declare l_msg_id_deleted integer default 1230;
declare l_msg_id_revived integer default 1240;
declare l_msg_id_is_used integer default 1250;
declare l_msg_id_is_assigned integer default 1260;
declare l_msg_id_has integer default 1270;
declare l_msg_id_has_or_used integer default 1280;
declare l_msg_id_requested integer default 1002;
declare l_msg_id_references integer default 1290;

declare l_cmdsyp varchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_check varchar(16) default 'CHECK';
declare l_ind_cmdsyp_check bit default 0;

declare l_cmdsyp_abandon varchar(16) default 'ABANDON';
declare l_ind_cmdsyp_abandon bit default 0;

declare l_cmdsyp_revive varchar(16) default 'REVIVE';
declare l_ind_cmdsyp_revive bit default 0;

declare l_cmdsyp_kill varchar(16) default 'KILL';
declare l_ind_cmdsyp_kill bit default 0;

-- all possible system options
declare l_optsyp_withuca varchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_optsyp varchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);

declare l_config_id      varchar(128);

-- internal strings (e.g. logging command and its options)
declare l_ind_handle_callable bit default 0;
declare l_ind_handle_constraint bit default 0;
declare l_ind_handle_link bit default 0;
declare l_ind_handle_lookup bit default 0;
declare l_ind_handle_menu bit default 0;
declare l_ind_handle_transaction bit default 0;
declare l_ind_handle_user bit default 0;
declare l_ind_handle_usergroup bit default 0;
declare l_ind_handle_object bit default 0;
declare l_ind_handle_objectinstance bit default 0;
declare l_ind_handle_logicaldom bit default 0;
declare l_ind_handle_physicaldom bit default 0;
declare l_ind_handle_semanticdom bit default 0;

declare l_username varchar(16) default CURRENT_USER();
declare l_username2 varchar(16);
declare l_usergroupname varchar(32);
declare l_constraint_name varchar(32);
declare l_lookup_name varchar(32);
declare l_logical_link varchar(32);
declare l_menu_id varchar(10);
declare l_callable_object varchar(32);
declare l_transaction_code varchar(16);
declare l_domain_id_logical varchar(64);
declare l_domain_id_physical varchar(64);
declare l_domain_id_semantic varchar(64);

declare l_catalog_id INTEGER;
declare l_catalog_id_mdbo INTEGER;

declare l_catalog_id_c varchar(10);
declare l_catalog_id_mdbo_c varchar(10);

declare l_instance_name_mdbo varchar(16) ;
declare l_instance_name varchar(16) ;

declare l_cataloginstance varchar(32) ;

declare l_instsplit varchar(01) default '.';
declare l_linksplit varchar(01) default '~';

declare l_splitposinst integer default 0;
declare l_splitposlink integer default 0;

declare l_catalog_id_c_pfx varchar(12);
declare l_objabbrev varchar(5);
declare l_description varchar(128);
declare l_description_aswas varchar(128);
declare l_objectcategory varchar(32);

declare l_description_mdbo varchar(128);

declare l_ind_active integer;
declare l_object_base varchar(128) default '';
declare l_object_checked varchar(128) default '';

declare l_count integer;
declare l_count_c varchar(5);
declare l_total_count integer;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_catalog_id_mdbo = CATALOG_ID_MDBO_I;
-- set l_instance_name_mdbo = INSTANCE_NAME_MDBO_I;
set l_config_id = CONFIG_ID_I;

set l_catalog_id_mdbo_c = convert(l_catalog_id_mdbo, char);

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_catalog_id_mdbo_c, sep, CONFIG_ID_I );
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

set l_username = mdInfo_OptionConfigValue(l_optsyp,l_optsyp_withuca);

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
set l_ind_cmdsyp_check = nHelper_OptionCheckOnOff(l_cmdsyp_check, l_cmdsyp);
set l_ind_cmdsyp_abandon = nHelper_OptionCheckOnOff(l_cmdsyp_abandon, l_cmdsyp);
set l_ind_cmdsyp_kill = nHelper_OptionCheckOnOff(l_cmdsyp_kill, l_cmdsyp);
set l_ind_cmdsyp_revive = nHelper_OptionCheckOnOff(l_cmdsyp_revive, l_cmdsyp);

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_check | l_ind_cmdsyp_abandon | l_ind_cmdsyp_revive | l_ind_cmdsyp_kill;
set l_allcmdsyp = concat(l_cmdsyp_check, sep_mp, l_cmdsyp_abandon, sep_mp, l_cmdsyp_revive, sep_mp, l_cmdsyp_kill); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
set l_ind_optsyp_withuca = nHelper_OptionCheckOnOff(l_optsyp_withuca, l_optsyp);

-- insert into etx_log (logtext) values(concat('XXX', cast(l_ind_optsyp_withuca as char), '-XX' ));
      
-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_withuca); -- , sep_sp, next

if l_optsyp = '' OR l_optsyp IS NULL then SET l_ind_optsyp = 1; END if;

set l_total_count = 0;

main: begin

call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_requested, l_cmdsyp, l_config_id, null, null, null);


if l_ind_cmdsyp = 0 then set l_msg_par_sperr = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_sperr = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_metadb_object');

select
   description 
  ,objabbrev
into 
   l_description_mdbo
  ,l_objabbrev
from et_metadb_object
where catalog_id = l_catalog_id_mdbo;
if row_count() <> 1 then 
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_mdbo_not_found, l_catalog_id_mdbo, l_object_checked, null, null, null);
    leave main;
end if;

set l_logtext = 'checking ';

if l_objabbrev = 'COBJE' then 
   set l_catalog_id = cast(l_config_id as signed);
   set l_catalog_id_c = trim(l_config_id);
   set l_ind_handle_object = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_objabbrev = 'CINST' then
   set l_splitposinst = locate(l_instsplit, l_config_id);
   if l_splitposinst > 0 then
	  set l_catalog_id_c = trim(left(l_config_id,l_splitposinst-1));
	  set l_catalog_id = cast(l_catalog_id_c as signed);
    
      set l_instance_name = substr(l_config_id,l_splitposinst+1);
      set l_cataloginstance = trim(l_config_id);
      set l_ind_handle_objectinstance = 1;
      set l_logtext = concat(l_logtext, sep, l_objabbrev);
   end if;
end if;

if l_objabbrev = 'USERD' then
   set l_username2 = trim(l_config_id);
   set l_ind_handle_user = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_objabbrev = 'UGRPD' then
   set l_usergroupname = trim(l_config_id);
   set l_ind_handle_usergroup = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_objabbrev = 'CNSTR' then
   set l_constraint_name = trim(l_config_id);
   set l_ind_handle_constraint = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_objabbrev = 'LOOKD' then
   set l_lookup_name = trim(l_config_id);
   set l_ind_handle_lookup = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);   
end if;

if l_objabbrev = 'CABLE' then
   set l_callable_object = trim(l_config_id);
   set l_ind_handle_callable = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

 if l_objabbrev = 'TRANS' then
   set l_transaction_code = trim(l_config_id);
   set l_ind_handle_transaction = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);   
end if;

 if l_objabbrev = 'MTREE' then
   set l_menu_id = trim(l_config_id);
   set l_ind_handle_menu = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);   
end if;

if l_objabbrev = 'TALNK' then
   set l_splitposinst = locate(l_instsplit, l_config_id);
   if l_splitposinst > 0 then
	  set l_catalog_id_c = trim(left(l_config_id,l_splitposinst-1));
	  set l_catalog_id = cast(l_catalog_id_c as signed);
   end if;

   set l_splitposlink = locate(l_linksplit, l_config_id);
   if l_splitposlink > 0 then
  
      set l_instance_name = substr(l_config_id,l_splitposinst+1,(l_splitposlink - l_splitposinst -1));
   
	  set l_logical_link = substr(l_config_id,l_splitposlink+1);
      set l_ind_handle_link = 1;
      set l_logtext = concat(l_logtext, sep, l_objabbrev, sep, l_catalog_id_c, sep, l_instance_name, sep, l_logical_link);
   end if;
end if;

if l_objabbrev = 'FDLOG' then
   set l_domain_id_logical = trim(l_config_id);
   set l_ind_handle_logicaldom = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_objabbrev = 'FDPHY' then
   set l_domain_id_physical = trim(l_config_id);
   set l_ind_handle_physicaldom = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_objabbrev = 'FDSEM' then
   set l_domain_id_semantic = trim(l_config_id);
   set l_ind_handle_semanticdom = 1;
   set l_logtext = concat(l_logtext, sep, l_objabbrev);
end if;

if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


check_CatalogOjbect: begin
if not l_ind_handle_object then leave check_CatalogOjbect; end if;

set l_catalog_id_c_pfx = concat(l_catalog_id_c, '.%');

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_CatalogOjbect; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_catalog_object');
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object');
select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_catalog_object
where catalog_id = l_catalog_id;
if row_count() <> 1 then  
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_CatalogOjbect;
end if;

-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then 
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_CatalogOjbect;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_CatalogOjbect;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_CatalogOjbect;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_column_prop');
select count(*) into l_count from et_catalog_object_column_prop where catalog_id = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then
	   delete from et_catalog_object_column_prop where catalog_id = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);  
    end if;
    
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_lookup');
select count(*) into l_count from et_lookup where catalog_id_lookup = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_catalog_object_column_prop 
          set lookup_name = null
           ,  ind_lookup_import_check = null
        where lookup_name in (select distinct lookup_name from et_lookup where catalog_id_lookup = l_catalog_id);
 
       update et_catalog_object_column_prop 
          set lookup_name_extended = null
           ,  columnname_extended_lookup = null
           ,  ind_use_extendend = null
       where lookup_name_extended in (select distinct lookup_name from et_lookup where catalog_id_lookup = l_catalog_id);
  
	   delete from et_lookup where catalog_id = l_catalog_id;
       
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link');
select count(*) into l_count from et_table_link where catalog_id_master = l_catalog_id OR catalog_id_detail = l_catalog_id; 
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has_or_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_table_link where catalog_id_master = l_catalog_id OR catalog_id_detail = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;       
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link_detail');
select count(*) into l_count from et_table_link_detail where catalog_id_master = l_catalog_id; 
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then

	   delete from et_table_link_detail where catalog_id_master = l_catalog_id; 
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;  
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_access');
select count(*) into l_count from et_catalog_object_access where catalog_id = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_assigned, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_catalog_object_access where catalog_id = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;      
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_instance');
select count(*) into l_count from et_catalog_object_instance where catalog_id = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then

	   delete from et_catalog_object_instance where catalog_id = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;   
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_callable');
select count(*) into l_count from et_catalog_object_callable where catalog_id = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_catalog_object_callable where catalog_id = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;       
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_parameter_set');
select count(*) into l_count from et_transaction_parameter_set where param_name = 'selected_instance' and param_value LIKE l_catalog_id_c_pfx;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_transaction_parameter_set where param_name = 'selected_instance' and param_value LIKE l_catalog_id_c_pfx;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;        
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_user_parameter');
select count(*) into l_count from et_user_parameter where param_filter_01 LIKE l_catalog_id_c_pfx OR param_value like l_catalog_id_c_pfx;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_user_parameter where param_filter_01 LIKE l_catalog_id_c_pfx OR param_value like l_catalog_id_c_pfx;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;      
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_format_object');
select count(*) into l_count from et_format_object where catalog_id = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_format_object where catalog_id = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;       
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_format_object_column');
select count(*) into l_count from et_format_object_column where catalog_id = l_catalog_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then

	   delete from et_format_object_column where catalog_id = l_catalog_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);     
    end if;       
end if;

abandon_CatalogOjbect: begin
if not l_ind_cmdsyp_abandon then leave abandon_CatalogOjbect; end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object');
set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_catalog_object
 set ind_active = 0, 
     description = l_description
where catalog_id = l_catalog_id;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_CatalogOjbect;

revive_CatalogOjbect: begin
if not l_ind_cmdsyp_revive then leave revive_CatalogOjbect; end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object');

update et_catalog_object
 set ind_active = 1, 
     description = l_description_aswas
where catalog_id = l_catalog_id;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description_aswas, null, null);
end if;
 
end revive_CatalogOjbect;

kill_CatalogOjbect: begin
if not l_ind_cmdsyp_kill then leave kill_CatalogOjbect; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object');
delete from et_catalog_object where catalog_id = l_catalog_id and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if;

end kill_CatalogOjbect;

end check_CatalogOjbect;
-- -- -- -- -- -- --
-- *** instance  ***
-- -- -- -- -- -- --

check_ObjectInstance: begin
if not l_ind_handle_objectinstance then leave check_ObjectInstance; end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_ObjectInstance; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_catalog_object_instance');
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_instance');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_catalog_object_instance
where catalog_id = l_catalog_id
 and instance_name = l_instance_name;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_ObjectInstance;
end if;

-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_ObjectInstance;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_ObjectInstance;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_ObjectInstance;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_lookup');
select count(*) into l_count from et_lookup where catalog_id_lookup = l_catalog_id and instance_name_lookup = l_instance_name;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
    update et_catalog_object_column_prop 
       set lookup_name = null
        ,  ind_lookup_import_check = null
    where lookup_name in (select distinct lookup_name from et_lookup where catalog_id_lookup = l_catalog_id and instance_name_lookup = l_instance_name);
 
    update et_catalog_object_column_prop 
       set lookup_name_extended = null
        ,  columnname_extended_lookup = null
        ,  ind_use_extendend = null
    where lookup_name_extended in (select distinct lookup_name from et_lookup where catalog_id_lookup = l_catalog_id and instance_name_lookup = l_instance_name);
  
	delete from et_lookup where catalog_id = l_catalog_id and instance_name_lookup = l_instance_name;
       
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link');
select count(*) into l_count from et_table_link 
 where (catalog_id_master = l_catalog_id and instance_name_master = l_instance_name) 
    OR (catalog_id_detail = l_catalog_id and instance_name_detail = l_instance_name); 
    
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has_or_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then 

       delete from et_table_link 
	   where (catalog_id_master = l_catalog_id and instance_name_master = l_instance_name) 
       OR (catalog_id_detail = l_catalog_id and instance_name_detail = l_instance_name); 
    
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link_detail');
select count(*) into l_count from et_table_link_detail where catalog_id_master = l_catalog_id and instance_name_master = l_instance_name; 
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then 

       delete from et_table_link_detail where catalog_id_master = l_catalog_id and instance_name_master = l_instance_name;   
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_access');
select count(*) into l_count from et_catalog_object_access where catalog_id = l_catalog_id and instance_name = l_instance_name;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_assigned, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then 

       delete from et_catalog_object_access where catalog_id = l_catalog_id and instance_name = l_instance_name;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_parameter_set');
select count(*) into l_count from et_transaction_parameter_set where param_name = 'selected_instance' and param_value = l_cataloginstance;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then 

       delete from et_transaction_parameter_set where param_name = 'selected_instance' and param_value = l_cataloginstance;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;    
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_user_parameter');
select count(*) into l_count from et_user_parameter where param_filter_01 = l_config_id OR param_value = l_cataloginstance;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then 

       delete from et_user_parameter where param_filter_01 = l_config_id OR param_value = l_cataloginstance;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;        
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_format_object');
select count(*) into l_count from et_format_object where catalog_id = l_catalog_id and instance_name = l_instance_name;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then 

       delete from et_format_object where catalog_id = l_catalog_id and instance_name = l_instance_name;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_format_object_column');
select count(*) into l_count from et_format_object_column where catalog_id = l_catalog_id and instance_name = l_instance_name;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);

    if l_ind_cmdsyp_kill then 

       delete from et_format_object_column where catalog_id = l_catalog_id and instance_name = l_instance_name;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_ObjectInstance: begin
if not l_ind_cmdsyp_abandon then leave abandon_ObjectInstance; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_catalog_object_instance
 set ind_active = 0, 
     description = l_description
where catalog_id = l_catalog_id
  and instance_name = l_instance_name;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_ObjectInstance;

revive_ObjectInstance: begin
if not l_ind_cmdsyp_revive then leave revive_ObjectInstance; end if;

update et_catalog_object_instance
 set ind_active = 1, 
     description = l_description_aswas
where catalog_id = l_catalog_id
  and instance_name = l_instance_name;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_ObjectInstance;

kill_ObjectInstance: begin
if not l_ind_cmdsyp_kill then leave kill_ObjectInstance; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_instance');
delete from et_catalog_object_instance
where catalog_id = l_catalog_id
  and instance_name = l_instance_name
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_ObjectInstance;

end check_ObjectInstance;

-- 
-- user 
-- 
check_User: begin

if not l_ind_handle_user then leave check_User; end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_User; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_user');
set l_object_checked = mdLookup_SysMDObjectDescription('et_user');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_user
where username = l_username2;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_User;
end if;

-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_User;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_User;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_User;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_user_parameter');
select count(*) into l_count from et_user_parameter where username = l_username2;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_user_parameter where username = l_username2;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

set l_object_checked = mdLookup_SysMDObjectDescription('et_callable_access');
select count(*) into l_count from et_callable_access where usergroupname = l_username2;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_callable_access where usergroupname = l_username2;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_transaction_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_access');
select count(*) into l_count from et_transaction_access where usergroupname = l_username2;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_transaction_access where usergroupname = l_username2;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_catalog_object_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_access');
select count(*) into l_count from et_catalog_object_access where usergroupname = l_username2;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_catalog_object_access where usergroupname = l_username2;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_user_group_member
set l_object_checked = mdLookup_SysMDObjectDescription('et_user_group_member');
select count(*) into l_count from et_user_group_member where username = l_username2;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_user_group_member where username = l_username2;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_user_group
set l_object_checked = mdLookup_SysMDObjectDescription('et_user_group');
select count(*) into l_count from et_user_group where usergroupname = l_username2;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_user_group where usergroupname = l_username2;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_User: begin
if not l_ind_cmdsyp_abandon then leave abandon_User; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_user
 set ind_active = 0, 
     description = l_description
where username = l_username2;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_User;

revive_User: begin
if not l_ind_cmdsyp_revive then leave revive_User; end if;

update et_user
 set ind_active = 1, 
     description = l_description_aswas
where username = l_username2;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_User;

kill_User: begin
if not l_ind_cmdsyp_kill then leave kill_User; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_user');
delete from et_user
where username = l_username2
  and ind_active = 0;
if row_count() > 0 then

    delete from et_user_comm_area where username = l_username2;
    delete from etx_user_config where username = l_username2;
    
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_User;

end check_User;

--
-- user group
--

check_Usergroup: begin

if not l_ind_handle_usergroup then leave check_Usergroup; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Usergroup; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_user_group');
set l_object_checked = mdLookup_SysMDObjectDescription('et_user_group');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_user_group
where usergroupname = l_usergroupname;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Usergroup;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Usergroup;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Usergroup;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Usergroup;
end if;

-- et_catalog_object_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_callable_access');
select count(*) into l_count from et_callable_access where usergroupname = l_usergroupname;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_callable_access where usergroupname = l_usergroupname;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_transaction_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_access');
select count(*) into l_count from et_transaction_access where usergroupname = l_usergroupname;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_transaction_access where usergroupname = l_usergroupname;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_catalog_object_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_access');
select count(*) into l_count from et_catalog_object_access where usergroupname = l_usergroupname;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_catalog_object_access where usergroupname = l_usergroupname;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_user_group_member
set l_object_checked = mdLookup_SysMDObjectDescription('et_user_group_member');
select count(*) into l_count from et_user_group_member where usergroupname = l_usergroupname;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_user_group_member where usergroupname = l_usergroupname;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;


abandon_Usergroup: begin
if not l_ind_cmdsyp_abandon then leave abandon_Usergroup; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_user_group
 set ind_active = 0, 
     description = l_description
where usergroupname = l_usergroupname;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end abandon_Usergroup;

revive_Usergroup: begin
if not l_ind_cmdsyp_revive then leave revive_Usergroup; end if;

update et_user_group
 set ind_active = 1, 
     description = l_description_aswas
where usergroupname = l_usergroupname;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Usergroup;

kill_Usergroup: begin
if not l_ind_cmdsyp_kill then leave kill_Usergroup; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_user_group');
delete from et_user_group
where usergroupname = l_usergroupname
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_Usergroup;

end check_Usergroup;

--            --
-- constraint --
--            --
check_Constraint: begin

if not l_ind_handle_constraint then leave check_Constraint; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Constraint; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_constraint');
set l_object_checked = mdLookup_SysMDObjectDescription('et_constraint');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_constraint
where constraint_name = l_constraint_name;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Constraint;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Constraint;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Constraint;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Constraint;
end if;

-- et_catalog_object_column_prop
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_column_prop');
select count(*) into l_count from et_catalog_object_column_prop where constraint_name = l_constraint_name;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_catalog_object_column_prop 
          set constraint_name = null
           ,  ind_constraint_import_check = null
       where constraint_name = l_constraint_name;
   
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_Constraint: begin
if not l_ind_cmdsyp_abandon then leave abandon_Constraint; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_constraint
 set ind_active = 0, 
     description = l_description
where constraint_name = l_constraint_name;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_Constraint;

revive_Constraint: begin
if not l_ind_cmdsyp_revive then leave revive_Constraint; end if;

update et_constraint
 set ind_active = 1, 
     description = l_description_aswas
where constraint_name = l_constraint_name;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Constraint;

kill_Constraint: begin
if not l_ind_cmdsyp_kill then leave kill_Constraint; end if;

-- check again if to delete;
delete from et_constraint
where constraint_name = l_constraint_name
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_description, null, null);
end if; 

end kill_Constraint;

end check_Constraint;

--            --
-- lookup --
--            --
check_Lookup: begin

if not l_ind_handle_lookup then leave check_Lookup; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Lookup; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_lookup');
set l_object_checked = mdLookup_SysMDObjectDescription('et_lookup');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_lookup
where lookup_name = l_lookup_name;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Lookup;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Lookup;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Lookup;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Lookup;
end if;

-- et_catalog_object_column_prop
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_column_prop');
select count(*) into l_count from et_catalog_object_column_prop where lookup_name = l_lookup_name or lookup_name_extended = l_lookup_name;
if l_count > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_catalog_object_column_prop 
          set lookup_name = null
           ,  ind_lookup_import_check = null
       where lookup_name = l_lookup_name;

       update et_catalog_object_column_prop 
          set lookup_name_extended = null
		   ,  column_name_extended_lookup = null
           ,  ind_lookup_import_check = null
       where lookup_name_extended = l_lookup_name;
  
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_Lookup: begin
if not l_ind_cmdsyp_abandon then leave abandon_Lookup; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_lookup
 set ind_active = 0, 
     description = l_description
where lookup_name = l_lookup_name;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_Lookup;

revive_Lookup: begin
if not l_ind_cmdsyp_revive then leave revive_Lookup; end if;

update et_lookup
 set ind_active = 1, 
     description = l_description_aswas
where lookup_name = l_lookup_name;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Lookup;

kill_Lookup: begin
if not l_ind_cmdsyp_kill then leave kill_Lookup; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_lookup');
delete from et_lookup
where lookup_name = l_lookup_name
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_Lookup;

end check_Lookup;

--            --
-- callable --
--            --
check_Callable: begin

if not l_ind_handle_callable then leave check_Callable; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Callable; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_callable_object');
set l_object_checked = mdLookup_SysMDObjectDescription('et_callable_object');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_callable_object
where callable_object = l_callable_object;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Callable;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Callable;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Callable;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Callable;
end if;

-- et_logging
set l_object_checked = mdLookup_SysMDObjectDescription('et_logging');
select count(*) into l_count from et_logging where callable_object = l_callable_object;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_logging 
          set callable_object = null
       where callable_object = l_callable_object;
  
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;


-- et_catalog_object_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_callable_object_access');
select count(*) into l_count from et_callable_object_access where callable_object = l_callable_object;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_callable_object_access where callable_object = l_callable_object;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_catalog_object_callable
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_callable');
select count(*) into l_count from et_catalog_object_callable where callable_object = l_callable_object;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_catalog_object_callable where callable_object = l_callable_object;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_callable_seq
set l_object_checked = mdLookup_SysMDObjectDescription('et_callable_seq');
select count(*) into l_count from et_callable_seq where callable_object = l_callable_object or callable_object_seq_member = l_callable_object;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_callable_seq where callable_object = l_callable_object or callable_object_seq_member = l_callable_object;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_Callable: begin
if not l_ind_cmdsyp_abandon then leave abandon_Callable; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_callable_object
 set ind_active = 0, 
     description = l_description
where callable_object = l_callable_object;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_Callable;

revive_Callable: begin
if not l_ind_cmdsyp_revive then leave revive_Callable; end if;

update et_callable_object
 set ind_active = 1, 
     description = l_description_aswas
where callable_object = l_callable_object;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Callable;

kill_Callable: begin
if not l_ind_cmdsyp_kill then leave kill_Callable; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_callable_object');
delete from et_callable_object
where callable_object = l_callable_object
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_Callable;

end check_Callable;

--            --
-- transaction --
--            --
check_Transaction: begin

if not l_ind_handle_transaction then leave check_Transaction; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Transaction; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_transaction');
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_transaction
where transaction_code = l_transaction_code;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Transaction;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Transaction;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Transaction;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Transaction;
end if;

-- et_transaction_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_access');
select count(*) into l_count from et_transaction_access where transaction_code = l_transaction_code;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       delete from et_transaction_access where transaction_code = transaction_code;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;


-- et_transaction_menu
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_menu');
select count(*) into l_count from et_transaction_menu where transaction_code = l_transaction_code;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       delete from et_transaction_menu where transaction_code = l_transaction_code;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

-- et_transaction_parameter_set
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_parameter_set');
select count(*) into l_count from et_transaction_parameter_set where transaction_code = l_transaction_code;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
 	   delete from et_transaction_parameter_set where transaction_code = l_transaction_code;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_Transaction: begin
if not l_ind_cmdsyp_abandon then leave abandon_Transaction; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_transaction
 set ind_active = 0, 
     description = l_description
where transaction_code = l_transaction_code;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_Transaction;

revive_Transaction: begin
if not l_ind_cmdsyp_revive then leave revive_Transaction; end if;

update et_transaction
 set ind_active = 1, 
     description = l_description_aswas
where transaction_code = l_transaction_code;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Transaction;

kill_Transaction: begin
if not l_ind_cmdsyp_kill then leave kill_Transaction; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction');
delete from et_transaction
where transaction_code = l_transaction_code
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_Transaction;

end check_Transaction;

--            --
-- menu --
--            --
check_Menu: begin

if not l_ind_handle_menu then leave check_Menu; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Menu; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_transaction_menu');
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_menu');

select 
  description
 ,ind_active
 into 
  l_description
 ,l_ind_active
 from et_transaction_menu
where menu_id = l_menu_id;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Menu;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Menu;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Menu;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null or l_ind_active <> 0) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Menu;
end if;

-- et_transaction_access
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_menu');
select count(*) into l_count from et_transaction_menu where menu_id_parent = l_menu_id;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       delete from et_transaction_menu where menu_id_parent = l_menu_id;
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;


abandon_Menu: begin
if not l_ind_cmdsyp_abandon then leave abandon_Menu; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_transaction_menu
 set ind_active = 0, 
     description = l_description
where transaction_code = l_transaction_code;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_Menu;

revive_Menu: begin
if not l_ind_cmdsyp_revive then leave revive_Menu; end if;

update et_transaction_menu
 set ind_active = 1, 
     description = l_description_aswas
where menu_id = l_menu_id;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Menu;

kill_Menu: begin
if not l_ind_cmdsyp_kill then leave kill_Menu; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_transaction_menu');
delete from et_transaction_menu
where menu_id = l_menu_id
  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_Menu;

end check_Menu;

--            --
-- link (master-detail/advanced filter/related tables --
--            --
check_Link: begin

if not l_ind_handle_link then leave check_Link; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_Link; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_table_link');
set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link');

select 
  description
-- ,ind_active
 into 
  l_description
-- ,l_ind_active
 from et_table_link
where catalog_id_master = l_catalog_id
  and instance_name_master = l_instance_name
  and logical_link = l_logical_link;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_Link;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description = coalesce(l_description,l_config_id);
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Link;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Link;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_Link;
end if;

-- et_table_link_detail
set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link_detail');
select count(*) into l_count from et_table_link_detail 
where catalog_id_master = l_catalog_id
  and instance_name_master = l_instance_name
  and logical_link = l_logical_link;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_has, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       delete from et_table_link_detail 
        where catalog_id_master = l_catalog_id
          and instance_name_master = l_instance_name
          and logical_link = l_logical_link;
          
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_Link: begin
if not l_ind_cmdsyp_abandon then leave abandon_Link; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_table_link
 set -- ind_active = 0, 
     description = l_description
where catalog_id_master = l_catalog_id
  and instance_name_master = l_instance_name
  and logical_link = l_logical_link;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_Link;

revive_Link: begin
if not l_ind_cmdsyp_revive then leave revive_Link; end if;

update et_table_link
 set -- ind_active = 1, 
     description = l_description_aswas
where catalog_id_master = l_catalog_id
  and instance_name_master = l_instance_name
  and logical_link = l_logical_link;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_Link;

kill_Link: begin
if not l_ind_cmdsyp_kill then leave kill_Link; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_table_link');
delete from et_table_link
where catalog_id_master = l_catalog_id
  and instance_name_master = l_instance_name
  and logical_link = l_logical_link;
--  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_Link;

end check_Link;

--
--            --
-- LogicalDom --
--            --
check_LogicalDom: begin

if not l_ind_handle_logicaldom then leave check_LogicalDom; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_LogicalDom; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_format_domain_logical');
set l_object_checked = mdLookup_SysMDObjectDescription('et_format_domain_logical');

select 
  description
 -- ,ind_active
 into 
  l_description
 -- ,l_ind_active
 from et_format_domain_logical
where domain_id_logical = l_domain_id_logical;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_LogicalDom;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_LogicalDom;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_LogicalDom;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_LogicalDom;
end if;

-- et_catalog_object_column_prop
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_column_prop');
select count(*) into l_count from et_catalog_object_column_prop where domain_id_logical = l_domain_id_logical;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_catalog_object_column_prop 
          set domain_id_logical = null
       where domain_id_logical = l_domain_id_logical;
   
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_LogicalDom: begin
if not l_ind_cmdsyp_abandon then leave abandon_LogicalDom; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_format_domain_logical
 set -- ind_active = 0, 
     description = l_description
where domain_id_logical = l_domain_id_logical;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_LogicalDom;

revive_LogicalDom: begin
if not l_ind_cmdsyp_revive then leave revive_LogicalDom; end if;

update et_format_domain_logical
 set -- ind_active = 1, 
     description = l_description_aswas
where domain_id_logical = l_domain_id_logical;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_LogicalDom;

kill_LogicalDom: begin
if not l_ind_cmdsyp_kill then leave kill_LogicalDom; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_format_domain_logical');
delete from et_format_domain_logical
where domain_id_logical = l_domain_id_logical;
--  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_LogicalDom;

end check_LogicalDom;

--            --
-- PhysicalDom --
--            --
check_PhysicalDom: begin

if not l_ind_handle_physicaldom then leave check_PhysicalDom; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_PhysicalDom; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_format_domain_physical');
set l_object_checked = mdLookup_SysMDObjectDescription('et_format_domain_physical');

select 
  description
 -- ,ind_active
 into 
  l_description
 -- ,l_ind_active
 from et_format_domain_physical
where domain_id_physical = l_domain_id_physical;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_PhysicalDom;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_PhysicalDom;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_PhysicalDom;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_PhysicalDom;
end if;

-- et_catalog_object_column_prop
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_column_prop');
select count(*) into l_count from et_catalog_object_column_prop where domain_id_physical = l_domain_id_physical;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_catalog_object_column_prop 
          set domain_id_physical = null
       where domain_id_physical = l_domain_id_physical;
   
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_PhysicalDom: begin
if not l_ind_cmdsyp_abandon then leave abandon_PhysicalDom; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_format_domain_physical
 set -- ind_active = 0, 
     description = l_description
where domain_id_physical = l_domain_id_physical;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_PhysicalDom;

revive_PhysicalDom: begin
if not l_ind_cmdsyp_revive then leave revive_PhysicalDom; end if;

update et_format_domain_physical
 set -- ind_active = 1, 
     description = l_description_aswas
where domain_id_physical = l_domain_id_physical;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_PhysicalDom;

kill_PhysicalDom: begin
if not l_ind_cmdsyp_kill then leave kill_PhysicalDom; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_format_domain_physical');
delete from et_format_domain_physical
where domain_id_physical = l_domain_id_physical;
--  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_PhysicalDom;

end check_PhysicalDom;

--            --
-- SemanticDom --
--            --
check_SemanticDom: begin

if not l_ind_handle_semanticdom then leave check_SemanticDom; end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_config_id);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;

if not l_ind_cmdsyp_check and 
  not l_ind_cmdsyp_abandon and
  not l_ind_cmdsyp_revive and  
  not l_ind_cmdsyp_kill then leave check_SemanticDom; end if;

set l_object_base = mdLookup_SysMDObjectDomainTitle('et_format_domain_semantic');
set l_object_checked = mdLookup_SysMDObjectDescription('et_format_domain_semantic');

select 
  description
 -- ,ind_active
 into 
  l_description
 -- ,l_ind_active
 from et_format_domain_semantic
where domain_id_semantic = l_domain_id_semantic;
if row_count() <> 1 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_found, l_object_base, l_config_id, l_object_checked, null, null);
    leave check_SemanticDom;
end if;

set l_logtext = concat(l_this_sp, sep, l_cmdsyp, sep, l_optsyp, sep, l_objabbrev, sep, l_usergroupname, sep, l_description);
if l_loglevel >= '0' then insert into etx_log (logtext) values(l_logtext); end if;


-- if it should be killed or revived - check if it is yet abandoned
if l_ind_cmdsyp_abandon or l_ind_cmdsyp_revive or l_ind_cmdsyp_kill then
-- returns null if l_description not surrounded with ABANDON()
   set l_description_aswas = mdInfo_OptionConfigValue(l_description,l_cmdsyp_abandon);
end if;

if l_ind_cmdsyp_abandon 
 and (l_description_aswas is not null) then   
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_SemanticDom;
end if;

if l_ind_cmdsyp_revive 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_SemanticDom;
end if;

if l_ind_cmdsyp_kill 
 and (l_description_aswas is null -- or l_ind_active <> 0
 ) then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_not_abandoned, l_object_base, l_config_id, l_description, null, null);
    leave check_SemanticDom;
end if;

-- et_catalog_object_column_prop
set l_object_checked = mdLookup_SysMDObjectDescription('et_catalog_object_column_prop');
select count(*) into l_count from et_catalog_object_column_prop where domain_id_semantic = l_domain_id_semantic;
if l_count > 0 then
    set l_total_count = l_total_count + l_count;
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_is_used, l_object_base, l_config_id, l_description, l_count, l_object_checked);
    
    if l_ind_cmdsyp_kill then
    
       update et_catalog_object_column_prop 
          set domain_id_semantic = null
       where domain_id_semantic = l_domain_id_semantic;
   
       call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
    end if;
end if;

abandon_SemanticDom: begin
if not l_ind_cmdsyp_abandon then leave abandon_SemanticDom; end if;

set l_description = concat(l_cmdsyp_abandon, '(', l_description, ')');

update et_format_domain_semantic
 set -- ind_active = 0, 
     description = l_description
where domain_id_semantic = l_domain_id_semantic;
if row_count() > 0 then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_abandoned, l_object_base, l_config_id, l_description, null, null);
end if;
 
end abandon_SemanticDom;

revive_SemanticlDom: begin
if not l_ind_cmdsyp_revive then leave revive_SemanticlDom; end if;

update et_format_domain_semantic
 set -- ind_active = 1, 
     description = l_description_aswas
where domain_id_semantic = l_domain_id_semanticl;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_revived, l_object_base, l_config_id, l_description, null, null);
end if; 
 
end revive_SemanticlDom;

kill_SemanticDom: begin
if not l_ind_cmdsyp_kill then leave kill_SemanticDom; end if;

-- check again if to delete;
set l_object_checked = mdLookup_SysMDObjectDescription('et_format_domain_semantic');
delete from et_format_domain_semantic
where domain_id_semantic = l_domain_id_semantic;
--  and ind_active = 0;
if row_count() > 0 then
    call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_deleted, l_object_base, l_config_id, l_object_checked, null, null);
end if; 

end kill_SemanticDom;

end check_SemanticDom;

if l_ind_cmdsyp_check then 
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_references, l_object_base, l_config_id, l_description, l_total_count, null); 
end if;


end main;

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   set l_message_text = concat(l_cmdsyp, l_allcmdsyp, l_optsyp, l_alloptsyp);

   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_sperr, l_this_sp, l_cmdsyp, l_allcmdsyp, l_optsyp, l_alloptsyp);
    
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
