DELIMITER $$
CREATE  PROCEDURE `mdConfig_MigrateSimple`(
  IN CMDSYP_I            nvarchar(16)             
 ,IN OPTSYP_I            nvarchar(128) 
 ,IN ID_I                nvarchar(100) 
 ,IN POSTER_LOG_I        nvarchar(128) 
)
-- drop procedure `mdConfig_MigrateSimple`
    DETERMINISTIC
this_sp: BEGIN
declare l_this_sp nvarchar(128) DEFAULT 'mdConfig_MigrateSimple';
declare l_ind_rollback bool default 0;
declare sep_mp varchar(01) DEFAULT ',';
declare l_msg_par_final nvarchar(4000) DEFAULT ' ';
declare l_message_text varchar(128) default ' ';

declare l_cmdsyp nvarchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_v15_2_v20 nvarchar(16) default 'V15_2_V20';
declare l_ind_cmdsyp_v15_2_v20 bit default 0;

declare l_optsyp nvarchar(128);
declare l_ind_optsyp bit default 0;

declare l_optsyp_connection nvarchar(16) default '[CONNECTION]';
declare l_ind_optsyp_connection bit default 0;

declare l_optsyp_catalog nvarchar(16) default '[CATALOG]';
declare l_ind_optsyp_catalog bit default 0;

declare l_optsyp_lookup nvarchar(16) default '[LOOKUP]';
declare l_ind_optsyp_lookup bit default 0;

declare l_optsyp_logging nvarchar(16) default '[LOGGING]';
declare l_ind_optsyp_logging bit default 0;

declare l_optsyp_constraint nvarchar(16) default '[CONSTRAINT]';
declare l_ind_optsyp_constraint bit default 0;

declare l_optsyp_callable nvarchar(16) default '[CALLABLE]';
declare l_ind_optsyp_callable bit default 0;

declare l_optsyp_user nvarchar(16) default '[USER]';
declare l_ind_optsyp_user bit default 0;

declare l_optsyp_usergroup nvarchar(16) default '[USERGROUP]';
declare l_ind_optsyp_usergroup bit default 0;

declare l_optsyp_groupmember nvarchar(16) default '[GROUPMEMBER]';
declare l_ind_optsyp_groupmember bit default 0;

declare l_optsyp_transaction nvarchar(16) default '[TRANSACTION]';
declare l_ind_optsyp_transaction bit default 0;

declare l_optsyp_menu nvarchar(16) default '[MENU]';
declare l_ind_optsyp_menu bit default 0;

declare l_alloptsyp nvarchar(512);
declare l_allcmdsyp nvarchar(512);

DECLARE l_id nvarchar(100);

declare l_rc_wu integer default 0;
declare l_end_of_cursor INTEGER DEFAULT 0;

declare l_catalog_id BIGINT;

declare l_conn_name nvarchar(16);
declare l_catalog_idc nvarchar(16);
declare l_lookup_name nvarchar(32);
declare l_constraint_name nvarchar(32);
declare l_callable_object nvarchar(32);
declare l_transaction_code nvarchar(16);
declare l_username nvarchar(16);
declare l_usergroupname nvarchar(32);
declare l_menu_idc nvarchar(16);
declare l_menu_id integer;

declare l_metadb_object nvarchar(128) DEFAULT '';
declare l_metadb_object_buggy nvarchar(128) DEFAULT '';
DECLARE l_cnt_metadb_object INT DEFAULT 0;

DECLARE l_poster_log nvarchar(128);

DECLARE CONTINUE HANDLER FOR 1062
  BEGIN
    set @duplicates = @duplicates + 1;
  END;

DECLARE CONTINUE HANDLER FOR SQLEXCEPTION 
begin
  GET DIAGNOSTICS @cno = NUMBER;
  GET DIAGNOSTICS CONDITION @cno l_rc_wu = MYSQL_ERRNO,
      @l_sqlstate = RETURNED_SQLSTATE, 
      @l_message_text = MESSAGE_TEXT;
   set l_ind_rollback = 1;
   SET l_metadb_object_buggy = l_metadb_object;
END;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_id = ID_I;
SET l_poster_log = COALESCE(nullif(POSTER_LOG_I, ''), l_this_sp);

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_v15_2_v20, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_v15_2_v20 = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_v15_2_v20; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_v15_2_v20); -- next

-- test the set options and switch on option indicators
if locate(l_optsyp_connection, l_optsyp, 1) > 0 then set l_ind_optsyp_connection = 1; end if; 
if locate(l_optsyp_catalog, l_optsyp, 1) > 0 then set l_ind_optsyp_catalog = 1; end if;
if locate(l_optsyp_lookup, l_optsyp, 1) > 0 then set l_ind_optsyp_lookup = 1; end if;
if locate(l_optsyp_logging, l_optsyp, 1) > 0 then set l_ind_optsyp_logging = 1; end if;
if locate(l_optsyp_constraint, l_optsyp, 1) > 0 then set l_ind_optsyp_constraint = 1; end if;
if locate(l_optsyp_callable, l_optsyp, 1) > 0 then set l_ind_optsyp_callable = 1; end if;
if locate(l_optsyp_user, l_optsyp, 1) > 0 then set l_ind_optsyp_user = 1; end if;
if locate(l_optsyp_usergroup, l_optsyp, 1) > 0 then set l_ind_optsyp_usergroup = 1; end if;
if locate(l_optsyp_groupmember, l_optsyp, 1) > 0 then set l_ind_optsyp_groupmember = 1; end if;
if locate(l_optsyp_transaction, l_optsyp, 1) > 0 then set l_ind_optsyp_transaction = 1; end if;
if locate(l_optsyp_menu, l_optsyp, 1) > 0 then set l_ind_optsyp_menu = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_connection | l_ind_optsyp_catalog | 
                   l_ind_optsyp_lookup | l_ind_optsyp_logging | l_ind_optsyp_constraint | 
                   l_ind_optsyp_callable | l_ind_optsyp_user | 
                   l_ind_optsyp_usergroup | l_ind_optsyp_groupmember | 
                   l_ind_optsyp_transaction | l_ind_optsyp_menu; -- | next;
                    
set l_alloptsyp = concat(l_optsyp_connection, sep_mp, 
                         l_optsyp_catalog, sep_mp, 
                         l_optsyp_lookup, sep_mp,
                         l_optsyp_logging, sep_mp, 
                         l_optsyp_constraint, sep_mp,
                         l_optsyp_callable, sep_mp,
                         l_optsyp_user, sep_mp,
                         l_optsyp_usergroup, sep_mp,
                         l_optsyp_groupmember, sep_mp,
                         l_optsyp_transaction, sep_mp,
                         l_optsyp_menu); -- next

-- INSERT INTO etx_log(poster_log, logtext) select l_poster_log, l_ind_cmdsyp;
-- INSERT INTO etx_log(poster_log, logtext) select l_poster_log, l_ind_optsyp;

main: begin
if coalesce(l_ind_cmdsyp,0) = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if coalesce(l_ind_optsyp,0) = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

set l_ind_rollback = 0;
START TRANSACTION;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, 'start transaction';


do_connection: BEGIN
if not l_ind_optsyp_connection then leave do_connection; end if;

SET l_conn_name = l_id;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_connection';
    
INSERT INTO et_connection
(
 `conn_name`,
 `description`,
 `conn_name_msg`,
 `conn_type`
)
SELECT 
 `conn_name`,
 `description`,
 `conn_name_msg`,
 `conn_type`
FROM niota_mdv15.et_connection srctbl
WHERE conn_name like l_conn_name
ON DUPLICATE KEY UPDATE  
  description = srctbl.description
, conn_name_msg = srctbl.conn_name_msg
, conn_type = srctbl.conn_type
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_connection;


do_logging: BEGIN
if not l_ind_optsyp_logging then leave do_logging; end if;

SET l_conn_name = l_id;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_logging';
    
INSERT INTO et_logging
(
 `conn_name`,
 `ind_active_logfile`,
 `ind_active_logdb`,
 `filename_log`,
 `callable_object`
)
SELECT 
 `conn_name`,
 `ind_active_logfile`,
 `ind_active_logdb`,
 `filename_log`,
 `callable_object`
FROM niota_mdv15.et_logging srctbl
WHERE conn_name like l_conn_name
ON DUPLICATE KEY UPDATE  
  ind_active_logfile = srctbl.ind_active_logfile
, ind_active_logdb = srctbl.ind_active_logdb
, filename_log = srctbl.filename_log
, callable_object = srctbl.callable_object
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_logging;


do_catalog: BEGIN
if not l_ind_optsyp_catalog then leave do_catalog; end if;

SET l_catalog_idc = l_id;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_catalog_object';

INSERT INTO et_catalog_object
(
  catalog_id
, conn_name
, object
, description
, date_activation
, ind_active
, objectcategory
, format_file_prefix
, username_owner
, usergroupname_deputy
, ind_cust_01
, ind_cust_02
, ind_cust_03
, ind_cust_04
, ind_cust_05
, ind_cust_06
, ind_cust_07
, ind_cust_08
, ind_cust_09
, ind_cust_10
)
SELECT 
  catalog_id
, conn_name
, object
, description
, date_activation
, ind_active
, objectcategory
, format_file_prefix
, username_owner
, usergroupname_deputy
, ind_cust_01
, ind_cust_02
, ind_cust_03
, ind_cust_04
, ind_cust_05
, ind_cust_06
, ind_cust_07
, ind_cust_08
, ind_cust_09
, ind_cust_10 
FROM niota_mdv15.et_catalog_object srctbl
WHERE convert(catalog_id, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE  
  conn_name = srctbl.conn_name
, object = srctbl.object
, description = srctbl.description
, date_activation = srctbl.date_activation
, ind_active = srctbl.ind_active
, objectcategory = srctbl.objectcategory
, format_file_prefix = srctbl.format_file_prefix
, username_owner = srctbl.username_owner
, usergroupname_deputy = srctbl.usergroupname_deputy
, ind_cust_01 = srctbl.ind_cust_01
, ind_cust_02 = srctbl.ind_cust_02
, ind_cust_03 = srctbl.ind_cust_03
, ind_cust_04 = srctbl.ind_cust_04
, ind_cust_05 = srctbl.ind_cust_05
, ind_cust_06 = srctbl.ind_cust_06
, ind_cust_07 = srctbl.ind_cust_07
, ind_cust_08 = srctbl.ind_cust_08
, ind_cust_09 = srctbl.ind_cust_09
, ind_cust_10 = srctbl.ind_cust_10
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_catalog_object_instance';

INSERT INTO et_catalog_object_instance
(
  catalog_id
, instance_name
, description
, ind_active
, projection_list
, ind_active_projection_list
, read_only_list
, ind_active_read_only_list
, objectfilter
, ind_active_objectfilter
, objectjoin
, ind_active_objectjoin
)
SELECT 
  catalog_id
, instance_name
, description
, ind_active
, projection_list
, ind_active_projection_list
, read_only_list
, ind_active_read_only_list
, objectfilter
, ind_active_objectfilter
, objectjoin
, ind_active_objectjoin
FROM niota_mdv15.et_catalog_object_instance srctbl
WHERE convert(catalog_id, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE

  description = srctbl.description
, ind_active = srctbl.ind_active
, projection_list = srctbl.projection_list
, ind_active_projection_list = srctbl.ind_active_projection_list
, read_only_list = srctbl.read_only_list
, ind_active_read_only_list = srctbl.ind_active_read_only_list
, objectfilter = srctbl.objectfilter
, ind_active_objectfilter = srctbl.ind_active_objectfilter
, objectjoin = srctbl.objectjoin
, ind_active_objectjoin = srctbl.ind_active_objectjoin
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

	  
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_catalog_object_callable';

INSERT INTO et_catalog_object_callable
(
  catalog_id
, callable_object
, description
, ind_active
, binding_level
)
SELECT 
  catalog_id
, callable_object
, description
, ind_active
, binding_level
FROM niota_mdv15.et_catalog_object_callable srctbl
WHERE convert(catalog_id, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, binding_level = srctbl.binding_level
;
if l_rc_wu <> 0 then leave main; END if;
	
INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_catalog_object_access';

INSERT INTO et_catalog_object_access
(
  usergroupname
, catalog_id
, instance_name
, ind_active
, ind_allow_ins
, ind_allow_upd
, ind_allow_del
, ind_allow_import
, ind_allow_export
, ind_hidden
)
SELECT 
  usergroupname
, catalog_id
, instance_name
, ind_active
, ind_allow_ins
, ind_allow_upd
, ind_allow_del
, ind_allow_import
, ind_allow_export
, ind_hidden
FROM niota_mdv15.et_catalog_object_access srctbl
WHERE convert(catalog_id, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE
  instance_name = srctbl.instance_name
, ind_active = srctbl.ind_active
, ind_allow_ins = srctbl.ind_allow_ins
, ind_allow_upd = srctbl.ind_allow_upd
, ind_allow_del = srctbl.ind_allow_del
, ind_allow_import = srctbl.ind_allow_import
, ind_allow_export = srctbl.ind_allow_export
, ind_hidden = srctbl.ind_hidden
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;
	
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_table_link';

INSERT INTO et_table_link
(
  catalog_id_master
, instance_name_master
, logical_link
, catalog_id_detail
, instance_name_detail
, linktype
, ind_logical_link_default
)
SELECT 
  catalog_id_master
, instance_name_master
, logical_link
, catalog_id_detail
, instance_name_detail
, linktype
, ind_logical_link_default
FROM niota_mdv15.et_table_link srctbl
WHERE convert(catalog_id_master, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE
  catalog_id_detail = srctbl.catalog_id_detail
, instance_name_detail = srctbl.instance_name_detail
, linktype = srctbl.linktype
, ind_logical_link_default = srctbl.ind_logical_link_default
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_table_link_detail';

INSERT INTO et_table_link_detail
(
  catalog_id_master
, instance_name_master
, logical_link
, column_name_master
, column_name_detail
, operation
, sortorder
)
SELECT 
  catalog_id_master
, instance_name_master
, logical_link
, column_name_master
, column_name_detail
, operation
, sortorder
FROM niota_mdv15.et_table_link_detail srctbl
WHERE convert(catalog_id_master, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE
  column_name_detail = srctbl.column_name_detail
, operation = srctbl.operation
, sortorder = srctbl.sortorder
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_lookup';

INSERT INTO et_lookup
(
  lookup_name
, description
, ind_active
, catalog_id_lookup
, instance_name_lookup
)
SELECT 
  lookup_name
, description
, ind_active
, catalog_id_lookup
, instance_name_lookup
FROM niota_mdv15.et_lookup srctbl
WHERE convert(catalog_id_lookup, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, catalog_id_lookup = srctbl.catalog_id_lookup
, instance_name_lookup = srctbl.instance_name_lookup
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;


SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_catalog_object_column_prop';

INSERT INTO et_catalog_object_column_prop
(
  catalog_id
, COLUMN_NAME
, description
, ind_active
, lookup_name
, ind_lookup_import_check
, `CONSTRAINT_NAME`
, ind_constraint_import_check
, ordinal_position_pkey
)	
SELECT 
  catalog_id
, `COLUMN_NAME`
, description
, ind_active
, lookup_name
, ind_lookup_import_check
, `CONSTRAINT_NAME`
, ind_constraint_import_check
, ordinal_position_pkey
FROM niota_mdv15.et_catalog_object_column_prop srctbl
WHERE convert(catalog_id, char) like l_catalog_idc
ON DUPLICATE KEY UPDATE

  description = srctbl.description
, ind_active = srctbl.ind_active
, lookup_name = srctbl.lookup_name
, ind_lookup_import_check = srctbl.ind_lookup_import_check
,`ind_lookup_import_check` = srctbl.ind_lookup_import_check
, ind_constraint_import_check = srctbl.ind_constraint_import_check
, ordinal_position_pkey = srctbl.ordinal_position_pkey
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;
			  
END do_catalog;



do_lookup: BEGIN
if not l_ind_optsyp_lookup then leave do_lookup; end if;

SET l_lookup_name = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_lookup';

INSERT INTO et_lookup
(
  lookup_name
, description
, ind_active
, catalog_id_lookup
, instance_name_lookup
)
SELECT 
  lookup_name
, description
, ind_active
, catalog_id_lookup
, instance_name_lookup
FROM niota_mdv15.et_lookup srctbl
WHERE lookup_name like l_lookup_name
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, catalog_id_lookup = srctbl.catalog_id_lookup
, instance_name_lookup = srctbl.instance_name_lookup
;

if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_lookup;


do_constraint: BEGIN
if not l_ind_optsyp_constraint then leave do_constraint; end if;

SET l_constraint_name = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_constraint';

INSERT INTO et_constraint
(
  `constraint_name`
 , description
 , ind_active
 , operand_1
 , operand_2
 , column_type
 , operation
)
SELECT
   `constraint_name`
 , description
 , ind_active
 , operand_1
 , operand_2
 , column_type
 , operation
FROM niota_mdv15.et_constraint srctbl
WHERE `constraint_name` like l_constraint_name	
ON DUPLICATE KEY UPDATE
   description = srctbl.description
 , ind_active = srctbl.ind_active
 , operand_1 = srctbl.operand_1
 , operand_2 = srctbl.operand_2
 , column_type = srctbl.column_type
 , operation = srctbl.operation
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_constraint;

do_callable: BEGIN
if not l_ind_optsyp_callable then leave do_callable; end if;

SET l_callable_object = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_callable_object';

INSERT INTO et_callable_object
(
  callable_object
, description
, ind_active
, callobject_type
, conn_name
, command
, callobject_category
, sortorder
, ind_messaging
, ind_reload_grid
, ind_seq
)
SELECT 
  callable_object
, description
, ind_active
, callobject_type
, conn_name
, command
, callobject_category
, sortorder
, ind_messaging
, ind_reload_grid
, ind_seq
FROM niota_mdv15.et_callable_object srctbl
WHERE callable_object like l_callable_object
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, callobject_type = srctbl.callobject_type
, conn_name = srctbl.conn_name
, command = srctbl.command
, callobject_category = srctbl.callobject_category
, sortorder = srctbl.sortorder
, ind_messaging = srctbl.ind_messaging
, ind_reload_grid = srctbl.ind_reload_grid
, ind_seq = srctbl.ind_seq
;

if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_callable_seq';

INSERT INTO et_callable_seq
(
  callable_object
, callable_object_seq_member
, sort_order
, ind_active
)
SELECT 
  callable_object
, callable_object_seq_member
, sort_order
, ind_active
FROM niota_mdv15.et_callable_seq srctbl
WHERE callable_object like l_callable_object
ON DUPLICATE KEY UPDATE
  sort_order = srctbl.sort_order
, ind_active = srctbl.ind_active
;

if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_callable_access';

INSERT INTO et_callable_access
(
   callable_object
 , usergroupname
 , ind_active
)
SELECT 
   callable_object
 , usergroupname
 , ind_active
FROM niota_mdv15.et_callable_access srctbl
WHERE callable_object like l_callable_object
ON DUPLICATE KEY UPDATE
   ind_active = srctbl.ind_active	
;

if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

	
END do_callable;

do_user: BEGIN
if not l_ind_optsyp_user then leave do_user; end if;

SET l_username = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_user';

INSERT INTO et_user
(
  username
, description
, ind_active
, `password`
, email
, firstname
, lastname
, phone
, ind_active_ldap
, username_ldap
, ind_is_admin
)
SELECT
  username
, description
, ind_active
, `password`
, email
, firstname
, lastname
, phone
, ind_active_ldap
, username_ldap
, ind_is_admin
FROM niota_mdv15.et_user srctbl
WHERE username like l_username
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
-- , `password`
, email = srctbl.email
, firstname = srctbl.firstname
, lastname = srctbl.lastname
, phone = srctbl.phone
, ind_active_ldap = srctbl.ind_active_ldap
, username_ldap = srctbl.username_ldap
, ind_is_admin = srctbl.ind_is_admin
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;


SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_usergroup (selfgroup)';

INSERT INTO et_user_group
(
  usergroupname
, description
, ind_active
, usergroup_type
)
SELECT 
  usergroupname
, description
, ind_active
, usergroup_type
FROM niota_mdv15.et_user_group srctbl
WHERE usergroupname like l_username
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, usergroup_type = srctbl.usergroup_type
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_user_parameter (delete)';

DELETE FROM et_user_parameter WHERE username LIKE l_username;
INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_metadb_object = 'et_user_parameter';

INSERT INTO et_user_parameter
(
  username
, param_name
, param_value
, param_filter_01
, param_filter_02
, param_filter_03
, param_filter_04
, param_filter_05
)
SELECT 
  username
, param_name
, param_value
, param_filter_01
, param_filter_02
, param_filter_03
, param_filter_04
, param_filter_05
FROM niota_mdv15.et_user_parameter srctbl
WHERE username LIKE l_username
ON DUPLICATE KEY UPDATE
  username = srctbl.username
, param_name = srctbl.param_name
, param_value = srctbl.param_value
, param_filter_01 = srctbl.param_filter_01
, param_filter_02 = srctbl.param_filter_02
, param_filter_03 = srctbl.param_filter_03
, param_filter_04 = srctbl.param_filter_04
, param_filter_04 = srctbl.param_filter_04
;

-- must not be migrated because panel names can change
delete from et_user_parameter 
WHERE username LIKE l_username
and param_name = 'admin_menu_state'
;

if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;
END do_user;

-- next
do_usergroup: BEGIN
if not l_ind_optsyp_usergroup then leave do_usergroup; end if;

SET l_usergroupname = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_usergroup';

INSERT INTO et_user_group
(
  usergroupname
, description
, ind_active
, usergroup_type
)
SELECT 
  usergroupname
, description
, ind_active
, usergroup_type
FROM niota_mdv15.et_user_group srctbl
WHERE usergroupname like l_usergroupname
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, usergroup_type = srctbl.usergroup_type
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_usergroup;

do_groupmember: BEGIN
if not l_ind_optsyp_groupmember then leave do_groupmember; end if;

SET l_usergroupname = l_id;
 

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_user_group_member';

INSERT INTO et_user_group_member
(
  usergroupname
, username
, description
, ind_active
)
SELECT 
  usergroupname
, username
, description
, ind_active
FROM niota_mdv15.et_user_group_member srctbl
WHERE usergroupname like l_usergroupname
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_groupmember;


-- next
do_transaction: BEGIN
if not l_ind_optsyp_transaction then leave do_transaction; end if;

SET l_transaction_code = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_transaction';

INSERT INTO et_transaction
(
  transaction_code
, description
, ind_active
, targetpage
, param_set
)
SELECT 
  transaction_code
, description
, ind_active
, targetpage
, param_set
FROM niota_mdv15.et_transaction srctbl
WHERE transaction_code like l_transaction_code
ON DUPLICATE KEY UPDATE
  description = srctbl.description
, ind_active = srctbl.ind_active
, targetpage = srctbl.targetpage
, param_set = srctbl.param_set
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_transaction_parameter_set';

INSERT INTO et_transaction_parameter_set
(
  transaction_code
, param_set
, param_name
, param_value
)
SELECT 
  transaction_code
, param_set
, param_name
, param_value
FROM niota_mdv15.et_transaction_parameter_set srctbl
WHERE transaction_code like l_transaction_code
ON DUPLICATE KEY UPDATE
  param_set = srctbl.param_set
, param_name = srctbl.param_name
, param_value = srctbl.param_value
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_transaction_access';

INSERT INTO et_transaction_access
(
  transaction_code
, usergroupname
, ind_active
)
SELECT 
  transaction_code
, usergroupname
, ind_active
FROM niota_mdv15.et_transaction_access srctbl
WHERE transaction_code like l_transaction_code
ON DUPLICATE KEY UPDATE
  ind_active = srctbl.ind_active
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;
	
END do_transaction;

-- next
do_menu: BEGIN
if not l_ind_optsyp_menu then leave do_menu; end if;

SET l_menu_idc = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_transaction_menu';

INSERT INTO et_transaction_menu
(
  menu_id
, transaction_code
, menu_label
, description
, ind_active
, menu_id_parent
, icon_menu
, sortorder
)
SELECT
  menu_id
, transaction_code
, menu_label
, description
, ind_active
, menu_id_parent
, icon_menu
, sortorder
FROM niota_mdv15.et_transaction_menu srctbl
WHERE convert(menu_id, char) like l_menu_idc
or menu_id in 
(select distinct menu_id_parent 
  from niota_mdv15.et_transaction_menu
  WHERE convert(menu_id, char) like l_menu_idc
)
ON DUPLICATE KEY UPDATE
  transaction_code = srctbl.transaction_code
, menu_label = srctbl.menu_label
, description = srctbl.description
, ind_active = srctbl.ind_active
, menu_id_parent = srctbl.menu_id_parent
, icon_menu = srctbl.icon_menu
, sortorder = srctbl.sortorder
;
if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

END do_menu;


-- commit or rollback this transaction
if l_ind_rollback then
   ROLLBACK;
   set l_ind_rollback = 0;
ELSE

   COMMIT;
END IF;

end main;

if l_cnt_metadb_object > 0 then
-- start the final update status transaction
   START TRANSACTION; 
	
	IF l_rc_wu = 0 THEN
       INSERT INTO etx_log(poster_log, logtext)
      select l_poster_log, 'commit transaction'; 
	ELSE
      INSERT INTO etx_log(poster_log, logtext)
      select l_poster_log, CONCAT('rollback transaction rc= ', CONVERT(l_rc_wu, CHAR), ' at ', l_metadb_object_buggy) ; 
	END IF; 
	
	COMMIT;
END if;

set autocommit = ON;

-- declare l_dynview varchar(512) default '';

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   INSERT INTO etx_log(poster_log, logtext) select l_poster_log, CONCAT('cancel ' , l_msg_par_final) ; 
   SET l_message_text = left(l_msg_par_final, 128);
   
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;
end$$
DELIMITER ;
