DELIMITER $$
CREATE PROCEDURE `mdConfig_SortOrder`(
  IN CMDSYP_I        varchar(16)  -- CoMmanD SYstem Procedure           
 ,IN OPTSYP_I        varchar(128) -- OPTion SYstem Procedure
 ,IN ID_I            varchar(32)  -- ID to handle                
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_SortOrder`
--
-- -- how to test --
-- call mdConfig_SortOrder('SETPRIO', 'CATALOG_ID', '16040');
--
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.06.30
-- 
-- set/change sort prio for given ID
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.06.30   fmrre    add comment and header
-- 2022.09.12	fmrre	 changed all nvar to var to avoid all warnings
-- 2022.09.16	fmrre	 remove schema qualfier
--
-- *******************************************************************************
--	

declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare l_this_sp varchar(128) default 'mdConfig_SortOrder';
declare l_msg_id_sperr integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_sperr varchar(4000) default ' ';
declare l_msg varchar(4000) default ' ';
declare l_logtext varchar(8192) default ' ';
declare l_optionsp varchar(256) default mdinfo_SysConfigOption(null,l_this_sp);
declare l_loglevel varchar(01) default mdInfo_OptionConfigValue(l_optionsp,'LOGLEVEL');

declare l_message_text varchar(128) DEFAULT ' ';
declare l_msg_id_insert_prio integer default 1071;
declare l_msg_id_update_prio integer default 1072;

declare l_appcode varchar(5) default mdinfo_SysConstant('APPCODE');
declare l_cfg_id_maxnbr varchar(32) default 'NBR_PRIORIZED_MD_ENTRIES';

declare l_cmdsyp varchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_setprio varchar(16) default 'SETPRIO';
declare l_ind_cmdsyp_setprio bit default 0;

-- all possible system options
declare l_optsyp_catalog varchar(16) default 'CATALOG_ID';
declare l_ind_optsyp_catalog bit default 0;

declare l_optsyp_withuca varchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_optsyp varchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);

-- internal strings (e.g. logging command and its options)
-- declare l_cmd_log varchar(16) default "LOG";
-- declare l_opt_cmdlog varchar(128) default "";

declare l_param_id integer;
declare l_username_param varchar(32) default mdinfo_SysConstant('USERGROUPNAME_ALLGROUP');
declare l_param_name varchar(256) default 'prioritized_md_entry';
declare l_param_value varchar(256) default ' ';
declare l_param_filter_01 varchar(128) default ' ';
declare l_param_filter_02 varchar(128) default ' ';

declare l_username varchar(16) default '';

declare l_id varchar(32);
declare l_nbr_setprio integer default 0;
declare l_max_setprio integer default 10;
declare l_nxt_setprio integer default 0;

declare l_ind_insertprio bit default 0;
declare l_ind_deleteprio bit default 0;
declare l_ind_updateprio bit default 0;

--
-- cursor columns
-- no cursor needed
--
  
set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
set l_ind_cmdsyp_setprio = nHelper_OptionCheckOnOff(l_cmdsyp_setprio, l_cmdsyp);

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_setprio; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_setprio); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
set l_ind_optsyp_catalog = nHelper_OptionCheckOnOff(l_optsyp_catalog, l_optsyp);
set l_ind_optsyp_withuca = nHelper_OptionCheckOnOff(l_optsyp_withuca, l_optsyp);

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_catalog | l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_catalog, sep_sp, l_optsyp_withuca); -- next

main: begin
if l_ind_cmdsyp = 0 then set l_msg_par_sperr = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_sperr = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
-- if l_ind_optsyp_withuca then set l_opt_cmdlog = l_optsyp_withuca; end if;

-- INSERT INTO etx_log(poster_log, logtext) select l_optsyp, l_optsyp_withuca;
-- retrieve the web-userid from the WITHUCA-String WITHUCA(username)
set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca), substring(current_user(),1,16));
-- INSERT INTO etx_log(poster_log, logtext) select 'l_username', l_username;
 
set l_id = id_i;
set l_max_setprio = mdInfo_SysConfigValue(l_appcode, l_cfg_id_maxnbr);
 
setprio: begin
if not l_ind_cmdsyp_setprio then leave setprio; end if;

-- use option - string for param-filter 
if l_ind_optsyp_catalog then
   set l_param_filter_01 = l_optsyp_catalog;
end if;

select 
   count(*)
into 
   l_nbr_setprio
from et_user_parameter
where username = l_username_param 
 and param_name = l_param_name
 and param_filter_01 = l_param_filter_01;

-- INSERT INTO etx_log(poster_log, logtext) select 'nbr_setprio:', l_nbr_setprio;
-- INSERT INTO etx_log(poster_log, logtext) select 'max_setprio:', l_max_setprio;

-- insert a record
if l_nbr_setprio < l_max_setprio then
   set l_nxt_setprio = l_nbr_setprio + 1;
   set l_ind_insertprio = 1;
end if;

-- delete all settings greater then max
if l_nbr_setprio > l_max_setprio then
   delete 
   from et_user_parameter
   where username = l_username_param 
    and param_name = l_param_name
    and param_filter_01 = l_param_filter_01
    and param_filter_02 > lpad((l_max_setprio),2,'0');
   set l_ind_updateprio = 1; 
--   INSERT INTO etx_log(poster_log, logtext) select 'nbr_setprio:', l_nbr_setprio;
end if;

if l_nbr_setprio = l_max_setprio then
   set l_ind_updateprio = 1; 
end if;

insert_prio: BEGIN
if not l_ind_insertprio then leave insert_prio; end if;

set l_param_value = lpad((l_max_setprio - l_nbr_setprio),2,'0');
set l_param_filter_02 = lpad((l_nxt_setprio),2,'0'); 

-- INSERT INTO etx_log(poster_log, logtext) select l_username_param, concat(l_param_name, l_param_filter_01, l_param_filter_02, l_id);
-- INSERT INTO etx_log(poster_log, logtext) select l_poster_log, l_ind_optsyp;

insert into et_user_parameter 
(username, param_name, param_value, param_filter_01, param_filter_02, param_filter_03, param_filter_04, param_filter_05)
values 
(l_username_param, l_param_name, l_param_value, l_param_filter_01, l_param_filter_02, l_id, current_timestamp, null);

END insert_prio;

update_prio: BEGIN
if not l_ind_updateprio then leave update_prio; end if;

-- read the oldest entry (by time)
select 
  param_id
 into
  l_param_id  
from et_user_parameter
where username = l_username_param
  and param_name = l_param_name
  and param_filter_01 = l_param_filter_01
order by param_filter_04, param_value desc 
limit 1;

-- set new value to oldest value (using ID) set sort number to 1
update et_user_parameter
 set 
  param_value = '01',
  param_filter_03 = l_id,
  param_filter_04 = current_timestamp
where param_id = l_param_id;

END update_prio;


reorder_prio: BEGIN
  UPDATE et_user_parameter,
        (
        SELECT
          param_id, username, param_name, param_value, param_filter_03, param_filter_04, 
          ROW_NUMBER() OVER(PARTITION BY param_name ORDER BY param_filter_04 desc) AS new_order
        FROM et_user_parameter
        where param_name = l_param_name)
        as reorderd
   SET et_user_parameter.param_value = LPAD(reorderd.new_order, 2, 0)
   WHERE et_user_parameter.param_id = reorderd.param_id;
END reorder_prio;

if l_ind_insertprio then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_insert_prio, l_id, l_param_filter_01, null, null, null);
end if;

if l_ind_updateprio then
   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_update_prio, l_id, l_param_filter_01, null, null, null);
end if;

end setprio;
end main;
 
--  call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   set l_message_text = concat(l_cmdsyp, l_allcmdsyp, l_optsyp, l_alloptsyp);

   call mdLog_SessionMessage(null, null, l_username, l_this_sp, l_msg_id_sperr, l_this_sp, l_cmdsyp, l_allcmdsyp, l_optsyp, l_alloptsyp);

   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
