DELIMITER $$
CREATE PROCEDURE `mdConfig_TemplateApply`(
  IN CMDSYP_I            nvarchar(16)             
 ,IN OPTSYP_I            nvarchar(128) 
 ,IN ID_I                nvarchar(100) 
 ,IN POSTER_LOG_I        nvarchar(128) 
)
-- drop procedure if exists `mdConfig_TemplateApply`
-- grant execute on mdConfig_TemplateApply to 'niota'@'%'; 
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.04.01
-- 
-- apply some templates to config tables
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
--
-- *******************************************************************************
--	
    DETERMINISTIC
this_sp: BEGIN
declare l_this_sp nvarchar(128) DEFAULT 'mdConfig_TemplateApply';
declare l_ind_rollback bool default 0;
declare sep_mp varchar(01) DEFAULT ',';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final nvarchar(4000) DEFAULT ' ';
declare l_message_text varchar(128) default ' ';

declare l_cmdsyp nvarchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_apply nvarchar(16) default 'APPLY';
declare l_ind_cmdsyp_apply bit default 0;

declare l_optsyp nvarchar(128);
declare l_ind_optsyp bit default 0;

declare l_optsyp_callable nvarchar(16) default '[CALLABLE]';
declare l_ind_optsyp_callable bit default 0;

declare l_optsyp_gridlayout nvarchar(16) default '[GRIDLAYOUT]';
declare l_ind_optsyp_gridlayout bit default 0;

declare l_optsyp_withuca nvarchar(16) DEFAULT '[WITHUCA]';
declare l_ind_optsyp_withuca bit DEFAULT 1;

declare l_alloptsyp nvarchar(512);
declare l_allcmdsyp nvarchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) DEFAULT "[WITHUCA]";
declare l_username nvarchar(16);

DECLARE l_id nvarchar(100);

declare l_rc_wu integer default 0;
declare l_end_of_cursor INTEGER DEFAULT 0;

declare l_catalog_id BIGINT;

declare l_catalog_idc nvarchar(16);
DECLARE l_param_filter_01 nvarchar(128);

declare l_metadb_object nvarchar(128) DEFAULT '';
declare l_metadb_object_buggy nvarchar(128) DEFAULT '';
DECLARE l_cnt_metadb_object INT DEFAULT 0;

DECLARE l_poster_log nvarchar(128);
DECLARE l_cfg_id_template_callable nvarchar(32) DEFAULT 'template_callable';
DECLARE l_usergroupname_allgroup nvarchar(16) DEFAULT mdinfo_SysConstant('USERGROUPNAME_ALLGROUP');


DECLARE CONTINUE HANDLER FOR 1062
  BEGIN
    set @duplicates = @duplicates + 1;
  END;

DECLARE CONTINUE HANDLER FOR SQLEXCEPTION 
begin
  GET DIAGNOSTICS @cno = NUMBER;
  GET DIAGNOSTICS CONDITION @cno l_rc_wu = MYSQL_ERRNO,
      @l_sqlstate = RETURNED_SQLSTATE, 
      @l_message_text = MESSAGE_TEXT;
   set l_ind_rollback = 1;
   SET l_metadb_object_buggy = l_metadb_object;
END;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_id = ID_I;
SET l_poster_log = l_this_sp;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_apply, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_apply = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_apply;
set l_allcmdsyp = concat(l_cmdsyp_apply); -- next

-- test the set options and switch on option indicators
if locate(l_optsyp_callable, l_optsyp, 1) > 0 then set l_ind_optsyp_callable = 1; end if;
if locate(l_optsyp_gridlayout, l_optsyp, 1) > 0 then set l_ind_optsyp_gridlayout = 1; end if;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_callable | l_ind_optsyp_gridlayout; -- | next;
                    
set l_alloptsyp = concat(l_optsyp_callable, sep_mp, l_optsyp_gridlayout); -- next

-- INSERT INTO etx_log(poster_log, logtext) select l_poster_log, l_ind_cmdsyp;
-- INSERT INTO etx_log(poster_log, logtext) select l_poster_log, l_ind_optsyp;

main: begin
if coalesce(l_ind_cmdsyp,0) = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if coalesce(l_ind_optsyp,0) = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca), substring(current_user(),1,16));


set l_ind_rollback = 0;
START TRANSACTION;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, 'start transaction';

do_callable: BEGIN
if not l_ind_optsyp_callable then leave do_callable; end if;

SET l_catalog_idc = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_catalog_object_callable';

-- DELETE FROM et_catalog_object_callable where catalog_id = 20130;
  
 INSERT INTO et_catalog_object_callable
 (
  catalog_id, 
  callable_object, 
  description, 
  ind_active, 
  binding_level
 ) 
 SELECT 
  cob.catalog_id,
  coc.callable_object,
  MAX(coc.description) AS description,
  MAX(coc.ind_active) AS ind_active,
  MAX(coc.binding_level) AS binding_level
-- start from the main catalog  
 FROM et_catalog_object cob 
-- join to extended config setting  
JOIN  etx_catalog_object_config cfg
  ON cfg.cfg_id = l_cfg_id_template_callable
 AND upper(cfg.cfg_value) IN (UPPER('true'), UPPER('on'), UPPER('1')) 
-- join to the assigned callable objects for template 
JOIN et_catalog_object_callable coc
  ON coc.catalog_id = cfg.catalog_id

WHERE convert(cob.catalog_id, CHAR) = l_catalog_idc
GROUP BY cob.catalog_id, coc.callable_object
ON DUPLICATE KEY UPDATE
   description = VALUES(description)
  ,ind_active = VALUES(ind_active)
  ,binding_level = VALUES(binding_level)
;  
if l_rc_wu <> 0 then leave main; END if;  


INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;


SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_callable_access';


-- INSERT INTO et_callable_access


if l_rc_wu <> 0 then leave main; END if;

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

set l_msg_id_final = 1067;
set l_msg_par_final = concat(l_cfg_id_template_callable, sep_mp, l_catalog_idc);
	
END do_callable;


do_gridlayout: BEGIN
if not l_ind_optsyp_gridlayout then leave do_gridlayout; end if;

SET l_param_filter_01 = l_id;
 
SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_user_parameter (delete)';


DELETE 
FROM et_user_parameter
WHERE username = l_usergroupname_allgroup
 AND param_filter_01 = l_param_filter_01;
if l_rc_wu <> 0 then leave main; END if;  

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

SET l_cnt_metadb_object = l_cnt_metadb_object + 1;
SET l_metadb_object = 'et_user_parameter';

INSERT INTO et_user_parameter
(
 username, 
 param_name, 
 param_value, 
 param_filter_01, 
 param_filter_02, 
 param_filter_03, 
 param_filter_04, 
 param_filter_05
)
SELECT
 l_usergroupname_allgroup, 
 param_name, 
 param_value, 
 param_filter_01, 
 param_filter_02, 
 param_filter_03, 
 param_filter_04, 
 param_filter_05 
FROM et_user_parameter
WHERE param_filter_01 = l_param_filter_01
AND username = l_username;

if l_rc_wu <> 0 then leave main; END if;  

INSERT INTO etx_log(poster_log, logtext) select l_poster_log, concat(trim(l_this_sp), ' ', l_metadb_object, ' ', TRIM(ID_I)) ;

set l_msg_id_final = 1068;
set l_msg_par_final = concat(l_param_filter_01, sep_mp, l_username, sep_mp, l_usergroupname_allgroup);
	
END do_gridlayout;


-- commit or rollback this transaction
if l_ind_rollback then
   ROLLBACK;
   set l_ind_rollback = 0;
ELSE

   COMMIT;
END IF;

end main;


if l_cnt_metadb_object > 0 then
-- start the final update status transaction
   START TRANSACTION; 
	
	IF l_rc_wu = 0 THEN
       INSERT INTO etx_log(poster_log, logtext)
      select l_poster_log, 'commit transaction'; 
	ELSE
      INSERT INTO etx_log(poster_log, logtext)
      select l_poster_log, CONCAT('rollback transaction rc= ', CONVERT(l_rc_wu, CHAR), ' at ', l_metadb_object) ; 
	END IF; 
	
	COMMIT;
END if;

set autocommit = ON;

-- declare l_dynview varchar(512) default '';

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   INSERT INTO etx_log(poster_log, logtext) select l_poster_log, CONCAT('cancel ' , l_msg_par_final) ; 
   SET l_message_text = left(l_msg_par_final, 128);
   
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

   
call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);


end$$
DELIMITER ;
