DELIMITER $$
CREATE PROCEDURE `mdConfig_User`(
  IN CMDSYP_I            varchar(16)  -- CoMmanD SYstem Procedure           
 ,IN OPTSYP_I            varchar(128) -- OPTion SYstem Procedure
 ,IN USERNAME_I          varchar(16)  -- username
 ,IN DESCRIPTION_I       varchar(128)  -- description 
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_User`
-- call mdConfig_User('DROP', 'USER', '8EA8A696', null);
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2022.12.22
-- 
-- remove a user from the system
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2022.12.22	fmrre	 changed all nvar to var to avoid all warnings
-- *******************************************************************************
--	

declare rownumber bigint default 0;
declare rownumber_c varchar(10);
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare l_this_sp varchar(128) default 'mdConfig_User';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare l_cmdsyp varchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_drop varchar(16) default 'DROP';
declare l_ind_cmdsyp_drop bit default 0;

-- all possible system options
declare l_optsyp_withuca varchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_optsyp varchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_username varchar(16) default current_user();
declare l_description varchar(128);
declare l_ind_active bit default 1;

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_username = USERNAME_I;
set l_description = coalesce(DESCRIPTION_I,l_this_sp);

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_drop, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_drop = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_drop; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_drop); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_withuca); -- next

main: begin
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

drop_user: begin
if not l_ind_cmdsyp_drop then leave drop_user; end if;

delete from et_user_parameter where username = l_username;
delete from et_user_group_member where username = l_username;
delete from et_user_group where usergroupname = l_username;
delete from et_user where username = l_username;

set l_msg_id_final = 1000;
set l_message_text = 'dropped successfully';

end drop_user;
  
end main;

call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
