DELIMITER $$
CREATE  PROCEDURE `mdConfig_UserCommArea`(
  IN CMDSYP_I        varchar(16)  -- CoMmanD SYstem Procedure           
 ,IN OPTSYP_I        varchar(128) -- OPTion SYstem Procedure
 ,IN USERNAME_I      varchar(16)  -- username
 ,IN APPCODE_I       varchar(5)   -- application code
 ,IN ID_SESSION_I    varchar(32)  -- session id 
 ,IN GUID_MSG_I      varchar(32)  -- message guid
 ,IN LANG_I          varchar(2)   -- language
 ,IN UCA_I           varchar(512)  -- user communication area
) 
this_sp: BEGIN
-- drop procedure if exists `mdConfig_UserCommArea`
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.12
-- 
-- set user communication area entry
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.04   fmrre    add comment and header
-- 2021.11.03	nmz		 mysql 8.0 compatiblity - adding ` around reserved word: row_number
-- 2022.09.12	fmrre	 changed all nvar to var to avoid all warnings
-- *******************************************************************************
--	

declare loop_max bigint default 1000;
declare loop_max_c varchar(10);

declare `row_number` bigint default 0;
declare row_number_c varchar(10);
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare l_this_sp varchar(128) default 'mdConfig_UserCommArea';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

declare l_cmdsyp varchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_setuca varchar(16) default 'SETUCA';
declare l_ind_cmdsyp_setuca bit default 0;

-- all possible system options
declare l_optsyp_withdefault varchar(16) default 'WITHDEFAULT';
declare l_ind_optsyp_withdefault bit default 0;

declare l_optsyp varchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_username varchar(16) default current_user();
declare l_appcode varchar(5);
declare l_id_session varchar(32);
declare l_guid_msg varchar(32);
declare l_lang varchar(2);
declare l_uca varchar(512);

set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;
set l_username = USERNAME_I;
set l_appcode = APPCODE_I;
set l_id_session = ID_SESSION_I;
set l_guid_msg = GUID_MSG_I;
set l_lang = LANG_I;
set l_UCA = UCA_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_setuca, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_setuca = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_setuca; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_setuca); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_optsyp_withdefault, l_optsyp, 1) > 0 then set l_ind_optsyp_withdefault = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_withdefault; -- | next;
set l_alloptsyp = concat(l_optsyp_withdefault); -- next

main: begin
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
if l_ind_optsyp_withdefault then
 if l_username is null or l_username <= '' then set l_username = current_user(); end if;
 if l_appcode is null or l_appcode <= '' then set l_appcode = mdinfo_SysConstant('APPCODE'); end if; 
 if l_id_session is null or l_id_session <= '' then set l_id_session = current_user(); end if;
 if l_guid_msg is null or l_guid_msg <= '' then set l_guid_msg = current_user(); end if;
 if l_lang is null or l_lang <= '' then set l_lang = mdinfo_SysConstant('LANG'); end if;
 if l_uca is null or l_uca <= '' then set l_uca = convert(current_timestamp(), char); end if; 
end if;

insert into et_user_comm_area (username, appcode, id_session, guid_msg, lang, uca) 
 values (l_username, l_appcode, l_id_session, l_guid_msg, l_lang, l_uca)
  on duplicate key update 
    appcode = values(appcode)
  , id_session = values(id_session)
  , guid_msg = values(guid_msg)
  , lang = values(lang)
  , uca = values(uca)
  ;
  
end main;

call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
