DELIMITER $$
CREATE PROCEDURE `mdLog_SessionMessageText`(
	IN `CMDSYP_I`      varchar(16)            -- procedure command 
,	IN `OPTSYP_I`      varchar(128)           -- procedure option
,	IN `USERNAME_I`    varchar(56)            -- username UI
,	IN `POSTER_I`      varchar(128)           -- issuing stored procedure
,	IN `MSG_ID_I`      integer                -- message ID
,	IN `TEXT_MSG_I`    varchar(4000)          -- message 
)
this_sp: BEGIN
-- DROP PROCEDURE if exists mdLog_SessionMessageText
-- grant execute on mdLog_SessionMessage to 'niota'@'%'; 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2023.03.26
-- 
-- log a user message into the extended message table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2019.10.17   rre    add comments
-- 2022.09.12	fmrre	 changed all nvar to var to avoid all warnings
--
-- *******************************************************************************
--	
declare l_this_sp varchar(32) default 'mdLog_SessionMessageText';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final varchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';

-- all possible system commands
declare l_CMDSYP_LOG varchar(16) default 'LOG';
declare l_IND_CMDSYP_LOG bit default 1;

declare l_CMDSYP varchar(16);
declare l_IND_CMDSYP bit default 0;

-- all possible system options
declare l_OPTSYP_WITHUCA varchar(20) default 'WITHUCA';
declare l_IND_OPTSYP_WITHUCA bit default 1;

declare l_OPTSYP varchar(256);
declare l_IND_OPTSYP bit default 0;

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);
-- end of OPTSYPions

declare l_msg_id integer;
declare l_id_session varchar(32) default null;
declare l_guid_msg varchar(32) default null;
declare l_type_msg varchar(3);
declare l_text_msg varchar(4000);
declare l_username varchar(16);
declare l_poster varchar(128);
declare l_ind_stop_msg smallint;

declare l_infotype_session varchar(16) default 'ID_SESSION';
declare l_infotype_guid varchar(16) default 'GUID_MSG';

-- initialize missing input parameter
set l_CMDSYP = coalesce(CMDSYP_I,l_CMDSYP_LOG);
set l_OPTSYP = coalesce(OPTSYP_I,l_OPTSYP_WITHUCA);
set l_username = LEFT(USERNAME_I,16);
set l_poster = POSTER_I;
set l_msg_id = MSG_ID_I;
set l_text_msg = TEXT_MSG_I;


-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_CMDSYP_LOG, l_CMDSYP, 1) > 0 then set l_IND_CMDSYP_LOG = 1;  end if;

-- check if at least one command is valid
set l_IND_CMDSYP = l_IND_CMDSYP_LOG; -- | next;

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_OPTSYP_WITHUCA, l_OPTSYP, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_withuca); -- next

main: BEGIN
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

if l_username <= '' or l_username is null then SET l_username = LEFT(SYSTEM_USER(),16); end if;   
if l_poster <= '' or l_poster is null then set l_poster = l_this_sp; end if;

set l_id_session = mdInfo_UserCommArea(l_infotype_session,l_username);   
set l_guid_msg = mdInfo_UserCommArea(l_infotype_guid,l_username);
set l_ind_stop_msg = mdInfo_SysMessageStop(l_msg_id);
set l_type_msg = mdInfo_SysMessageType(l_msg_id);

insert into etx_message 
 (id_session, guid_msg, type_msg, text_msg, username, poster_be, username_be ,ind_stop_msg
 )
values
 (l_id_session, l_guid_msg, l_type_msg, l_text_msg, l_username, l_poster, left(user(),16), l_ind_stop_msg
); 

END main;

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;
end$$
DELIMITER ;
