DELIMITER $$
CREATE PROCEDURE `mdLog_TestMessage`(
	IN `CMDSYP_I`      varchar(16)            -- ui procedure command 
,	IN `OPTSYP_I`      varchar(128)           -- ui procedure option
,	IN `USERNAME_I`    varchar(16)            -- username UI
,	IN `ID_SESSION_I`  varchar(32)            -- session ID
,   IN `GUID_MSG_I`    varchar(32)            -- guid message
,	IN `TEXT_MSG_I`    varchar(2000)          -- message to log
)
this_sp: BEGIN
-- DROP PROCEDURE if exists mdLog_TestMessage
-- grant execute on mdLog_TestMessage to 'niota'@'%'; 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2019.07.01
-- 
-- log a user message into the extended message table
-- and return the first 128 chars to caller for abort message
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2019.10.17   rre     add comments
-- 2021.11.03	nmz		remove DEFINER... part
-- 2022.09.12	fmrre	 changed all nvar to var to avoid all warnings
--
-- *******************************************************************************
--	
declare THIS_SP varchar(32) default 'mdLog_TestMessage';

-- all possible system commands
declare l_CMDSYP_LOG varchar(16) default 'LOG';
declare l_IND_CMDSYP_LOG bit default 0;

declare l_CMDSYP varchar(16);
declare l_IND_CMDSYP bit default 0;

-- all possible system options
declare l_OPTSYP varchar(256);
declare l_IND_OPTSYP bit default 0;
-- end of OPTSYPions

declare l_username varchar(16);
declare l_id_session varchar(32);
declare l_guid_msg varchar(32);
declare l_text_msg varchar(2000);

-- initialize missing input parameter
set l_CMDSYP = CMDSYP_I;
set l_OPTSYP = OPTSYP_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_CMDSYP_LOG, l_CMDSYP, 1) > 0 then set l_IND_CMDSYP_LOG = 1;  end if;

-- check if at least one command is valid
set l_IND_CMDSYP = l_IND_CMDSYP_LOG; -- | next;

-- check if at least one option is valid
set l_IND_OPTSYP = 1;

main: BEGIN
 
if l_IND_CMDSYP = 0 then leave main; end if;
if l_IND_OPTSYP = 0 then leave main; end if;

set l_username = USERNAME_I;
set l_id_session = ID_SESSION_I;
set l_guid_msg = GUID_MSG_I;
set l_text_msg = TEXT_MSG_I;

if l_IND_CMDSYP_LOG then
set l_text_msg = rtrim(l_text_msg); -- + ' | ' + MSGTYP_C +' | '+ MSG_ID_C ;
insert into etx_message 
 (id_session, guid_msg,
  type_msg, text_msg, username, poster_be, username_be ,ind_stop_msg 
 )
values
 (l_id_session, l_guid_msg,
  'INF', l_text_msg, left(l_username, 16), THIS_SP, left(user(), 16), 0    
  ); 
end if;

leave this_sp;
END main;


if l_IND_CMDSYP = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'unvalid system command';
end if;

if l_IND_OPTSYP = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'unvalid system option';
end if;

ERROR_SYSP: begin
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'undefined end of procedure';
END ERROR_SYSP;
  

end$$
DELIMITER ;
