

DELIMITER $$
CREATE  PROCEDURE `mdLog_UserAction`(
	IN `CMDSYP_I`        varchar(16)       -- procedure command 
,	IN `OPTSYP_I`        varchar(128)      -- procedure option
,	IN `CATALOG_ID_I`    INTEGER 	          -- catalog id to log
,	IN `INSTANCE_NAME_I` varchar(16)       -- instance to log
,	IN `USERNAME_I`      varchar(16)       -- username to log
,	IN `ACTION_I`        varchar(20)       -- action to log
,	IN `COMMAND_I`       varchar(4000)     -- command string to log
)
-- DROP PROCEDURE if exists mdLog_UserAction 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2019.07.01
-- 
-- log a user message into the extended message table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2019.10.17   fmrre    add comments
-- 2021.11.03	nmz		 remove DEFINER... part
-- 2022.09.12	fmrre	 changed all nvar to var to avoid all warnings
--
-- **************************************************
this_sp: BEGIN

declare THIS_SP varchar(32) default 'mdLog_UserAction';
declare l_ind_rollback bool default 0;
declare sep_mp varchar(01) DEFAULT ',';
declare l_msg_par_final varchar(4000) DEFAULT ' ';
declare l_message_text varchar(128) default ' ';

-- all possible system commands
declare l_CMDSYP_LOG varchar(16) default 'LOG';
declare l_IND_CMDSYP_LOG bit default 0;

declare l_CMDSYP varchar(16);
declare l_IND_CMDSYP bit default 0;


-- all possible system options
declare l_OPTSYP_WITHUCA varchar(20) default 'WITHUCA';
declare l_IND_OPTSYP_WITHUCA bit default 0;

declare l_OPTSYP_SESSION varchar(20) DEFAULT '[SESSION]';
declare l_IND_OPTSYP_SESSION bit default 0;

declare l_OPTSYP_DB_NAME varchar(20) DEFAULT '[DB_NAME]';
declare l_ind_optsyp_db_name bit default 0;

declare l_OPTSYP_OBJECT varchar(20) DEFAULT '[OBJECT]';
declare l_IND_OPTSYP_OBJECT bit default 0;

declare l_OPTSYP varchar(256);
declare l_IND_OPTSYP bit default 0;
-- end of OPTSYPions

declare l_alloptsyp varchar(512);
declare l_allcmdsyp varchar(512);

DECLARE l_id_session varchar(32);
DECLARE l_id_session_default varchar(32) DEFAULT 'NOSESSION';

DECLARE l_object varchar(128);
DECLARE l_object_default varchar(128) DEFAULT 'READCATALOG';

DECLARE l_db_name varchar(128);
DECLARE l_db_name_default varchar(128) DEFAULT 'READCATALOG';



declare l_CATALOG_ID integer;
declare l_INSTANCE_NAME varchar(16);

declare l_USERNAME varchar(16);
DECLARE l_ACTION varchar(20);
declare l_COMMAND varchar(4000);

-- initialize missing input parameter
set l_CMDSYP = CMDSYP_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_log, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_log = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_log; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_log); -- next


set l_OPTSYP = OPTSYP_I;

if locate(l_optsyp_session, l_optsyp, 1) > 0 then set l_ind_optsyp_session = 1; end if; 
if locate(l_optsyp_object, l_optsyp, 1) > 0 then set l_ind_optsyp_object = 1; end if;
if locate(l_optsyp_db_name, l_optsyp, 1) > 0 then set l_ind_optsyp_db_name = 1; end if;


-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_session | l_ind_optsyp_object | l_ind_optsyp_db_name; -- | next;
                    
set l_alloptsyp = concat(l_optsyp_session, sep_mp, 
                         l_optsyp_object, sep_mp, 
                         l_optsyp_object); -- next
                    

main: begin
if coalesce(l_ind_cmdsyp,0) = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if coalesce(l_ind_optsyp,0) = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;


-- set session id from option string or from default
if l_ind_optsyp_session then 
   set l_id_session = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_session), l_id_session_default);
ELSE
   set l_id_session = l_id_session_default; 
END if;

-- set object id from option string or from default
if l_ind_optsyp_object then 
   set l_object = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_object), l_object_default);
ELSE
   set l_object = l_object_default; 
END if;

-- set dbname from option string or from default
if l_ind_optsyp_db_name then 
   set l_db_name = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_db_name), l_db_name_default);
ELSE
   set l_db_name = l_db_name_default; 
END if;



set l_catalog_id = catalog_id_I;
set l_instance_name = instance_name_I;
SET l_username = username_I;
set l_action = action_I;
set l_command = command_I;

if l_object = l_object_default 
or l_db_name = l_db_name_default then
   select
        object,
        conn_name
        INTO 
        l_object,
        l_db_name
   FROM et_catalog_object
   WHERE catalog_id = l_catalog_id;
   
   if row_count() <> 1 then
      set l_object = 'NOTFOUND';
      set l_db_name = 'NOTFOUND';
   end if;   
END if;



insert into etx_useraction 
   (`id_session`, `db_name`, `object`, `catalog_id`, `instance_name`, `action`, `username`, `command`)
values
   (l_id_session, l_db_name, l_object, l_catalog_id, l_instance_name, l_action, l_username, l_command);

end main;


set autocommit = ON;

-- declare l_dynview varchar(512) default '';

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SET l_message_text = left(l_msg_par_final, 128);
   
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

END$$
DELIMITER ;

