DELIMITER $$
CREATE PROCEDURE `mdLog_UserMessage`(
	IN `CMDSYP_I`      varchar(16)            -- ui procedure command 
,	IN `OPTSYP_I`      varchar(128)           -- ui procedure option
,	IN `USERNAME_I`    varchar(56)            -- username UI
,	IN `POSTER_I`      varchar(128)           -- issuing stored procedure
,	IN `MSG_ID_I`      INTEGER                 -- message ID
,	IN `MSG_PAR_I`     varchar(4000)          -- message Parameter
,	OUT `MSG_O`        varchar(128)           -- message Parameter
)
this_sp: BEGIN
-- DROP PROCEDURE if exists mdLog_UserMessage
-- grant execute on mdLog_UserMessage to 'niota'@'%'; 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2019.07.01
-- 
-- log a user message into the extended message table
-- and return the first 128 chars to caller for abort message
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2019.10.17   rre    add comments
-- 2022.09.12	fmrre	 changed all nvar to var to avoid all warnings
--
-- *******************************************************************************
--	
declare THIS_SP varchar(32) default 'mdLog_UserMessage';

declare MSG_ID_C varchar(5);
declare MSGTYP_C varchar(3);
declare CS       varchar(1) default ' ';
declare MSGTXT_C varchar(3000);
declare MSGTS_C  varchar(26);

declare ERRMSG varchar(4000);
declare ERRNUM int;

-- all possible system commands
declare l_CMDSYP_LOG varchar(16) default 'LOG';
declare l_IND_CMDSYP_LOG bit default 0;

declare l_CMDSYP_GET varchar(16) default 'GET';
declare l_IND_CMDSYP_GET bit default 0;

declare l_CMDSYP varchar(16);
declare l_IND_CMDSYP bit default 0;

-- all possible system options
declare l_OPTSYP_WITHUCA varchar(20) default 'WITHUCA';
declare l_IND_OPTSYP_WITHUCA bit default 0;

declare l_OPTSYP varchar(256);
declare l_IND_OPTSYP bit default 0;
-- end of OPTSYPions

declare l_username varchar(16);
declare l_poster varchar(128);
declare l_msg_id integer;
declare l_msg_par varchar(4000);

declare l_appcode varchar(5) default mdinfo_SysConstant('appcode');
declare l_id_session varchar(32) default 'ID_SESSION';
declare l_guid_msg varchar(32) default 'GUID_MSG';
declare l_lang varchar(2) default 'en';

declare l_TEXT_MSG varchar(2000);
declare l_IND_STOP_MSG int default 0;

declare PARSEP varchar(1) default mdinfo_SysConstant('SEP_MSGPAR');
declare PARMARKER_LEFT varchar(1) default '{';
declare PARMARKER_RIGHT varchar(1) default '}';
declare PARREPL varchar(3) default '';
declare LOOPCNT integer;

declare MSG_PAR varchar(256);
declare MSG_PAR_WRK varchar(4000);

declare charlen_par int;

declare charpos_name_start int;
declare charlen_name int;

declare charpos_value_start int;
declare charpos_value_end int;
declare charlen_value int;

declare MSG_P1 varchar(256) default '';       -- message parameter 1
declare MSG_P2 varchar(256) default '';       -- message parameter 2
declare MSG_P3 varchar(256) default '';       -- message parameter 3
declare MSG_P4 varchar(256) default '';       -- message parameter 4
declare MSG_P5 varchar(256) default '';       -- message parameter 5
declare MSG_P6 varchar(256) default '';       -- message parameter 6
declare MSG_P7 varchar(256) default '';       -- message parameter 7
declare MSG_P8 varchar(256) default '';       -- message parameter 8
declare MSG_P9 varchar(256) default '';       -- message parameter 9

-- initialize missing input parameter
set l_CMDSYP = CMDSYP_I;
set l_OPTSYP = OPTSYP_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_CMDSYP_LOG, l_CMDSYP, 1) > 0 then set l_IND_CMDSYP_LOG = 1;  end if;
if locate(l_CMDSYP_GET, l_CMDSYP, 1) > 0 then set l_IND_CMDSYP_GET = 1;  end if;

-- check if at least one command is valid
set l_IND_CMDSYP = l_IND_CMDSYP_LOG | l_IND_CMDSYP_GET; -- | next;

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_OPTSYP_WITHUCA, l_OPTSYP, 1) > 0 then 
   set l_IND_OPTSYP_WITHUCA = 1; 
end if;

-- check if at least one option is valid
if l_OPTSYP <> '' then
   set l_IND_OPTSYP =  l_IND_OPTSYP_withuca; -- | next;
else
   set l_IND_OPTSYP = 1;
end if;
-- if IND_OPTSYP = 0 goto UNVALIDOPT;

main: BEGIN
 
if l_IND_CMDSYP = 0 then leave main; end if;
if l_IND_OPTSYP = 0 then leave main; end if;

if USERNAME_I <= '' then
   SET l_username = LEFT(SYSTEM_USER(),16);   
else   
   set l_username = LEFT(USERNAME_I,16);
end if;

if POSTER_I <= '' then
   set l_poster = THIS_SP;
else 
   set l_poster = POSTER_I;   
end if;

-- split the message parameter by delimiter

set l_msg_id = MSG_ID_I;
set l_msg_par = MSG_PAR_I;

set MSG_ID_C = LPAD(l_msg_id, 5, 0);

if l_msg_id < 1 then
   set MSG_ID_C = cast(l_msg_id as character(5));
else 
   set MSG_ID_C = LPAD(l_msg_id, 5, 0);
end if;

-- set MSGTS_C = cast(CURRENT_TIMESTAMP()  as character(26));
if l_IND_OPTSYP_WITHUCA then

   set l_appcode = mdInfo_UserCommArea('APPCODE', l_username);
   set l_id_session = mdInfo_UserCommArea('SESSION_ID', l_username);
   set l_guid_msg = mdInfo_UserCommArea('MSG_GUID', l_username);
   
end if;


select  text_msg, type_msg
   into l_text_msg, msgtyp_c 
 from etx_message_text
where appcode_msg = l_appcode
  and lang_msg = l_lang
  and msg_id = l_msg_id;

do_replace: BEGIN
if FOUND_ROWS( ) = 0 then
   set l_TEXT_MSG = concat('unknown message ', l_appcode,  ' ', l_lang, ' ', cast(l_msg_id as character(10)), ' ', rtrim(l_msg_par));
   leave do_replace;
end if; 

set l_IND_STOP_MSG =
    case
	when upper(MSGTYP_C) = 'ERR' then 1	
	else 0 end;

set charpos_value_start = 1;
set charpos_value_end = 1;

set MSG_PAR_WRK = l_msg_par;

set LOOPCNT = -1;


do_loop: WHILE 1 = 1 DO
  
set LOOPCNT = LOOPCNT + 1;
if LOOPCNT > 8 then
   leave do_loop;
end if;

set MSG_PAR = '';
 
set charpos_value_start = 1;

-- patindex vs. locate
--
set charpos_value_end = locate(PARSEP, MSG_PAR_WRK);
-- 

-- select charpos_value_end;

if charpos_value_end = 0 then
   set charpos_value_end = length(MSG_PAR_WRK) + 1;
end if;

set charlen_value = charpos_value_end - charpos_value_start;
if charlen_value <= 0 then
  leave do_loop; 
end if;

if charpos_value_end > charpos_value_start then
   set MSG_PAR = ltrim(rtrim(SUBSTRING(MSG_PAR_WRK, charpos_value_start, charlen_value)));
end if;

set PARREPL = concat(PARMARKER_LEFT, cast(LOOPCNT as character(1)), PARMARKER_RIGHT);

if MSG_PAR <> '' then set l_text_msg = replace(l_text_msg,PARREPL,MSG_PAR); end if; 
if MSG_PAR <> '' and LOOPCNT = 0 then set MSG_P1 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 1 then set MSG_P2 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 2 then set MSG_P3 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 3 then set MSG_P4 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 4 then set MSG_P5 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 5 then set MSG_P6 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 6 then set MSG_P7 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 7 then set MSG_P8 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 8 then set MSG_P9 = MSG_PAR; end if; 

set charlen_par = length(MSG_PAR_WRK) - charpos_value_end + 1;
set MSG_PAR_WRK = ltrim(SUBSTRING(MSG_PAR_WRK, charpos_value_end + 1,charlen_par) );

END WHILE; -- do_loop

END do_replace;

-- select 'abc'; 


if l_IND_CMDSYP_LOG then
set l_text_msg = rtrim(l_text_msg); -- + ' | ' + MSGTYP_C +' | '+ MSG_ID_C ;
insert into etx_message 
 (id_session, guid_msg,
  type_msg, text_msg, username, poster_be, username_be ,ind_stop_msg 
 ,par_msg_1 ,par_msg_2 ,par_msg_3 ,par_msg_4 ,par_msg_5 ,par_msg_6 ,par_msg_7 ,par_msg_8 ,par_msg_9
 )
values
 (l_id_session, l_guid_msg,
  MSGTYP_C, l_text_msg, l_USERNAME, l_POSTER, left(user(),16), l_IND_STOP_MSG    
 ,MSG_P1, MSG_P2, MSG_P3, MSG_P4, MSG_P5, MSG_P6, MSG_P7, MSG_P8, MSG_P9
  ); 
end if;

set MSG_O = concat(l_appcode, ' ', MSGTYP_C, ' ', msg_id_c, ' ', substring(rtrim(l_text_msg), 1 ,110)); -- + ' | ' + MSGTYP_C +' | '+ MSG_ID_C ;

leave this_sp;
END main;


if l_IND_CMDSYP = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'unvalid system command';
end if;

if l_IND_OPTSYP = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'unvalid system option';
end if;

ERROR_SYSP: begin
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'undefined end of procedure';
END ERROR_SYSP;
  

end$$
DELIMITER ;
