
DELIMITER $$
CREATE  PROCEDURE `ui_log_message`(
	IN `CMDUIP_I` nvarchar(128)                -- ui procedure command 
,	IN `OPTUIP_I` nvarchar(128)                -- ui procedure option
,	IN `GUID_MSG_UI_I` nvarchar(32)            -- message GUID/call from UI 
,	IN `ID_SESSION_UI_I` nvarchar(32)          -- UI session ID
,	IN `USERNAME_UI_I` nvarchar(20)            -- username UI
,	IN `POSTER_BE_I` nvarchar(128)             -- issuing stored procedure
,	IN `MSG_ID_I` INTEGER                      -- message ID
,	IN `MSG_PAR_I` nvarchar(4000)              -- message Parameter

)
sp: BEGIN
-- DROP PROCEDURE if exists ui_log_message 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2019.07.01
-- 
-- log a user message into the extended message table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2019.10.17   fmrre    add comments
-- 2021.11.03	nmz		 remove DEFINER... part
--
-- *******************************************************************************
--	
declare THIS_SP nvarchar(32) default 'ui_log_message';

declare MSG_ID_C nvarchar(5);
declare MSGTYP_C nvarchar(3);
declare CS       nvarchar(1) default ' ';
declare MSGTXT_C nvarchar(3000);
declare MSGTS_C  nvarchar(26);

declare ERRMSG nvarchar(4000);
declare ERRNUM int;

-- all possible system commands
declare CMDUIP_DEFAULT nvarchar(20) default '*HELP';
declare IND_CMDUIP_DEFAULT bit default 0;

declare CMDUIP_LOG nvarchar(20) default '*LOG';
declare IND_CMDUIP_RUN bit default 0;

declare CMDUIP nvarchar(20);
declare IND_CMDUIP bit default 0;
declare CMDUIP_PAR nvarchar(20)  default '*NONE';

-- all possible system options
declare OPTUIP_DEFAULT nvarchar(20) default '*NONE';
declare IND_OPTUIP_DEFAULT bit default 0;

declare OPTUIP_SETLANG nvarchar(20) default '*SETLANG';
declare IND_OPTUIP_SETLANG bit default 0;

declare OPTUIP_SETAPPCODE nvarchar(20) default '*SETAPPCODE';
declare IND_OPTUIP_SETAPPCODE bit default 0;

declare OPTUIP_NONE nvarchar(20) default '*NONE';
declare IND_OPTUIP_NONE bit default 0;

declare OPTUIP nvarchar(256);
declare IND_OPTUIP bit default 0;
-- end of OPTUIPions

declare APPCODE nvarchar(5) default 'NIOTA';
declare LANG nvarchar(2) default 'DE';

declare l_TEXT_MSG nvarchar(2000);
declare l_IND_STOP_MSG int default 0;

declare PARSEP nvarchar(1) default ',';
declare PARMARKER_LEFT nvarchar(1) default '{';
declare PARMARKER_RIGHT nvarchar(1) default '}';
declare PARREPL nvarchar(3) default '';
declare LOOPCNT integer;

declare MSG_PAR nvarchar(256);
declare MSG_PAR_WRK nvarchar(4000);

declare charlen_par int;

declare charpos_name_start int;
declare charlen_name int;

declare charpos_value_start int;
declare charpos_value_end int;
declare charlen_value int;

declare MSG_P1 nvarchar(256) default '';       -- message parameter 1
declare MSG_P2 nvarchar(256) default '';       -- message parameter 2
declare MSG_P3 nvarchar(256) default '';       -- message parameter 3
declare MSG_P4 nvarchar(256) default '';       -- message parameter 4
declare MSG_P5 nvarchar(256) default '';       -- message parameter 5
declare MSG_P6 nvarchar(256) default '';       -- message parameter 6
declare MSG_P7 nvarchar(256) default '';       -- message parameter 7
declare MSG_P8 nvarchar(256) default '';       -- message parameter 8
declare MSG_P9 nvarchar(256) default '';       -- message parameter 9

-- initialize missing input parameter
if CMDUIP_I is null or CMDUIP_I = '' then
 set CMDUIP_I = CMDUIP_DEFAULT;
end if;


if OPTUIP_I is null or OPTUIP_I = '' then
 set OPTUIP_I = OPTUIP_DEFAULT;
 end if;

set CMDUIP = CMDUIP_I;
set OPTUIP = OPTUIP_I;

-- reset if there is a parameter-split
if locate('.', CMDUIP_I, 1 ) > 1 then
   set CMDUIP     = substring(CMDUIP_I,1,locate('.', CMDUIP_I, 1) -1);
   set CMDUIP_PAR = substring(CMDUIP_I,locate('.', CMDUIP_I, 1) +1, length(CMDUIP_I) );
end if;


-- set indicators for syscommand to true if the string is found in den CMDUIP-Parameter;
if locate(CMDUIP_DEFAULT, CMDUIP, 1) > 0 then
   set IND_CMDUIP_DEFAULT = 1; 
end if;
if locate(CMDUIP_LOG, CMDUIP, 1) > 0 then
   set IND_CMDUIP_RUN = 1;
 end if;

-- check if at least one command is valid
set IND_CMDUIP = IND_CMDUIP_DEFAULT | IND_CMDUIP_RUN; -- | next;

if locate(OPTUIP_DEFAULT, OPTUIP, 1) > 0 then
  set IND_OPTUIP_DEFAULT = 1;
end if;


if locate(OPTUIP_SETLANG, OPTUIP, 1) > 0 then 
   set IND_OPTUIP_SETLANG = 1; 
   set charpos_value_start = locate(OPTUIP_SETLANG, OPTUIP, 1) + length(rtrim(OPTUIP_SETLANG)) + 1;
   set LANG = substring(OPTUIP, charpos_value_start, 2); 
end if;


if locate(OPTUIP_SETAPPCODE, OPTUIP, 1) > 0 then 
   set IND_OPTUIP_SETAPPCODE = 1;
   set charpos_value_start = locate(OPTUIP_SETAPPCODE, OPTUIP, 1) + length(rtrim(OPTUIP_SETAPPCODE)) + 1; 
   set APPCODE = SUBSTRING(OPTUIP, charpos_value_start, 5);  
end if;


if locate(OPTUIP_NONE, OPTUIP, 1) > 0 then
   set IND_OPTUIP_NONE = 1; 
end if;


-- check if at least one option is valid
set IND_OPTUIP =  IND_OPTUIP_DEFAULT | IND_OPTUIP_SETLANG | IND_OPTUIP_SETAPPCODE | IND_OPTUIP_NONE ;
-- if IND_OPTUIP = 0 goto UNVALIDOPT;

do_DisplayHelp: BEGIN
-- when everything is OK no help info needed
if IND_CMDUIP_DEFAULT = 'FALSE' and IND_CMDUIP = 1 and IND_OPTUIP = 1 then 
   leave do_DisplayHelp;
end if;

SELECT text_help FROM etx_helptext WHERE helptopic = THIS_SP ORDER BY lang_help, recnr_help; 
leave SP;

END do_displayHelp;

main: BEGIN
 
if IND_CMDUIP = 0 then leave main; end if;
if IND_OPTUIP = 0 then leave main; end if;
if IND_CMDUIP_DEFAULT = 1 then leave main; end if;   

if USERNAME_UI_I <= '' then
   set USERNAME_UI_I = SYSTEM_USER;
end if;

if POSTER_BE_I <= '' then
   set POSTER_BE_I = THIS_SP;
end if;

-- split the message parameter by delimiter

set MSG_ID_C = LPAD(MSG_ID_I, 5, 0);

if MSG_ID_I < 1 then
   set MSG_ID_C = cast(MSG_ID_I as character(5));
else 
   set MSG_ID_C = LPAD(MSG_ID_I, 5, 0);
end if;

-- set MSGTS_C = cast(CURRENT_TIMESTAMP()  as character(26));

select  text_msg, type_msg
   into l_text_msg, msgtyp_c 
 from etx_message_text
where appcode_msg = APPCODE
  and lang_msg = LANG
  and msg_id = MSG_ID_I;

do_replace: BEGIN
if FOUND_ROWS( ) = 0 then
   set l_TEXT_MSG = concat('unknown message ', APPCODE,  ' ', LANG, ' ', cast(MSG_ID_I as character(10)), ' ', rtrim(MSG_PAR_I));
   leave do_replace;
end if; 

set l_IND_STOP_MSG =
    case
	when upper(MSGTYP_C) = 'ERR' then 1	
	else 0 end;

set charpos_value_start = 1;
set charpos_value_end = 1;

set MSG_PAR_WRK = MSG_PAR_I;

set LOOPCNT = -1;


do_loop: WHILE 1 = 1 DO
  
set LOOPCNT = LOOPCNT + 1;
if LOOPCNT > 8 then
   leave do_loop;
end if;

set MSG_PAR = '';
 
set charpos_value_start = 1;

-- patindex vs. locate
--
set charpos_value_end = locate(PARSEP, MSG_PAR_WRK);
-- 

-- select charpos_value_end;

if charpos_value_end = 0 then
   set charpos_value_end = length(MSG_PAR_WRK) + 1;
end if;

set charlen_value = charpos_value_end - charpos_value_start;
if charlen_value <= 0 then
  leave do_loop; 
end if;

if charpos_value_end > charpos_value_start then
   set MSG_PAR = ltrim(rtrim(SUBSTRING(MSG_PAR_WRK, charpos_value_start, charlen_value)));
end if;

set PARREPL = concat(PARMARKER_LEFT, cast(LOOPCNT as character(1)), PARMARKER_RIGHT);

if MSG_PAR <> '' then set l_text_msg = replace(l_text_msg,PARREPL,MSG_PAR); end if; 
if MSG_PAR <> '' and LOOPCNT = 0 then set MSG_P1 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 1 then set MSG_P2 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 2 then set MSG_P3 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 3 then set MSG_P4 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 4 then set MSG_P5 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 5 then set MSG_P6 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 6 then set MSG_P7 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 7 then set MSG_P8 = MSG_PAR; end if; 
if MSG_PAR <> '' and LOOPCNT = 8 then set MSG_P9 = MSG_PAR; end if; 

set charlen_par = length(MSG_PAR_WRK) - charpos_value_end + 1;
set MSG_PAR_WRK = ltrim(SUBSTRING(MSG_PAR_WRK, charpos_value_end + 1,charlen_par) );

END WHILE; -- do_loop

END do_replace;

-- select 'abc'; 

set l_text_msg = rtrim(l_text_msg); -- + ' | ' + MSGTYP_C +' | '+ MSG_ID_C ;

insert into etx_message 
 (id_session, guid_msg,
  type_msg, text_msg, username, poster_be, username_be ,ind_stop_msg 
 ,par_msg_1 ,par_msg_2 ,par_msg_3 ,par_msg_4 ,par_msg_5 ,par_msg_6 ,par_msg_7 ,par_msg_8 ,par_msg_9
 )
values
 (ID_SESSION_UI_I, GUID_MSG_UI_I,
  MSGTYP_C, l_text_msg, user(), POSTER_BE_I, USERNAME_UI_I, l_IND_STOP_MSG    
 ,MSG_P1, MSG_P2, MSG_P3, MSG_P4, MSG_P5, MSG_P6, MSG_P7, MSG_P8, MSG_P9
  ); 

leave SP;
END main;


if IND_CMDUIP = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'unvalid UTLCMD';
end if;

if IND_OPTUIP = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'unvalid CMDOPT';
end if;

ERROR_SYSP: begin
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = 'undefined end of procedure';
END ERROR_SYSP;
  
END$$
DELIMITER ;
