

DELIMITER $$
CREATE PROCEDURE `ui_log_useraction`(
	IN `UTLCMD_I` nvarchar(128)             -- utility command 
, 	IN `CMDOPT_I` nvarchar(128)             -- command option
, 	IN `ID_SESSION_UI_I` nvarchar(32)       -- UI session ID   
,	IN `db_name_I` nvarchar(128)            -- connection to log
,	IN `object_I` nvarchar(128)             -- object_name to log
,	IN `catalog_id_I` INTEGER 	            -- catalog id to log
,	IN `instance_name_I` nvarchar(16)       -- instance to log
,	IN `username_I` NVARCHAR(16)              -- action to log
,	IN `action_I` NVARCHAR(20)            -- username to log
,	IN `command_I` nvarchar(4000)           -- command string to log
)
-- DROP PROCEDURE if exists ui_log_useraction 
--
-- *******************************************************************************
-- author.........: ritconsult
-- date written...: 2019.07.01
-- 
-- log a user message into the extended message table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2019.10.17   fmrre    add comments
-- 2021.11.03	nmz		 remove DEFINER... part
--
-- ********************************************************************************
this_sp: BEGIN

declare UTLCMD nvarchar(128);
declare CMDOPT nvarchar(128);
declare ID_SESSION nvarchar(32);
declare CATALOG_ID integer;
declare INSTANCE_NAME nvarchar(16);
declare DB_NAME nvarchar(128);
declare OBJECT nvarchar(128);
declare USERNAME nvarchar(16);
declare ACTION nvarchar(20);
declare COMMAND nvarchar(4000);


set UTLCMD = UTLCMD_I;
set CMDOPT = CMDOPT_I;

set ID_SESSION = ID_SESSION_UI_I;
set CATALOG_ID = catalog_id_I;
set INSTANCE_NAME = instance_name_I;
set DB_NAME = db_name_I;
set OBJECT = object_I;
set USERNAME = username_I;
set ACTION = action_I;
set COMMAND = command_I;

insert into etx_useraction 
   (id_session, db_name, object, catalog_id, instance_name, action, username, command)
values
   (id_session, db_name, object, catalog_id, instance_name, action, username,  command);

END$$
DELIMITER ;

