/*
niota federated metadata V2.0 for niota v4.0.0

---------------------
-	CREATE TABLES	-	
---------------------

*/
use niota_mdv20;

/*
drop table if exists `et_connection`; -- 01
drop table if exists `et_constraint`; -- 02
drop table if exists `et_user`; -- 03
drop table if exists `et_user_group`; -- 04
drop table if exists `et_user_group_member`; -- 05
drop table if exists `et_callable_object`; -- 06
drop table if exists `et_callable_seq`; -- 07
drop table if exists `et_callable_access`; -- 08
drop table if exists `et_catalog_object`; -- 09
drop table if exists `et_catalog_object_instance`; -- 10
drop table if exists `et_catalog_object_access`; -- 11
drop table if exists `et_catalog_object_callable`; -- 12
drop table if exists `et_catalog_object_column_prop`; -- 13
drop table if exists `et_table_link`; -- 14
drop table if exists `et_table_link_detail`; -- 15
drop table if exists `et_logging`; -- 16
drop table if exists `et_lookup`; -- 17
drop table if exists `et_transaction`; -- 18
drop table if exists `et_transaction_parameter_set`; -- 19
drop table if exists `et_transaction_access`; -- 20
drop table if exists `et_transaction_menu`; -- 21
drop table if exists `et_user_parmeter`; -- 22

drop table if exists `etx_useraction`; -- 01
drop table if exists `etx_catalog_object_config`; -- 02
drop table if exists `etx_message_text`; -- 03
drop table if exists `etx_system_config`; -- 04
drop table if exists `etx_user_config`; -- 05
drop table if exists `etx_sequence`; -- 06
*/

/*
      select '01' as ID, 'et_connections' as table_name, count(*) as records from `et_connection` 
union select '02' as ID, 'et_constraint' as table_name, count(*) as records from `et_constraint` 
union select '03' as ID, 'et_user' as table_name, count(*) as records from `et_user` 
union select '04' as ID, 'et_user_group' as table_name, count(*) as records from `et_user_group` 
union select '05' as ID, 'et_user_group_member' as table_name, count(*) as records from `et_user_group_member`
union select '06' as ID, 'et_callable_object' as table_name, count(*) as records from `et_callable_object`
union select '07' as ID, 'et_callable_seq' as table_name, count(*) as records from `et_callable_seq`
union select '08' as ID, 'et_callable_access' as table_name, count(*) as records from `et_callable_access`
union select '09' as ID, 'et_catalog_object' as table_name, count(*) as records from `et_catalog_object`
union select '10' as ID, 'et_catalog_object_instance' as table_name, count(*) as records from `et_catalog_object_instance` 
union select '11' as ID, 'et_catalog_object_access' as table_name, count(*) as records from `et_catalog_object_access` 
union select '12' as ID, 'et_catalog_object_callable' as table_name, count(*) as records from `et_catalog_object_callable`
union select '13' as ID, 'et_catalog_object_column_prop' as table_name, count(*) as records from `et_catalog_object_column_prop`
union select '14' as ID, 'et_table_link' as table_name, count(*) as records from `et_table_link`
union select '15' as ID, 'et_table_link_detail' as table_name, count(*) as records from `et_table_link_detail` 
union select '16' as ID, 'et_logging' as table_name, count(*) as records from `et_logging` 
union select '17' as ID, 'et_lookup' as table_name, count(*) as records from `et_lookup` 
union select '18' as ID, 'et_transaction' as table_name, count(*) as records from `et_transaction` 
union select '19' as ID, 'et_transaction_parameter_set' as table_name, count(*) as records from `et_transaction_parameter_set` 
union select '20' as ID, 'et_transaction_access' as table_name, count(*) as records from `et_transaction_access` 
union select '21' as ID, 'et_transaction_menu' as table_name, count(*) as records from `et_transaction_menu` 
union select '22' as ID, 'et_user_parmeter' as table_name, count(*) as records from `et_user_parmeter`
;
 
      select '01' as ID, 'etx_useraction' as table_name, count(*) as records from `etx_useraction` 
union select '02' as ID, 'etx_catalog_object_config' as table_name, count(*) as records from `etx_catalog_object_config`
union select '03' as ID, 'etx_message_text' as table_name, count(*) as records from `etx_message_text`
union select '04' as ID, 'etx_system_config' as table_name, count(*) as records from `etx_system_config`
union select '05' as ID, 'etx_user_config' as table_name, count(*) as records from `etx_user_config`
union select '06' as ID, 'etx_sequence' as table_name, count(*) as records from `etx_sequence`

*/

-- 01
CREATE TABLE IF NOT EXISTS `et_connection` (
  `conn_name` varchar(16) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `conn_name_msg` varchar(16) DEFAULT NULL,
  `conn_type` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`conn_name`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=utf8;

-- 02	   
CREATE TABLE IF NOT EXISTS `et_constraint` (
  `constraint_name` varchar(32) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `operand_1` varchar(128) DEFAULT NULL,
  `operand_2` varchar(128) DEFAULT NULL,
  `column_type` varchar(1) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL,
  PRIMARY KEY (`constraint_name`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 03
CREATE TABLE IF NOT EXISTS `et_user` (
  `username` varchar(16) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `password` varchar(64) DEFAULT NULL,
  `email` varchar(64) DEFAULT NULL,
  `firstname` varchar(128) DEFAULT NULL,
  `lastname` varchar(128) DEFAULT NULL,
  `phone` varchar(32) DEFAULT NULL,
  `ind_active_ldap` smallint(6) DEFAULT '0',
  `username_ldap` varchar(16) DEFAULT NULL,
  `ind_is_admin` smallint(6) DEFAULT '0',
  PRIMARY KEY (`username`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 04
CREATE TABLE IF NOT EXISTS `et_user_group` (
  `usergroupname` varchar(32) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `usergroup_type` int(11) DEFAULT '2',
  PRIMARY KEY (`usergroupname`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_user_group'
DEFAULT CHARSET=utf8;

-- 05
CREATE TABLE IF NOT EXISTS `et_user_group_member` (
  `usergroupname` varchar(32) NOT NULL,
  `username` varchar(16) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  PRIMARY KEY (`usergroupname`,`username`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_user_group_member'
DEFAULT CHARSET=utf8;

-- 06
CREATE TABLE IF NOT EXISTS et_callable_object(
  callable_object nvarchar (32),
  description nvarchar (128),
  ind_active  smallint default 1,
  callobject_type int,
  conn_name  nvarchar (16),
  command mediumtext,
  callobject_category nvarchar (16),
  sortorder int,
  ind_messaging smallint default 0,
  ind_reload_grid smallint default 0,
  ind_seq smallint default 0,
  promptpage_type smallint,
  icon_callable  nvarchar(32),
  primary key (callable_object)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 07
CREATE TABLE IF NOT EXISTS `et_callable_seq` (
  `callable_object` varchar(32) NOT NULL,
  `callable_object_seq_member` varchar(32) NOT NULL,
  `sort_order` smallint(6) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`callable_object`,`callable_object_seq_member`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_callable_seq'
DEFAULT CHARSET=UTF8;

-- 08
CREATE TABLE IF NOT EXISTS `et_callable_access` (
  `callable_object` varchar(32) NOT NULL,
  `usergroupname` varchar(32) NOT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  PRIMARY KEY (`callable_object`,`usergroupname`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_callable_access'
DEFAULT CHARSET=UTF8;

-- 09
CREATE TABLE IF NOT EXISTS et_catalog_object (
	catalog_id int unique not null, 
	conn_name nvarchar(16) not null, 
	object nvarchar(128) not null, 
	description nvarchar(128), 
	date_activation date, 
	ind_active smallint default 1, 
	objectcategory nvarchar(32),
	format_file_prefix nvarchar(32),
	username_owner nvarchar(16),
	usergroupname_deputy nvarchar(32),
	ind_nolog_upload SMALLINT DEFAULT 0,
	ind_cust_01 smallint,
	ind_cust_02 smallint,
	ind_cust_03 smallint,
	ind_cust_04 smallint,
	ind_cust_05 smallint,
	ind_cust_06 smallint,
	ind_cust_07 smallint,
	ind_cust_08 smallint,
	ind_cust_09 smallint,
	ind_cust_10 smallint, 
  PRIMARY KEY (`catalog_id`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 10
CREATE TABLE IF NOT EXISTS et_catalog_object_instance (
  catalog_id int not null,
  instance_name nvarchar(16) not null,
  description nvarchar(128),
  ind_active smallint default 1,
  projection_list nvarchar (1024),
  ind_active_projection_list smallint default 0,
  read_only_list nvarchar (1024),
  ind_active_read_only_list smallint default 0,
  objectfilter nvarchar (1024),
  ind_active_objectfilter smallint default 0,
  objectjoin nvarchar (1024),
  ind_active_objectjoin smallint default 0,
  objectunion varchar(1024) DEFAULT NULL,
  ind_active_objectunion smallint(6) DEFAULT 0,
  objectgroupby varchar(1024) DEFAULT NULL,
  ind_active_objectgroupby smallint(6) DEFAULT 0,
  objectorder varchar(1024) DEFAULT NULL,
  ind_active_objectorder smallint(6) DEFAULT 0,
  primary key(catalog_id, instance_name) 
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 11
CREATE TABLE IF NOT EXISTS et_catalog_object_access(
  usergroupname nvarchar (32),
  catalog_id int,
  instance_name nvarchar (16),
  ind_active smallint default 1,
  ind_allow_ins smallint default 0,
  ind_allow_upd smallint default 0,
  ind_allow_del smallint default 0,
  ind_allow_import smallint default 0,
  ind_allow_export smallint default 0,
  ind_allow_upd_partial SMALLINT DEFAULT 0,
  ind_allow_upload_partial SMALLINT DEFAULT 0,
  ind_hidden smallint default 0,
  primary key(usergroupname, catalog_id, instance_name)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 12	  
CREATE TABLE IF NOT EXISTS `et_catalog_object_callable` (
  `catalog_id` int(11) NOT NULL,
  `callable_object` varchar(32) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `binding_level` int(11) DEFAULT NULL,
  PRIMARY KEY (`catalog_id`,`callable_object`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_catalog_object_callable'
DEFAULT CHARSET=utf8;

-- 13
CREATE TABLE IF NOT EXISTS et_catalog_object_column_prop(
  catalog_id int,
  column_name nvarchar (64),
  description nvarchar (128),
  ind_active  smallint default 1,
  lookup_name nvarchar(32),
  ind_lookup_import_check smallint default 1,
  constraint_name nvarchar(32),
  ind_constraint_import_check smallint default 1,
  ordinal_position_pkey smallint,
  PRIMARY KEY (`catalog_id`,`column_name`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 14
CREATE TABLE IF NOT EXISTS `et_table_link` (
  `catalog_id_master` int(11) NOT NULL,
  `instance_name_master` varchar(16) NOT NULL,
  `logical_link` varchar(32) NOT NULL,
  `catalog_id_detail` int(11) DEFAULT NULL,
  `instance_name_detail` varchar(16) DEFAULT NULL,
  `linktype` int(11) DEFAULT NULL,
  `ind_logical_link_default` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`catalog_id_master`,`instance_name_master`,`logical_link`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_table_link'
DEFAULT CHARSET=UTF8;

-- 15
CREATE TABLE IF NOT EXISTS `et_table_link_detail` (
  `catalog_id_master` int(11) NOT NULL,
  `instance_name_master` varchar(16) NOT NULL,
  `logical_link` varchar(32) NOT NULL,
  `column_name_master` varchar(64) NOT NULL,
  `column_name_detail` varchar(64) DEFAULT NULL,
  `operation` int(11) NOT NULL,
  `sortorder` int(11) DEFAULT NULL,
  PRIMARY KEY (`catalog_id_master`,`instance_name_master`,`logical_link`,`column_name_master`,`operation`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_table_link_detail'
DEFAULT CHARSET=UTF8;

-- 16
CREATE TABLE IF NOT EXISTS `et_logging` (
  `conn_name` varchar(16) NOT NULL,
  `ind_active_logfile` smallint(6) DEFAULT '0',
  `ind_active_logdb` smallint(6) DEFAULT '0',
  `filename_log` varchar(64) DEFAULT NULL,
  `callable_object` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`conn_name`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_logging'
DEFAULT CHARSET=utf8;

-- 17
CREATE TABLE IF NOT EXISTS `et_lookup` (
  `lookup_name` varchar(32) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `catalog_id_lookup` int(11) DEFAULT NULL,
  `instance_name_lookup` varchar(16) DEFAULT '*LOOKUP',
  PRIMARY KEY (`lookup_name`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_lookup'
DEFAULT CHARSET=UTF8;

-- 18
CREATE TABLE IF NOT EXISTS `et_transaction` (
  `transaction_code` varchar(16) NOT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `targetpage` varchar(256) DEFAULT NULL,
  `param_set` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`transaction_code`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_transaction'
DEFAULT CHARSET=UTF8;

-- 19
CREATE TABLE IF NOT EXISTS `et_transaction_parameter_set` (
  `transaction_code` varchar(16) NOT NULL,
  `param_set` varchar(32) NOT NULL,
  `param_name` varchar(32) NOT NULL,
  `param_value` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`transaction_code`,`param_set`,`param_name`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_transaction_parameter_set'
DEFAULT CHARSET=UTF8;

-- 20
CREATE TABLE IF NOT EXISTS `et_transaction_access` (
  `transaction_code` varchar(16) NOT NULL,
  `usergroupname` varchar(32) NOT NULL,
  `ind_active` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`transaction_code`,`usergroupname`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_transaction_access'
DEFAULT CHARSET=utf8;

-- 21
CREATE TABLE IF NOT EXISTS `et_transaction_menu` (
  `menu_id` int(11) NOT NULL,
  `transaction_code` varchar(16) DEFAULT NULL,
  `menu_label` varchar(64) DEFAULT NULL,
  `description` varchar(128) DEFAULT NULL,
  `ind_active` smallint(6) DEFAULT '1',
  `menu_id_parent` int(11) DEFAULT NULL,
  `icon_menu` varchar(32) DEFAULT NULL,
  `sortorder` int(11) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_transaction_menu'
DEFAULT CHARSET=UTF8;


-- 22
-- tables with autoincremts (in meta db)
CREATE TABLE IF NOT EXISTS `et_user_parameter` (
	`param_id` INT(11) NOT NULL,
	`username` VARCHAR(16) NOT NULL,
	`param_name` VARCHAR(256) NOT NULL,
	`param_value` VARCHAR(256) NULL DEFAULT NULL,
	`param_filter_01` VARCHAR(128) NULL DEFAULT NULL,
	`param_filter_02` VARCHAR(128) NULL DEFAULT NULL,
	`param_filter_03` VARCHAR(128) NULL DEFAULT NULL,
	`param_filter_04` VARCHAR(128) NULL DEFAULT NULL,
	`param_filter_05` VARCHAR(128) NULL DEFAULT NULL,
	PRIMARY KEY (`param_id`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /et_transaction_menu'
DEFAULT CHARSET=UTF8;

/*
 --------------------------------
 -	etx_... table definitions	-
 --------------------------------
 */

-- 01
CREATE TABLE IF NOT EXISTS `etx_useraction` (
	`id_log` BIGINT(20) NOT NULL,
	`ts_log` DATETIME NOT NULL,
	`id_session` VARCHAR(32) NOT NULL,
	`db_name` VARCHAR(128) NOT NULL,
	`object` VARCHAR(128) NOT NULL,
	`catalog_id` INT(11) NOT NULL,
	`instance_name` VARCHAR(16) NOT NULL,
	`action` VARCHAR(20) NOT NULL,
	`username` VARCHAR(16) NOT NULL,
	`command` VARCHAR(4000) NOT NULL,
	PRIMARY KEY (`id_log`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' -- /etx_useraction'
DEFAULT CHARSET=UTF8;

-- 02
CREATE TABLE IF NOT EXISTS etx_catalog_object_config (
  appcode_cfg varchar(5) NOT NULL default 'cust',  
  catalog_id int NOT NULL,
  cfg_id varchar(32) NOT NULL,
  cfg_value varchar(256) NOT NULL,
  description varchar(128) DEFAULT NULL,
  PRIMARY KEY (appcode_cfg, catalog_id, cfg_id)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 03
CREATE TABLE IF NOT EXISTS etx_message_text (
  appcode_msg nvarchar(5) NOT NULL,
  msg_id int(11) NOT NULL,
  lang_msg nvarchar(2) NOT NULL,
  type_msg nvarchar(3) NOT NULL,
  ind_stop_msg smallint(6) DEFAULT NULL,
  text_msg nvarchar(2000) NOT NULL,
  PRIMARY KEY (appcode_msg,msg_id,lang_msg)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 26
CREATE TABLE IF NOT EXISTS `etx_system_config` (
	`appcode_cfg` VARCHAR(5) NOT NULL,
	`cfg_id` VARCHAR(32) NOT NULL,
	`cfg_value` VARCHAR(256) NOT NULL,
	`description` VARCHAR(128) NULL DEFAULT NULL,
	PRIMARY KEY (`appcode_cfg`, `cfg_id`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 04
CREATE TABLE IF NOT EXISTS `etx_user_config` (
	`appcode_cfg` VARCHAR(5) NOT NULL,
	`username` VARCHAR(16) NOT NULL,    
	`cfg_id` VARCHAR(32) NOT NULL,
	`cfg_value` VARCHAR(256) NOT NULL,
	`description` VARCHAR(128) NULL DEFAULT NULL,
	PRIMARY KEY (`appcode_cfg`, `username`, `cfg_id`)
)
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;

-- 05
CREATE TABLE IF NOT EXISTS `etx_sequence` (
	`appcode_seq` VARCHAR(5) NOT NULL,
    `seq_id` varchar(16) NOT NULL,
    `seq_value_increment` int(11) unsigned NOT NULL DEFAULT 1,
    `seq_value_min` bigint(20) unsigned NOT NULL DEFAULT 1,
    `seq_value_max` bigint(20) unsigned NOT NULL DEFAULT 1,
    `seq_value_cur` bigint(20) unsigned DEFAULT 1,
    `ind_cycle` boolean NOT NULL DEFAULT FALSE,
    PRIMARY KEY (`appcode_seq`, `seq_id`)
) 
ENGINE=FEDERATED
CONNECTION='niota_fsv20' 
DEFAULT CHARSET=UTF8;
