/*(re) create new deploy feature tables*/

CREATE TABLE et_deploylog (
  niota_id             varchar(32) NOT NULL,
  deploy_id            int NOT NULL,
  cmdsyp_deploy        varchar(16) NOT NULL,
  optsyp_deploy        varchar(128) NOT NULL,
  username_deploy      varchar(16) NOT NULL,  
  jobname_deploy       varchar(32) NOT NULL,
  table_name_root      varchar(128) NOT NULL,
  where_root           varchar(1024) NOT NULL,
  PRIMARY KEY (niota_id, deploy_id)
 ) 
 CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_deploylog_step;
CREATE TABLE et_deploylog_step (
  niota_id               varchar(32) NOT NULL,
  deploy_id              int NOT NULL,
  stepnbr_deploy         int not null, 
  table_name_deploy      varchar(128) NOT NULL,
  dynsql_data            varchar(8192) NOT NULL,
  
  PRIMARY KEY (niota_id, deploy_id, stepnbr_deploy)
 ) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4_general_ci;

-- drop table et_deploydata_exp;
CREATE TABLE et_deploydata_exp (
  niota_id               varchar(32) NOT NULL,
  deploy_id              int NOT NULL,
  stepnbr_deploy         int not null,
  sortorder_deploy       smallint NOT NULL,
  jobname_deploy         varchar(32) NOT NULL,
  username_export        varchar(20) NOT NULL,
  workunit_id_export     bigint NOT NULL,
  username_import        varchar(20),
  workunit_id_import     bigint,
  ts_start_wu            datetime NOT NULL,
  ts_end_wu              datetime,
  task_wu                varchar(16) NOT NULL,
  ind_locked_wu          smallint NOT NULL,
  status_wu              smallint NOT NULL,
  rc_wu                  smallint NOT NULL,  
  table_name_deploy      varchar(128) NOT NULL, 
  command_deploy         varchar(16) NOT NULL,    
  columnlist_deploy      varchar(4096) NOT NULL,
  data_deploy            varchar(4096) NOT NULL,
  onduplicate_deploy     varchar(4096) NOT NULL,  
  PRIMARY KEY (niota_id, deploy_id, stepnbr_deploy, sortorder_deploy)
 ) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4_general_ci;
 
-- drop table et_deploydata_imp;
CREATE TABLE et_deploydata_imp (
  niota_id               varchar(32) NOT NULL,
  deploy_id              int NOT NULL,
  stepnbr_deploy         int not null,
  sortorder_deploy       smallint NOT NULL,
  jobname_deploy         varchar(32) NOT NULL,
  username_export        varchar(20) NOT NULL,
  workunit_id_export     bigint NOT NULL,
  username_import        varchar(20) ,
  workunit_id_import     bigint,
  ts_start_wu            datetime NOT NULL,
  ts_end_wu              datetime,
  task_wu                varchar(16) NOT NULL,
  ind_locked_wu          smallint NOT NULL,
  status_wu              smallint NOT NULL,
  rc_wu                  smallint NOT NULL,  
  table_name_deploy      varchar(128) NOT NULL, 
  command_deploy         varchar(16) NOT NULL,    
  columnlist_deploy      varchar(4096) NOT NULL,
  data_deploy            varchar(4096) NOT NULL,
  onduplicate_deploy     varchar(4096) NOT NULL,  
  PRIMARY KEY (niota_id, deploy_id, stepnbr_deploy, sortorder_deploy)
 ) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4_general_ci;
 
-- drop table  et_deployarchive;
CREATE TABLE et_deployarchive (
  id_archive             bigint(20) NOT NULL AUTO_INCREMENT,
  ts_archive             datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  workunit_id_archive    bigint NOT NULL,
  niota_id               varchar(32) NOT NULL,
  deploy_id              int NOT NULL,
  stepnbr_deploy         int not null,
  sortorder_deploy       smallint NOT NULL,
  jobname_deploy         varchar(32) NOT NULL,
  username_export        varchar(20) NOT NULL,
  workunit_id_export     bigint NOT NULL,
  username_import        varchar(20) null,
  workunit_id_import     bigint null,
  ts_start_wu            datetime NOT NULL,
  ts_end_wu              datetime,
  task_wu                varchar(16) NOT NULL,
  ind_locked_wu          smallint NOT NULL,
  status_wu              smallint NOT NULL,
  rc_wu                  smallint NOT NULL,  
  table_name_deploy      varchar(128) NOT NULL, 
  command_deploy         varchar(16) NOT NULL,    
  columnlist_deploy      varchar(4096) NOT NULL,
  data_deploy            varchar(4096) NOT NULL,
  onduplicate_deploy     varchar(4096) NOT NULL,   
  PRIMARY KEY (id_archive)
 ) ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4_general_ci;
 