/*
NIOTA METADATA V2.0
FOR NIOTA v4.0.0

-------------------------
-	SETTING CONSTRAINTS	-	
-------------------------

ORDER OF STEPS WHEN SETTING UP NIOTA META DB:
	1) metadata_db.sql
	2) metadata_tables.sql
	3) metadata_load.sql
	4) METADATA_CONSTRAINTS.SQL
	5) folders: 'functions', 'stored procedures'
*/
/*
alter table et_admin_domain
add constraint fk_et_admin_domain
	   foreign key (username)
	   references et_user (username)
	   on delete restrict;	
*/
/*	   
alter table et_admin_domain
add constraint fk_et_admin_domain_2
	   foreign key (conn_name)
	   references et_connection (conn_name)
	    on delete restrict;
*/
-- alter table et_catalog_object drop foreign key fk_et_catalog_object;

-- alter table et_catalog_object drop foreign key fk_et_catalog_object;
alter table et_catalog_object
add constraint fk_et_catalog_object
	   foreign key (conn_name)
	   references et_connection (conn_name)
	   on delete restrict;

DELIMITER //
DROP TRIGGER IF EXISTS trg_default_obj_inst;//
create trigger trg_default_obj_inst
  after insert
    on et_catalog_object
    for each row 
    
  begin  
    if new.catalog_id > 0 then
       insert into et_catalog_object_instance (catalog_id, instance_name, description) 
       select new.catalog_id, case when new.catalog_id > 0 then '*DEFAULT' else '*ADMIN' end, 
                           case when new.catalog_id > 0 then  CONCAT(new.description) else CONCAT(new.description, ' management') end;
    end if;                       
  end;//
DELIMITER ;

-- alter table et_catalog_object_instance drop foreign key fk_et_cat_obj_inst;
alter table et_catalog_object_instance
add constraint fk_et_cat_obj_inst
	   foreign key (catalog_id)
	   references et_catalog_object (catalog_id)
	   on delete restrict;
	   
DELIMITER //
DROP TRIGGER IF EXISTS trg_user_self_group;//
create trigger trg_user_self_group
  after insert
    on et_user
    for each row 
    
  begin  
    insert into et_user_group (usergroupname, description, ind_active, usergroup_type) values (new.username, 'user group by default for the user his/her self', 1, 1);
  end;//

DELIMITER ;

-- alter table et_user_group_member drop foreign key fk_et_usergroup_member;
alter table et_user_group_member
add constraint fk_et_usergroup_member
	   foreign key (username)
	   references et_user (username)
	   on delete restrict;

-- alter table et_user_group_member drop foreign key fk_et_usergroup_member_2;
alter table et_user_group_member
add constraint fk_et_usergroup_member_2
	   foreign key (usergroupname)
	   references et_user_group (usergroupname)
	   on delete restrict;

-- alter table et_catalog_object_access drop foreign key fk_et_catalog_object_access;
alter table et_catalog_object_access
add constraint fk_et_catalog_object_access
	   foreign key (usergroupname)
	   references et_user_group (usergroupname)
	   on delete restrict;

-- alter table et_transaction_access drop foreign key fk_et_transaction_access;	   
alter table et_transaction_access
add constraint fk_et_transaction_access
	   foreign key (transaction_code)
	   references et_transaction (transaction_code)
	   on delete restrict;

-- alter table et_transaction_access drop foreign key fk_et_transaction_access_2;	  	   
alter table et_transaction_access
add constraint fk_et_transaction_access_2
	   foreign key (usergroupname)
	   references et_user_group (usergroupname)
	   on delete restrict;

-- alter table et_transaction_parameter_set drop foreign key fk_et_transaction_parameter_set;
alter table et_transaction_parameter_set
add constraint fk_et_transaction_parameter_set
	   foreign key (transaction_code)
	   references et_transaction (transaction_code)
	   on delete restrict;
	  
-- alter table et_transaction_menu drop foreign key fk_et_transaction_menu;
alter table et_transaction_menu
add constraint fk_et_transaction_menu
	   foreign key (transaction_code)
	   references et_transaction (transaction_code)
	   on delete restrict;
	  
-- alter table et_callable_object drop foreign key fk_et_callable_object; 
alter table et_callable_object
add constraint fk_et_callable_object
	   foreign key (conn_name)
	   references et_connection (conn_name)
	   on delete restrict;

-- alter table et_catalog_object_callable drop foreign key fk_et_cat_obj_callable; 
alter table et_catalog_object_callable
add constraint fk_et_cat_obj_callable
	   foreign key (catalog_id)
	   references et_catalog_object (catalog_id)
	   on delete restrict;

-- alter table et_catalog_object_callable drop foreign key fk_et_cat_obj_callable_2; 	   
alter table et_catalog_object_callable
add constraint fk_et_cat_obj_callable_2
	   foreign key (callable_object)
	   references et_callable_object (callable_object)
	   on delete restrict;   

-- alter table et_callable_access drop foreign key fk_et_callable_access; 	
alter table et_callable_access
add constraint fk_et_callable_access
	   foreign key (callable_object)
	   references et_callable_object (callable_object)
	   on delete restrict;

-- alter table et_callable_access drop foreign key fk_et_callable_access_2; 
alter table et_callable_access
add constraint fk_et_callable_access_2
	   foreign key (usergroupname)
	   references et_user_group (usergroupname)
	   on delete restrict;

-- alter table et_catalog_object_column_prop drop foreign key fk_et_cat_obj_col_prop; 	  
alter table et_catalog_object_column_prop
add constraint fk_et_cat_obj_col_prop
	   foreign key (catalog_id)
	   references et_catalog_object (catalog_id)
	   on delete restrict;

-- alter table et_lookup drop foreign key fk_et_lookup; 		  
alter table et_lookup
add constraint fk_et_lookup
	   foreign key (catalog_id_lookup, instance_name_lookup)
	   references et_catalog_object_instance (catalog_id, instance_name)
	   on delete restrict;

-- alter table et_table_link_detail drop foreign key fk_et_table_link_detail; 
alter table et_table_link_detail
add constraint fk_et_table_link_detail
	   foreign key (catalog_id_master)
	   references et_catalog_object (catalog_id)
	   on delete restrict;

-- alter table et_table_link_detail drop foreign key fk_et_table_link_detail_2; 	   
alter table et_table_link_detail
add constraint fk_et_table_link_detail_2
	   foreign key (catalog_id_master, instance_name_master)
	   references et_catalog_object_instance (catalog_id, instance_name)
	   on delete restrict;

-- alter table et_table_link drop foreign key fk_et_table_link; 	   
alter table et_table_link
add constraint fk_et_table_link
	   foreign key (catalog_id_master, instance_name_master)
	   references et_catalog_object_instance (catalog_id, instance_name)
	   on delete restrict;

-- alter table et_table_link drop foreign key fk_et_table_link_2; 	   
alter table et_table_link
add constraint fk_et_table_link_2
	   foreign key (catalog_id_detail, instance_name_detail)
	   references et_catalog_object_instance (catalog_id, instance_name)
	   on delete restrict;	   

-- alter table et_logging drop foreign key fk_et_logging;
alter table et_logging
add constraint fk_et_logging
	   foreign key (conn_name)
	   references et_connection (conn_name)
	   on delete restrict;

-- alter table et_logging drop foreign key fk_et_logging_2;
alter table et_logging
add constraint fk_et_logging_2
	   foreign key (callable_object)
	   references et_callable_object (callable_object)
	   on delete restrict;
	  
-- alter table et_user_parameter drop foreign key fk_et_user_parameter;
alter table et_user_parameter
add CONSTRAINT fk_et_user_parameter 
	FOREIGN KEY (username)
	REFERENCES et_user (username)
	on delete RESTRICT;


	  