/*
NIOTA METADATA V2.0
FOR NIOTA v4.0.0

---------------------
-	CREATE TABLES	-	
---------------------

ORDER OF STEPS WHEN SETTING UP NIOTA META DB:
	1) metadata_db.sql	
	2) METADATA_TABLES.SQL
	   -------------------	
	3) metadata_load.sql	
	4) metadata_constraints.sql	
	5) folders: 'functions', 'stored procedures' 
-- --    
-- v5.0.0 - changed character set to UTF8MB4_general_ciM4
-- --
*/
-- drop table et_connection;
create table et_connection(
  conn_name varchar(16) not null,
  description varchar(128),
  conn_name_msg varchar(16),
  conn_type smallint not null default 0,
  constraint et_connection_pk primary key(conn_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_user;
create table et_user (
  username varchar(16) not null,
  description varchar(128),
  ind_active smallint default 1,
  password varchar (64),
  email varchar (64),
  firstname varchar (128),
  lastname varchar (128),
  phone varchar (32),
  ind_active_ldap smallint default 0,
  username_ldap varchar(16),
  ind_is_admin smallint default 0,
  lang_grid varchar(2),
  company_name varchar(128),
  ticket_id varchar(32),
  constraint et_user_pk primary key(username) 
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
/*
-- drop table et_admin_domain;
create table et_admin_domain(
  username varchar (16),
  conn_name varchar (16),
  ind_active smallint default 1,
  constraint et_admin_domains_pk primary key(username, conn_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
*/

-- drop table et_catalog_object;
create table et_catalog_object (
	catalog_id int unique not null, 
	conn_name varchar(16) not null, 
	object varchar(128) not null, 
	description varchar(128), 
	date_activation date, 
	ind_active smallint default 1, 
	objectcategory varchar(32),
	format_file_prefix varchar(32),
	username_owner varchar(16),
	usergroupname_deputy varchar(32),
	ind_nolog_upload SMALLINT DEFAULT 0,
	ind_cust_01 smallint,
	ind_cust_02 smallint,
	ind_cust_03 smallint,
	ind_cust_04 smallint,
	ind_cust_05 smallint,
	ind_cust_06 smallint,
	ind_cust_07 smallint,
	ind_cust_08 smallint,
	ind_cust_09 smallint,
	ind_cust_10 smallint, 
	constraint cat_obj_pk primary key (catalog_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_catalog_object_instance;
create table et_catalog_object_instance (
  catalog_id int not null,
  instance_name varchar(16) not null,
  description varchar(128),
  ind_active smallint default 1,
  projection_list varchar (1024),
  ind_active_projection_list smallint default 0,
  read_only_list varchar (1024),
  ind_active_read_only_list smallint default 0,
  objectfilter varchar (1024),
  ind_active_objectfilter smallint default 0,
  objectjoin varchar (1024),
  ind_active_objectjoin smallint default 0,
  objectunion varchar(1024) DEFAULT NULL,
  ind_active_objectunion smallint DEFAULT 0,
  objectgroupby varchar(1024) DEFAULT NULL,
  ind_active_objectgroupby smallint DEFAULT 0,
  objectorder varchar(1024) DEFAULT NULL,
  ind_active_objectorder smallint DEFAULT 0,
  ind_use_as_lookup SMALLINT,
  ind_use_as_filter SMALLINT,
  ind_use_as_grid SMALLINT,
  ind_use_as_detail SMALLINT,
  constraint cat_obj_inst_pk primary key(catalog_id, instance_name) 
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_user_group;
create table et_user_group(
  usergroupname varchar (32),
  description varchar (128),
  ind_active smallint default 1,
  usergroup_type int default 2,
  constraint et_user_group_pk primary key(usergroupname)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_user_group_member;
create table et_user_group_member(
  usergroupname varchar (32),
  username varchar (16),
  description varchar (128),
  ind_active smallint default 1,
  constraint et_user_group_member_pk primary key(usergroupname, username)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_catalog_object_access;
create table et_catalog_object_access(
  usergroupname varchar (32),
  catalog_id int,
  instance_name varchar (16),
  ind_active smallint default 1,
  ind_allow_ins smallint default 0,
  ind_allow_upd smallint default 0,
  ind_allow_del smallint default 0,
  ind_allow_import smallint default 0,
  ind_allow_export smallint default 0,
  ind_allow_upd_partial SMALLINT DEFAULT 0,
  ind_allow_upload_partial SMALLINT DEFAULT 0,
  ind_hidden smallint default 0,
  constraint et_catalog_object_access_pk primary key(usergroupname, catalog_id, instance_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_transaction;
create table et_transaction(
  transaction_code varchar (16),
  description varchar (128),
  ind_active  smallint default 1,
  targetpage varchar (256),
  param_set varchar (32),
  constraint et_transaction_pk primary key(transaction_code)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_transaction_access;
create table et_transaction_access (
  transaction_code varchar(16),
  usergroupname varchar(32),
  ind_active smallint,
  constraint transaction_access_pk primary key(transaction_code, usergroupname) 
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_transaction_parameter_set;
create table et_transaction_parameter_set(
  transaction_code varchar (16),
  param_set varchar (32),
  param_name varchar (32),
  param_value varchar (256),
  constraint et_transaction_param_set_pk primary key (transaction_code, param_set, param_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_transaction_menu;
create table et_transaction_menu(
  menu_id varchar(10) unique not null,
  transaction_code varchar (16),
  menu_label varchar (64),
  description varchar (128),
  ind_active  smallint default 1,
  menu_id_parent varchar(10),
  icon_menu varchar (32),
  sortorder int,
  constraint et_transaction_menu_pk primary key (menu_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_callable_object;		  
create table et_callable_object(
  callable_object varchar (32),
  description varchar (128),
  ind_active  smallint default 1,
  callobject_type int,
  conn_name  varchar (16),
  command mediumtext,
  callobject_category varchar (16),
  sortorder int,
  ind_messaging smallint default 0,
  ind_reload_grid smallint default 0,
  ind_seq smallint default 0,
  promptpage_type smallint,
  icon_callable  varchar(32),
  ind_use_uca smallint not null default 0,
  ind_save_uca smallint not null default 0,
  uca varchar(512),
  constraint et_callable_object_pk primary key (callable_object)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_callable_seq;	
create table et_callable_seq (
	callable_object varchar(32), 
	callable_object_seq_member varchar(32), 
	sort_order smallint,
	ind_active smallint,	
	constraint et_callable_seq_pk primary key (callable_object,	callablE_object_seq_member)				
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_catalog_object_callable;	  
create table et_catalog_object_callable(
  catalog_id int,
  callable_object varchar (32),
  description varchar (128),
  ind_active  smallint default 1,
  binding_level int,
  constraint et_catalog_object_callable_pk primary key (catalog_id, callable_object)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;


-- drop table et_callable_access;
create table et_callable_access (
  callable_object varchar (32),
  usergroupname varchar (32),
  ind_active  smallint default 1,
  constraint et_callable_access_pk primary key (callable_object, usergroupname)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_catalog_object_column_prop;
create table et_catalog_object_column_prop (
  catalog_id int,
  column_name varchar (64),
  description varchar (128),
  ind_active  smallint default 1,
  lookup_name varchar(32),
  ind_lookup_import_check smallint default 1,
  constraint_name varchar(32),
  ind_constraint_import_check smallint default 1,
  ordinal_position_pkey smallint,
  lookup_name_extended varchar(32),
  column_name_extended_lookup varchar(64),
  ind_use_extended_lookup SMALLINT,
  ind_add_null SMALLINT,
  
  datatype char(32) , 
  metatype char(1) , 
  ind_nullable smallint , 
  column_len bigint DEFAULT NULL,
  ind_is_autoseq smallint, 
  ind_is_volatile smallint, 
  
  ind_is_required SMALLINT,	
  ind_is_read_only SMALLINT,	
  ind_is_hidden SMALLINT,
  ind_editable_hidden SMALLINT,

  colvalue_default varchar (256),
  domain_id_physical varchar (64),
  domain_id_logical varchar (64),
  domain_id_semantic varchar (64),
  
  column_title_ui varchar (128),
  column_heading_ui varchar (1024),
  colpos_form SMALLINT,
  rowpos_form SMALLINT,
  constraint et_catalog_obj_col_prop_pk primary key (catalog_id, column_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_constraint;	   
create table et_constraint(
  constraint_name varchar (32),
  description varchar (128),
  ind_active  smallint default 1,
  operand_1 varchar (128),
  operand_2 varchar (128),
  column_type varchar (1),
  operation int,
  constraint et_constraint_pk primary key (constraint_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_lookup;
create table et_lookup(
  lookup_name varchar (32),
  description varchar (128),
  ind_active  smallint default 1,
  catalog_id_lookup int,
  instance_name_lookup varchar (16) default '*LOOKUP',
  lookup_type smallint default 0,
  constraint et_lookup_pk primary key (lookup_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;


-- drop table et_table_link_detail;
create table et_table_link_detail(
  catalog_id_master int,
  instance_name_master varchar (16),
  logical_link varchar (32),
  column_name_master varchar (64),
  column_name_detail varchar (64),
  operation int,
  sortorder int,
  constraint et_table_link_detail_pk primary key (catalog_id_master, instance_name_master, logical_link, column_name_master, operation)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_table_link;
create table et_table_link(
  catalog_id_master int,
  instance_name_master varchar (16),
  logical_link varchar (32),
  catalog_id_detail int,
  instance_name_detail varchar (16),
  linktype int,
  ind_logical_link_default smallint default 1 not null,
  grid_location_detail SMALLINT,
  icon_link varchar(32),
  description varchar(128),
  constraint et_table_link_pk primary key (catalog_id_master, instance_name_master, logical_link)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_logging;
create table et_logging(
  conn_name varchar (16),
  ind_active_logfile  smallint default 0,
  ind_active_logdb  smallint default 0,
  filename_log varchar (64),
  callable_object varchar (32),
  constraint et_logging_pk primary key (conn_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_lookup_value_system;
create table et_lookup_value_system(
  lookup_name varchar (32),
  lookup_number int not null,  
  lookup_int int,
  lookup_char varchar (32), 
  lookup_description varchar (128) not null,
  ind_active smallint default 1,
  constraint  et_system_lookup_value_pk primary key(lookup_name, lookup_number)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_user_parameter;
CREATE TABLE et_user_parameter(
	param_id int AUTO_INCREMENT not null, 
	username varchar(16) NOT NULL,	
	param_name varchar(256) NOT NULL,
	param_value varchar(256),
	param_filter_01 varchar(128),
	param_filter_02 varchar(128),
	param_filter_03 varchar(128),
	param_filter_04 varchar(128),
	param_filter_05 varchar(128),
	CONSTRAINT et_user_parameter_pk PRIMARY KEY(param_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_metadb_object;
create table et_metadb_object (
object varchar(128),
description varchar(128),
ind_active smallint default 1,
er_level int,
sortorder smallint,
ind_deploy smallint default 0,
objabbrev varchar(5) DEFAULT NULL,
catalog_id int not null,
conn_name varchar(16),
domain_id_semantic varchar(64),
constraint et_meta_db_object_pk primary key (object)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_metadb_link;
CREATE TABLE et_metadb_link (
  catalog_id         int NOT NULL,
  logical_link       varchar(32) NOT NULL,
  sortorder          smallint NOT NULL,  
  catalog_id_linked  int NOT NULL,  
  ind_active         smallint NOT NULL,
  catlink_type       integer not null,
  PRIMARY KEY (catalog_id, logical_link)
 ) 
 CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
 
-- drop table et_metadb_link_detail;
CREATE TABLE et_metadb_link_detail (
  catalog_id          int NOT NULL,
  logical_link        varchar(32) NOT NULL,
  column_name         varchar(64) NOT NULL,
  column_name_linked  varchar(64) NOT NULL,
  ind_active          smallint NOT NULL,   
  sortorder           smallint NOT NULL,  
  PRIMARY KEY (catalog_id, logical_link, column_name)
 )
 CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
 
 -- drop table et_catalog_object_column_format;
CREATE TABLE et_catalog_object_column_format (
  catalog_id int NOT NULL,
  column_name varchar(64) NOT NULL,
  ordinal_position smallint not null,
  datatype char(32) not null,
  metatype char(1) not null,
  ind_nullable smallint not null,
  char_max_len bigint,
  ind_active_format smallint DEFAULT 1,
  ordinal_position_fmt smallint,
  metatype_fmt char(1),
  ind_nullable_fmt smallint,
  char_input_len_fmt smallint,
  ind_read_only_fmt smallint,
  ind_hidden_fmt smallint,
  PRIMARY KEY (catalog_id,column_name)
--  CONSTRAINT fk_et_cat_obj_col_fmt FOREIGN KEY (catalog_id) REFERENCES et_catalog_object (catalog_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table et_user_comm_area;
CREATE TABLE et_user_comm_area (
	username        VARCHAR(16) NOT NULL,
    appcode         VARCHAR(5) NOT NULL,
	id_session      VARCHAR(32) NOT NULL,
	guid_msg        VARCHAR(32) ,
    lang            VARCHAR(2) NOT NULL,
    uca             VARCHAR(512) ,
	PRIMARY KEY (username)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

/*
 --------------------------------
 -	etx_... table definitions	-
 --------------------------------
 */
-- drop table etx_catalog_object_config;
CREATE TABLE etx_catalog_object_config (
  appcode_cfg varchar(5) NOT NULL default 'cust',  
  catalog_id int NOT NULL,
  cfg_id varchar(32) NOT NULL,
  cfg_value varchar(256) NOT NULL,
  description varchar(128) DEFAULT NULL,
  PRIMARY KEY (appcode_cfg, catalog_id, cfg_id)
) 
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_message;
create table etx_message (
    id_log int AUTO_INCREMENT not null,
    ts_log datetime default CURRENT_TIMESTAMP(),
	ts_msg_ui datetime,
    id_session varchar(32),
    guid_msg varchar(32) not null,
    type_msg varchar(3),
    text_msg varchar(2000),
    username varchar(16),
    poster_be varchar(128),
    username_be varchar(16),
    ind_stop_msg smallint default 0,
    par_msg_1 varchar(256),
    par_msg_2 varchar(256),
    par_msg_3 varchar(256),
    par_msg_4 varchar(256),
    par_msg_5 varchar(256),
    par_msg_6 varchar(256),
    par_msg_7 varchar(256),
    par_msg_8 varchar(256),
    par_msg_9 varchar(256),
    constraint pk_etx_message PRIMARY KEY (id_log)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_message_text;
CREATE TABLE etx_message_text (
  appcode_msg varchar(5) NOT NULL,
  msg_id int NOT NULL,
  lang_msg varchar(2) NOT NULL,
  type_msg varchar(3) NOT NULL,
  ind_stop_msg smallint DEFAULT NULL,
  text_msg varchar(2000) NOT NULL,
  PRIMARY KEY (appcode_msg,msg_id,lang_msg)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_useraction;
CREATE TABLE etx_useraction (
  id_log bigint NOT NULL AUTO_INCREMENT,
  ts_log datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  id_session varchar(32) NOT NULL,
  db_name varchar(128) NOT NULL,
  object varchar(128) NOT NULL,
  catalog_id int NOT NULL,
  instance_name varchar(16) NOT NULL,
  action varchar(20) NOT NULL,
  username varchar(16) NOT NULL,
  command varchar(4000) NOT NULL,
  PRIMARY KEY (id_log)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_system_config;
CREATE TABLE etx_system_config (
	appcode_cfg VARCHAR(5) NOT NULL,
	cfg_id VARCHAR(32) NOT NULL,
	cfg_value VARCHAR(256) NOT NULL,
	description VARCHAR(128) NULL DEFAULT NULL,
	PRIMARY KEY (appcode_cfg, cfg_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_user_config;
CREATE TABLE etx_user_config (
	appcode_cfg VARCHAR(5) NOT NULL,
	username VARCHAR(16) NOT NULL,    
	cfg_id VARCHAR(32) NOT NULL,
	cfg_value VARCHAR(256) NOT NULL,
	description VARCHAR(128) NULL DEFAULT NULL,
	PRIMARY KEY (appcode_cfg, username, cfg_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_sequence;
CREATE TABLE etx_sequence (
	appcode_seq VARCHAR(5) NOT NULL,
    seq_id varchar(16) NOT NULL,
    seq_value_increment int unsigned NOT NULL DEFAULT 1,
    seq_value_min bigint unsigned NOT NULL DEFAULT 1,
    seq_value_max bigint unsigned NOT NULL DEFAULT 18446744073709551615,
    seq_value_cur bigint unsigned DEFAULT 1,
    ind_cycle boolean NOT NULL DEFAULT FALSE,
    PRIMARY KEY (appcode_seq, seq_id)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_log;
CREATE TABLE etx_log (
  id_log int NOT NULL AUTO_INCREMENT,
  ts_log datetime DEFAULT CURRENT_TIMESTAMP,
  poster_log varchar(128),
  logtext varchar(8192) NULL,
  PRIMARY KEY (id_log)
) 
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_message_detail;
create table etx_message_detail (
	id_log int auto_increment primary key,
    ts_log datetime,
    id_session varchar(32),
    guid_msg varchar(32),
    client_id varchar(16),    
    username varchar(16),
    action_type varchar(20), 
    db_name varchar(128),
    object varchar(128),
    catalog_id integer,
    instance_name varchar(16),
    data_pk varchar(4096),
    text_msg varchar(2000)    
) 
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table etx_catalog_object_blob;
CREATE TABLE etx_catalog_object_blob (
   appcode_blob varchar(5) NOT NULL,
   catalog_id int NOT NULL,
   blob_id varchar(32) NOT NULL,
   foldername_blob varchar(256) NOT NULL,
   filename_blob varchar(256) NOT NULL,
   blob_data longblob,
   ts_load datetime NOT NULL,
   username_load varchar(32) NOT NULL,
  PRIMARY KEY (appcode_blob, catalog_id, blob_id)
) 
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;


-- drop table if exists et_format_collection_column;

create table et_format_collection_column (
  collection_id varchar (32),
  column_name varchar (64),
  ind_active smallint default 1,
  
  colvalue_default varchar (256),
  column_title_ui varchar (128),
  column_heading_ui varchar (1024),
  constraint et_format_collection_column_pk primary key (collection_id, column_name)

)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
	   

-- drop table if exists et_format_domain_logical;

CREATE TABLE et_format_domain_logical (
  domain_id_logical varchar(64) NOT NULL,
  description varchar(128) NOT NULL,
  edittype varchar(64) NOT NULL,
  param_edittype varchar(256) NULL,

  textarea_rows int NULL,
  textarea_cols int NULL,
   
  constraint et_format_domain_logical primary key (domain_id_logical)
 ) 
 CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

-- drop table if exists et_format_domain_physical;

CREATE TABLE et_format_domain_physical (
  domain_id_physical varchar(64) NOT NULL,
  description varchar(128) NOT NULL,
  editsize int NOT NULL,
  editmaxlength int NOT NULL,
 
  constraint et_format_domain_physical_pk primary key (domain_id_physical)
 ) 
 CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
 
 
-- drop table if exists et_format_domain_semantic;

CREATE TABLE et_format_domain_semantic (
  domain_id_semantic varchar(64) NOT NULL,
  description varchar(128) NOT NULL,

  column_title_ui varchar (128),
  column_heading_ui varchar (1024),
  colvalue_default varchar (256),
   
  constraint et_format_domain_semantic primary key (domain_id_semantic)
 ) 
 CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;
 
-- drop table if exists et_format_object;

create table et_format_object (
  catalog_id int,
  instance_name varchar (16),
  ind_active smallint default 1,
  grid_caption_ui varchar(128),
  grid_caption_suffix_ui varchar(128),
  pagesize SMALLINT,
  form_width varchar(5),
  ind_rownumbers SMALLINT,	
  ind_advanced_search SMALLINT,
  ind_multiselect SMALLINT,

  constraint et_format_object_pk primary key (catalog_id, instance_name)
)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;

 -- drop table if exists et_format_object_column;

create table et_format_object_column (
  catalog_id int,
  instance_name varchar (16),
  column_name varchar (64),
  ind_active smallint default 1,
  
  ind_is_required SMALLINT,	
  ind_is_read_only SMALLINT,	
  ind_is_hidden SMALLINT,
  ind_editable_hidden SMALLINT,

  colvalue_default varchar (256),
  column_title_ui varchar (128),
  column_heading_ui varchar (1024),
  colpos_form SMALLINT,
  rowpos_form SMALLINT,
  constraint et_format_object_column_pk primary key (catalog_id, instance_name, column_name)

)
CHARACTER SET UTF8MB4 COLLATE UTF8MB4_general_ci;