/*
----------------------
--	create views	--
----------------------
-- name of the views sometimes has to be shortened because in oracle the max length of a view name is 30 chars
*/
CREATE OR REPLACE VIEW v_et_callable_access as select * from et_callable_access;
CREATE OR REPLACE VIEW v_et_callable_object as select * from et_callable_object;
CREATE OR REPLACE VIEW v_et_catalog_object as select * from et_catalog_object;
CREATE OR REPLACE VIEW v_et_catalog_object_access as select * from et_catalog_object_access;
CREATE OR REPLACE VIEW v_et_catalog_object_callable as select * from et_catalog_object_callable;
CREATE OR REPLACE VIEW v_et_catalog_object_col_prop as select * from et_catalog_object_column_prop;
CREATE OR REPLACE VIEW v_et_catalog_object_instance as select * from et_catalog_object_instance;
CREATE OR REPLACE VIEW v_et_constraint as select * from et_constraint;
CREATE OR REPLACE VIEW v_et_logging as select * from et_logging;
CREATE OR REPLACE VIEW v_et_lookup as select * from et_lookup;
CREATE OR REPLACE VIEW v_et_table_link as select * from et_table_link;
CREATE OR REPLACE VIEW v_et_table_link_detail as select * from et_table_link_detail;
CREATE OR REPLACE VIEW v_et_transaction as select * from et_transaction;
CREATE OR REPLACE VIEW v_et_transaction_menu as select * from et_transaction_menu;
CREATE OR REPLACE VIEW v_et_transaction_param_set as select * from et_transaction_parameter_set;
CREATE OR REPLACE VIEW v_et_user as select * from et_user;
CREATE OR REPLACE VIEW v_et_user_group as select * from et_user_group;
CREATE OR REPLACE VIEW v_et_user_group_member as select * from et_user_group_member;
CREATE OR REPLACE VIEW v_et_user_parameter AS select * from et_user_parameter; 
CREATE OR REPLACE VIEW v_et_connection as select * from et_connection;
CREATE OR REPLACE VIEW v_et_transaction_access AS select * from et_transaction_access;
CREATE OR REPLACE VIEW v_et_callable_seq AS SELECT * FROM et_callable_seq;
CREATE OR REPLACE VIEW v_et_lookup_value_system as select * from et_lookup_value_system;
CREATE OR REPLACE VIEW v_et_metadb_object as select * from et_metadb_object;
CREATE OR REPLACE VIEW v_et_user_comm_area AS select * from et_user_comm_area;
CREATE OR REPLACE VIEW v_et_metadb_link AS select * from et_metadb_link;
CREATE OR REPLACE VIEW v_et_metadb_link_detail AS select * from et_metadb_link_detail;
CREATE OR REPLACE VIEW v_et_catalog_object_column_format AS select * from et_catalog_object_column_format;
CREATE OR REPLACE VIEW v_etx_useraction AS select * FROM etx_useraction;
CREATE OR REPLACE VIEW v_etx_message AS select * FROM etx_message;
CREATE OR REPLACE VIEW v_etx_system_config AS select * FROM etx_system_config;
CREATE OR REPLACE VIEW v_etx_catalog_object_config AS select * FROM etx_catalog_object_config;
CREATE OR REPLACE VIEW v_etx_user_config AS select * FROM etx_user_config;
CREATE OR REPLACE VIEW v_etx_sequence AS select * FROM etx_sequence;


CREATE OR REPLACE VIEW v_et_catalog_instance_id AS 
SELECT concat(et_catalog_object_instance.catalog_id,'.',et_catalog_object_instance.instance_name) AS cataloginstanceid,
et_catalog_object_instance.description AS description,
et_catalog_object_instance.catalog_id AS catalog_id,
et_catalog_object_instance.instance_name AS instance_name,
cast(et_catalog_object_instance.catalog_id as char charSET UTF8MB4) AS catalog_id_char,
coalesce(et_catalog_object_instance.ind_active,0) AS ind_active, 
coalesce(et_catalog_object_instance.ind_use_as_lookup,0) AS ind_use_as_lookup,
coalesce(et_catalog_object_instance.ind_use_as_filter,0) AS ind_use_as_filter,
coalesce(et_catalog_object_instance.ind_use_as_grid,1) AS ind_use_as_grid,
coalesce(et_catalog_object_instance.ind_use_as_detail,0) AS ind_use_as_detail 
from et_catalog_object_instance;


CREATE OR REPLACE VIEW v_et_user_group_lu AS
-- create a view for lookup where we can see the name of the user
SELECT ugr.usergroupname, coalesce(concat(usr.firstname, ' ', usr.lastname), ugr.description) AS description, ugr.ind_active, ugr.usergroup_type
 FROM et_user_group ugr
left outer JOIN et_user usr
ON usr.username = ugr.usergroupname
;

-- to be refined --

CREATE OR REPLACE VIEW v_et_catalog_id_next AS 
select 
catalog_id_next_suggestion.catalog_id_next AS catalog_id_next,
concat(convert(catalog_id_next_suggestion.description using utf8mb4), catalog_id_next_suggestion.conn_name) AS description 
from (
-- get the next it / add increment and check if already used
select 
((truncate((max(et_catalog_object.catalog_id) / coalesce(seq.seq_value_increment,1)),0) * coalesce(seq.seq_value_increment,1)) + coalesce(seq.seq_value_increment,1)) AS catalog_id_next,
et_catalog_object.conn_name AS conn_name,
' is perfect next ID for ' AS description 
from et_catalog_object 
left join etx_sequence seq 
  on seq.appcode_seq = 'niota' 
 and seq.seq_id = 'CATALOG_ID' 
where et_catalog_object.catalog_id > 0 
group by et_catalog_object.conn_name, coalesce(seq.seq_value_increment,1) 
union 
select 
((truncate((max(abs(et_catalog_object.catalog_id)) / coalesce(seq.seq_value_increment,1)),0) * coalesce(seq.seq_value_increment,1)) + coalesce(seq.seq_value_increment,1)) AS catalog_id_next,
et_catalog_object.conn_name AS conn_name,
' is suggested MD ID for ' AS description 
from et_catalog_object 
left join etx_sequence seq 
  on seq.appcode_seq = 'niota' 
 and seq.seq_id = 'CATALOG_ID' 
where et_catalog_object.catalog_id <= 0 
group by et_catalog_object.conn_name, coalesce(seq.seq_value_increment,1) 
union 
-- get the next id / max + 1 can never ever be already in use 
select 
inc_01.catalog_id_next AS catalog_id_next,
inc_01.conn_name AS conn_name,
inc_01.description AS description 
from 
(
select 
(max(freeid.catalog_id) + 1) AS catalog_id_next,
freeid.conn_name AS conn_name,
' is very next free ID in ' AS description 
    from et_catalog_object freeid 
   where freeid.catalog_id > 0 
group by freeid.conn_name) inc_01 
left join et_catalog_object co 
   on co.catalog_id = inc_01.catalog_id_next 
where co.catalog_id is null 
union 
select 
min(freeids.catalog_id_next) AS catalog_id_next,
cnc.conn_name AS conn_name,
' first cosy place in ' AS description 
from et_connection cnc 
join 
 (
  select 
  freeid.conn_name AS conn_name,
  (freeid.catalog_id + 1) AS catalog_id_next 
 from et_catalog_object freeid 
 where exists
 (
 select 1 
   from et_catalog_object usedid 
  where ((freeid.catalog_id + 1) = usedid.catalog_id) is false 
    and freeid.catalog_id > 0
 )    
  ) freeids 
on freeids.conn_name = cnc.conn_name
group by cnc.conn_name 
union 
select min(freeidx.catalog_id_next) AS catalog_id_next,
cnc.conn_name AS conn_name,
' first regular gap in ' AS description 
from (et_connection cnc 
join 
(
select 
((truncate((freeid.catalog_id / coalesce(seq.seq_value_increment,1)),0) * coalesce(seq.seq_value_increment,1)) + coalesce(seq.seq_value_increment,1)) AS catalog_id_next,
freeid.conn_name AS conn_name 
  from et_catalog_object freeid 
left join etx_sequence seq 
  on seq.appcode_seq = 'niota' 
 and seq.seq_id = 'CATALOG_ID'
where exists 
(
   select 1 from et_catalog_object usedid 
    where (((truncate((freeid.catalog_id / coalesce(seq.seq_value_increment,1)),0) * coalesce(seq.seq_value_increment,1)) + coalesce(seq.seq_value_increment,1)) = usedid.catalog_id)
) is false 
and freeid.catalog_id > 0

) freeidx 
on freeidx.conn_name = cnc.conn_name

) 
group by cnc.conn_name
) 
catalog_id_next_suggestion;



--
CREATE OR REPLACE VIEW v_et_user_group_lu 
AS 
select ugr.usergroupname AS usergroupname,
coalesce(concat(usr.firstname,' ',usr.lastname),ugr.description) AS description,
ugr.ind_active AS ind_active,
ugr.usergroup_type AS usergroup_type 
from et_user_group ugr 
left join et_user usr 
on usr.username = ugr.usergroupname;


CREATE OR REPLACE VIEW v_et_format_collection_column AS select * FROM et_format_collection_column;
CREATE OR REPLACE VIEW v_et_format_domain_logical AS select * FROM et_format_domain_logical;
CREATE OR REPLACE VIEW v_et_format_domain_physical AS select * FROM et_format_domain_physical;
CREATE OR REPLACE VIEW v_et_format_domain_semantic AS select * FROM et_format_domain_semantic;
CREATE OR REPLACE VIEW v_et_format_object AS select * FROM et_format_object;
CREATE OR REPLACE VIEW v_et_format_object_column AS select * FROM et_format_object_column;

CREATE OR REPLACE VIEW v_et_format_domain_logical_lu 
AS 
-- select * from v_et_format_domain_logical_lu
select domain_id_logical, 
  case when edittype = 'checkbox' then 
   concat(description, '(', edittype, coalesce(param_edittype, ' '), ')')
   else concat(description, ' ', edittype, ' ' ,cast(coalesce(textarea_rows, 0) as char), ' x ', cast(coalesce(textarea_cols,0) as char)) end as description
FROM et_format_domain_logical   
;

CREATE OR REPLACE VIEW v_et_format_domain_physical_lu 
as 
select 
 domain_id_physical, 
 concat(description, ' with editsize ',  cast(editsize as char), ' and maxlen ', cast(editmaxlength as char)) as description
from et_format_domain_physical;
-- select * from v_et_format_domain_physical_lu


CREATE OR REPLACE VIEW v_et_format_domain_semantic_lu AS 
-- select * from v_et_format_domain_semantic_lu
select 
 domain_id_semantic,
 concat(description, ' titled as ', column_title_ui) as description 
FROM et_format_domain_semantic;



CREATE OR REPLACE VIEW v_et_format_object_column_php
as
select 
  cp.catalog_id
, case when cp.catalog_id > 0 then coalesce(coi.instance_name, '*DEFAULT') else coalesce(fo.instance_name, coi.instance_name, '*ADMIN') end as instance_name 
, cp.column_name
, cp.domain_id_physical
, cp.domain_id_logical
, cp.domain_id_semantic 
, cp.column_len
, case when dse.column_title_ui is null then coalesce(fco.column_title_ui, cp.column_title_ui, ccofpx.column_title_ui, ccocnc.column_title_ui)
       else case when coalesce(fco.column_title_ui, cp.column_title_ui) is null
				then dse.column_title_ui
                else concat(dse.column_title_ui, '<br>', coalesce(fco.column_title_ui, cp.column_title_ui)) end end as column_title_ui
, case when dse.column_heading_ui is null then coalesce(fco.column_heading_ui, cp.column_heading_ui, ccofpx.column_title_ui, ccocnc.column_title_ui)
       else case when coalesce(fco.column_heading_ui, cp.column_heading_ui) is null
                 then dse.column_heading_ui 
                 else concat(dse.column_heading_ui, ' ', coalesce(fco.column_heading_ui, cp.column_heading_ui)) end end as column_heading_ui
, case when dph.editsize is null and (cp.column_len < 50 or cp.column_len is null) then coalesce(cp.column_len,10) else dph.editsize end as editsize
, coalesce(dph.editmaxlength, cp.column_len, 20) as editmaxlength
, coalesce(fco.ind_is_required, cp.ind_is_required) as ind_is_required
, coalesce(fco.ind_is_read_only, cp.ind_is_read_only) as ind_is_read_only
, coalesce(fco.ind_is_hidden, cp.ind_is_hidden) as ind_is_hidden
, coalesce(fco.ind_editable_hidden, cp.ind_editable_hidden) as ind_editable_hidden
, coalesce(dse.colvalue_default, fco.colvalue_default, cp.colvalue_default) as colvalue_default

, coalesce(fco.rowpos_form, cp.rowpos_form) as rowpos_form
, coalesce(fco.colpos_form, cp.colpos_form) as colpos_form

, dlo.edittype
, dlo.param_edittype
, dlo.textarea_rows
, dlo.textarea_cols

from et_catalog_object co
left join et_catalog_object_column_prop cp
 on cp.catalog_id = co.catalog_id

left join 
(
select distinct catalog_id, instance_name
from et_catalog_object_instance where ind_active = 1
union distinct
select distinct catalog_id, instance_name
from et_format_object where ind_active = 1
union distinct
select catalog_id, '*ADMIN' as instance_name
from et_metadb_object where ind_active = 1
) coi
on coi.catalog_id = cp.catalog_id

left join et_format_object fo
 on fo.catalog_id = cp.catalog_id
and fo.instance_name = coi.instance_name 

left join et_format_object_column fco
 on fco.catalog_id = cp.catalog_id
and fco.instance_name = coi.instance_name
and fco.column_name = cp.column_name
and fco.ind_active = 1

left join et_format_domain_physical dph
 on dph.domain_id_physical = cp.domain_id_physical

left join et_format_domain_logical dlo
 on dlo.domain_id_logical = cp.domain_id_logical
 
left join et_format_domain_semantic dse
 on dse.domain_id_semantic = cp.domain_id_semantic 

left join et_format_collection_column ccofpx
  on ccofpx.collection_id = co.format_file_prefix 
 and ccofpx.column_name = cp.column_name 
 and ccofpx.ind_active = 1

left join et_format_collection_column ccocnc
  on ccocnc.collection_id = co.conn_name
 and ccocnc.column_name = cp.column_name
 and ccocnc.ind_active = 1

where not exists 
(select 1 from etx_catalog_object_config etxcfg
         where etxcfg.appcode_cfg = 'niota'
           and etxcfg.cfg_id = 'dbformat'
           and etxcfg.cfg_value in ('off','0')
           and etxcfg.catalog_id = co.catalog_id
 )
 ;
 
 
CREATE OR REPLACE VIEW v_et_format_object_php
as
select 
  co.catalog_id
, co.object
, case when co.catalog_id > 0 then coalesce(coi.instance_name, '*default') else coalesce(coi.instance_name, '*ADMIN') end as instance_name 
, case when foi.grid_caption_suffix_ui is not null then
       concat(coalesce(foi.grid_caption_ui, coi.description, co.description, co.object), ' - ' , foi.grid_caption_suffix_ui) else
       coalesce(foi.grid_caption_ui, coi.description, co.description, co.object) end as description  
, case when co.catalog_id > 0 then coalesce(foi.pagesize, foi_d.pagesize, foi_a.pagesize, 10) else 
								   coalesce(foi.pagesize, foi_a.pagesize, 10) end as pagesize
, case when co.catalog_id > 0 then coalesce(foi.form_width, foi_d.form_width, foi_a.form_width, '800') else 
                                   coalesce(foi.form_width, foi.form_width, foi_a.form_width, '800') end as form_width
, case when co.catalog_id > 0 then coalesce(foi.ind_rownumbers, foi_d.ind_rownumbers, foi_a.ind_rownumbers, 1) else 
                                   coalesce(foi.ind_rownumbers, foi_a.ind_rownumbers, 1) end as ind_rownumbers
, case when co.catalog_id > 0 then coalesce(foi.ind_advanced_search, foi_d.ind_advanced_search, foi_a.ind_advanced_search, 0) else 
                                   coalesce(foi.ind_advanced_search, foi_a.ind_advanced_search, 1) end as ind_advanced_search
, case when co.catalog_id > 0 then coalesce(foi.ind_multiselect, foi_d.ind_multiselect, foi_a.ind_multiselect, 0) else 
                                   coalesce(foi.ind_multiselect, foi_a.ind_multiselect, 1) end as ind_multiselect

from et_catalog_object co 
left join 
(
select distinct catalog_id, instance_name, description
from et_catalog_object_instance where ind_active = 1
union distinct
select distinct catalog_id, instance_name, grid_caption_ui as description
from et_format_object  where ind_active = 1
union distinct
select catalog_id, '*ADMIN' as instance_name, description
from et_metadb_object where ind_active = 1
) coi
 on coi.catalog_id = co.catalog_id

left join et_format_object foi
 on foi.catalog_id = coi.catalog_id
and foi.instance_name = coi.instance_name
and foi.ind_active = 1 
 
left join et_format_object foi_d
 on foi_d.catalog_id = 0
and foi_d.instance_name = '*default'
and foi_d.ind_active = 1 

left join et_format_object foi_a
 on foi_a.catalog_id = 0
and foi_a.instance_name = '*ADMIN'
and foi_a.ind_active = 1 

where not exists 
(select 1 from etx_catalog_object_config etxcfg
         where etxcfg.appcode_cfg = 'niota'
           and etxcfg.cfg_id = 'dbformat'
           and etxcfg.cfg_value in ('off','0')
           and etxcfg.catalog_id = co.catalog_id
 ) 
;

-- drop view  v_et_metatdb_repository
CREATE OR REPLACE VIEW v_et_metadb_object_repository
-- select * from v_et_metadb_object_repository
as
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.catalog_id as character) as config_id
     , cfg.ind_active, cast(cfg.object as character) as config_detail, cfg.description as description_cfg 
from et_catalog_object cfg
join et_metadb_object mdo on mdo.object = 'et_catalog_object'
where cfg.catalog_id > 0
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(concat(cast(cfg.catalog_id as character), '.', cfg.instance_name) as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.projection_list,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_catalog_object_instance cfg
join et_metadb_object mdo on mdo.object = 'et_catalog_object_instance'
where cfg.catalog_id > 0
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.username as character) as config_id
     , cfg.ind_active,  cast(left(coalesce(cfg.email,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_user cfg
join et_metadb_object mdo on mdo.object = 'et_user'
where cfg.username not in ('superuser', '*ALL_GROUP', '*ALL_ADMIN_GROUP', '*ALL_NON_ADMIN_GROUP')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.usergroupname as character) as config_id
     , cfg.ind_active,  cast(' ' as character) as config_detail, cfg.description as description_cfg
from et_user_group cfg
join et_metadb_object mdo on mdo.object = 'et_user_group' where cfg.usergroup_type in (0,2)
and cfg.usergroupname not in ('superuser', '*ALL_GROUP', '*ALL_ADMIN_GROUP', '*ALL_NON_ADMIN_GROUP')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.callable_object as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.command,'run'),128) as character) as config_detail, cfg.description as description_cfg
from et_callable_object cfg
join et_metadb_object mdo on mdo.object = 'et_callable_object'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.lookup_name as character) as config_id
     , cfg.ind_active, cast(concat(cast(catalog_id_lookup as character),'.', instance_name_lookup) as character) as config_detail, cfg.description as description_cfg
from et_lookup cfg
join et_metadb_object mdo on mdo.object = 'et_lookup'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.constraint_name as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.operand_1,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_constraint cfg
join et_metadb_object mdo on mdo.object = 'et_constraint'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.transaction_code as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.targetpage,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_transaction cfg
join et_metadb_object mdo on mdo.object = 'et_transaction'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.menu_id as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.menu_label,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_transaction_menu cfg
join et_metadb_object mdo on mdo.object = 'et_transaction_menu'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(concat(cast(cfg.catalog_id_master as character), '.', cfg.instance_name_master, '~', cfg.logical_link) as character) as config_id
     , 1 as ind_active, cast(catalog_id_detail as character) as config_detail, cfg.description as description_cfg
from et_table_link cfg
join et_metadb_object mdo on mdo.object = 'et_table_link'
where cfg.catalog_id_master > 0
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.domain_id_logical as character) as config_id
     , 1 as ind_active, cast(edittype as character) as config_detail, cfg.description as description_cfg
from et_format_domain_logical cfg
join et_metadb_object mdo on mdo.object = 'et_format_domain_logical'
where substring(cfg.domain_id_logical,1,4) not in ('ZLD_')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.domain_id_physical as character) as config_id
     , 1 as ind_active, cast(concat(cast(coalesce(cfg.editsize,0) as character), '->', cast(coalesce(editmaxlength,0) as character)) as character) as config_detail, cfg.description as description_cfg
from et_format_domain_physical cfg
join et_metadb_object mdo on mdo.object = 'et_format_domain_physical'
where substring(cfg.domain_id_physical,1,4) not in ('ZPD_')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.domain_id_semantic as character) as config_id
     , 1 as ind_active, cast(cfg.column_title_ui as character) as config_detail, cfg.description as description_cfg
from et_format_domain_semantic cfg
join et_metadb_object mdo on mdo.object = 'et_format_domain_semantic'
where substring(cfg.domain_id_semantic,1,4) not in ('ZSD_')
;
