-- drop view  v_et_metatdb_repository
CREATE OR REPLACE VIEW v_et_metadb_object_repository
-- select * from v_et_metadb_object_repository
as
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.catalog_id as character) as config_id
     , cfg.ind_active, cast(cfg.object as character) as config_detail, cfg.description as description_cfg 
from et_catalog_object cfg
join et_metadb_object mdo on mdo.object = 'et_catalog_object'
where cfg.catalog_id > 0
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(concat(cast(cfg.catalog_id as character), '.', cfg.instance_name) as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.projection_list,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_catalog_object_instance cfg
join et_metadb_object mdo on mdo.object = 'et_catalog_object_instance'
where cfg.catalog_id > 0
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.username as character) as config_id
     , cfg.ind_active,  cast(left(coalesce(cfg.email,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_user cfg
join et_metadb_object mdo on mdo.object = 'et_user'
where cfg.username not in ('superuser', '*ALL_GROUP', '*ALL_ADMIN_GROUP', '*ALL_NON_ADMIN_GROUP')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.usergroupname as character) as config_id
     , cfg.ind_active,  cast(' ' as character) as config_detail, cfg.description as description_cfg
from et_user_group cfg
join et_metadb_object mdo on mdo.object = 'et_user_group' where cfg.usergroup_type in (0,2)
and cfg.usergroupname not in ('superuser', '*ALL_GROUP', '*ALL_ADMIN_GROUP', '*ALL_NON_ADMIN_GROUP')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.callable_object as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.command,'run'),128) as character) as config_detail, cfg.description as description_cfg
from et_callable_object cfg
join et_metadb_object mdo on mdo.object = 'et_callable_object'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.lookup_name as character) as config_id
     , cfg.ind_active, cast(concat(cast(catalog_id_lookup as character),'.', instance_name_lookup) as character) as config_detail, cfg.description as description_cfg
from et_lookup cfg
join et_metadb_object mdo on mdo.object = 'et_lookup'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.constraint_name as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.operand_1,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_constraint cfg
join et_metadb_object mdo on mdo.object = 'et_constraint'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.transaction_code as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.targetpage,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_transaction cfg
join et_metadb_object mdo on mdo.object = 'et_transaction'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.menu_id as character) as config_id
     , cfg.ind_active, cast(left(coalesce(cfg.menu_label,'*'),128) as character) as config_detail, cfg.description as description_cfg
from et_transaction_menu cfg
join et_metadb_object mdo on mdo.object = 'et_transaction_menu'
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(concat(cast(cfg.catalog_id_master as character), '.', cfg.instance_name_master, '~', cfg.logical_link) as character) as config_id
     , 1 as ind_active, cast(catalog_id_detail as character) as config_detail, cfg.description as description_cfg
from et_table_link cfg
join et_metadb_object mdo on mdo.object = 'et_table_link'
where cfg.catalog_id_master > 0
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.domain_id_logical as character) as config_id
     , 1 as ind_active, cast(edittype as character) as config_detail, cfg.description as description_cfg
from et_format_domain_logical cfg
join et_metadb_object mdo on mdo.object = 'et_format_domain_logical'
where substring(cfg.domain_id_logical,1,4) not in ('ZLD_')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.domain_id_physical as character) as config_id
     , 1 as ind_active, cast(concat(cast(coalesce(cfg.editsize,0) as character), '->', cast(coalesce(editmaxlength,0) as character)) as character) as config_detail, cfg.description as description_cfg
from et_format_domain_physical cfg
join et_metadb_object mdo on mdo.object = 'et_format_domain_physical'
where substring(cfg.domain_id_physical,1,4) not in ('ZPD_')
union
select mdo.objabbrev, mdo.description, mdo.sortorder, mdo.catalog_id as catalog_id_mdbo, cast(cfg.domain_id_semantic as character) as config_id
     , 1 as ind_active, cast(cfg.column_title_ui as character) as config_detail, cfg.description as description_cfg
from et_format_domain_semantic cfg
join et_metadb_object mdo on mdo.object = 'et_format_domain_semantic'
where substring(cfg.domain_id_semantic,1,4) not in ('ZSD_')
;
